/* JS helpers for the Flash RDP client. */
var RDPWebClient = {
    embedSWF: function (FlashName, FlashId)
    {
      /* Create the Flash object. */
      var flashvars = {};
      flashvars.flashId = FlashId;

      var params = {};
      params.wmode="opaque";
      params.menu="false";
      params.bgcolor="#ffffff";
      params.quality="low";
      params.allowScriptAccess="always";

      var attributes = {};

      swfobject.embedSWF(FlashName, FlashId, "100%", "100%", "9.0.0",
                         "", flashvars, params, attributes);
    },
    init: function (FlashId)
    {
        RDPWebClient.FlashId = FlashId;

        var flash = RDPWebClient.getFlashById(RDPWebClient.FlashId);
            
        if (window.addEventListener)
        {
            /* Mozilla */
            window.addEventListener("contextmenu", function(event) { return RDPWebClient.MozillaContextMenu(event); }, true);
            window.addEventListener("mousedown", function(event) { return RDPWebClient.MozillaMouse(event, true); }, true);
            window.addEventListener("mouseup", function(event) { return RDPWebClient.MozillaMouse(event, false); }, true);
            flash.addEventListener("mouseout", function(event) { return RDPWebClient.MouseOut(); }, true);
        }
        else
        {
            if (flash)
            {
                document.oncontextmenu = function() { return RDPWebClient.IEContextMenu(); }
                flash.parentNode.onmousedown = function() { return RDPWebClient.IEMouse(true); }
                flash.parentNode.onmouseup = function() { return RDPWebClient.IEMouse(false); }
                flash.onmouseout=function() {return RDPWebClient.MouseOut(); }
            }
        }
    },
    MouseOut: function()
    {
        RDPWebClient.callMouseOut();
        return true;
    },
    IECancelEvent: function()
    {
        window.event.returnValue = false;
        window.event.cancelBubble = true;
        return false;
    },
    IEContextMenu: function()
    {
        if (window.event && window.event.srcElement.id == RDPWebClient.FlashId)
        {
            return RDPWebClient.IECancelEvent();
        }
    },
    IEMouse: function(fMouseDown)
    {
        if (window.event && window.event.srcElement.id == RDPWebClient.FlashId)
        {
            if (window.event.button == 2)
            {
                if (fMouseDown == true)
                {
                    RDPWebClient.getFlashById(RDPWebClient.FlashId).parentNode.setCapture();
                    RDPWebClient.callRightMouseDown();
                }
                else
                {
                    RDPWebClient.callRightMouseUp();
                    RDPWebClient.getFlashById(RDPWebClient.FlashId).parentNode.releaseCapture();
                }
                return RDPWebClient.IECancelEvent();
            }
        }
    },
    MozillaCancelEvent: function(event)
    {
        if (event)
        {
            if (event.preventBubble) event.preventBubble();
            if (event.preventCapture) event.preventCapture();
            if (event.preventDefault) event.preventDefault();
            if (event.stopPropagation) event.stopPropagation();
        }
    },
    MozillaContextMenu: function(event)
    {
        if (event.target.id == RDPWebClient.FlashId)
        {
            RDPWebClient.MozillaCancelEvent(event);
        }
    },
    MozillaMouse: function(event, fMouseDown)
    {
        if (event.target.id == RDPWebClient.FlashId)
        {
            if (event.button == 2)
            {
                if (fMouseDown)
                {
                    RDPWebClient.callRightMouseDown();
                }
                else
                {
                    RDPWebClient.callRightMouseUp();
                }
                RDPWebClient.MozillaCancelEvent(event);
            }
        }
    },
    callRightMouseDown: function()
    {
        var flash = RDPWebClient.getFlashById(RDPWebClient.FlashId);
        if (flash && flash.rightMouseDown)
        {
            try
            {
                flash.rightMouseDown();
            }
            catch (e) {}; /* Hack for IE, which calls the Flash method but then throws the exception. */
        }
    },
    callRightMouseUp: function()
    {
        var flash = RDPWebClient.getFlashById(RDPWebClient.FlashId);
        if (flash && flash.rightMouseUp)
        {
            try
            {
               flash.rightMouseUp();
            }
            catch (e) {}; /* Hack for IE, which calls the Flash method but then throws the exception. */
        }
    },
    callMouseOut: function()
    {
        var flash = RDPWebClient.getFlashById(RDPWebClient.FlashId);
        if (flash && flash.mouseOut)
        {
            try
            {
               flash.mouseOut();
            }
            catch (e) {}; /* Hack for IE, which calls the Flash method but then throws the exception. */
        }
    },
    getFlashById: function(flashId)
    {
        if (document.embeds && document.embeds[flashId])
            return document.embeds[flashId];

        return document.getElementById(flashId);
    },
    resizeContainer: function(containerId, width, height, reason)
    {
        var e = document.getElementById(containerId);
        if (e)
        {
            e.style.width=width + "px";
            e.style.height=height +  "px";
        }
    }
}
