
/*
 * Copyright (C) 2010-2023 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * IPlatformX86.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_1;

import org.virtualbox_7_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The x86 specific platform properties for a virtual machine.

Accessed via{@link org.virtualbox_7_1.IMachine#getPlatform()}and{@link org.virtualbox_7_1.IPlatform#getX86()}.

Interface ID: <code>{5ADA589F-09C9-4604-B700-9AB3A5572E3A}</code>
*/
public class IPlatformX86 extends IUnknown
{

    public IPlatformX86(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
This attribute controls if High Precision Event Timer (HPET) is
enabled in this VM. Use this property if you want to provide guests
with additional time source, or if guest requires HPET to function correctly.
Default is false.
@return Boolean
*/
    public Boolean getHPETEnabled()
    {
        try
        {
            Boolean retVal = port.iPlatformX86GetHPETEnabled(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
This attribute controls if High Precision Event Timer (HPET) is
enabled in this VM. Use this property if you want to provide guests
with additional time source, or if guest requires HPET to function correctly.
Default is false.
@param value Boolean

*/
    public void setHPETEnabled(Boolean value)
    {
        try
        {
        port.iPlatformX86SetHPETEnabled(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IPlatformX86 queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IPlatformX86(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Returns the virtual CPU boolean value of the specified property.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_INVALIDARG</code> - Invalid property.</dd>
</dl>

@param property Property type to query.

@return Property value.

*/
    public Boolean getCPUProperty(org.virtualbox_7_1.CPUPropertyTypeX86 property)
    {
        try
        {
            Boolean retVal;
        retVal = port.iPlatformX86GetCPUProperty(obj, org.virtualbox_7_1.jaxws.CPUPropertyTypeX86.fromValue(property.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Sets the virtual CPU boolean value of the specified property.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_INVALIDARG</code> - Invalid property.</dd>
</dl>

@param property Property type to query.

@param value Property value.

*/
    public void setCPUProperty(org.virtualbox_7_1.CPUPropertyTypeX86 property, Boolean value)
    {
        try
        {
        port.iPlatformX86SetCPUProperty(obj, org.virtualbox_7_1.jaxws.CPUPropertyTypeX86.fromValue(property.name()), value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Used to enumerate CPUID information override values.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_INVALIDARG</code> - Invalid ordinal number is out of range.</dd>
</dl>

@param ordinal The ordinal number of the leaf to get.

@param idx CPUID leaf index.

@param idxSub CPUID leaf sub-index.

@param valEax CPUID leaf value for register eax.

@param valEbx CPUID leaf value for register ebx.

@param valEcx CPUID leaf value for register ecx.

@param valEdx CPUID leaf value for register edx.

*/
    public void getCPUIDLeafByOrdinal(Long ordinal, Holder<Long> idx, Holder<Long> idxSub, Holder<Long> valEax, Holder<Long> valEbx, Holder<Long> valEcx, Holder<Long> valEdx)
    {
        try
        {
        javax.xml.ws.Holder<Long> tmp_idx = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_idxSub = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEax = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEbx = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEcx = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEdx = new javax.xml.ws.Holder<Long>();
        port.iPlatformX86GetCPUIDLeafByOrdinal(obj, ordinal, tmp_idx, tmp_idxSub, tmp_valEax, tmp_valEbx, tmp_valEcx, tmp_valEdx);
        idx.value = tmp_idx.value;
        idxSub.value = tmp_idxSub.value;
        valEax.value = tmp_valEax.value;
        valEbx.value = tmp_valEbx.value;
        valEcx.value = tmp_valEcx.value;
        valEdx.value = tmp_valEdx.value;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the virtual CPU cpuid information for the specified leaf.

Currently supported index values for cpuid:
Standard CPUID leaves: 0 - 0x1f
Extended CPUID leaves: 0x80000000 - 0x8000001f
VIA CPUID leaves:      0xc0000000 - 0xc000000f

See the Intel, AMD and VIA programmer's manuals for detailed information
about the CPUID instruction and its leaves.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_INVALIDARG</code> - Invalid index.</dd>
</dl>

@param idx CPUID leaf index.

@param idxSub CPUID leaf sub-index (ECX).  Set to 0xffffffff (or 0) if not applicable.

@param valEax CPUID leaf value for register eax.

@param valEbx CPUID leaf value for register ebx.

@param valEcx CPUID leaf value for register ecx.

@param valEdx CPUID leaf value for register edx.

*/
    public void getCPUIDLeaf(Long idx, Long idxSub, Holder<Long> valEax, Holder<Long> valEbx, Holder<Long> valEcx, Holder<Long> valEdx)
    {
        try
        {
        javax.xml.ws.Holder<Long> tmp_valEax = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEbx = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEcx = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEdx = new javax.xml.ws.Holder<Long>();
        port.iPlatformX86GetCPUIDLeaf(obj, idx, idxSub, tmp_valEax, tmp_valEbx, tmp_valEcx, tmp_valEdx);
        valEax.value = tmp_valEax.value;
        valEbx.value = tmp_valEbx.value;
        valEcx.value = tmp_valEcx.value;
        valEdx.value = tmp_valEdx.value;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Sets the virtual CPU cpuid information for the specified leaf. Note that these values
are not passed unmodified. VirtualBox clears features that it doesn't support.

Currently supported index values for cpuid:
Standard CPUID leaves: 0 - 0x1f
Extended CPUID leaves: 0x80000000 - 0x8000001f
VIA CPUID leaves:      0xc0000000 - 0xc000000f

The subleaf index is only applicable to certain leaves (see manuals as this is
subject to change).

See the Intel, AMD and VIA programmer's manuals for detailed information
about the cpuid instruction and its leaves.

Do not use this method unless you know exactly what you're doing. Misuse can lead to
random crashes inside VMs.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_INVALIDARG</code> - Invalid index.</dd>
</dl>

@param idx CPUID leaf index.

@param idxSub CPUID leaf sub-index (ECX).  Set to 0xffffffff (or 0) if not applicable.
The 0xffffffff causes it to remove all other subleaves before adding one
with sub-index 0.

@param valEax CPUID leaf value for register eax.

@param valEbx CPUID leaf value for register ebx.

@param valEcx CPUID leaf value for register ecx.

@param valEdx CPUID leaf value for register edx.

*/
    public void setCPUIDLeaf(Long idx, Long idxSub, Long valEax, Long valEbx, Long valEcx, Long valEdx)
    {
        try
        {
        port.iPlatformX86SetCPUIDLeaf(obj, idx, idxSub, valEax, valEbx, valEcx, valEdx);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Removes the virtual CPU cpuid leaf for the specified index
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_INVALIDARG</code> - Invalid index.</dd>
</dl>

@param idx CPUID leaf index.

@param idxSub CPUID leaf sub-index (ECX).  Set to 0xffffffff (or 0) if not applicable.
The 0xffffffff value works like a wildcard.

*/
    public void removeCPUIDLeaf(Long idx, Long idxSub)
    {
        try
        {
        port.iPlatformX86RemoveCPUIDLeaf(obj, idx, idxSub);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Removes all the virtual CPU cpuid leaves
*/
    public void removeAllCPUIDLeaves()
    {
        try
        {
        port.iPlatformX86RemoveAllCPUIDLeaves(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the value of the specified hardware virtualization boolean property.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_INVALIDARG</code> - Invalid property.</dd>
</dl>

@param property Property type to query.

@return Property value.

*/
    public Boolean getHWVirtExProperty(org.virtualbox_7_1.HWVirtExPropertyType property)
    {
        try
        {
            Boolean retVal;
        retVal = port.iPlatformX86GetHWVirtExProperty(obj, org.virtualbox_7_1.jaxws.HWVirtExPropertyType.fromValue(property.name()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Sets a new value for the specified hardware virtualization boolean property.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_INVALIDARG</code> - Invalid property.</dd>
</dl>

@param property Property type to set.

@param value New property value.

*/
    public void setHWVirtExProperty(org.virtualbox_7_1.HWVirtExPropertyType property, Boolean value)
    {
        try
        {
        port.iPlatformX86SetHWVirtExProperty(obj, org.virtualbox_7_1.jaxws.HWVirtExPropertyType.fromValue(property.name()), value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
