
/*
 * Copyright (C) 2010-2023 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * IUSBDeviceStateChangedEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_0;

import org.virtualbox_7_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when a USB device is attached to or detached from
the virtual USB controller.

This notification is sent as a result of the indirect
request to attach the device because it matches one of the
machine USB filters, or as a result of the direct request
issued by{@link org.virtualbox_7_0.IConsole#attachUSBDevice(String,String)}or{@link org.virtualbox_7_0.IConsole#detachUSBDevice(String)}.

This notification is sent in case of both a succeeded and a
failed request completion. When the request succeeds, the
error parameter is  null, and the given device has been
already added to (when  attached is  true) or removed from
(when  attached is  false) the collection represented by{@link org.virtualbox_7_0.IConsole#getUSBDevices()}. On failure, the collection
doesn't change and the  error parameter represents the error
message describing the failure.

Interface ID: <code>{806DA61B-6679-422A-B629-51B06B0C6D93}</code>
*/
public class IUSBDeviceStateChangedEvent extends IEvent
{

    public IUSBDeviceStateChangedEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Device that is subject to state change.
@return org.virtualbox_7_0.IUSBDevice
*/
    public org.virtualbox_7_0.IUSBDevice getDevice()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iusbDeviceStateChangedEventGetDevice(obj);
            return (retVal.length() > 0) ? new org.virtualbox_7_0.IUSBDevice(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
true if the device was attached and  false otherwise.
@return Boolean
*/
    public Boolean getAttached()
    {
        try
        {
            Boolean retVal = port.iusbDeviceStateChangedEventGetAttached(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
null on success or an error message object on failure.
@return org.virtualbox_7_0.IVirtualBoxErrorInfo
*/
    public org.virtualbox_7_0.IVirtualBoxErrorInfo getError()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iusbDeviceStateChangedEventGetError(obj);
            return (retVal.length() > 0) ? new org.virtualbox_7_0.IVirtualBoxErrorInfo(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public static IUSBDeviceStateChangedEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IUSBDeviceStateChangedEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
