
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * RecordingVideoCodec.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
Recording video codec enumeration.
Interface ID: <tt>{663BFC39-AFFF-49FA-98DD-322A857E877B}</tt>
*/
public enum RecordingVideoCodec
{

/**
No codec set.
*/
    None(0),

/**
VP8 codec.
*/
    VP8(1),

/**
VP9 codec. Not implemented yet.
*/
    VP9(2),

/**
AV1 codec. Not implemented yet.
*/
    AV1(3);

    private final int value;

    RecordingVideoCodec(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static RecordingVideoCodec fromValue(long v)
    {
        for (RecordingVideoCodec c: RecordingVideoCodec.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static RecordingVideoCodec fromValue(String v)
    {
        return valueOf(RecordingVideoCodec.class, v);
    }
}

