
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * ParavirtProvider.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
The paravirtualized guest interface provider. This enumeration represents possible
values for the{@link org.virtualbox_6_1.IMachine#getParavirtProvider()}attribute.
Interface ID: <tt>{696453EC-3742-4A05-BEAD-658CCBF2C944}</tt>
*/
public enum ParavirtProvider
{

/**
No provider is used.
*/
    None(0),

/**
A default provider is automatically chosen according to the guest OS type.
*/
    Default(1),

/**
Used for VMs which didn't used to have any provider settings. Usually
interpreted as  None for most VMs.
*/
    Legacy(2),

/**
A minimal set of features to expose to the paravirtualized guest.
*/
    Minimal(3),

/**
Microsoft Hyper-V.
*/
    HyperV(4),

/**
Linux KVM.
*/
    KVM(5);

    private final int value;

    ParavirtProvider(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static ParavirtProvider fromValue(long v)
    {
        for (ParavirtProvider c: ParavirtProvider.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static ParavirtProvider fromValue(String v)
    {
        return valueOf(ParavirtProvider.class, v);
    }
}

