
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IMouseCapabilityChangedEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when the mouse capabilities reported by the
guest have changed. The new capabilities are passed.

Interface ID: <tt>{70E7779A-E64A-4908-804E-371CAD23A756}</tt>
*/
public class IMouseCapabilityChangedEvent extends IEvent
{

    public IMouseCapabilityChangedEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Supports absolute coordinates.
@return Boolean
*/
    public Boolean getSupportsAbsolute()
    {
        try
        {
            Boolean retVal = port.iMouseCapabilityChangedEventGetSupportsAbsolute(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Supports relative coordinates.
@return Boolean
*/
    public Boolean getSupportsRelative()
    {
        try
        {
            Boolean retVal = port.iMouseCapabilityChangedEventGetSupportsRelative(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Supports multi-touch events coordinates.
@return Boolean
*/
    public Boolean getSupportsMultiTouch()
    {
        try
        {
            Boolean retVal = port.iMouseCapabilityChangedEventGetSupportsMultiTouch(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
If host cursor is needed.
@return Boolean
*/
    public Boolean getNeedsHostCursor()
    {
        try
        {
            Boolean retVal = port.iMouseCapabilityChangedEventGetNeedsHostCursor(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IMouseCapabilityChangedEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IMouseCapabilityChangedEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
