
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestOSType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**


Interface ID: <tt>{D0D6C6D8-E5DB-4D2C-BAAA-C71053A6236D}</tt>
*/
public class IGuestOSType
{

    private org.virtualbox_6_1.jaxws.IGuestOSType real;
    private VboxPortType port;
    private ObjectRefManager objMgr;

    public IGuestOSType(org.virtualbox_6_1.jaxws.IGuestOSType real, ObjectRefManager objMgr, VboxPortType port)
    {
        this.real = real;
        this.port = port;
        this.objMgr = objMgr;
    }

    private ObjectRefManager getObjMgr()
    {
        return this.objMgr;
    }

/**
Guest OS family identifier string.
@return String
*/
    public String getFamilyId()
    {
        String retVal = real.getFamilyId();
        return retVal;
    }

/**
Human readable description of the guest OS family.
@return String
*/
    public String getFamilyDescription()
    {
        String retVal = real.getFamilyDescription();
        return retVal;
    }

/**
Guest OS identifier string.
@return String
*/
    public String getId()
    {
        String retVal = real.getId();
        return retVal;
    }

/**
Human readable description of the guest OS.
@return String
*/
    public String getDescription()
    {
        String retVal = real.getDescription();
        return retVal;
    }

/**
Returns  true if the given OS is 64-bit
@return Boolean
*/
    public Boolean getIs64Bit()
    {
        Boolean retVal = real.isIs64Bit();
        return retVal;
    }

/**
Returns  true if I/O-APIC recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedIOAPIC()
    {
        Boolean retVal = real.isRecommendedIOAPIC();
        return retVal;
    }

/**
Returns  true if VT-x or AMD-V recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedVirtEx()
    {
        Boolean retVal = real.isRecommendedVirtEx();
        return retVal;
    }

/**
Recommended RAM size in Megabytes.
@return Long
*/
    public Long getRecommendedRAM()
    {
        Long retVal = real.getRecommendedRAM();
        return retVal;
    }

/**
Recommended graphics controller type.
@return org.virtualbox_6_1.GraphicsControllerType
*/
    public org.virtualbox_6_1.GraphicsControllerType getRecommendedGraphicsController()
    {
        org.virtualbox_6_1.jaxws.GraphicsControllerType retVal = real.getRecommendedGraphicsController();
        return org.virtualbox_6_1.GraphicsControllerType.fromValue(retVal.value());
    }

/**
Recommended video RAM size in Megabytes.
@return Long
*/
    public Long getRecommendedVRAM()
    {
        Long retVal = real.getRecommendedVRAM();
        return retVal;
    }

/**
Returns  true if 2D video acceleration is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommended2DVideoAcceleration()
    {
        Boolean retVal = real.isRecommended2DVideoAcceleration();
        return retVal;
    }

/**
Returns  true if 3D acceleration is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommended3DAcceleration()
    {
        Boolean retVal = real.isRecommended3DAcceleration();
        return retVal;
    }

/**
Recommended hard disk size in bytes.
@return Long
*/
    public Long getRecommendedHDD()
    {
        Long retVal = real.getRecommendedHDD();
        return retVal;
    }

/**
Returns recommended network adapter for this OS type.
@return org.virtualbox_6_1.NetworkAdapterType
*/
    public org.virtualbox_6_1.NetworkAdapterType getAdapterType()
    {
        org.virtualbox_6_1.jaxws.NetworkAdapterType retVal = real.getAdapterType();
        return org.virtualbox_6_1.NetworkAdapterType.fromValue(retVal.value());
    }

/**
Returns  true if using PAE is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedPAE()
    {
        Boolean retVal = real.isRecommendedPAE();
        return retVal;
    }

/**
Recommended storage controller type for DVD/CD drives.
@return org.virtualbox_6_1.StorageControllerType
*/
    public org.virtualbox_6_1.StorageControllerType getRecommendedDVDStorageController()
    {
        org.virtualbox_6_1.jaxws.StorageControllerType retVal = real.getRecommendedDVDStorageController();
        return org.virtualbox_6_1.StorageControllerType.fromValue(retVal.value());
    }

/**
Recommended storage bus type for DVD/CD drives.
@return org.virtualbox_6_1.StorageBus
*/
    public org.virtualbox_6_1.StorageBus getRecommendedDVDStorageBus()
    {
        org.virtualbox_6_1.jaxws.StorageBus retVal = real.getRecommendedDVDStorageBus();
        return org.virtualbox_6_1.StorageBus.fromValue(retVal.value());
    }

/**
Recommended storage controller type for HD drives.
@return org.virtualbox_6_1.StorageControllerType
*/
    public org.virtualbox_6_1.StorageControllerType getRecommendedHDStorageController()
    {
        org.virtualbox_6_1.jaxws.StorageControllerType retVal = real.getRecommendedHDStorageController();
        return org.virtualbox_6_1.StorageControllerType.fromValue(retVal.value());
    }

/**
Recommended storage bus type for HD drives.
@return org.virtualbox_6_1.StorageBus
*/
    public org.virtualbox_6_1.StorageBus getRecommendedHDStorageBus()
    {
        org.virtualbox_6_1.jaxws.StorageBus retVal = real.getRecommendedHDStorageBus();
        return org.virtualbox_6_1.StorageBus.fromValue(retVal.value());
    }

/**
Recommended firmware type.
@return org.virtualbox_6_1.FirmwareType
*/
    public org.virtualbox_6_1.FirmwareType getRecommendedFirmware()
    {
        org.virtualbox_6_1.jaxws.FirmwareType retVal = real.getRecommendedFirmware();
        return org.virtualbox_6_1.FirmwareType.fromValue(retVal.value());
    }

/**
Returns  true if using USB Human Interface Devices, such as keyboard and mouse recommended.
@return Boolean
*/
    public Boolean getRecommendedUSBHID()
    {
        Boolean retVal = real.isRecommendedUSBHID();
        return retVal;
    }

/**
Returns  true if using HPET is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedHPET()
    {
        Boolean retVal = real.isRecommendedHPET();
        return retVal;
    }

/**
Returns  true if using a USB Tablet is recommended.
@return Boolean
*/
    public Boolean getRecommendedUSBTablet()
    {
        Boolean retVal = real.isRecommendedUSBTablet();
        return retVal;
    }

/**
Returns  true if the RTC of this VM should be set to UTC
@return Boolean
*/
    public Boolean getRecommendedRTCUseUTC()
    {
        Boolean retVal = real.isRecommendedRTCUseUTC();
        return retVal;
    }

/**
Recommended chipset type.
@return org.virtualbox_6_1.ChipsetType
*/
    public org.virtualbox_6_1.ChipsetType getRecommendedChipset()
    {
        org.virtualbox_6_1.jaxws.ChipsetType retVal = real.getRecommendedChipset();
        return org.virtualbox_6_1.ChipsetType.fromValue(retVal.value());
    }

/**
Recommended audio controller type.
@return org.virtualbox_6_1.AudioControllerType
*/
    public org.virtualbox_6_1.AudioControllerType getRecommendedAudioController()
    {
        org.virtualbox_6_1.jaxws.AudioControllerType retVal = real.getRecommendedAudioController();
        return org.virtualbox_6_1.AudioControllerType.fromValue(retVal.value());
    }

/**
Recommended audio codec type.
@return org.virtualbox_6_1.AudioCodecType
*/
    public org.virtualbox_6_1.AudioCodecType getRecommendedAudioCodec()
    {
        org.virtualbox_6_1.jaxws.AudioCodecType retVal = real.getRecommendedAudioCodec();
        return org.virtualbox_6_1.AudioCodecType.fromValue(retVal.value());
    }

/**
Returns  true a floppy drive is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedFloppy()
    {
        Boolean retVal = real.isRecommendedFloppy();
        return retVal;
    }

/**
Returns  true a USB controller is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedUSB()
    {
        Boolean retVal = real.isRecommendedUSB();
        return retVal;
    }

/**
Returns  true an xHCI (USB 3) controller is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedUSB3()
    {
        Boolean retVal = real.isRecommendedUSB3();
        return retVal;
    }

/**
Returns  true if using VCPU reset on triple fault is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedTFReset()
    {
        Boolean retVal = real.isRecommendedTFReset();
        return retVal;
    }

/**
Returns  true if X2APIC is recommended for this OS type.
@return Boolean
*/
    public Boolean getRecommendedX2APIC()
    {
        Boolean retVal = real.isRecommendedX2APIC();
        return retVal;
    }

/**
Number of vCPUs recommended for this OS type.
@return Long
*/
    public Long getRecommendedCPUCount()
    {
        Long retVal = real.getRecommendedCPUCount();
        return retVal;
    }
}
