
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IAdditionsFacility.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Structure representing a Guest Additions facility.

Interface ID: <tt>{F2F7FAE4-4A06-81FC-A916-78B2DA1FA0E5}</tt>
*/
public class IAdditionsFacility
{

    private org.virtualbox_6_1.jaxws.IAdditionsFacility real;
    private VboxPortType port;
    private ObjectRefManager objMgr;

    public IAdditionsFacility(org.virtualbox_6_1.jaxws.IAdditionsFacility real, ObjectRefManager objMgr, VboxPortType port)
    {
        this.real = real;
        this.port = port;
        this.objMgr = objMgr;
    }

    private ObjectRefManager getObjMgr()
    {
        return this.objMgr;
    }

/**
The class this facility is part of.
@return org.virtualbox_6_1.AdditionsFacilityClass
*/
    public org.virtualbox_6_1.AdditionsFacilityClass getClassType()
    {
        org.virtualbox_6_1.jaxws.AdditionsFacilityClass retVal = real.getClassType();
        return org.virtualbox_6_1.AdditionsFacilityClass.fromValue(retVal.value());
    }

/**
Timestamp of the last status update,
in milliseconds since 1970-01-01 UTC.
@return Long
*/
    public Long getLastUpdated()
    {
        Long retVal = real.getLastUpdated();
        return retVal;
    }

/**
The facility's friendly name.
@return String
*/
    public String getName()
    {
        String retVal = real.getName();
        return retVal;
    }

/**
The current status.
@return org.virtualbox_6_1.AdditionsFacilityStatus
*/
    public org.virtualbox_6_1.AdditionsFacilityStatus getStatus()
    {
        org.virtualbox_6_1.jaxws.AdditionsFacilityStatus retVal = real.getStatus();
        return org.virtualbox_6_1.AdditionsFacilityStatus.fromValue(retVal.value());
    }

/**
The facility's type ID.
@return org.virtualbox_6_1.AdditionsFacilityType
*/
    public org.virtualbox_6_1.AdditionsFacilityType getType()
    {
        org.virtualbox_6_1.jaxws.AdditionsFacilityType retVal = real.getType();
        return org.virtualbox_6_1.AdditionsFacilityType.fromValue(retVal.value());
    }
}
