
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * GuestMonitorStatus.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
The current status of the guest display.
Interface ID: <tt>{6B8D3F71-39CB-459E-A916-48917ED43E19}</tt>
*/
public enum GuestMonitorStatus
{

/**
The guest monitor is disabled in the guest.
*/
    Disabled(0),

/**
The guest monitor is enabled in the guest.
*/
    Enabled(1),

/**
The guest monitor is enabled in the guest but should display nothing.
*/
    Blank(2);

    private final int value;

    GuestMonitorStatus(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static GuestMonitorStatus fromValue(long v)
    {
        for (GuestMonitorStatus c: GuestMonitorStatus.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static GuestMonitorStatus fromValue(String v)
    {
        return valueOf(GuestMonitorStatus.class, v);
    }
}

