/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_6_1;

import java.util.List;
import org.virtualbox_6_1.Helper;
import org.virtualbox_6_1.IUSBDeviceFilter;
import org.virtualbox_6_1.IUnknown;
import org.virtualbox_6_1.ObjectRefManager;
import org.virtualbox_6_1.VBoxException;
import org.virtualbox_6_1.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_6_1.jaxws.RuntimeFaultMsg;
import org.virtualbox_6_1.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IUSBDeviceFilters
extends IUnknown {
    public IUSBDeviceFilters(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public List<IUSBDeviceFilter> getDeviceFilters() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iusbDeviceFiltersGetDeviceFilters(this.obj);
            List<IUSBDeviceFilter> list2 = Helper.wrap(IUSBDeviceFilter.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public static IUSBDeviceFilters queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IUSBDeviceFilters(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public IUSBDeviceFilter createDeviceFilter(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iusbDeviceFiltersCreateDeviceFilter(this.obj, string);
            IUSBDeviceFilter iUSBDeviceFilter = string2.length() > 0 ? new IUSBDeviceFilter(string2, this.getObjMgr(), this.port) : null;
            return iUSBDeviceFilter;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void insertDeviceFilter(Long l, IUSBDeviceFilter iUSBDeviceFilter) {
        try {
            this.port.iusbDeviceFiltersInsertDeviceFilter(this.obj, l, iUSBDeviceFilter == null ? null : iUSBDeviceFilter.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IUSBDeviceFilter removeDeviceFilter(Long l) {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iusbDeviceFiltersRemoveDeviceFilter(this.obj, l);
            IUSBDeviceFilter iUSBDeviceFilter = string.length() > 0 ? new IUSBDeviceFilter(string, this.getObjMgr(), this.port) : null;
            return iUSBDeviceFilter;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }
}

