
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * RecordingFeature.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
Recording features enumeration.
Interface ID: <tt>{A7DDC6A5-DAA8-4485-B860-E9F2E98A7794}</tt>
*/
public enum RecordingFeature
{

/**
No feature set.
*/
    None(0),

/**
Video recording.
*/
    Video(1),

/**
Audio recording.
*/
    Audio(2);

    private final int value;

    RecordingFeature(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static RecordingFeature fromValue(long v)
    {
        for (RecordingFeature c: RecordingFeature.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static RecordingFeature fromValue(String v)
    {
        return valueOf(RecordingFeature.class, v);
    }
}

