/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_6_1;

import java.util.List;
import org.virtualbox_6_1.Helper;
import org.virtualbox_6_1.IEventSource;
import org.virtualbox_6_1.IUnknown;
import org.virtualbox_6_1.ObjectRefManager;
import org.virtualbox_6_1.ProcessStatus;
import org.virtualbox_6_1.VBoxException;
import org.virtualbox_6_1.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_6_1.jaxws.ProcessInputFlag;
import org.virtualbox_6_1.jaxws.ProcessWaitForFlag;
import org.virtualbox_6_1.jaxws.ProcessWaitResult;
import org.virtualbox_6_1.jaxws.RuntimeFaultMsg;
import org.virtualbox_6_1.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IProcess
extends IUnknown {
    public IProcess(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public List<String> getArguments() {
        try {
            List<String> list = this.port.iProcessGetArguments(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<String> getEnvironment() {
        try {
            List<String> list = this.port.iProcessGetEnvironment(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IEventSource getEventSource() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iProcessGetEventSource(this.obj);
            IEventSource iEventSource = string.length() > 0 ? new IEventSource(string, this.getObjMgr(), this.port) : null;
            return iEventSource;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public String getExecutablePath() {
        try {
            String string = this.port.iProcessGetExecutablePath(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Integer getExitCode() {
        try {
            Integer n = this.port.iProcessGetExitCode(this.obj);
            return n;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getName() {
        try {
            String string = this.port.iProcessGetName(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getPID() {
        try {
            Long l = this.port.iProcessGetPID(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public ProcessStatus getStatus() {
        try {
            org.virtualbox_6_1.jaxws.ProcessStatus processStatus = this.port.iProcessGetStatus(this.obj);
            return ProcessStatus.fromValue(processStatus.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public static IProcess queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IProcess(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public org.virtualbox_6_1.ProcessWaitResult waitFor(Long l, Long l2) {
        try {
            ProcessWaitResult processWaitResult = this.port.iProcessWaitFor(this.obj, l, l2);
            return org.virtualbox_6_1.ProcessWaitResult.fromValue(processWaitResult.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public org.virtualbox_6_1.ProcessWaitResult waitForArray(List<org.virtualbox_6_1.ProcessWaitForFlag> list, Long l) {
        try {
            ProcessWaitResult processWaitResult = this.port.iProcessWaitForArray(this.obj, Helper.convertEnums(org.virtualbox_6_1.ProcessWaitForFlag.class, ProcessWaitForFlag.class, list), l);
            return org.virtualbox_6_1.ProcessWaitResult.fromValue(processWaitResult.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public byte[] read(Long l, Long l2, Long l3) {
        try {
            String string = this.port.iProcessRead(this.obj, l, l2, l3);
            return Helper.decodeBase64(string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long write(Long l, Long l2, byte[] byArray, Long l3) {
        try {
            Long l4 = this.port.iProcessWrite(this.obj, l, l2, Helper.encodeBase64(byArray), l3);
            return l4;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long writeArray(Long l, List<org.virtualbox_6_1.ProcessInputFlag> list, byte[] byArray, Long l2) {
        try {
            Long l3 = this.port.iProcessWriteArray(this.obj, l, Helper.convertEnums(org.virtualbox_6_1.ProcessInputFlag.class, ProcessInputFlag.class, list), Helper.encodeBase64(byArray), l2);
            return l3;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void terminate() {
        try {
            this.port.iProcessTerminate(this.obj);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }
}

