
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * GraphicsControllerType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
Graphics controller type, used with{@link org.virtualbox_6_1.IGraphicsAdapter#getGraphicsControllerType()}.
Interface ID: <tt>{3E009BB0-2B57-4283-A39B-4C363D4F0808}</tt>
*/
public enum GraphicsControllerType
{

/**
Reserved value, invalid.
*/
    Null(0),

/**
VirtualBox VGA device.
*/
    VBoxVGA(1),

/**
VMware SVGA II device.
*/
    VMSVGA(2),

/**
VirtualBox VGA device with VMware SVGA II extensions.
*/
    VBoxSVGA(3);

    private final int value;

    GraphicsControllerType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static GraphicsControllerType fromValue(long v)
    {
        for (GraphicsControllerType c: GraphicsControllerType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static GraphicsControllerType fromValue(String v)
    {
        return valueOf(GraphicsControllerType.class, v);
    }
}

