
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * DirectoryCopyFlag.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_0;

import org.virtualbox_6_0.jaxws.*;
import javax.xml.ws.*;

/**
Directory copying flags.
NOTE: Not flags are implemented yet.

Interface ID: <tt>{B5901856-D064-4FBC-AB06-2909BA106154}</tt>
*/
public enum DirectoryCopyFlag
{

/**
No flag set.
*/
    None(0),

/**
Allow copying into an existing destination directory.
*/
    CopyIntoExisting(1);

    private final int value;

    DirectoryCopyFlag(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static DirectoryCopyFlag fromValue(long v)
    {
        for (DirectoryCopyFlag c: DirectoryCopyFlag.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static DirectoryCopyFlag fromValue(String v)
    {
        return valueOf(DirectoryCopyFlag.class, v);
    }
}

