
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IPCIDeviceAttachment.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Information about PCI attachments.

Interface ID: <tt>{91F33D6F-E621-4F70-A77E-15F0E3C714D5}</tt>
*/
public class IPCIDeviceAttachment
{

    private org.virtualbox_5_2.jaxws.IPCIDeviceAttachment real;
    private VboxPortType port;
    private ObjectRefManager objMgr;

    public IPCIDeviceAttachment(org.virtualbox_5_2.jaxws.IPCIDeviceAttachment real, ObjectRefManager objMgr, VboxPortType port)
    {
        this.real = real;
        this.port = port;
        this.objMgr = objMgr;
    }

    private ObjectRefManager getObjMgr()
    {
        return this.objMgr;
    }

/**
Device name.
@return String
*/
    public String getName()
    {
        String retVal = real.getName();
        return retVal;
    }

/**
If this is physical or virtual device.
@return Boolean
*/
    public Boolean getIsPhysicalDevice()
    {
        Boolean retVal = real.isIsPhysicalDevice();
        return retVal;
    }

/**
Address of device on the host, applicable only to host devices.
@return Integer
*/
    public Integer getHostAddress()
    {
        Integer retVal = real.getHostAddress();
        return retVal;
    }

/**
Address of device in the guest.
@return Integer
*/
    public Integer getGuestAddress()
    {
        Integer retVal = real.getGuestAddress();
        return retVal;
    }
}
