
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IMediumChangedEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when a{@link org.virtualbox_5_2.IMachine#getMediumAttachments()}changes.
NOTE: This event is not yet implemented.


Interface ID: <tt>{0FE2DA40-5637-472A-9736-72019EABD7DE}</tt>
*/
public class IMediumChangedEvent extends IEvent
{

    public IMediumChangedEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Medium attachment that is subject to change.
@return org.virtualbox_5_2.IMediumAttachment
*/
    public org.virtualbox_5_2.IMediumAttachment getMediumAttachment()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            org.virtualbox_5_2.jaxws.IMediumAttachment retVal = port.iMediumChangedEventGetMediumAttachment(obj);
            return (retVal != null) ? new org.virtualbox_5_2.IMediumAttachment(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public static IMediumChangedEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IMediumChangedEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
