
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestMultiTouchEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when guest touch screen event happens.

Interface ID: <tt>{BE8A0EB5-F4F4-4DD0-9D30-C89B873247EC}</tt>
*/
public class IGuestMultiTouchEvent extends IEvent
{

    public IGuestMultiTouchEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Number of contacts in the event.
@return Integer
*/
    public Integer getContactCount()
    {
        try
        {
            Integer retVal = port.iGuestMultiTouchEventGetContactCount(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
X positions.
@return List&lt;Short&gt;
*/
    public List<Short> getXPositions()
    {
        try
        {
            List<Short> retVal = port.iGuestMultiTouchEventGetXPositions(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Y positions.
@return List&lt;Short&gt;
*/
    public List<Short> getYPositions()
    {
        try
        {
            List<Short> retVal = port.iGuestMultiTouchEventGetYPositions(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Contact identifiers.
@return List&lt;Integer&gt;
*/
    public List<Integer> getContactIds()
    {
        try
        {
            List<Integer> retVal = port.iGuestMultiTouchEventGetContactIds(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Contact state.
Bit 0: in contact.
Bit 1: in range.
@return List&lt;Integer&gt;
*/
    public List<Integer> getContactFlags()
    {
        try
        {
            List<Integer> retVal = port.iGuestMultiTouchEventGetContactFlags(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Timestamp of the event in milliseconds. Only relative time between events is important.
@return Long
*/
    public Long getScanTime()
    {
        try
        {
            Long retVal = port.iGuestMultiTouchEventGetScanTime(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IGuestMultiTouchEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestMultiTouchEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
