
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestFileStateChangedEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when a guest file changed its state.

Interface ID: <tt>{D37FE88F-0979-486C-BAA1-3ABB144DC82D}</tt>
*/
public class IGuestFileStateChangedEvent extends IGuestFileEvent
{

    public IGuestFileStateChangedEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
New guest file status.
@return org.virtualbox_5_2.FileStatus
*/
    public org.virtualbox_5_2.FileStatus getStatus()
    {
        try
        {
            org.virtualbox_5_2.jaxws.FileStatus retVal = port.iGuestFileStateChangedEventGetStatus(obj);
            return org.virtualbox_5_2.FileStatus.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Error information in case of new session status is indicating an error.

The attribute{@link org.virtualbox_5_2.IVirtualBoxErrorInfo#getResultDetail()}will contain
the runtime (IPRT) error code from the guest. See include/iprt/err.h and
include/VBox/err.h for details.
@return org.virtualbox_5_2.IVirtualBoxErrorInfo
*/
    public org.virtualbox_5_2.IVirtualBoxErrorInfo getError()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iGuestFileStateChangedEventGetError(obj);
            return (retVal.length() > 0) ? new org.virtualbox_5_2.IVirtualBoxErrorInfo(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public static IGuestFileStateChangedEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestFileStateChangedEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
