
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * AudioCodecType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;

/**
The exact variant of audio codec hardware presented
to the guest; see{@link org.virtualbox_5_2.IAudioAdapter#getAudioCodec()}.
Interface ID: <tt>{7B406301-F520-420C-9805-8CE11C086370}</tt>
*/
public enum AudioCodecType
{

/**
null value. Never used by the API.
*/
    Null(0),

/**
SB16; this is the only option for the SB16 device.
*/
    SB16(1),

/**
A STAC9700 AC'97 codec.
*/
    STAC9700(2),

/**
An AD1980 AC'97 codec. Recommended for Linux guests.
*/
    AD1980(3),

/**
A STAC9221 HDA codec.
*/
    STAC9221(4);

    private final int value;

    AudioCodecType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static AudioCodecType fromValue(long v)
    {
        for (AudioCodecType c: AudioCodecType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static AudioCodecType fromValue(String v)
    {
        return valueOf(AudioCodecType.class, v);
    }
}

