/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_5_2;

import java.io.File;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.xpcom.Mozilla;
import org.virtualbox_5_2.EventListenerImpl;
import org.virtualbox_5_2.IEventListener;
import org.virtualbox_5_2.IMachine;
import org.virtualbox_5_2.ISession;
import org.virtualbox_5_2.IVirtualBox;
import org.virtualbox_5_2.LockType;
import org.virtualbox_5_2.VBoxException;

public class VirtualBoxManager {
    private Mozilla mozilla;
    private IVirtualBox vbox;
    private nsIComponentManager componentManager;
    private static boolean hasInstance = false;
    private static boolean isMozillaInited = false;

    private VirtualBoxManager(Mozilla mozilla) {
        this.mozilla = mozilla;
        this.componentManager = mozilla.getComponentManager();
        this.vbox = new IVirtualBox((org.mozilla.interfaces.IVirtualBox)this.componentManager.createInstanceByContractID("@virtualbox.org/VirtualBox;1", null, "{9570b9d5-f1a1-448a-10c5-e12f5285adad}"));
    }

    public void connect(String string, String string2, String string3) {
        throw new VBoxException("Connect doesn't make sense for local bindings");
    }

    public void disconnect() {
        throw new VBoxException("Disconnect doesn't make sense for local bindings");
    }

    public static void initPerThread() {
    }

    public static void deinitPerThread() {
    }

    public String getClientAPIVersion() {
        return "5_2";
    }

    public IVirtualBox getVBox() {
        return this.vbox;
    }

    public ISession getSessionObject() {
        return new ISession((org.mozilla.interfaces.ISession)this.componentManager.createInstanceByContractID("@virtualbox.org/Session;1", null, "{7844aa05-b02e-4cdd-a04f-ade4a762e6b7}"));
    }

    public ISession openMachineSession(IMachine iMachine) throws Exception {
        ISession iSession = this.getSessionObject();
        iMachine.lockMachine(iSession, LockType.Shared);
        return iSession;
    }

    public void closeMachineSession(ISession iSession) {
        if (iSession != null) {
            iSession.unlockMachine();
        }
    }

    public static synchronized VirtualBoxManager createInstance(String string) {
        if (hasInstance) {
            throw new VBoxException("only one instance of VirtualBoxManager at a time allowed");
        }
        if (string == null || string.equals("")) {
            string = System.getProperty("vbox.home");
        }
        if (string == null) {
            throw new VBoxException("vbox.home Java property must be defined to use XPCOM bridge");
        }
        File file = new File(string);
        Mozilla mozilla = Mozilla.getInstance();
        if (!isMozillaInited) {
            mozilla.initialize(file);
            try {
                mozilla.initXPCOM(file, null);
                isMozillaInited = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        hasInstance = true;
        return new VirtualBoxManager(mozilla);
    }

    public IEventListener createListener(Object object) {
        return new IEventListener(new EventListenerImpl(object));
    }

    public void cleanup() {
        VirtualBoxManager.deinitPerThread();
        this.mozilla = null;
        hasInstance = false;
    }

    public void waitForEvents(long l) {
        this.mozilla.waitForEvents(l);
    }
}

