/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_5_2;

import org.virtualbox_5_2.IEvent;
import org.virtualbox_5_2.IUSBDevice;
import org.virtualbox_5_2.IUnknown;
import org.virtualbox_5_2.IVirtualBoxErrorInfo;
import org.virtualbox_5_2.ObjectRefManager;
import org.virtualbox_5_2.VBoxException;
import org.virtualbox_5_2.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_5_2.jaxws.RuntimeFaultMsg;
import org.virtualbox_5_2.jaxws.VboxPortType;

public class IUSBDeviceStateChangedEvent
extends IEvent {
    public IUSBDeviceStateChangedEvent(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public IUSBDevice getDevice() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iusbDeviceStateChangedEventGetDevice(this.obj);
            IUSBDevice iUSBDevice = string.length() > 0 ? new IUSBDevice(string, this.getObjMgr(), this.port) : null;
            return iUSBDevice;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public Boolean getAttached() {
        try {
            Boolean bl = this.port.iusbDeviceStateChangedEventGetAttached(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IVirtualBoxErrorInfo getError() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iusbDeviceStateChangedEventGetError(this.obj);
            IVirtualBoxErrorInfo iVirtualBoxErrorInfo = string.length() > 0 ? new IVirtualBoxErrorInfo(string, this.getObjMgr(), this.port) : null;
            return iVirtualBoxErrorInfo;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public static IUSBDeviceStateChangedEvent queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IUSBDeviceStateChangedEvent(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }
}

