
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IUnattended.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The IUnattended interface represents the pipeline for preparing
the Guest OS for fully automated install.

It is based on the IMachine:{@link org.virtualbox_5_2.IMachine#getUnattended()}attribute.

Interface ID: <tt>{167420E1-B72B-488E-9D56-F45894A8623A}</tt>
*/
public class IUnattended extends IUnknown
{

    public IUnattended(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
A group this VM belongs to.
@return String
*/
    public String getGroup()
    {
        try
        {
            String retVal = port.iUnattendedGetGroup(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
A group this VM belongs to.
@param value String

*/
    public void setGroup(String value)
    {
        try
        {
        port.iUnattendedSetGroup(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Guest Additions ISO image path
@return String
*/
    public String getVboxAdditionsIsoPath()
    {
        try
        {
            String retVal = port.iUnattendedGetVboxAdditionsIsoPath(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Guest Additions ISO image path
@param value String

*/
    public void setVboxAdditionsIsoPath(String value)
    {
        try
        {
        port.iUnattendedSetVboxAdditionsIsoPath(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Guest operating system ISO image
@return String
*/
    public String getIsoPath()
    {
        try
        {
            String retVal = port.iUnattendedGetIsoPath(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Guest operating system ISO image
@param value String

*/
    public void setIsoPath(String value)
    {
        try
        {
        port.iUnattendedSetIsoPath(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Assign an user name.
@return String
*/
    public String getUser()
    {
        try
        {
            String retVal = port.iUnattendedGetUser(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Assign an user name.
@param value String

*/
    public void setUser(String value)
    {
        try
        {
        port.iUnattendedSetUser(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Assign a password to the user. The password is the same for both
normal user and for Administrator / 'root' accounts.
@return String
*/
    public String getPassword()
    {
        try
        {
            String retVal = port.iUnattendedGetPassword(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Assign a password to the user. The password is the same for both
normal user and for Administrator / 'root' accounts.
@param value String

*/
    public void setPassword(String value)
    {
        try
        {
        port.iUnattendedSetPassword(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Any key which is used as authorization of access to install genuine OS
@return String
*/
    public String getProductKey()
    {
        try
        {
            String retVal = port.iUnattendedGetProductKey(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Any key which is used as authorization of access to install genuine OS
@param value String

*/
    public void setProductKey(String value)
    {
        try
        {
        port.iUnattendedSetProductKey(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
specifies if the Oracle VirtualBox additions should be installed or not.
(Answering "false" does not affect Guest Additions, that come
pre-installed with certain versions of Linux guests, such as openSUSE).
Currently not implemented.
@return Boolean
*/
    public Boolean getInstallGuestAdditions()
    {
        try
        {
            Boolean retVal = port.iUnattendedGetInstallGuestAdditions(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
specifies if the Oracle VirtualBox additions should be installed or not.
(Answering "false" does not affect Guest Additions, that come
pre-installed with certain versions of Linux guests, such as openSUSE).
Currently not implemented.
@param value Boolean

*/
    public void setInstallGuestAdditions(Boolean value)
    {
        try
        {
        port.iUnattendedSetInstallGuestAdditions(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The image index on installation CD/DVD used to install.
Used only with Windows installation CD/DVD
@return Integer
*/
    public Integer getImageIndex()
    {
        try
        {
            Integer retVal = port.iUnattendedGetImageIndex(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The image index on installation CD/DVD used to install.
Used only with Windows installation CD/DVD
@param value Integer

*/
    public void setImageIndex(Integer value)
    {
        try
        {
        port.iUnattendedSetImageIndex(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IUnattended queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IUnattended(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Preparation for running the unattended process of installation
*/
    public void preparation()
    {
        try
        {
        port.iUnattendedPreparation(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Generates Guest-OS-specific unattended script.
*/
    public void constructScript()
    {
        try
        {
        port.iUnattendedConstructScript(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Fix scripts in auxiliary CD ISO if it's needed
Packages Guest-OS-specific unattended script into auxiliary CD ISO
or into auxiliary floppy, depending on IMachine::OSTypId.
*/
    public void constructMedia()
    {
        try
        {
        port.iUnattendedConstructMedia(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Prepare a newly created VM to start unattended installation
(For example, such steps like open/attach bootable CD/FDD, OS ISO, additions)
*/
    public void reconstructVM()
    {
        try
        {
        port.iUnattendedReconstructVM(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Run unattended installation
*/
    public void runInstallation()
    {
        try
        {
        port.iUnattendedRunInstallation(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
