
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IDnDTarget.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Abstract interface for handling drag'n drop targets.

Interface ID: <tt>{FF5BEFC3-4BA3-7903-2AA4-43988BA11554}</tt>
*/
public class IDnDTarget extends IDnDBase
{

    public IDnDTarget(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }
    public static IDnDTarget queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IDnDTarget(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Informs the target about a drag and drop enter event.
@param screenId The screen ID where the drag and drop event occurred.

@param y Y-position of the event.

@param x X-position of the event.

@param defaultAction The default action to use.

@param allowedActions The actions which are allowed.

@param formats The supported MIME types.

@return The resulting action of this event.

Expected result codes:
<table summary="">
<tr><td>@link ::VBOX_E_VM_ERROR VBOX_E_VM_ERROR</td><td>VMM device is not available.</td></tr>
</table>

*/
    public org.virtualbox_5_2.DnDAction enter(Long screenId, Long y, Long x, org.virtualbox_5_2.DnDAction defaultAction, List<org.virtualbox_5_2.DnDAction> allowedActions, List<String> formats)
    {
        try
        {
            org.virtualbox_5_2.jaxws.DnDAction retVal;
        retVal = port.iDnDTargetEnter(obj, screenId, y, x, org.virtualbox_5_2.jaxws.DnDAction.fromValue(defaultAction.name()), Helper.convertEnums(org.virtualbox_5_2.DnDAction.class, org.virtualbox_5_2.jaxws.DnDAction.class, allowedActions), formats);
           return org.virtualbox_5_2.DnDAction.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Informs the target about a drag and drop move event.
@param screenId The screen ID where the drag and drop event occurred.

@param x X-position of the event.

@param y Y-position of the event.

@param defaultAction The default action to use.

@param allowedActions The actions which are allowed.

@param formats The supported MIME types.

@return The resulting action of this event.

Expected result codes:
<table summary="">
<tr><td>@link ::VBOX_E_VM_ERROR VBOX_E_VM_ERROR</td><td>VMM device is not available.</td></tr>
</table>

*/
    public org.virtualbox_5_2.DnDAction move(Long screenId, Long x, Long y, org.virtualbox_5_2.DnDAction defaultAction, List<org.virtualbox_5_2.DnDAction> allowedActions, List<String> formats)
    {
        try
        {
            org.virtualbox_5_2.jaxws.DnDAction retVal;
        retVal = port.iDnDTargetMove(obj, screenId, x, y, org.virtualbox_5_2.jaxws.DnDAction.fromValue(defaultAction.name()), Helper.convertEnums(org.virtualbox_5_2.DnDAction.class, org.virtualbox_5_2.jaxws.DnDAction.class, allowedActions), formats);
           return org.virtualbox_5_2.DnDAction.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Informs the target about a drag and drop leave event.
@param screenId The screen ID where the drag and drop event occurred.

Expected result codes:
<table summary="">
<tr><td>@link ::VBOX_E_VM_ERROR VBOX_E_VM_ERROR</td><td>VMM device is not available.</td></tr>
</table>

*/
    public void leave(Long screenId)
    {
        try
        {
        port.iDnDTargetLeave(obj, screenId);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Informs the target about a drop event.
@param screenId The screen ID where the Drag and Drop event occurred.

@param x X-position of the event.

@param y Y-position of the event.

@param defaultAction The default action to use.

@param allowedActions The actions which are allowed.

@param formats The supported MIME types.

@param format The resulting format of this event.

@return The resulting action of this event.

Expected result codes:
<table summary="">
<tr><td>@link ::VBOX_E_VM_ERROR VBOX_E_VM_ERROR</td><td>VMM device is not available.</td></tr>
</table>

*/
    public org.virtualbox_5_2.DnDAction drop(Long screenId, Long x, Long y, org.virtualbox_5_2.DnDAction defaultAction, List<org.virtualbox_5_2.DnDAction> allowedActions, List<String> formats, Holder<String> format)
    {
        try
        {
        javax.xml.ws.Holder<String> tmp_format = new javax.xml.ws.Holder<String>();
        javax.xml.ws.Holder<org.virtualbox_5_2.jaxws.DnDAction> retVal = new javax.xml.ws.Holder<org.virtualbox_5_2.jaxws.DnDAction>();
        port.iDnDTargetDrop(obj, screenId, x, y, org.virtualbox_5_2.jaxws.DnDAction.fromValue(defaultAction.name()), Helper.convertEnums(org.virtualbox_5_2.DnDAction.class, org.virtualbox_5_2.jaxws.DnDAction.class, allowedActions), formats, tmp_format, retVal);
        format.value = tmp_format.value;
           return org.virtualbox_5_2.DnDAction.fromValue(retVal.value.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Initiates sending data to the target.
@param screenId The screen ID where the drag and drop event occurred.

@param format The MIME type the data is in.

@param data The actual data.

@return Progress object to track the operation completion.

Expected result codes:
<table summary="">
<tr><td>@link ::VBOX_E_VM_ERROR VBOX_E_VM_ERROR</td><td>VMM device is not available.</td></tr>
</table>

*/
    public org.virtualbox_5_2.IProgress sendData(Long screenId, String format, byte[] data)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iDnDTargetSendData(obj, screenId, format, Helper.encodeBase64(data));
           return (retVal.length() > 0) ? new org.virtualbox_5_2.IProgress(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Requests cancelling the current operation. The target can veto
the request in case the operation is not cancelable at the moment.
@return Whether the target has vetoed cancelling the operation.

Expected result codes:
<table summary="">
<tr><td>@link ::VBOX_E_VM_ERROR VBOX_E_VM_ERROR</td><td>VMM device is not available.</td></tr>
</table>

*/
    public Boolean cancel()
    {
        try
        {
            Boolean retVal;
        retVal = port.iDnDTargetCancel(obj);
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
