
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * ScreenLayoutMode.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;

/**
How IDisplay::setScreenLayout method should work.
Interface ID: <tt>{9A982F4F-B815-4802-8539-D0B46435A7B7}</tt>
*/
public enum ScreenLayoutMode
{

/**
If the guest is already at desired mode then the API might avoid setting the mode.
*/
    Apply(0),

/**
Always set the new mode even if the guest is already at desired mode.
*/
    Reset(1);

    private final int value;

    ScreenLayoutMode(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static ScreenLayoutMode fromValue(long v)
    {
        for (ScreenLayoutMode c: ScreenLayoutMode.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static ScreenLayoutMode fromValue(String v)
    {
        return valueOf(ScreenLayoutMode.class, v);
    }
}

