
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * CertificateVersion.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;

/**
X.509 certificate version numbers.
Interface ID: <tt>{9E232A99-51D0-4DBD-96A0-FFAC4BC3E2A8}</tt>
*/
public enum CertificateVersion
{
    V1(1),
    V2(2),
    V3(3),
    Unknown(99);

    private final int value;

    CertificateVersion(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static CertificateVersion fromValue(long v)
    {
        for (CertificateVersion c: CertificateVersion.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static CertificateVersion fromValue(String v)
    {
        return valueOf(CertificateVersion.class, v);
    }
}

