
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestFileEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_2;

import org.virtualbox_5_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Base abstract interface for all guest file events.

Interface ID: <tt>{C8ADB7B0-057D-4391-B928-F14B06B710C5}</tt>
*/
public class IGuestFileEvent extends IGuestSessionEvent
{

    public IGuestFileEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Guest file object which is related to this event.
@return org.virtualbox_5_2.IGuestFile
*/
    public org.virtualbox_5_2.IGuestFile getFile()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iGuestFileEventGetFile(obj);
            return (retVal.length() > 0) ? new org.virtualbox_5_2.IGuestFile(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public static IGuestFileEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestFileEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
