
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IUSBProxyBackend.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_1;

import org.virtualbox_5_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The USBProxyBackend interface represents a source for USB devices available
to the host for attaching to the VM.

Interface ID: <tt>{DFE56449-6989-4002-80CF-3607F377D40C}</tt>
*/
public class IUSBProxyBackend extends IUnknown
{

    public IUSBProxyBackend(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
The unique name of the proxy backend.
@return String
*/
    public String getName()
    {
        try
        {
            String retVal = port.iusbProxyBackendGetName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The type of the backend.
@return String
*/
    public String getType()
    {
        try
        {
            String retVal = port.iusbProxyBackendGetType(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IUSBProxyBackend queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IUSBProxyBackend(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
