
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IVetoEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_1;

import org.virtualbox_5_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Base abstract interface for veto events.

Interface ID: <tt>{7C5E945F-2354-4267-883F-2F417D216519}</tt>
*/
public class IVetoEvent extends IEvent
{

    public IVetoEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }
    public static IVetoEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IVetoEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Adds a veto on this event.
@param reason Reason for veto, could be null or empty string.

*/
    public void addVeto(String reason)
    {
        try
        {
        port.iVetoEventAddVeto(obj, reason);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
If this event was vetoed.
@return Reason for veto.

*/
    public Boolean isVetoed()
    {
        try
        {
            Boolean retVal;
        retVal = port.iVetoEventIsVetoed(obj);
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Current veto reason list, if size is 0 - no veto.
@return Array of reasons for veto provided by different event handlers.

*/
    public List<String> getVetos()
    {
        try
        {
            List<String> retVal;
        retVal = port.iVetoEventGetVetos(obj);
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Adds an approval on this event.
@param reason Reason for approval, could be null or empty string.

*/
    public void addApproval(String reason)
    {
        try
        {
        port.iVetoEventAddApproval(obj, reason);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
If this event was approved.
*/
    public Boolean isApproved()
    {
        try
        {
            Boolean retVal;
        retVal = port.iVetoEventIsApproved(obj);
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Current approval reason list, if size is 0 - no approvals.
@return Array of reasons for approval provided by different event handlers.

*/
    public List<String> getApprovals()
    {
        try
        {
            List<String> retVal;
        retVal = port.iVetoEventGetApprovals(obj);
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
