
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * APICMode.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_1;

import org.virtualbox_5_1.jaxws.*;
import javax.xml.ws.*;

/**
BIOS APIC initialization mode. If the hardware does not support the
mode then the code falls back to a lower mode.
Interface ID: <tt>{C6884BA5-3CC4-4A92-A7F6-4410F9FD894E}</tt>
*/
public enum APICMode
{
    Disabled(0),
    APIC(1),
    X2APIC(2);

    private final int value;

    APICMode(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static APICMode fromValue(long v)
    {
        for (APICMode c: APICMode.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static APICMode fromValue(String v)
    {
        return valueOf(APICMode.class, v);
    }
}

