# Copyright (C) 2008-2016 Oracle Corporation
#
# This file is part of a free software library; you can redistribute
# it and/or modify it under the terms of the GNU Lesser General
# Public License version 2.1 as published by the Free Software
# Foundation and shipped in the "COPYING.LIB" file with this library.
# The library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY of any kind.
#
# Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
# any license choice other than GPL or LGPL is available it will
# apply instead, Oracle elects to use only the Lesser General Public
# License version 2.1 (LGPLv2) at this time for any software where
# a choice of LGPL license versions is made available with the
# language indicating that LGPLv2 or any later version may be used,
# or where a choice of which version of the LGPL is applied is
# otherwise unspecified.
#
# This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
#

# Works only with ZSI 2.0 generated stubs (part of the VirtualBox SDK).
from VirtualBox_client import *

class ObjectRefManager:
  def __init__(self, sessionmgr):
     self.map = {}
     self.sessionmgr = sessionmgr

  def register(self, handle):
     if handle == None:
        return
     c = self.map.get(handle,0)
     c = c + 1
     self.map[handle]=c

  def unregister(self, handle):
     if handle == None:
        return
     c = self.map.get(handle,-1)
     if c == -1:
        raise Error('wrong refcount')
     c = c - 1
     if c == 0:
        try:
            req=IManagedObjectRef_releaseRequestMsg()
            req._this=handle
            self.sessionmgr.getPort().IManagedObjectRef_release(req)
        except:
            pass
        del self.map[handle]
     else:
        self.map[handle] = c

class String:
  def __init__(self, mgr, handle, isarray = False):
      self.handle = handle
      self.mgr = mgr
      self.isarray = isarray

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

  def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

  def __getitem__(self, index):
      if self.isarray:
          return String(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

  def __str__(self):
      return str(self.handle)

  def __eq__(self,other):
      if self.isarray:
         return isinstance(other,String) and self.handle == other.handle
      if isinstance(other,String):
         return self.handle == other.handle
      if isinstance(other,basestring):
         return self.handle == other
      return False

  def __ne__(self,other):
      if self.isarray:
         return not isinstance(other,String) or self.handle != other.handle
      if isinstance(other,String):
         return self.handle != other.handle
      if isinstance(other,basestring):
         return self.handle != other
      return True

  def __add__(self,other):
      return str(self.handle)+str(other)


class Boolean:
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       if self.handle == "false":
          self.handle = None
       self.mgr = mgr
       self.isarray = isarray

  def __str__(self):
       if self.handle:
         return "true"
       else:
         return "false"

  def __eq__(self,other):
      if isinstance(other,Bool):
         return self.handle == other.value
      if isinstance(other,bool):
         return self.handle == other
      return False

  def __ne__(self,other):
      if isinstance(other,Bool):
         return self.handle != other.handle
      if isinstance(other,bool):
         return self.handle != other
      return True

  def __int__(self):
      if self.handle:
        return 1
      else:
        return 0

  def __long__(self):
      if self.handle:
        return 1
      else:
        return 0

  def __nonzero__(self):
      if self.handle:
        return True
      else:
        return False

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

  def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

  def __getitem__(self, index):
      if self.isarray:
          return Boolean(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

class Number:
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

  def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

  def __long__(self):
       return long(self.handle)

  def __float__(self):
       return float(self.handle)

  def __lt__(self, other):
       if self.isarray:
            return NotImplemented
       else:
            return self.handle < other

  def __le__(self, other):
       if self.isarray:
            return NotImplemented
       else:
            return self.handle <= other

  def __eq__(self, other):
       return self.handle == other

  def __ne__(self, other):
       return self.handle != other

  def __gt__(self, other):
       if self.isarray:
            return NotImplemented
       else:
            return self.handle > other

  def __ge__(self, other):
       if self.isarray:
            return NotImplemented
       else:
            return self.handle >= other

class Octet:
  def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       self.isarray = isarray
       if isarray:
           self.handle = mgr.decodebase64(handle)
       else:
           raise TypeError("only octet arrays")

  def __getitem__(self, index):
      return self.handle[index]

  def __str__(self):
       return str(self.handle)

  def __len__(self):
      return self.handle.__len__()

class UnsignedInt(Number):
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __getitem__(self, index):
      if self.isarray:
          return UnsignedInt(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")


class Int(Number):
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __getitem__(self, index):
      if self.isarray:
          return Int(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

class UnsignedShort(Number):
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __getitem__(self, index):
      if self.isarray:
          return UnsignedShort(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

class Short(Number):
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __getitem__(self, index):
      if self.isarray:
          return Short(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

class UnsignedLong(Number):
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __getitem__(self, index):
      if self.isarray:
          return UnsignedLong(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

class Long(Number):
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __getitem__(self, index):
      if self.isarray:
          return Long(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

class Double(Number):
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __getitem__(self, index):
      if self.isarray:
          return Double(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

class Float(Number):
  def __init__(self, mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __getitem__(self, index):
      if self.isarray:
          return Float(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

class IUnknown:
  def __init__(self,  mgr, handle, isarray = False):
       self.handle = handle
       self.mgr = mgr
       self.isarray = isarray

  def __nonzero__(self):
      if self.handle != "":
           return True
      else:
           return False

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

  def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

  def __getitem__(self, index):
      if self.isarray:
          return IUnknown(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

  def __str__(self):
       return str(self.handle)

  def __eq__(self, other):
       return self.handle == other

  def __ne__(self, other):
       return self.handle != other

  def __getattr__(self,attr):
       if self.__class__.__dict__.get(attr) != None:
           return self.__class__.__dict__.get(attr)
       if self.__dict__.get(attr) != None:
           return self.__dict__.get(attr)
       raise AttributeError



class IVirtualBoxErrorInfo(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVirtualBoxErrorInfo(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVirtualBoxErrorInfo._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVirtualBoxErrorInfo._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getResultCode(self):
       req=IVirtualBoxErrorInfo_getResultCodeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBoxErrorInfo_getResultCode(req)
       return Int(self.mgr,val._returnval)
   def getResultDetail(self):
       req=IVirtualBoxErrorInfo_getResultDetailRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBoxErrorInfo_getResultDetail(req)
       return Int(self.mgr,val._returnval)
   def getInterfaceID(self):
       req=IVirtualBoxErrorInfo_getInterfaceIDRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBoxErrorInfo_getInterfaceID(req)
       return String(self.mgr,val._returnval)
   def getComponent(self):
       req=IVirtualBoxErrorInfo_getComponentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBoxErrorInfo_getComponent(req)
       return String(self.mgr,val._returnval)
   def getText(self):
       req=IVirtualBoxErrorInfo_getTextRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBoxErrorInfo_getText(req)
       return String(self.mgr,val._returnval)
   def getNext(self):
       req=IVirtualBoxErrorInfo_getNextRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBoxErrorInfo_getNext(req)
       return IVirtualBoxErrorInfo(self.mgr,val._returnval)


   _Attrs_={         'resultCode':[getResultCode,None],
         'resultDetail':[getResultDetail,None],
         'interfaceID':[getInterfaceID,None],
         'component':[getComponent,None],
         'text':[getText,None],
         'next':[getNext,None]}

class INATNetwork(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATNetwork(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATNetwork._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATNetwork._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def addLocalMapping(self, _arg_hostid, _arg_offset):
       req=INATNetwork_addLocalMappingRequestMsg()
       req._this=self.handle
       
       req._hostid=_arg_hostid
       req._offset=_arg_offset
       val=self.mgr.getPort().INATNetwork_addLocalMapping(req)
       
       return 


   def addPortForwardRule(self, _arg_isIpv6, _arg_ruleName, _arg_proto, _arg_hostIP, _arg_hostPort, _arg_guestIP, _arg_guestPort):
       req=INATNetwork_addPortForwardRuleRequestMsg()
       req._this=self.handle
       
       req._isIpv6=_arg_isIpv6
       req._ruleName=_arg_ruleName
       req._proto=_arg_proto
       req._hostIP=_arg_hostIP
       req._hostPort=_arg_hostPort
       req._guestIP=_arg_guestIP
       req._guestPort=_arg_guestPort
       val=self.mgr.getPort().INATNetwork_addPortForwardRule(req)
       
       return 


   def removePortForwardRule(self, _arg_iSipv6, _arg_ruleName):
       req=INATNetwork_removePortForwardRuleRequestMsg()
       req._this=self.handle
       
       req._iSipv6=_arg_iSipv6
       req._ruleName=_arg_ruleName
       val=self.mgr.getPort().INATNetwork_removePortForwardRule(req)
       
       return 


   def start(self, _arg_trunkType):
       req=INATNetwork_startRequestMsg()
       req._this=self.handle
       
       req._trunkType=_arg_trunkType
       val=self.mgr.getPort().INATNetwork_start(req)
       
       return 


   def stop(self):
       req=INATNetwork_stopRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().INATNetwork_stop(req)
       
       return 


   def getNetworkName(self):
       req=INATNetwork_getNetworkNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getNetworkName(req)
       return String(self.mgr,val._returnval)
   def setNetworkName(self, value):
       req=INATNetwork_setNetworkNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._networkName = value
       else:
            req._networkName = value.handle
       self.mgr.getPort().INATNetwork_setNetworkName(req)

   def getEnabled(self):
       req=INATNetwork_getEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabled(self, value):
       req=INATNetwork_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabled = value
       else:
            req._enabled = value.handle
       self.mgr.getPort().INATNetwork_setEnabled(req)

   def getNetwork(self):
       req=INATNetwork_getNetworkRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getNetwork(req)
       return String(self.mgr,val._returnval)
   def setNetwork(self, value):
       req=INATNetwork_setNetworkRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._network = value
       else:
            req._network = value.handle
       self.mgr.getPort().INATNetwork_setNetwork(req)

   def getGateway(self):
       req=INATNetwork_getGatewayRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getGateway(req)
       return String(self.mgr,val._returnval)
   def getIPv6Enabled(self):
       req=INATNetwork_getIPv6EnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getIPv6Enabled(req)
       return Boolean(self.mgr,val._returnval)
   def setIPv6Enabled(self, value):
       req=INATNetwork_setIPv6EnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IPv6Enabled = value
       else:
            req._IPv6Enabled = value.handle
       self.mgr.getPort().INATNetwork_setIPv6Enabled(req)

   def getIPv6Prefix(self):
       req=INATNetwork_getIPv6PrefixRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getIPv6Prefix(req)
       return String(self.mgr,val._returnval)
   def setIPv6Prefix(self, value):
       req=INATNetwork_setIPv6PrefixRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IPv6Prefix = value
       else:
            req._IPv6Prefix = value.handle
       self.mgr.getPort().INATNetwork_setIPv6Prefix(req)

   def getAdvertiseDefaultIPv6RouteEnabled(self):
       req=INATNetwork_getAdvertiseDefaultIPv6RouteEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getAdvertiseDefaultIPv6RouteEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setAdvertiseDefaultIPv6RouteEnabled(self, value):
       req=INATNetwork_setAdvertiseDefaultIPv6RouteEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._advertiseDefaultIPv6RouteEnabled = value
       else:
            req._advertiseDefaultIPv6RouteEnabled = value.handle
       self.mgr.getPort().INATNetwork_setAdvertiseDefaultIPv6RouteEnabled(req)

   def getNeedDhcpServer(self):
       req=INATNetwork_getNeedDhcpServerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getNeedDhcpServer(req)
       return Boolean(self.mgr,val._returnval)
   def setNeedDhcpServer(self, value):
       req=INATNetwork_setNeedDhcpServerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._needDhcpServer = value
       else:
            req._needDhcpServer = value.handle
       self.mgr.getPort().INATNetwork_setNeedDhcpServer(req)

   def getEventSource(self):
       req=INATNetwork_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)
   def getPortForwardRules4(self):
       req=INATNetwork_getPortForwardRules4RequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getPortForwardRules4(req)
       return String(self.mgr,val._returnval, True)
   def getLocalMappings(self):
       req=INATNetwork_getLocalMappingsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getLocalMappings(req)
       return String(self.mgr,val._returnval, True)
   def getLoopbackIp6(self):
       req=INATNetwork_getLoopbackIp6RequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getLoopbackIp6(req)
       return Int(self.mgr,val._returnval)
   def setLoopbackIp6(self, value):
       req=INATNetwork_setLoopbackIp6RequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._loopbackIp6 = value
       else:
            req._loopbackIp6 = value.handle
       self.mgr.getPort().INATNetwork_setLoopbackIp6(req)

   def getPortForwardRules6(self):
       req=INATNetwork_getPortForwardRules6RequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetwork_getPortForwardRules6(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'networkName':[getNetworkName,setNetworkName,
        ],
         'enabled':[getEnabled,setEnabled,
        ],
         'network':[getNetwork,setNetwork,
        ],
         'gateway':[getGateway,None],
         'IPv6Enabled':[getIPv6Enabled,setIPv6Enabled,
        ],
         'IPv6Prefix':[getIPv6Prefix,setIPv6Prefix,
        ],
         'advertiseDefaultIPv6RouteEnabled':[getAdvertiseDefaultIPv6RouteEnabled,setAdvertiseDefaultIPv6RouteEnabled,
        ],
         'needDhcpServer':[getNeedDhcpServer,setNeedDhcpServer,
        ],
         'eventSource':[getEventSource,None],
         'portForwardRules4':[getPortForwardRules4,None],
         'localMappings':[getLocalMappings,None],
         'loopbackIp6':[getLoopbackIp6,setLoopbackIp6,
        ],
         'portForwardRules6':[getPortForwardRules6,None]}

class IDHCPServer(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IDHCPServer(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDHCPServer._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IDHCPServer._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def addGlobalOption(self, _arg_option, _arg_value):
       req=IDHCPServer_addGlobalOptionRequestMsg()
       req._this=self.handle
       
       req._option=_arg_option
       req._value=_arg_value
       val=self.mgr.getPort().IDHCPServer_addGlobalOption(req)
       
       return 


   def addVmSlotOption(self, _arg_vmname, _arg_slot, _arg_option, _arg_value):
       req=IDHCPServer_addVmSlotOptionRequestMsg()
       req._this=self.handle
       
       req._vmname=_arg_vmname
       req._slot=_arg_slot
       req._option=_arg_option
       req._value=_arg_value
       val=self.mgr.getPort().IDHCPServer_addVmSlotOption(req)
       
       return 


   def removeVmSlotOptions(self, _arg_vmname, _arg_slot):
       req=IDHCPServer_removeVmSlotOptionsRequestMsg()
       req._this=self.handle
       
       req._vmname=_arg_vmname
       req._slot=_arg_slot
       val=self.mgr.getPort().IDHCPServer_removeVmSlotOptions(req)
       
       return 


   def getVmSlotOptions(self, _arg_vmname, _arg_slot):
       req=IDHCPServer_getVmSlotOptionsRequestMsg()
       req._this=self.handle
       
       req._vmname=_arg_vmname
       req._slot=_arg_slot
       val=self.mgr.getPort().IDHCPServer_getVmSlotOptions(req)
       
       return String(self.mgr,val._returnval, True)


   def getMacOptions(self, _arg_mac):
       req=IDHCPServer_getMacOptionsRequestMsg()
       req._this=self.handle
       
       req._mac=_arg_mac
       val=self.mgr.getPort().IDHCPServer_getMacOptions(req)
       
       return String(self.mgr,val._returnval, True)


   def setConfiguration(self, _arg_IPAddress, _arg_networkMask, _arg_FromIPAddress, _arg_ToIPAddress):
       req=IDHCPServer_setConfigurationRequestMsg()
       req._this=self.handle
       
       req._IPAddress=_arg_IPAddress
       req._networkMask=_arg_networkMask
       req._FromIPAddress=_arg_FromIPAddress
       req._ToIPAddress=_arg_ToIPAddress
       val=self.mgr.getPort().IDHCPServer_setConfiguration(req)
       
       return 


   def start(self, _arg_networkName, _arg_trunkName, _arg_trunkType):
       req=IDHCPServer_startRequestMsg()
       req._this=self.handle
       
       req._networkName=_arg_networkName
       req._trunkName=_arg_trunkName
       req._trunkType=_arg_trunkType
       val=self.mgr.getPort().IDHCPServer_start(req)
       
       return 


   def stop(self):
       req=IDHCPServer_stopRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IDHCPServer_stop(req)
       
       return 


   def getEventSource(self):
       req=IDHCPServer_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)
   def getEnabled(self):
       req=IDHCPServer_getEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabled(self, value):
       req=IDHCPServer_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabled = value
       else:
            req._enabled = value.handle
       self.mgr.getPort().IDHCPServer_setEnabled(req)

   def getIPAddress(self):
       req=IDHCPServer_getIPAddressRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getIPAddress(req)
       return String(self.mgr,val._returnval)
   def getNetworkMask(self):
       req=IDHCPServer_getNetworkMaskRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getNetworkMask(req)
       return String(self.mgr,val._returnval)
   def getNetworkName(self):
       req=IDHCPServer_getNetworkNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getNetworkName(req)
       return String(self.mgr,val._returnval)
   def getLowerIP(self):
       req=IDHCPServer_getLowerIPRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getLowerIP(req)
       return String(self.mgr,val._returnval)
   def getUpperIP(self):
       req=IDHCPServer_getUpperIPRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getUpperIP(req)
       return String(self.mgr,val._returnval)
   def getGlobalOptions(self):
       req=IDHCPServer_getGlobalOptionsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getGlobalOptions(req)
       return String(self.mgr,val._returnval, True)
   def getVmConfigs(self):
       req=IDHCPServer_getVmConfigsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDHCPServer_getVmConfigs(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'eventSource':[getEventSource,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'IPAddress':[getIPAddress,None],
         'networkMask':[getNetworkMask,None],
         'networkName':[getNetworkName,None],
         'lowerIP':[getLowerIP,None],
         'upperIP':[getUpperIP,None],
         'globalOptions':[getGlobalOptions,None],
         'vmConfigs':[getVmConfigs,None]}

class IVirtualBox(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVirtualBox(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVirtualBox._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVirtualBox._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def composeMachineFilename(self, _arg_name, _arg_group, _arg_createFlags, _arg_baseFolder):
       req=IVirtualBox_composeMachineFilenameRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._group=_arg_group
       req._createFlags=_arg_createFlags
       req._baseFolder=_arg_baseFolder
       val=self.mgr.getPort().IVirtualBox_composeMachineFilename(req)
       
       return String(self.mgr,val._returnval)


   def createMachine(self, _arg_settingsFile, _arg_name, _arg_groups, _arg_osTypeId, _arg_flags):
       req=IVirtualBox_createMachineRequestMsg()
       req._this=self.handle
       
       req._settingsFile=_arg_settingsFile
       req._name=_arg_name
       req._groups=_arg_groups
       req._osTypeId=_arg_osTypeId
       req._flags=_arg_flags
       val=self.mgr.getPort().IVirtualBox_createMachine(req)
       
       return IMachine(self.mgr,val._returnval)


   def openMachine(self, _arg_settingsFile):
       req=IVirtualBox_openMachineRequestMsg()
       req._this=self.handle
       
       req._settingsFile=_arg_settingsFile
       val=self.mgr.getPort().IVirtualBox_openMachine(req)
       
       return IMachine(self.mgr,val._returnval)


   def registerMachine(self, _arg_machine):
       req=IVirtualBox_registerMachineRequestMsg()
       req._this=self.handle
       
       req._machine=_arg_machine
       val=self.mgr.getPort().IVirtualBox_registerMachine(req)
       
       return 


   def findMachine(self, _arg_nameOrId):
       req=IVirtualBox_findMachineRequestMsg()
       req._this=self.handle
       
       req._nameOrId=_arg_nameOrId
       val=self.mgr.getPort().IVirtualBox_findMachine(req)
       
       return IMachine(self.mgr,val._returnval)


   def getMachinesByGroups(self, _arg_groups):
       req=IVirtualBox_getMachinesByGroupsRequestMsg()
       req._this=self.handle
       
       req._groups=_arg_groups
       val=self.mgr.getPort().IVirtualBox_getMachinesByGroups(req)
       
       return IMachine(self.mgr,val._returnval, True)


   def getMachineStates(self, _arg_machines):
       req=IVirtualBox_getMachineStatesRequestMsg()
       req._this=self.handle
       
       req._machines=_arg_machines
       val=self.mgr.getPort().IVirtualBox_getMachineStates(req)
       
       return MachineState(self.mgr,val._returnval, True)


   def createAppliance(self):
       req=IVirtualBox_createApplianceRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVirtualBox_createAppliance(req)
       
       return IAppliance(self.mgr,val._returnval)


   def createMedium(self, _arg_format, _arg_location, _arg_accessMode, _arg_aDeviceTypeType):
       req=IVirtualBox_createMediumRequestMsg()
       req._this=self.handle
       
       req._format=_arg_format
       req._location=_arg_location
       req._accessMode=_arg_accessMode
       req._aDeviceTypeType=_arg_aDeviceTypeType
       val=self.mgr.getPort().IVirtualBox_createMedium(req)
       
       return IMedium(self.mgr,val._returnval)


   def openMedium(self, _arg_location, _arg_deviceType, _arg_accessMode, _arg_forceNewUuid):
       req=IVirtualBox_openMediumRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       req._deviceType=_arg_deviceType
       req._accessMode=_arg_accessMode
       req._forceNewUuid=_arg_forceNewUuid
       val=self.mgr.getPort().IVirtualBox_openMedium(req)
       
       return IMedium(self.mgr,val._returnval)


   def getGuestOSType(self, _arg_id):
       req=IVirtualBox_getGuestOSTypeRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IVirtualBox_getGuestOSType(req)
       
       return IGuestOSType(self.mgr,val._returnval)


   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable, _arg_automount):
       req=IVirtualBox_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       req._automount=_arg_automount
       val=self.mgr.getPort().IVirtualBox_createSharedFolder(req)
       
       return 


   def removeSharedFolder(self, _arg_name):
       req=IVirtualBox_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IVirtualBox_removeSharedFolder(req)
       
       return 


   def getExtraDataKeys(self):
       req=IVirtualBox_getExtraDataKeysRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVirtualBox_getExtraDataKeys(req)
       
       return String(self.mgr,val._returnval, True)


   def getExtraData(self, _arg_key):
       req=IVirtualBox_getExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=self.mgr.getPort().IVirtualBox_getExtraData(req)
       
       return String(self.mgr,val._returnval)


   def setExtraData(self, _arg_key, _arg_value):
       req=IVirtualBox_setExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=self.mgr.getPort().IVirtualBox_setExtraData(req)
       
       return 


   def setSettingsSecret(self, _arg_password):
       req=IVirtualBox_setSettingsSecretRequestMsg()
       req._this=self.handle
       
       req._password=_arg_password
       val=self.mgr.getPort().IVirtualBox_setSettingsSecret(req)
       
       return 


   def createDHCPServer(self, _arg_name):
       req=IVirtualBox_createDHCPServerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IVirtualBox_createDHCPServer(req)
       
       return IDHCPServer(self.mgr,val._returnval)


   def findDHCPServerByNetworkName(self, _arg_name):
       req=IVirtualBox_findDHCPServerByNetworkNameRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IVirtualBox_findDHCPServerByNetworkName(req)
       
       return IDHCPServer(self.mgr,val._returnval)


   def removeDHCPServer(self, _arg_server):
       req=IVirtualBox_removeDHCPServerRequestMsg()
       req._this=self.handle
       
       req._server=_arg_server
       val=self.mgr.getPort().IVirtualBox_removeDHCPServer(req)
       
       return 


   def createNATNetwork(self, _arg_networkName):
       req=IVirtualBox_createNATNetworkRequestMsg()
       req._this=self.handle
       
       req._networkName=_arg_networkName
       val=self.mgr.getPort().IVirtualBox_createNATNetwork(req)
       
       return INATNetwork(self.mgr,val._returnval)


   def findNATNetworkByName(self, _arg_networkName):
       req=IVirtualBox_findNATNetworkByNameRequestMsg()
       req._this=self.handle
       
       req._networkName=_arg_networkName
       val=self.mgr.getPort().IVirtualBox_findNATNetworkByName(req)
       
       return INATNetwork(self.mgr,val._returnval)


   def removeNATNetwork(self, _arg_network):
       req=IVirtualBox_removeNATNetworkRequestMsg()
       req._this=self.handle
       
       req._network=_arg_network
       val=self.mgr.getPort().IVirtualBox_removeNATNetwork(req)
       
       return 


   def checkFirmwarePresent(self, _arg_firmwareType, _arg_version):
       req=IVirtualBox_checkFirmwarePresentRequestMsg()
       req._this=self.handle
       
       req._firmwareType=_arg_firmwareType
       req._version=_arg_version
       val=self.mgr.getPort().IVirtualBox_checkFirmwarePresent(req)
       
       return Boolean(self.mgr,val._returnval), String(self.mgr,val._url), String(self.mgr,val._file)


   def getVersion(self):
       req=IVirtualBox_getVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getVersion(req)
       return String(self.mgr,val._returnval)
   def getVersionNormalized(self):
       req=IVirtualBox_getVersionNormalizedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getVersionNormalized(req)
       return String(self.mgr,val._returnval)
   def getRevision(self):
       req=IVirtualBox_getRevisionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getRevision(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getPackageType(self):
       req=IVirtualBox_getPackageTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getPackageType(req)
       return String(self.mgr,val._returnval)
   def getAPIVersion(self):
       req=IVirtualBox_getAPIVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getAPIVersion(req)
       return String(self.mgr,val._returnval)
   def getAPIRevision(self):
       req=IVirtualBox_getAPIRevisionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getAPIRevision(req)
       return Long(self.mgr,val._returnval)
   def getHomeFolder(self):
       req=IVirtualBox_getHomeFolderRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getHomeFolder(req)
       return String(self.mgr,val._returnval)
   def getSettingsFilePath(self):
       req=IVirtualBox_getSettingsFilePathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getSettingsFilePath(req)
       return String(self.mgr,val._returnval)
   def getHost(self):
       req=IVirtualBox_getHostRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getHost(req)
       return IHost(self.mgr,val._returnval)
   def getSystemProperties(self):
       req=IVirtualBox_getSystemPropertiesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getSystemProperties(req)
       return ISystemProperties(self.mgr,val._returnval)
   def getMachines(self):
       req=IVirtualBox_getMachinesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getMachines(req)
       return IMachine(self.mgr,val._returnval, True)
   def getMachineGroups(self):
       req=IVirtualBox_getMachineGroupsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getMachineGroups(req)
       return String(self.mgr,val._returnval, True)
   def getHardDisks(self):
       req=IVirtualBox_getHardDisksRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getHardDisks(req)
       return IMedium(self.mgr,val._returnval, True)
   def getDVDImages(self):
       req=IVirtualBox_getDVDImagesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getDVDImages(req)
       return IMedium(self.mgr,val._returnval, True)
   def getFloppyImages(self):
       req=IVirtualBox_getFloppyImagesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getFloppyImages(req)
       return IMedium(self.mgr,val._returnval, True)
   def getProgressOperations(self):
       req=IVirtualBox_getProgressOperationsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getProgressOperations(req)
       return IProgress(self.mgr,val._returnval, True)
   def getGuestOSTypes(self):
       req=IVirtualBox_getGuestOSTypesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getGuestOSTypes(req)
       return IGuestOSType(self.mgr,val._returnval, True)
   def getSharedFolders(self):
       req=IVirtualBox_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getSharedFolders(req)
       return ISharedFolder(self.mgr,val._returnval, True)
   def getPerformanceCollector(self):
       req=IVirtualBox_getPerformanceCollectorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getPerformanceCollector(req)
       return IPerformanceCollector(self.mgr,val._returnval)
   def getDHCPServers(self):
       req=IVirtualBox_getDHCPServersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getDHCPServers(req)
       return IDHCPServer(self.mgr,val._returnval, True)
   def getNATNetworks(self):
       req=IVirtualBox_getNATNetworksRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getNATNetworks(req)
       return INATNetwork(self.mgr,val._returnval, True)
   def getEventSource(self):
       req=IVirtualBox_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)
   def getInternalNetworks(self):
       req=IVirtualBox_getInternalNetworksRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getInternalNetworks(req)
       return String(self.mgr,val._returnval, True)
   def getGenericNetworkDrivers(self):
       req=IVirtualBox_getGenericNetworkDriversRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualBox_getGenericNetworkDrivers(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'version':[getVersion,None],
         'versionNormalized':[getVersionNormalized,None],
         'revision':[getRevision,None],
         'packageType':[getPackageType,None],
         'APIVersion':[getAPIVersion,None],
         'APIRevision':[getAPIRevision,None],
         'homeFolder':[getHomeFolder,None],
         'settingsFilePath':[getSettingsFilePath,None],
         'host':[getHost,None],
         'systemProperties':[getSystemProperties,None],
         'machines':[getMachines,None],
         'machineGroups':[getMachineGroups,None],
         'hardDisks':[getHardDisks,None],
         'DVDImages':[getDVDImages,None],
         'floppyImages':[getFloppyImages,None],
         'progressOperations':[getProgressOperations,None],
         'guestOSTypes':[getGuestOSTypes,None],
         'sharedFolders':[getSharedFolders,None],
         'performanceCollector':[getPerformanceCollector,None],
         'DHCPServers':[getDHCPServers,None],
         'NATNetworks':[getNATNetworks,None],
         'eventSource':[getEventSource,None],
         'internalNetworks':[getInternalNetworks,None],
         'genericNetworkDrivers':[getGenericNetworkDrivers,None]}

class IVFSExplorer(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVFSExplorer(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVFSExplorer._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVFSExplorer._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def update(self):
       req=IVFSExplorer_updateRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVFSExplorer_update(req)
       
       return IProgress(self.mgr,val._returnval)


   def cd(self, _arg_dir):
       req=IVFSExplorer_cdRequestMsg()
       req._this=self.handle
       
       req._dir=_arg_dir
       val=self.mgr.getPort().IVFSExplorer_cd(req)
       
       return IProgress(self.mgr,val._returnval)


   def cdUp(self):
       req=IVFSExplorer_cdUpRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVFSExplorer_cdUp(req)
       
       return IProgress(self.mgr,val._returnval)


   def entryList(self):
       req=IVFSExplorer_entryListRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVFSExplorer_entryList(req)
       
       return String(self.mgr,val._names, True), UnsignedInt(self.mgr,val._types, True), Long(self.mgr,val._sizes, True), UnsignedInt(self.mgr,val._modes, True)


   def exists(self, _arg_names):
       req=IVFSExplorer_existsRequestMsg()
       req._this=self.handle
       
       req._names=_arg_names
       val=self.mgr.getPort().IVFSExplorer_exists(req)
       
       return String(self.mgr,val._returnval, True)


   def remove(self, _arg_names):
       req=IVFSExplorer_removeRequestMsg()
       req._this=self.handle
       
       req._names=_arg_names
       val=self.mgr.getPort().IVFSExplorer_remove(req)
       
       return IProgress(self.mgr,val._returnval)


   def getPath(self):
       req=IVFSExplorer_getPathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVFSExplorer_getPath(req)
       return String(self.mgr,val._returnval)
   def getType(self):
       req=IVFSExplorer_getTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVFSExplorer_getType(req)
       return VFSType(self.mgr,val._returnval)


   _Attrs_={         'path':[getPath,None],
         'type':[getType,None]}

class ICertificate(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ICertificate(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ICertificate._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ICertificate._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def isCurrentlyExpired(self):
       req=ICertificate_isCurrentlyExpiredRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().ICertificate_isCurrentlyExpired(req)
       
       return Boolean(self.mgr,val._returnval)


   def queryInfo(self, _arg_what):
       req=ICertificate_queryInfoRequestMsg()
       req._this=self.handle
       
       req._what=_arg_what
       val=self.mgr.getPort().ICertificate_queryInfo(req)
       
       return String(self.mgr,val._returnval)


   def getVersionNumber(self):
       req=ICertificate_getVersionNumberRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getVersionNumber(req)
       return CertificateVersion(self.mgr,val._returnval)
   def getSerialNumber(self):
       req=ICertificate_getSerialNumberRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getSerialNumber(req)
       return String(self.mgr,val._returnval)
   def getSignatureAlgorithmOID(self):
       req=ICertificate_getSignatureAlgorithmOIDRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getSignatureAlgorithmOID(req)
       return String(self.mgr,val._returnval)
   def getSignatureAlgorithmName(self):
       req=ICertificate_getSignatureAlgorithmNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getSignatureAlgorithmName(req)
       return String(self.mgr,val._returnval)
   def getIssuerName(self):
       req=ICertificate_getIssuerNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getIssuerName(req)
       return String(self.mgr,val._returnval, True)
   def getSubjectName(self):
       req=ICertificate_getSubjectNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getSubjectName(req)
       return String(self.mgr,val._returnval, True)
   def getFriendlyName(self):
       req=ICertificate_getFriendlyNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getFriendlyName(req)
       return String(self.mgr,val._returnval)
   def getValidityPeriodNotBefore(self):
       req=ICertificate_getValidityPeriodNotBeforeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getValidityPeriodNotBefore(req)
       return String(self.mgr,val._returnval)
   def getValidityPeriodNotAfter(self):
       req=ICertificate_getValidityPeriodNotAfterRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getValidityPeriodNotAfter(req)
       return String(self.mgr,val._returnval)
   def getPublicKeyAlgorithmOID(self):
       req=ICertificate_getPublicKeyAlgorithmOIDRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getPublicKeyAlgorithmOID(req)
       return String(self.mgr,val._returnval)
   def getPublicKeyAlgorithm(self):
       req=ICertificate_getPublicKeyAlgorithmRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getPublicKeyAlgorithm(req)
       return String(self.mgr,val._returnval)
   def getSubjectPublicKey(self):
       req=ICertificate_getSubjectPublicKeyRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getSubjectPublicKey(req)
       return self.mgr.decodebase64(val._returnval)
   def getIssuerUniqueIdentifier(self):
       req=ICertificate_getIssuerUniqueIdentifierRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getIssuerUniqueIdentifier(req)
       return String(self.mgr,val._returnval)
   def getSubjectUniqueIdentifier(self):
       req=ICertificate_getSubjectUniqueIdentifierRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getSubjectUniqueIdentifier(req)
       return String(self.mgr,val._returnval)
   def getCertificateAuthority(self):
       req=ICertificate_getCertificateAuthorityRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getCertificateAuthority(req)
       return Boolean(self.mgr,val._returnval)
   def getKeyUsage(self):
       req=ICertificate_getKeyUsageRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getKeyUsage(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getExtendedKeyUsage(self):
       req=ICertificate_getExtendedKeyUsageRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getExtendedKeyUsage(req)
       return String(self.mgr,val._returnval, True)
   def getRawCertData(self):
       req=ICertificate_getRawCertDataRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getRawCertData(req)
       return self.mgr.decodebase64(val._returnval)
   def getSelfSigned(self):
       req=ICertificate_getSelfSignedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getSelfSigned(req)
       return Boolean(self.mgr,val._returnval)
   def getTrusted(self):
       req=ICertificate_getTrustedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getTrusted(req)
       return Boolean(self.mgr,val._returnval)
   def getExpired(self):
       req=ICertificate_getExpiredRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICertificate_getExpired(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'versionNumber':[getVersionNumber,None],
         'serialNumber':[getSerialNumber,None],
         'signatureAlgorithmOID':[getSignatureAlgorithmOID,None],
         'signatureAlgorithmName':[getSignatureAlgorithmName,None],
         'issuerName':[getIssuerName,None],
         'subjectName':[getSubjectName,None],
         'friendlyName':[getFriendlyName,None],
         'validityPeriodNotBefore':[getValidityPeriodNotBefore,None],
         'validityPeriodNotAfter':[getValidityPeriodNotAfter,None],
         'publicKeyAlgorithmOID':[getPublicKeyAlgorithmOID,None],
         'publicKeyAlgorithm':[getPublicKeyAlgorithm,None],
         'subjectPublicKey':[getSubjectPublicKey,None],
         'issuerUniqueIdentifier':[getIssuerUniqueIdentifier,None],
         'subjectUniqueIdentifier':[getSubjectUniqueIdentifier,None],
         'certificateAuthority':[getCertificateAuthority,None],
         'keyUsage':[getKeyUsage,None],
         'extendedKeyUsage':[getExtendedKeyUsage,None],
         'rawCertData':[getRawCertData,None],
         'selfSigned':[getSelfSigned,None],
         'trusted':[getTrusted,None],
         'expired':[getExpired,None]}

class IAppliance(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IAppliance(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IAppliance._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IAppliance._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def read(self, _arg_file):
       req=IAppliance_readRequestMsg()
       req._this=self.handle
       
       req._file=_arg_file
       val=self.mgr.getPort().IAppliance_read(req)
       
       return IProgress(self.mgr,val._returnval)


   def interpret(self):
       req=IAppliance_interpretRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IAppliance_interpret(req)
       
       return 


   def importMachines(self, _arg_options):
       req=IAppliance_importMachinesRequestMsg()
       req._this=self.handle
       
       req._options=_arg_options
       val=self.mgr.getPort().IAppliance_importMachines(req)
       
       return IProgress(self.mgr,val._returnval)


   def createVFSExplorer(self, _arg_URI):
       req=IAppliance_createVFSExplorerRequestMsg()
       req._this=self.handle
       
       req._URI=_arg_URI
       val=self.mgr.getPort().IAppliance_createVFSExplorer(req)
       
       return IVFSExplorer(self.mgr,val._returnval)


   def write(self, _arg_format, _arg_options, _arg_path):
       req=IAppliance_writeRequestMsg()
       req._this=self.handle
       
       req._format=_arg_format
       req._options=_arg_options
       req._path=_arg_path
       val=self.mgr.getPort().IAppliance_write(req)
       
       return IProgress(self.mgr,val._returnval)


   def getWarnings(self):
       req=IAppliance_getWarningsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IAppliance_getWarnings(req)
       
       return String(self.mgr,val._returnval, True)


   def getPasswordIds(self):
       req=IAppliance_getPasswordIdsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IAppliance_getPasswordIds(req)
       
       return String(self.mgr,val._returnval, True)


   def getMediumIdsForPasswordId(self, _arg_passwordId):
       req=IAppliance_getMediumIdsForPasswordIdRequestMsg()
       req._this=self.handle
       
       req._passwordId=_arg_passwordId
       val=self.mgr.getPort().IAppliance_getMediumIdsForPasswordId(req)
       
       return String(self.mgr,val._returnval, True)


   def addPasswords(self, _arg_identifiers, _arg_passwords):
       req=IAppliance_addPasswordsRequestMsg()
       req._this=self.handle
       
       req._identifiers=_arg_identifiers
       req._passwords=_arg_passwords
       val=self.mgr.getPort().IAppliance_addPasswords(req)
       
       return 


   def getPath(self):
       req=IAppliance_getPathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAppliance_getPath(req)
       return String(self.mgr,val._returnval)
   def getDisks(self):
       req=IAppliance_getDisksRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAppliance_getDisks(req)
       return String(self.mgr,val._returnval, True)
   def getVirtualSystemDescriptions(self):
       req=IAppliance_getVirtualSystemDescriptionsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAppliance_getVirtualSystemDescriptions(req)
       return IVirtualSystemDescription(self.mgr,val._returnval, True)
   def getMachines(self):
       req=IAppliance_getMachinesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAppliance_getMachines(req)
       return String(self.mgr,val._returnval, True)
   def getCertificate(self):
       req=IAppliance_getCertificateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAppliance_getCertificate(req)
       return ICertificate(self.mgr,val._returnval)


   _Attrs_={         'path':[getPath,None],
         'disks':[getDisks,None],
         'virtualSystemDescriptions':[getVirtualSystemDescriptions,None],
         'machines':[getMachines,None],
         'certificate':[getCertificate,None]}

class IVirtualSystemDescription(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVirtualSystemDescription(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVirtualSystemDescription._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVirtualSystemDescription._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getDescription(self):
       req=IVirtualSystemDescription_getDescriptionRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVirtualSystemDescription_getDescription(req)
       
       return VirtualSystemDescriptionType(self.mgr,val._types, True), String(self.mgr,val._refs, True), String(self.mgr,val._OVFValues, True), String(self.mgr,val._VBoxValues, True), String(self.mgr,val._extraConfigValues, True)


   def getDescriptionByType(self, _arg_type):
       req=IVirtualSystemDescription_getDescriptionByTypeRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       val=self.mgr.getPort().IVirtualSystemDescription_getDescriptionByType(req)
       
       return VirtualSystemDescriptionType(self.mgr,val._types, True), String(self.mgr,val._refs, True), String(self.mgr,val._OVFValues, True), String(self.mgr,val._VBoxValues, True), String(self.mgr,val._extraConfigValues, True)


   def getValuesByType(self, _arg_type, _arg_which):
       req=IVirtualSystemDescription_getValuesByTypeRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       req._which=_arg_which
       val=self.mgr.getPort().IVirtualSystemDescription_getValuesByType(req)
       
       return String(self.mgr,val._returnval, True)


   def setFinalValues(self, _arg_enabled, _arg_VBoxValues, _arg_extraConfigValues):
       req=IVirtualSystemDescription_setFinalValuesRequestMsg()
       req._this=self.handle
       
       req._enabled=_arg_enabled
       req._VBoxValues=_arg_VBoxValues
       req._extraConfigValues=_arg_extraConfigValues
       val=self.mgr.getPort().IVirtualSystemDescription_setFinalValues(req)
       
       return 


   def addDescription(self, _arg_type, _arg_VBoxValue, _arg_extraConfigValue):
       req=IVirtualSystemDescription_addDescriptionRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       req._VBoxValue=_arg_VBoxValue
       req._extraConfigValue=_arg_extraConfigValue
       val=self.mgr.getPort().IVirtualSystemDescription_addDescription(req)
       
       return 


   def getCount(self):
       req=IVirtualSystemDescription_getCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVirtualSystemDescription_getCount(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'count':[getCount,None]}

class IBIOSSettings(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IBIOSSettings(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IBIOSSettings._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IBIOSSettings._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getLogoFadeIn(self):
       req=IBIOSSettings_getLogoFadeInRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getLogoFadeIn(req)
       return Boolean(self.mgr,val._returnval)
   def setLogoFadeIn(self, value):
       req=IBIOSSettings_setLogoFadeInRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._logoFadeIn = value
       else:
            req._logoFadeIn = value.handle
       self.mgr.getPort().IBIOSSettings_setLogoFadeIn(req)

   def getLogoFadeOut(self):
       req=IBIOSSettings_getLogoFadeOutRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getLogoFadeOut(req)
       return Boolean(self.mgr,val._returnval)
   def setLogoFadeOut(self, value):
       req=IBIOSSettings_setLogoFadeOutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._logoFadeOut = value
       else:
            req._logoFadeOut = value.handle
       self.mgr.getPort().IBIOSSettings_setLogoFadeOut(req)

   def getLogoDisplayTime(self):
       req=IBIOSSettings_getLogoDisplayTimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getLogoDisplayTime(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setLogoDisplayTime(self, value):
       req=IBIOSSettings_setLogoDisplayTimeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._logoDisplayTime = value
       else:
            req._logoDisplayTime = value.handle
       self.mgr.getPort().IBIOSSettings_setLogoDisplayTime(req)

   def getLogoImagePath(self):
       req=IBIOSSettings_getLogoImagePathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getLogoImagePath(req)
       return String(self.mgr,val._returnval)
   def setLogoImagePath(self, value):
       req=IBIOSSettings_setLogoImagePathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._logoImagePath = value
       else:
            req._logoImagePath = value.handle
       self.mgr.getPort().IBIOSSettings_setLogoImagePath(req)

   def getBootMenuMode(self):
       req=IBIOSSettings_getBootMenuModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getBootMenuMode(req)
       return BIOSBootMenuMode(self.mgr,val._returnval)
   def setBootMenuMode(self, value):
       req=IBIOSSettings_setBootMenuModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._bootMenuMode = value
       else:
            req._bootMenuMode = value.handle
       self.mgr.getPort().IBIOSSettings_setBootMenuMode(req)

   def getACPIEnabled(self):
       req=IBIOSSettings_getACPIEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getACPIEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setACPIEnabled(self, value):
       req=IBIOSSettings_setACPIEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._ACPIEnabled = value
       else:
            req._ACPIEnabled = value.handle
       self.mgr.getPort().IBIOSSettings_setACPIEnabled(req)

   def getIOAPICEnabled(self):
       req=IBIOSSettings_getIOAPICEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getIOAPICEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setIOAPICEnabled(self, value):
       req=IBIOSSettings_setIOAPICEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IOAPICEnabled = value
       else:
            req._IOAPICEnabled = value.handle
       self.mgr.getPort().IBIOSSettings_setIOAPICEnabled(req)

   def getAPICMode(self):
       req=IBIOSSettings_getAPICModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getAPICMode(req)
       return APICMode(self.mgr,val._returnval)
   def setAPICMode(self, value):
       req=IBIOSSettings_setAPICModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._APICMode = value
       else:
            req._APICMode = value.handle
       self.mgr.getPort().IBIOSSettings_setAPICMode(req)

   def getTimeOffset(self):
       req=IBIOSSettings_getTimeOffsetRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getTimeOffset(req)
       return Long(self.mgr,val._returnval)
   def setTimeOffset(self, value):
       req=IBIOSSettings_setTimeOffsetRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._timeOffset = value
       else:
            req._timeOffset = value.handle
       self.mgr.getPort().IBIOSSettings_setTimeOffset(req)

   def getPXEDebugEnabled(self):
       req=IBIOSSettings_getPXEDebugEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getPXEDebugEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setPXEDebugEnabled(self, value):
       req=IBIOSSettings_setPXEDebugEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._PXEDebugEnabled = value
       else:
            req._PXEDebugEnabled = value.handle
       self.mgr.getPort().IBIOSSettings_setPXEDebugEnabled(req)

   def getNonVolatileStorageFile(self):
       req=IBIOSSettings_getNonVolatileStorageFileRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBIOSSettings_getNonVolatileStorageFile(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'logoFadeIn':[getLogoFadeIn,setLogoFadeIn,
        ],
         'logoFadeOut':[getLogoFadeOut,setLogoFadeOut,
        ],
         'logoDisplayTime':[getLogoDisplayTime,setLogoDisplayTime,
        ],
         'logoImagePath':[getLogoImagePath,setLogoImagePath,
        ],
         'bootMenuMode':[getBootMenuMode,setBootMenuMode,
        ],
         'ACPIEnabled':[getACPIEnabled,setACPIEnabled,
        ],
         'IOAPICEnabled':[getIOAPICEnabled,setIOAPICEnabled,
        ],
         'APICMode':[getAPICMode,setAPICMode,
        ],
         'timeOffset':[getTimeOffset,setTimeOffset,
        ],
         'PXEDebugEnabled':[getPXEDebugEnabled,setPXEDebugEnabled,
        ],
         'nonVolatileStorageFile':[getNonVolatileStorageFile,None]}

class IPCIAddress(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IPCIAddress(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IPCIAddress._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IPCIAddress._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def asLong(self):
       req=IPCIAddress_asLongRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IPCIAddress_asLong(req)
       
       return Int(self.mgr,val._returnval)


   def fromLong(self, _arg_number):
       req=IPCIAddress_fromLongRequestMsg()
       req._this=self.handle
       
       req._number=_arg_number
       val=self.mgr.getPort().IPCIAddress_fromLong(req)
       
       return 


   def getBus(self):
       req=IPCIAddress_getBusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPCIAddress_getBus(req)
       return Short(self.mgr,val._returnval)
   def setBus(self, value):
       req=IPCIAddress_setBusRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._bus = value
       else:
            req._bus = value.handle
       self.mgr.getPort().IPCIAddress_setBus(req)

   def getDevice(self):
       req=IPCIAddress_getDeviceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPCIAddress_getDevice(req)
       return Short(self.mgr,val._returnval)
   def setDevice(self, value):
       req=IPCIAddress_setDeviceRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._device = value
       else:
            req._device = value.handle
       self.mgr.getPort().IPCIAddress_setDevice(req)

   def getDevFunction(self):
       req=IPCIAddress_getDevFunctionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPCIAddress_getDevFunction(req)
       return Short(self.mgr,val._returnval)
   def setDevFunction(self, value):
       req=IPCIAddress_setDevFunctionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._devFunction = value
       else:
            req._devFunction = value.handle
       self.mgr.getPort().IPCIAddress_setDevFunction(req)



   _Attrs_={         'bus':[getBus,setBus,
        ],
         'device':[getDevice,setDevice,
        ],
         'devFunction':[getDevFunction,setDevFunction,
        ]}

class IMachine(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMachine(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMachine._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMachine._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def lockMachine(self, _arg_session, _arg_lockType):
       req=IMachine_lockMachineRequestMsg()
       req._this=self.handle
       
       req._session=_arg_session
       req._lockType=_arg_lockType
       val=self.mgr.getPort().IMachine_lockMachine(req)
       
       return 


   def launchVMProcess(self, _arg_session, _arg_name, _arg_environment):
       req=IMachine_launchVMProcessRequestMsg()
       req._this=self.handle
       
       req._session=_arg_session
       req._name=_arg_name
       req._environment=_arg_environment
       val=self.mgr.getPort().IMachine_launchVMProcess(req)
       
       return IProgress(self.mgr,val._returnval)


   def setBootOrder(self, _arg_position, _arg_device):
       req=IMachine_setBootOrderRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._device=_arg_device
       val=self.mgr.getPort().IMachine_setBootOrder(req)
       
       return 


   def getBootOrder(self, _arg_position):
       req=IMachine_getBootOrderRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       val=self.mgr.getPort().IMachine_getBootOrder(req)
       
       return DeviceType(self.mgr,val._returnval)


   def attachDevice(self, _arg_name, _arg_controllerPort, _arg_device, _arg_type, _arg_medium):
       req=IMachine_attachDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._type=_arg_type
       req._medium=_arg_medium
       val=self.mgr.getPort().IMachine_attachDevice(req)
       
       return 


   def attachDeviceWithoutMedium(self, _arg_name, _arg_controllerPort, _arg_device, _arg_type):
       req=IMachine_attachDeviceWithoutMediumRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._type=_arg_type
       val=self.mgr.getPort().IMachine_attachDeviceWithoutMedium(req)
       
       return 


   def detachDevice(self, _arg_name, _arg_controllerPort, _arg_device):
       req=IMachine_detachDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       val=self.mgr.getPort().IMachine_detachDevice(req)
       
       return 


   def passthroughDevice(self, _arg_name, _arg_controllerPort, _arg_device, _arg_passthrough):
       req=IMachine_passthroughDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._passthrough=_arg_passthrough
       val=self.mgr.getPort().IMachine_passthroughDevice(req)
       
       return 


   def temporaryEjectDevice(self, _arg_name, _arg_controllerPort, _arg_device, _arg_temporaryEject):
       req=IMachine_temporaryEjectDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._temporaryEject=_arg_temporaryEject
       val=self.mgr.getPort().IMachine_temporaryEjectDevice(req)
       
       return 


   def nonRotationalDevice(self, _arg_name, _arg_controllerPort, _arg_device, _arg_nonRotational):
       req=IMachine_nonRotationalDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._nonRotational=_arg_nonRotational
       val=self.mgr.getPort().IMachine_nonRotationalDevice(req)
       
       return 


   def setAutoDiscardForDevice(self, _arg_name, _arg_controllerPort, _arg_device, _arg_discard):
       req=IMachine_setAutoDiscardForDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._discard=_arg_discard
       val=self.mgr.getPort().IMachine_setAutoDiscardForDevice(req)
       
       return 


   def setHotPluggableForDevice(self, _arg_name, _arg_controllerPort, _arg_device, _arg_hotPluggable):
       req=IMachine_setHotPluggableForDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._hotPluggable=_arg_hotPluggable
       val=self.mgr.getPort().IMachine_setHotPluggableForDevice(req)
       
       return 


   def setBandwidthGroupForDevice(self, _arg_name, _arg_controllerPort, _arg_device, _arg_bandwidthGroup):
       req=IMachine_setBandwidthGroupForDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._bandwidthGroup=_arg_bandwidthGroup
       val=self.mgr.getPort().IMachine_setBandwidthGroupForDevice(req)
       
       return 


   def setNoBandwidthGroupForDevice(self, _arg_name, _arg_controllerPort, _arg_device):
       req=IMachine_setNoBandwidthGroupForDeviceRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       val=self.mgr.getPort().IMachine_setNoBandwidthGroupForDevice(req)
       
       return 


   def unmountMedium(self, _arg_name, _arg_controllerPort, _arg_device, _arg_force):
       req=IMachine_unmountMediumRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._force=_arg_force
       val=self.mgr.getPort().IMachine_unmountMedium(req)
       
       return 


   def mountMedium(self, _arg_name, _arg_controllerPort, _arg_device, _arg_medium, _arg_force):
       req=IMachine_mountMediumRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       req._medium=_arg_medium
       req._force=_arg_force
       val=self.mgr.getPort().IMachine_mountMedium(req)
       
       return 


   def getMedium(self, _arg_name, _arg_controllerPort, _arg_device):
       req=IMachine_getMediumRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       val=self.mgr.getPort().IMachine_getMedium(req)
       
       return IMedium(self.mgr,val._returnval)


   def getMediumAttachmentsOfController(self, _arg_name):
       req=IMachine_getMediumAttachmentsOfControllerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachine_getMediumAttachmentsOfController(req)
       
       return IMediumAttachment(self.mgr,val._returnval, True)


   def getMediumAttachment(self, _arg_name, _arg_controllerPort, _arg_device):
       req=IMachine_getMediumAttachmentRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       val=self.mgr.getPort().IMachine_getMediumAttachment(req)
       
       return IMediumAttachment(self.mgr,val._returnval)


   def attachHostPCIDevice(self, _arg_hostAddress, _arg_desiredGuestAddress, _arg_tryToUnbind):
       req=IMachine_attachHostPCIDeviceRequestMsg()
       req._this=self.handle
       
       req._hostAddress=_arg_hostAddress
       req._desiredGuestAddress=_arg_desiredGuestAddress
       req._tryToUnbind=_arg_tryToUnbind
       val=self.mgr.getPort().IMachine_attachHostPCIDevice(req)
       
       return 


   def detachHostPCIDevice(self, _arg_hostAddress):
       req=IMachine_detachHostPCIDeviceRequestMsg()
       req._this=self.handle
       
       req._hostAddress=_arg_hostAddress
       val=self.mgr.getPort().IMachine_detachHostPCIDevice(req)
       
       return 


   def getNetworkAdapter(self, _arg_slot):
       req=IMachine_getNetworkAdapterRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=self.mgr.getPort().IMachine_getNetworkAdapter(req)
       
       return INetworkAdapter(self.mgr,val._returnval)


   def addStorageController(self, _arg_name, _arg_connectionType):
       req=IMachine_addStorageControllerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._connectionType=_arg_connectionType
       val=self.mgr.getPort().IMachine_addStorageController(req)
       
       return IStorageController(self.mgr,val._returnval)


   def getStorageControllerByName(self, _arg_name):
       req=IMachine_getStorageControllerByNameRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachine_getStorageControllerByName(req)
       
       return IStorageController(self.mgr,val._returnval)


   def getStorageControllerByInstance(self, _arg_connectionType, _arg_instance):
       req=IMachine_getStorageControllerByInstanceRequestMsg()
       req._this=self.handle
       
       req._connectionType=_arg_connectionType
       req._instance=_arg_instance
       val=self.mgr.getPort().IMachine_getStorageControllerByInstance(req)
       
       return IStorageController(self.mgr,val._returnval)


   def removeStorageController(self, _arg_name):
       req=IMachine_removeStorageControllerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachine_removeStorageController(req)
       
       return 


   def setStorageControllerBootable(self, _arg_name, _arg_bootable):
       req=IMachine_setStorageControllerBootableRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._bootable=_arg_bootable
       val=self.mgr.getPort().IMachine_setStorageControllerBootable(req)
       
       return 


   def addUSBController(self, _arg_name, _arg_type):
       req=IMachine_addUSBControllerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._type=_arg_type
       val=self.mgr.getPort().IMachine_addUSBController(req)
       
       return IUSBController(self.mgr,val._returnval)


   def removeUSBController(self, _arg_name):
       req=IMachine_removeUSBControllerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachine_removeUSBController(req)
       
       return 


   def getUSBControllerByName(self, _arg_name):
       req=IMachine_getUSBControllerByNameRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachine_getUSBControllerByName(req)
       
       return IUSBController(self.mgr,val._returnval)


   def getUSBControllerCountByType(self, _arg_type):
       req=IMachine_getUSBControllerCountByTypeRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       val=self.mgr.getPort().IMachine_getUSBControllerCountByType(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getSerialPort(self, _arg_slot):
       req=IMachine_getSerialPortRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=self.mgr.getPort().IMachine_getSerialPort(req)
       
       return ISerialPort(self.mgr,val._returnval)


   def getParallelPort(self, _arg_slot):
       req=IMachine_getParallelPortRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=self.mgr.getPort().IMachine_getParallelPort(req)
       
       return IParallelPort(self.mgr,val._returnval)


   def getExtraDataKeys(self):
       req=IMachine_getExtraDataKeysRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachine_getExtraDataKeys(req)
       
       return String(self.mgr,val._returnval, True)


   def getExtraData(self, _arg_key):
       req=IMachine_getExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=self.mgr.getPort().IMachine_getExtraData(req)
       
       return String(self.mgr,val._returnval)


   def setExtraData(self, _arg_key, _arg_value):
       req=IMachine_setExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=self.mgr.getPort().IMachine_setExtraData(req)
       
       return 


   def getCPUProperty(self, _arg_property):
       req=IMachine_getCPUPropertyRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       val=self.mgr.getPort().IMachine_getCPUProperty(req)
       
       return Boolean(self.mgr,val._returnval)


   def setCPUProperty(self, _arg_property, _arg_value):
       req=IMachine_setCPUPropertyRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       req._value=_arg_value
       val=self.mgr.getPort().IMachine_setCPUProperty(req)
       
       return 


   def getCPUIDLeaf(self, _arg_id):
       req=IMachine_getCPUIDLeafRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IMachine_getCPUIDLeaf(req)
       
       return UnsignedInt(self.mgr,val._valEax), UnsignedInt(self.mgr,val._valEbx), UnsignedInt(self.mgr,val._valEcx), UnsignedInt(self.mgr,val._valEdx)


   def setCPUIDLeaf(self, _arg_id, _arg_valEax, _arg_valEbx, _arg_valEcx, _arg_valEdx):
       req=IMachine_setCPUIDLeafRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       req._valEax=_arg_valEax
       req._valEbx=_arg_valEbx
       req._valEcx=_arg_valEcx
       req._valEdx=_arg_valEdx
       val=self.mgr.getPort().IMachine_setCPUIDLeaf(req)
       
       return 


   def removeCPUIDLeaf(self, _arg_id):
       req=IMachine_removeCPUIDLeafRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IMachine_removeCPUIDLeaf(req)
       
       return 


   def removeAllCPUIDLeaves(self):
       req=IMachine_removeAllCPUIDLeavesRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachine_removeAllCPUIDLeaves(req)
       
       return 


   def getHWVirtExProperty(self, _arg_property):
       req=IMachine_getHWVirtExPropertyRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       val=self.mgr.getPort().IMachine_getHWVirtExProperty(req)
       
       return Boolean(self.mgr,val._returnval)


   def setHWVirtExProperty(self, _arg_property, _arg_value):
       req=IMachine_setHWVirtExPropertyRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       req._value=_arg_value
       val=self.mgr.getPort().IMachine_setHWVirtExProperty(req)
       
       return 


   def setSettingsFilePath(self, _arg_settingsFilePath):
       req=IMachine_setSettingsFilePathRequestMsg()
       req._this=self.handle
       
       req._settingsFilePath=_arg_settingsFilePath
       val=self.mgr.getPort().IMachine_setSettingsFilePath(req)
       
       return IProgress(self.mgr,val._returnval)


   def saveSettings(self):
       req=IMachine_saveSettingsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachine_saveSettings(req)
       
       return 


   def discardSettings(self):
       req=IMachine_discardSettingsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachine_discardSettings(req)
       
       return 


   def unregister(self, _arg_cleanupMode):
       req=IMachine_unregisterRequestMsg()
       req._this=self.handle
       
       req._cleanupMode=_arg_cleanupMode
       val=self.mgr.getPort().IMachine_unregister(req)
       
       return IMedium(self.mgr,val._returnval, True)


   def deleteConfig(self, _arg_media):
       req=IMachine_deleteConfigRequestMsg()
       req._this=self.handle
       
       req._media=_arg_media
       val=self.mgr.getPort().IMachine_deleteConfig(req)
       
       return IProgress(self.mgr,val._returnval)


   def exportTo(self, _arg_appliance, _arg_location):
       req=IMachine_exportToRequestMsg()
       req._this=self.handle
       
       req._appliance=_arg_appliance
       req._location=_arg_location
       val=self.mgr.getPort().IMachine_exportTo(req)
       
       return IVirtualSystemDescription(self.mgr,val._returnval)


   def findSnapshot(self, _arg_nameOrId):
       req=IMachine_findSnapshotRequestMsg()
       req._this=self.handle
       
       req._nameOrId=_arg_nameOrId
       val=self.mgr.getPort().IMachine_findSnapshot(req)
       
       return ISnapshot(self.mgr,val._returnval)


   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable, _arg_automount):
       req=IMachine_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       req._automount=_arg_automount
       val=self.mgr.getPort().IMachine_createSharedFolder(req)
       
       return 


   def removeSharedFolder(self, _arg_name):
       req=IMachine_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachine_removeSharedFolder(req)
       
       return 


   def canShowConsoleWindow(self):
       req=IMachine_canShowConsoleWindowRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachine_canShowConsoleWindow(req)
       
       return Boolean(self.mgr,val._returnval)


   def showConsoleWindow(self):
       req=IMachine_showConsoleWindowRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachine_showConsoleWindow(req)
       
       return Long(self.mgr,val._returnval)


   def getGuestProperty(self, _arg_name):
       req=IMachine_getGuestPropertyRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachine_getGuestProperty(req)
       
       return String(self.mgr,val._value), Long(self.mgr,val._timestamp), String(self.mgr,val._flags)


   def getGuestPropertyValue(self, _arg_property):
       req=IMachine_getGuestPropertyValueRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       val=self.mgr.getPort().IMachine_getGuestPropertyValue(req)
       
       return String(self.mgr,val._returnval)


   def getGuestPropertyTimestamp(self, _arg_property):
       req=IMachine_getGuestPropertyTimestampRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       val=self.mgr.getPort().IMachine_getGuestPropertyTimestamp(req)
       
       return Long(self.mgr,val._returnval)


   def setGuestProperty(self, _arg_property, _arg_value, _arg_flags):
       req=IMachine_setGuestPropertyRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       req._value=_arg_value
       req._flags=_arg_flags
       val=self.mgr.getPort().IMachine_setGuestProperty(req)
       
       return 


   def setGuestPropertyValue(self, _arg_property, _arg_value):
       req=IMachine_setGuestPropertyValueRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       req._value=_arg_value
       val=self.mgr.getPort().IMachine_setGuestPropertyValue(req)
       
       return 


   def deleteGuestProperty(self, _arg_name):
       req=IMachine_deleteGuestPropertyRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachine_deleteGuestProperty(req)
       
       return 


   def enumerateGuestProperties(self, _arg_patterns):
       req=IMachine_enumerateGuestPropertiesRequestMsg()
       req._this=self.handle
       
       req._patterns=_arg_patterns
       val=self.mgr.getPort().IMachine_enumerateGuestProperties(req)
       
       return String(self.mgr,val._names, True), String(self.mgr,val._values, True), Long(self.mgr,val._timestamps, True), String(self.mgr,val._flags, True)


   def querySavedGuestScreenInfo(self, _arg_screenId):
       req=IMachine_querySavedGuestScreenInfoRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       val=self.mgr.getPort().IMachine_querySavedGuestScreenInfo(req)
       
       return UnsignedInt(self.mgr,val._originX), UnsignedInt(self.mgr,val._originY), UnsignedInt(self.mgr,val._width), UnsignedInt(self.mgr,val._height), Boolean(self.mgr,val._enabled)


   def readSavedThumbnailToArray(self, _arg_screenId, _arg_bitmapFormat):
       req=IMachine_readSavedThumbnailToArrayRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._bitmapFormat=_arg_bitmapFormat
       val=self.mgr.getPort().IMachine_readSavedThumbnailToArray(req)
       
       return self.mgr.decodebase64(val._returnval), UnsignedInt(self.mgr,val._width), UnsignedInt(self.mgr,val._height)


   def querySavedScreenshotInfo(self, _arg_screenId):
       req=IMachine_querySavedScreenshotInfoRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       val=self.mgr.getPort().IMachine_querySavedScreenshotInfo(req)
       
       return BitmapFormat(self.mgr,val._returnval, True), UnsignedInt(self.mgr,val._width), UnsignedInt(self.mgr,val._height)


   def readSavedScreenshotToArray(self, _arg_screenId, _arg_bitmapFormat):
       req=IMachine_readSavedScreenshotToArrayRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._bitmapFormat=_arg_bitmapFormat
       val=self.mgr.getPort().IMachine_readSavedScreenshotToArray(req)
       
       return self.mgr.decodebase64(val._returnval), UnsignedInt(self.mgr,val._width), UnsignedInt(self.mgr,val._height)


   def hotPlugCPU(self, _arg_cpu):
       req=IMachine_hotPlugCPURequestMsg()
       req._this=self.handle
       
       req._cpu=_arg_cpu
       val=self.mgr.getPort().IMachine_hotPlugCPU(req)
       
       return 


   def hotUnplugCPU(self, _arg_cpu):
       req=IMachine_hotUnplugCPURequestMsg()
       req._this=self.handle
       
       req._cpu=_arg_cpu
       val=self.mgr.getPort().IMachine_hotUnplugCPU(req)
       
       return 


   def getCPUStatus(self, _arg_cpu):
       req=IMachine_getCPUStatusRequestMsg()
       req._this=self.handle
       
       req._cpu=_arg_cpu
       val=self.mgr.getPort().IMachine_getCPUStatus(req)
       
       return Boolean(self.mgr,val._returnval)


   def getEffectiveParavirtProvider(self):
       req=IMachine_getEffectiveParavirtProviderRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachine_getEffectiveParavirtProvider(req)
       
       return ParavirtProvider(self.mgr,val._returnval)


   def queryLogFilename(self, _arg_idx):
       req=IMachine_queryLogFilenameRequestMsg()
       req._this=self.handle
       
       req._idx=_arg_idx
       val=self.mgr.getPort().IMachine_queryLogFilename(req)
       
       return String(self.mgr,val._returnval)


   def readLog(self, _arg_idx, _arg_offset, _arg_size):
       req=IMachine_readLogRequestMsg()
       req._this=self.handle
       
       req._idx=_arg_idx
       req._offset=_arg_offset
       req._size=_arg_size
       val=self.mgr.getPort().IMachine_readLog(req)
       
       return self.mgr.decodebase64(val._returnval)


   def cloneTo(self, _arg_target, _arg_mode, _arg_options):
       req=IMachine_cloneToRequestMsg()
       req._this=self.handle
       
       req._target=_arg_target
       req._mode=_arg_mode
       req._options=_arg_options
       val=self.mgr.getPort().IMachine_cloneTo(req)
       
       return IProgress(self.mgr,val._returnval)


   def saveState(self):
       req=IMachine_saveStateRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachine_saveState(req)
       
       return IProgress(self.mgr,val._returnval)


   def adoptSavedState(self, _arg_savedStateFile):
       req=IMachine_adoptSavedStateRequestMsg()
       req._this=self.handle
       
       req._savedStateFile=_arg_savedStateFile
       val=self.mgr.getPort().IMachine_adoptSavedState(req)
       
       return 


   def discardSavedState(self, _arg_fRemoveFile):
       req=IMachine_discardSavedStateRequestMsg()
       req._this=self.handle
       
       req._fRemoveFile=_arg_fRemoveFile
       val=self.mgr.getPort().IMachine_discardSavedState(req)
       
       return 


   def takeSnapshot(self, _arg_name, _arg_description, _arg_pause):
       req=IMachine_takeSnapshotRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._description=_arg_description
       req._pause=_arg_pause
       val=self.mgr.getPort().IMachine_takeSnapshot(req)
       
       return IProgress(self.mgr,val._returnval), String(self.mgr,val._id)


   def deleteSnapshot(self, _arg_id):
       req=IMachine_deleteSnapshotRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IMachine_deleteSnapshot(req)
       
       return IProgress(self.mgr,val._returnval)


   def deleteSnapshotAndAllChildren(self, _arg_id):
       req=IMachine_deleteSnapshotAndAllChildrenRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IMachine_deleteSnapshotAndAllChildren(req)
       
       return IProgress(self.mgr,val._returnval)


   def deleteSnapshotRange(self, _arg_startId, _arg_endId):
       req=IMachine_deleteSnapshotRangeRequestMsg()
       req._this=self.handle
       
       req._startId=_arg_startId
       req._endId=_arg_endId
       val=self.mgr.getPort().IMachine_deleteSnapshotRange(req)
       
       return IProgress(self.mgr,val._returnval)


   def restoreSnapshot(self, _arg_snapshot):
       req=IMachine_restoreSnapshotRequestMsg()
       req._this=self.handle
       
       req._snapshot=_arg_snapshot
       val=self.mgr.getPort().IMachine_restoreSnapshot(req)
       
       return IProgress(self.mgr,val._returnval)


   def applyDefaults(self, _arg_flags):
       req=IMachine_applyDefaultsRequestMsg()
       req._this=self.handle
       
       req._flags=_arg_flags
       val=self.mgr.getPort().IMachine_applyDefaults(req)
       
       return 


   def getParent(self):
       req=IMachine_getParentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getParent(req)
       return IVirtualBox(self.mgr,val._returnval)
   def getIcon(self):
       req=IMachine_getIconRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getIcon(req)
       return self.mgr.decodebase64(val._returnval)
   def setIcon(self, value):
       req=IMachine_setIconRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str, tuple, list]:
            req._icon = value
       else:
            req._icon = value.handle
       self.mgr.getPort().IMachine_setIcon(req)

   def getAccessible(self):
       req=IMachine_getAccessibleRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAccessible(req)
       return Boolean(self.mgr,val._returnval)
   def getAccessError(self):
       req=IMachine_getAccessErrorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAccessError(req)
       return IVirtualBoxErrorInfo(self.mgr,val._returnval)
   def getName(self):
       req=IMachine_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getName(req)
       return String(self.mgr,val._returnval)
   def setName(self, value):
       req=IMachine_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._name = value
       else:
            req._name = value.handle
       self.mgr.getPort().IMachine_setName(req)

   def getDescription(self):
       req=IMachine_getDescriptionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getDescription(req)
       return String(self.mgr,val._returnval)
   def setDescription(self, value):
       req=IMachine_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._description = value
       else:
            req._description = value.handle
       self.mgr.getPort().IMachine_setDescription(req)

   def getId(self):
       req=IMachine_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getId(req)
       return String(self.mgr,val._returnval)
   def getGroups(self):
       req=IMachine_getGroupsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getGroups(req)
       return String(self.mgr,val._returnval, True)
   def setGroups(self, value):
       req=IMachine_setGroupsRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str, tuple, list]:
            req._groups = value
       else:
            req._groups = value.handle
       self.mgr.getPort().IMachine_setGroups(req)

   def getOSTypeId(self):
       req=IMachine_getOSTypeIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getOSTypeId(req)
       return String(self.mgr,val._returnval)
   def setOSTypeId(self, value):
       req=IMachine_setOSTypeIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._OSTypeId = value
       else:
            req._OSTypeId = value.handle
       self.mgr.getPort().IMachine_setOSTypeId(req)

   def getHardwareVersion(self):
       req=IMachine_getHardwareVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getHardwareVersion(req)
       return String(self.mgr,val._returnval)
   def setHardwareVersion(self, value):
       req=IMachine_setHardwareVersionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._hardwareVersion = value
       else:
            req._hardwareVersion = value.handle
       self.mgr.getPort().IMachine_setHardwareVersion(req)

   def getHardwareUUID(self):
       req=IMachine_getHardwareUUIDRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getHardwareUUID(req)
       return String(self.mgr,val._returnval)
   def setHardwareUUID(self, value):
       req=IMachine_setHardwareUUIDRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._hardwareUUID = value
       else:
            req._hardwareUUID = value.handle
       self.mgr.getPort().IMachine_setHardwareUUID(req)

   def getCPUCount(self):
       req=IMachine_getCPUCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getCPUCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setCPUCount(self, value):
       req=IMachine_setCPUCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._CPUCount = value
       else:
            req._CPUCount = value.handle
       self.mgr.getPort().IMachine_setCPUCount(req)

   def getCPUHotPlugEnabled(self):
       req=IMachine_getCPUHotPlugEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getCPUHotPlugEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setCPUHotPlugEnabled(self, value):
       req=IMachine_setCPUHotPlugEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._CPUHotPlugEnabled = value
       else:
            req._CPUHotPlugEnabled = value.handle
       self.mgr.getPort().IMachine_setCPUHotPlugEnabled(req)

   def getCPUExecutionCap(self):
       req=IMachine_getCPUExecutionCapRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getCPUExecutionCap(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setCPUExecutionCap(self, value):
       req=IMachine_setCPUExecutionCapRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._CPUExecutionCap = value
       else:
            req._CPUExecutionCap = value.handle
       self.mgr.getPort().IMachine_setCPUExecutionCap(req)

   def getCPUIDPortabilityLevel(self):
       req=IMachine_getCPUIDPortabilityLevelRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getCPUIDPortabilityLevel(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setCPUIDPortabilityLevel(self, value):
       req=IMachine_setCPUIDPortabilityLevelRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._CPUIDPortabilityLevel = value
       else:
            req._CPUIDPortabilityLevel = value.handle
       self.mgr.getPort().IMachine_setCPUIDPortabilityLevel(req)

   def getMemorySize(self):
       req=IMachine_getMemorySizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getMemorySize(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setMemorySize(self, value):
       req=IMachine_setMemorySizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._memorySize = value
       else:
            req._memorySize = value.handle
       self.mgr.getPort().IMachine_setMemorySize(req)

   def getMemoryBalloonSize(self):
       req=IMachine_getMemoryBalloonSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getMemoryBalloonSize(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setMemoryBalloonSize(self, value):
       req=IMachine_setMemoryBalloonSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._memoryBalloonSize = value
       else:
            req._memoryBalloonSize = value.handle
       self.mgr.getPort().IMachine_setMemoryBalloonSize(req)

   def getPageFusionEnabled(self):
       req=IMachine_getPageFusionEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getPageFusionEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setPageFusionEnabled(self, value):
       req=IMachine_setPageFusionEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._pageFusionEnabled = value
       else:
            req._pageFusionEnabled = value.handle
       self.mgr.getPort().IMachine_setPageFusionEnabled(req)

   def getGraphicsControllerType(self):
       req=IMachine_getGraphicsControllerTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getGraphicsControllerType(req)
       return GraphicsControllerType(self.mgr,val._returnval)
   def setGraphicsControllerType(self, value):
       req=IMachine_setGraphicsControllerTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._graphicsControllerType = value
       else:
            req._graphicsControllerType = value.handle
       self.mgr.getPort().IMachine_setGraphicsControllerType(req)

   def getVRAMSize(self):
       req=IMachine_getVRAMSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVRAMSize(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setVRAMSize(self, value):
       req=IMachine_setVRAMSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._VRAMSize = value
       else:
            req._VRAMSize = value.handle
       self.mgr.getPort().IMachine_setVRAMSize(req)

   def getAccelerate3DEnabled(self):
       req=IMachine_getAccelerate3DEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAccelerate3DEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setAccelerate3DEnabled(self, value):
       req=IMachine_setAccelerate3DEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._accelerate3DEnabled = value
       else:
            req._accelerate3DEnabled = value.handle
       self.mgr.getPort().IMachine_setAccelerate3DEnabled(req)

   def getAccelerate2DVideoEnabled(self):
       req=IMachine_getAccelerate2DVideoEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAccelerate2DVideoEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setAccelerate2DVideoEnabled(self, value):
       req=IMachine_setAccelerate2DVideoEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._accelerate2DVideoEnabled = value
       else:
            req._accelerate2DVideoEnabled = value.handle
       self.mgr.getPort().IMachine_setAccelerate2DVideoEnabled(req)

   def getMonitorCount(self):
       req=IMachine_getMonitorCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getMonitorCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setMonitorCount(self, value):
       req=IMachine_setMonitorCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._monitorCount = value
       else:
            req._monitorCount = value.handle
       self.mgr.getPort().IMachine_setMonitorCount(req)

   def getVideoCaptureEnabled(self):
       req=IMachine_getVideoCaptureEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setVideoCaptureEnabled(self, value):
       req=IMachine_setVideoCaptureEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureEnabled = value
       else:
            req._videoCaptureEnabled = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureEnabled(req)

   def getVideoCaptureScreens(self):
       req=IMachine_getVideoCaptureScreensRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureScreens(req)
       return Boolean(self.mgr,val._returnval, True)
   def setVideoCaptureScreens(self, value):
       req=IMachine_setVideoCaptureScreensRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str, tuple, list]:
            req._videoCaptureScreens = value
       else:
            req._videoCaptureScreens = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureScreens(req)

   def getVideoCaptureFile(self):
       req=IMachine_getVideoCaptureFileRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureFile(req)
       return String(self.mgr,val._returnval)
   def setVideoCaptureFile(self, value):
       req=IMachine_setVideoCaptureFileRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureFile = value
       else:
            req._videoCaptureFile = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureFile(req)

   def getVideoCaptureWidth(self):
       req=IMachine_getVideoCaptureWidthRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureWidth(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setVideoCaptureWidth(self, value):
       req=IMachine_setVideoCaptureWidthRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureWidth = value
       else:
            req._videoCaptureWidth = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureWidth(req)

   def getVideoCaptureHeight(self):
       req=IMachine_getVideoCaptureHeightRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureHeight(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setVideoCaptureHeight(self, value):
       req=IMachine_setVideoCaptureHeightRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureHeight = value
       else:
            req._videoCaptureHeight = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureHeight(req)

   def getVideoCaptureRate(self):
       req=IMachine_getVideoCaptureRateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureRate(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setVideoCaptureRate(self, value):
       req=IMachine_setVideoCaptureRateRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureRate = value
       else:
            req._videoCaptureRate = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureRate(req)

   def getVideoCaptureFPS(self):
       req=IMachine_getVideoCaptureFPSRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureFPS(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setVideoCaptureFPS(self, value):
       req=IMachine_setVideoCaptureFPSRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureFPS = value
       else:
            req._videoCaptureFPS = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureFPS(req)

   def getVideoCaptureMaxTime(self):
       req=IMachine_getVideoCaptureMaxTimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureMaxTime(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setVideoCaptureMaxTime(self, value):
       req=IMachine_setVideoCaptureMaxTimeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureMaxTime = value
       else:
            req._videoCaptureMaxTime = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureMaxTime(req)

   def getVideoCaptureMaxFileSize(self):
       req=IMachine_getVideoCaptureMaxFileSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureMaxFileSize(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setVideoCaptureMaxFileSize(self, value):
       req=IMachine_setVideoCaptureMaxFileSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureMaxFileSize = value
       else:
            req._videoCaptureMaxFileSize = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureMaxFileSize(req)

   def getVideoCaptureOptions(self):
       req=IMachine_getVideoCaptureOptionsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVideoCaptureOptions(req)
       return String(self.mgr,val._returnval)
   def setVideoCaptureOptions(self, value):
       req=IMachine_setVideoCaptureOptionsRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._videoCaptureOptions = value
       else:
            req._videoCaptureOptions = value.handle
       self.mgr.getPort().IMachine_setVideoCaptureOptions(req)

   def getBIOSSettings(self):
       req=IMachine_getBIOSSettingsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getBIOSSettings(req)
       return IBIOSSettings(self.mgr,val._returnval)
   def getFirmwareType(self):
       req=IMachine_getFirmwareTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getFirmwareType(req)
       return FirmwareType(self.mgr,val._returnval)
   def setFirmwareType(self, value):
       req=IMachine_setFirmwareTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._firmwareType = value
       else:
            req._firmwareType = value.handle
       self.mgr.getPort().IMachine_setFirmwareType(req)

   def getPointingHIDType(self):
       req=IMachine_getPointingHIDTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getPointingHIDType(req)
       return PointingHIDType(self.mgr,val._returnval)
   def setPointingHIDType(self, value):
       req=IMachine_setPointingHIDTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._pointingHIDType = value
       else:
            req._pointingHIDType = value.handle
       self.mgr.getPort().IMachine_setPointingHIDType(req)

   def getKeyboardHIDType(self):
       req=IMachine_getKeyboardHIDTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getKeyboardHIDType(req)
       return KeyboardHIDType(self.mgr,val._returnval)
   def setKeyboardHIDType(self, value):
       req=IMachine_setKeyboardHIDTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._keyboardHIDType = value
       else:
            req._keyboardHIDType = value.handle
       self.mgr.getPort().IMachine_setKeyboardHIDType(req)

   def getHPETEnabled(self):
       req=IMachine_getHPETEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getHPETEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setHPETEnabled(self, value):
       req=IMachine_setHPETEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._HPETEnabled = value
       else:
            req._HPETEnabled = value.handle
       self.mgr.getPort().IMachine_setHPETEnabled(req)

   def getChipsetType(self):
       req=IMachine_getChipsetTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getChipsetType(req)
       return ChipsetType(self.mgr,val._returnval)
   def setChipsetType(self, value):
       req=IMachine_setChipsetTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._chipsetType = value
       else:
            req._chipsetType = value.handle
       self.mgr.getPort().IMachine_setChipsetType(req)

   def getSnapshotFolder(self):
       req=IMachine_getSnapshotFolderRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSnapshotFolder(req)
       return String(self.mgr,val._returnval)
   def setSnapshotFolder(self, value):
       req=IMachine_setSnapshotFolderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._snapshotFolder = value
       else:
            req._snapshotFolder = value.handle
       self.mgr.getPort().IMachine_setSnapshotFolder(req)

   def getVRDEServer(self):
       req=IMachine_getVRDEServerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVRDEServer(req)
       return IVRDEServer(self.mgr,val._returnval)
   def getEmulatedUSBCardReaderEnabled(self):
       req=IMachine_getEmulatedUSBCardReaderEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getEmulatedUSBCardReaderEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setEmulatedUSBCardReaderEnabled(self, value):
       req=IMachine_setEmulatedUSBCardReaderEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._emulatedUSBCardReaderEnabled = value
       else:
            req._emulatedUSBCardReaderEnabled = value.handle
       self.mgr.getPort().IMachine_setEmulatedUSBCardReaderEnabled(req)

   def getMediumAttachments(self):
       req=IMachine_getMediumAttachmentsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getMediumAttachments(req)
       return IMediumAttachment(self.mgr,val._returnval, True)
   def getUSBControllers(self):
       req=IMachine_getUSBControllersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getUSBControllers(req)
       return IUSBController(self.mgr,val._returnval, True)
   def getUSBDeviceFilters(self):
       req=IMachine_getUSBDeviceFiltersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getUSBDeviceFilters(req)
       return IUSBDeviceFilters(self.mgr,val._returnval)
   def getAudioAdapter(self):
       req=IMachine_getAudioAdapterRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAudioAdapter(req)
       return IAudioAdapter(self.mgr,val._returnval)
   def getStorageControllers(self):
       req=IMachine_getStorageControllersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getStorageControllers(req)
       return IStorageController(self.mgr,val._returnval, True)
   def getSettingsFilePath(self):
       req=IMachine_getSettingsFilePathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSettingsFilePath(req)
       return String(self.mgr,val._returnval)
   def getSettingsAuxFilePath(self):
       req=IMachine_getSettingsAuxFilePathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSettingsAuxFilePath(req)
       return String(self.mgr,val._returnval)
   def getSettingsModified(self):
       req=IMachine_getSettingsModifiedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSettingsModified(req)
       return Boolean(self.mgr,val._returnval)
   def getSessionState(self):
       req=IMachine_getSessionStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSessionState(req)
       return SessionState(self.mgr,val._returnval)
   def getSessionName(self):
       req=IMachine_getSessionNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSessionName(req)
       return String(self.mgr,val._returnval)
   def getSessionPID(self):
       req=IMachine_getSessionPIDRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSessionPID(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getState(self):
       req=IMachine_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getState(req)
       return MachineState(self.mgr,val._returnval)
   def getLastStateChange(self):
       req=IMachine_getLastStateChangeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getLastStateChange(req)
       return Long(self.mgr,val._returnval)
   def getStateFilePath(self):
       req=IMachine_getStateFilePathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getStateFilePath(req)
       return String(self.mgr,val._returnval)
   def getLogFolder(self):
       req=IMachine_getLogFolderRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getLogFolder(req)
       return String(self.mgr,val._returnval)
   def getCurrentSnapshot(self):
       req=IMachine_getCurrentSnapshotRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getCurrentSnapshot(req)
       return ISnapshot(self.mgr,val._returnval)
   def getSnapshotCount(self):
       req=IMachine_getSnapshotCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSnapshotCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getCurrentStateModified(self):
       req=IMachine_getCurrentStateModifiedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getCurrentStateModified(req)
       return Boolean(self.mgr,val._returnval)
   def getSharedFolders(self):
       req=IMachine_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getSharedFolders(req)
       return ISharedFolder(self.mgr,val._returnval, True)
   def getClipboardMode(self):
       req=IMachine_getClipboardModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getClipboardMode(req)
       return ClipboardMode(self.mgr,val._returnval)
   def setClipboardMode(self, value):
       req=IMachine_setClipboardModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._clipboardMode = value
       else:
            req._clipboardMode = value.handle
       self.mgr.getPort().IMachine_setClipboardMode(req)

   def getDnDMode(self):
       req=IMachine_getDnDModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getDnDMode(req)
       return DnDMode(self.mgr,val._returnval)
   def setDnDMode(self, value):
       req=IMachine_setDnDModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._dnDMode = value
       else:
            req._dnDMode = value.handle
       self.mgr.getPort().IMachine_setDnDMode(req)

   def getTeleporterEnabled(self):
       req=IMachine_getTeleporterEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getTeleporterEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setTeleporterEnabled(self, value):
       req=IMachine_setTeleporterEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._teleporterEnabled = value
       else:
            req._teleporterEnabled = value.handle
       self.mgr.getPort().IMachine_setTeleporterEnabled(req)

   def getTeleporterPort(self):
       req=IMachine_getTeleporterPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getTeleporterPort(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setTeleporterPort(self, value):
       req=IMachine_setTeleporterPortRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._teleporterPort = value
       else:
            req._teleporterPort = value.handle
       self.mgr.getPort().IMachine_setTeleporterPort(req)

   def getTeleporterAddress(self):
       req=IMachine_getTeleporterAddressRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getTeleporterAddress(req)
       return String(self.mgr,val._returnval)
   def setTeleporterAddress(self, value):
       req=IMachine_setTeleporterAddressRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._teleporterAddress = value
       else:
            req._teleporterAddress = value.handle
       self.mgr.getPort().IMachine_setTeleporterAddress(req)

   def getTeleporterPassword(self):
       req=IMachine_getTeleporterPasswordRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getTeleporterPassword(req)
       return String(self.mgr,val._returnval)
   def setTeleporterPassword(self, value):
       req=IMachine_setTeleporterPasswordRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._teleporterPassword = value
       else:
            req._teleporterPassword = value.handle
       self.mgr.getPort().IMachine_setTeleporterPassword(req)

   def getParavirtProvider(self):
       req=IMachine_getParavirtProviderRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getParavirtProvider(req)
       return ParavirtProvider(self.mgr,val._returnval)
   def setParavirtProvider(self, value):
       req=IMachine_setParavirtProviderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._paravirtProvider = value
       else:
            req._paravirtProvider = value.handle
       self.mgr.getPort().IMachine_setParavirtProvider(req)

   def getFaultToleranceState(self):
       req=IMachine_getFaultToleranceStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getFaultToleranceState(req)
       return FaultToleranceState(self.mgr,val._returnval)
   def setFaultToleranceState(self, value):
       req=IMachine_setFaultToleranceStateRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._faultToleranceState = value
       else:
            req._faultToleranceState = value.handle
       self.mgr.getPort().IMachine_setFaultToleranceState(req)

   def getFaultTolerancePort(self):
       req=IMachine_getFaultTolerancePortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getFaultTolerancePort(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setFaultTolerancePort(self, value):
       req=IMachine_setFaultTolerancePortRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._faultTolerancePort = value
       else:
            req._faultTolerancePort = value.handle
       self.mgr.getPort().IMachine_setFaultTolerancePort(req)

   def getFaultToleranceAddress(self):
       req=IMachine_getFaultToleranceAddressRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getFaultToleranceAddress(req)
       return String(self.mgr,val._returnval)
   def setFaultToleranceAddress(self, value):
       req=IMachine_setFaultToleranceAddressRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._faultToleranceAddress = value
       else:
            req._faultToleranceAddress = value.handle
       self.mgr.getPort().IMachine_setFaultToleranceAddress(req)

   def getFaultTolerancePassword(self):
       req=IMachine_getFaultTolerancePasswordRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getFaultTolerancePassword(req)
       return String(self.mgr,val._returnval)
   def setFaultTolerancePassword(self, value):
       req=IMachine_setFaultTolerancePasswordRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._faultTolerancePassword = value
       else:
            req._faultTolerancePassword = value.handle
       self.mgr.getPort().IMachine_setFaultTolerancePassword(req)

   def getFaultToleranceSyncInterval(self):
       req=IMachine_getFaultToleranceSyncIntervalRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getFaultToleranceSyncInterval(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setFaultToleranceSyncInterval(self, value):
       req=IMachine_setFaultToleranceSyncIntervalRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._faultToleranceSyncInterval = value
       else:
            req._faultToleranceSyncInterval = value.handle
       self.mgr.getPort().IMachine_setFaultToleranceSyncInterval(req)

   def getRTCUseUTC(self):
       req=IMachine_getRTCUseUTCRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getRTCUseUTC(req)
       return Boolean(self.mgr,val._returnval)
   def setRTCUseUTC(self, value):
       req=IMachine_setRTCUseUTCRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._RTCUseUTC = value
       else:
            req._RTCUseUTC = value.handle
       self.mgr.getPort().IMachine_setRTCUseUTC(req)

   def getIOCacheEnabled(self):
       req=IMachine_getIOCacheEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getIOCacheEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setIOCacheEnabled(self, value):
       req=IMachine_setIOCacheEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IOCacheEnabled = value
       else:
            req._IOCacheEnabled = value.handle
       self.mgr.getPort().IMachine_setIOCacheEnabled(req)

   def getIOCacheSize(self):
       req=IMachine_getIOCacheSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getIOCacheSize(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setIOCacheSize(self, value):
       req=IMachine_setIOCacheSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IOCacheSize = value
       else:
            req._IOCacheSize = value.handle
       self.mgr.getPort().IMachine_setIOCacheSize(req)

   def getPCIDeviceAssignments(self):
       req=IMachine_getPCIDeviceAssignmentsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getPCIDeviceAssignments(req)
       return IPCIDeviceAttachment(self.mgr,val._returnval, True)
   def getBandwidthControl(self):
       req=IMachine_getBandwidthControlRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getBandwidthControl(req)
       return IBandwidthControl(self.mgr,val._returnval)
   def getTracingEnabled(self):
       req=IMachine_getTracingEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getTracingEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setTracingEnabled(self, value):
       req=IMachine_setTracingEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._tracingEnabled = value
       else:
            req._tracingEnabled = value.handle
       self.mgr.getPort().IMachine_setTracingEnabled(req)

   def getTracingConfig(self):
       req=IMachine_getTracingConfigRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getTracingConfig(req)
       return String(self.mgr,val._returnval)
   def setTracingConfig(self, value):
       req=IMachine_setTracingConfigRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._tracingConfig = value
       else:
            req._tracingConfig = value.handle
       self.mgr.getPort().IMachine_setTracingConfig(req)

   def getAllowTracingToAccessVM(self):
       req=IMachine_getAllowTracingToAccessVMRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAllowTracingToAccessVM(req)
       return Boolean(self.mgr,val._returnval)
   def setAllowTracingToAccessVM(self, value):
       req=IMachine_setAllowTracingToAccessVMRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._allowTracingToAccessVM = value
       else:
            req._allowTracingToAccessVM = value.handle
       self.mgr.getPort().IMachine_setAllowTracingToAccessVM(req)

   def getAutostartEnabled(self):
       req=IMachine_getAutostartEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAutostartEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setAutostartEnabled(self, value):
       req=IMachine_setAutostartEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._autostartEnabled = value
       else:
            req._autostartEnabled = value.handle
       self.mgr.getPort().IMachine_setAutostartEnabled(req)

   def getAutostartDelay(self):
       req=IMachine_getAutostartDelayRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAutostartDelay(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setAutostartDelay(self, value):
       req=IMachine_setAutostartDelayRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._autostartDelay = value
       else:
            req._autostartDelay = value.handle
       self.mgr.getPort().IMachine_setAutostartDelay(req)

   def getAutostopType(self):
       req=IMachine_getAutostopTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getAutostopType(req)
       return AutostopType(self.mgr,val._returnval)
   def setAutostopType(self, value):
       req=IMachine_setAutostopTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._autostopType = value
       else:
            req._autostopType = value.handle
       self.mgr.getPort().IMachine_setAutostopType(req)

   def getDefaultFrontend(self):
       req=IMachine_getDefaultFrontendRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getDefaultFrontend(req)
       return String(self.mgr,val._returnval)
   def setDefaultFrontend(self, value):
       req=IMachine_setDefaultFrontendRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._defaultFrontend = value
       else:
            req._defaultFrontend = value.handle
       self.mgr.getPort().IMachine_setDefaultFrontend(req)

   def getUSBProxyAvailable(self):
       req=IMachine_getUSBProxyAvailableRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getUSBProxyAvailable(req)
       return Boolean(self.mgr,val._returnval)
   def getVMProcessPriority(self):
       req=IMachine_getVMProcessPriorityRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getVMProcessPriority(req)
       return String(self.mgr,val._returnval)
   def setVMProcessPriority(self, value):
       req=IMachine_setVMProcessPriorityRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._VMProcessPriority = value
       else:
            req._VMProcessPriority = value.handle
       self.mgr.getPort().IMachine_setVMProcessPriority(req)

   def getParavirtDebug(self):
       req=IMachine_getParavirtDebugRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getParavirtDebug(req)
       return String(self.mgr,val._returnval)
   def setParavirtDebug(self, value):
       req=IMachine_setParavirtDebugRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._paravirtDebug = value
       else:
            req._paravirtDebug = value.handle
       self.mgr.getPort().IMachine_setParavirtDebug(req)

   def getCPUProfile(self):
       req=IMachine_getCPUProfileRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachine_getCPUProfile(req)
       return String(self.mgr,val._returnval)
   def setCPUProfile(self, value):
       req=IMachine_setCPUProfileRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._CPUProfile = value
       else:
            req._CPUProfile = value.handle
       self.mgr.getPort().IMachine_setCPUProfile(req)



   _Attrs_={         'parent':[getParent,None],
         'icon':[getIcon,setIcon,
        ],
         'accessible':[getAccessible,None],
         'accessError':[getAccessError,None],
         'name':[getName,setName,
        ],
         'description':[getDescription,setDescription,
        ],
         'id':[getId,None],
         'groups':[getGroups,setGroups,
        ],
         'OSTypeId':[getOSTypeId,setOSTypeId,
        ],
         'hardwareVersion':[getHardwareVersion,setHardwareVersion,
        ],
         'hardwareUUID':[getHardwareUUID,setHardwareUUID,
        ],
         'CPUCount':[getCPUCount,setCPUCount,
        ],
         'CPUHotPlugEnabled':[getCPUHotPlugEnabled,setCPUHotPlugEnabled,
        ],
         'CPUExecutionCap':[getCPUExecutionCap,setCPUExecutionCap,
        ],
         'CPUIDPortabilityLevel':[getCPUIDPortabilityLevel,setCPUIDPortabilityLevel,
        ],
         'memorySize':[getMemorySize,setMemorySize,
        ],
         'memoryBalloonSize':[getMemoryBalloonSize,setMemoryBalloonSize,
        ],
         'pageFusionEnabled':[getPageFusionEnabled,setPageFusionEnabled,
        ],
         'graphicsControllerType':[getGraphicsControllerType,setGraphicsControllerType,
        ],
         'VRAMSize':[getVRAMSize,setVRAMSize,
        ],
         'accelerate3DEnabled':[getAccelerate3DEnabled,setAccelerate3DEnabled,
        ],
         'accelerate2DVideoEnabled':[getAccelerate2DVideoEnabled,setAccelerate2DVideoEnabled,
        ],
         'monitorCount':[getMonitorCount,setMonitorCount,
        ],
         'videoCaptureEnabled':[getVideoCaptureEnabled,setVideoCaptureEnabled,
        ],
         'videoCaptureScreens':[getVideoCaptureScreens,setVideoCaptureScreens,
        ],
         'videoCaptureFile':[getVideoCaptureFile,setVideoCaptureFile,
        ],
         'videoCaptureWidth':[getVideoCaptureWidth,setVideoCaptureWidth,
        ],
         'videoCaptureHeight':[getVideoCaptureHeight,setVideoCaptureHeight,
        ],
         'videoCaptureRate':[getVideoCaptureRate,setVideoCaptureRate,
        ],
         'videoCaptureFPS':[getVideoCaptureFPS,setVideoCaptureFPS,
        ],
         'videoCaptureMaxTime':[getVideoCaptureMaxTime,setVideoCaptureMaxTime,
        ],
         'videoCaptureMaxFileSize':[getVideoCaptureMaxFileSize,setVideoCaptureMaxFileSize,
        ],
         'videoCaptureOptions':[getVideoCaptureOptions,setVideoCaptureOptions,
        ],
         'BIOSSettings':[getBIOSSettings,None],
         'firmwareType':[getFirmwareType,setFirmwareType,
        ],
         'pointingHIDType':[getPointingHIDType,setPointingHIDType,
        ],
         'keyboardHIDType':[getKeyboardHIDType,setKeyboardHIDType,
        ],
         'HPETEnabled':[getHPETEnabled,setHPETEnabled,
        ],
         'chipsetType':[getChipsetType,setChipsetType,
        ],
         'snapshotFolder':[getSnapshotFolder,setSnapshotFolder,
        ],
         'VRDEServer':[getVRDEServer,None],
         'emulatedUSBCardReaderEnabled':[getEmulatedUSBCardReaderEnabled,setEmulatedUSBCardReaderEnabled,
        ],
         'mediumAttachments':[getMediumAttachments,None],
         'USBControllers':[getUSBControllers,None],
         'USBDeviceFilters':[getUSBDeviceFilters,None],
         'audioAdapter':[getAudioAdapter,None],
         'storageControllers':[getStorageControllers,None],
         'settingsFilePath':[getSettingsFilePath,None],
         'settingsAuxFilePath':[getSettingsAuxFilePath,None],
         'settingsModified':[getSettingsModified,None],
         'sessionState':[getSessionState,None],
         'sessionName':[getSessionName,None],
         'sessionPID':[getSessionPID,None],
         'state':[getState,None],
         'lastStateChange':[getLastStateChange,None],
         'stateFilePath':[getStateFilePath,None],
         'logFolder':[getLogFolder,None],
         'currentSnapshot':[getCurrentSnapshot,None],
         'snapshotCount':[getSnapshotCount,None],
         'currentStateModified':[getCurrentStateModified,None],
         'sharedFolders':[getSharedFolders,None],
         'clipboardMode':[getClipboardMode,setClipboardMode,
        ],
         'dnDMode':[getDnDMode,setDnDMode,
        ],
         'teleporterEnabled':[getTeleporterEnabled,setTeleporterEnabled,
        ],
         'teleporterPort':[getTeleporterPort,setTeleporterPort,
        ],
         'teleporterAddress':[getTeleporterAddress,setTeleporterAddress,
        ],
         'teleporterPassword':[getTeleporterPassword,setTeleporterPassword,
        ],
         'paravirtProvider':[getParavirtProvider,setParavirtProvider,
        ],
         'faultToleranceState':[getFaultToleranceState,setFaultToleranceState,
        ],
         'faultTolerancePort':[getFaultTolerancePort,setFaultTolerancePort,
        ],
         'faultToleranceAddress':[getFaultToleranceAddress,setFaultToleranceAddress,
        ],
         'faultTolerancePassword':[getFaultTolerancePassword,setFaultTolerancePassword,
        ],
         'faultToleranceSyncInterval':[getFaultToleranceSyncInterval,setFaultToleranceSyncInterval,
        ],
         'RTCUseUTC':[getRTCUseUTC,setRTCUseUTC,
        ],
         'IOCacheEnabled':[getIOCacheEnabled,setIOCacheEnabled,
        ],
         'IOCacheSize':[getIOCacheSize,setIOCacheSize,
        ],
         'PCIDeviceAssignments':[getPCIDeviceAssignments,None],
         'bandwidthControl':[getBandwidthControl,None],
         'tracingEnabled':[getTracingEnabled,setTracingEnabled,
        ],
         'tracingConfig':[getTracingConfig,setTracingConfig,
        ],
         'allowTracingToAccessVM':[getAllowTracingToAccessVM,setAllowTracingToAccessVM,
        ],
         'autostartEnabled':[getAutostartEnabled,setAutostartEnabled,
        ],
         'autostartDelay':[getAutostartDelay,setAutostartDelay,
        ],
         'autostopType':[getAutostopType,setAutostopType,
        ],
         'defaultFrontend':[getDefaultFrontend,setDefaultFrontend,
        ],
         'USBProxyAvailable':[getUSBProxyAvailable,None],
         'VMProcessPriority':[getVMProcessPriority,setVMProcessPriority,
        ],
         'paravirtDebug':[getParavirtDebug,setParavirtDebug,
        ],
         'CPUProfile':[getCPUProfile,setCPUProfile,
        ]}

class IEmulatedUSB(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IEmulatedUSB(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IEmulatedUSB._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IEmulatedUSB._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def webcamAttach(self, _arg_path, _arg_settings):
       req=IEmulatedUSB_webcamAttachRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._settings=_arg_settings
       val=self.mgr.getPort().IEmulatedUSB_webcamAttach(req)
       
       return 


   def webcamDetach(self, _arg_path):
       req=IEmulatedUSB_webcamDetachRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       val=self.mgr.getPort().IEmulatedUSB_webcamDetach(req)
       
       return 


   def getWebcams(self):
       req=IEmulatedUSB_getWebcamsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IEmulatedUSB_getWebcams(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'webcams':[getWebcams,None]}

class IConsole(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IConsole(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IConsole._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IConsole._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def powerUp(self):
       req=IConsole_powerUpRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_powerUp(req)
       
       return IProgress(self.mgr,val._returnval)


   def powerUpPaused(self):
       req=IConsole_powerUpPausedRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_powerUpPaused(req)
       
       return IProgress(self.mgr,val._returnval)


   def powerDown(self):
       req=IConsole_powerDownRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_powerDown(req)
       
       return IProgress(self.mgr,val._returnval)


   def reset(self):
       req=IConsole_resetRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_reset(req)
       
       return 


   def pause(self):
       req=IConsole_pauseRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_pause(req)
       
       return 


   def resume(self):
       req=IConsole_resumeRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_resume(req)
       
       return 


   def powerButton(self):
       req=IConsole_powerButtonRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_powerButton(req)
       
       return 


   def sleepButton(self):
       req=IConsole_sleepButtonRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_sleepButton(req)
       
       return 


   def getPowerButtonHandled(self):
       req=IConsole_getPowerButtonHandledRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_getPowerButtonHandled(req)
       
       return Boolean(self.mgr,val._returnval)


   def getGuestEnteredACPIMode(self):
       req=IConsole_getGuestEnteredACPIModeRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_getGuestEnteredACPIMode(req)
       
       return Boolean(self.mgr,val._returnval)


   def getDeviceActivity(self, _arg_type):
       req=IConsole_getDeviceActivityRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       val=self.mgr.getPort().IConsole_getDeviceActivity(req)
       
       return DeviceActivity(self.mgr,val._returnval, True)


   def attachUSBDevice(self, _arg_id, _arg_captureFilename):
       req=IConsole_attachUSBDeviceRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       req._captureFilename=_arg_captureFilename
       val=self.mgr.getPort().IConsole_attachUSBDevice(req)
       
       return 


   def detachUSBDevice(self, _arg_id):
       req=IConsole_detachUSBDeviceRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IConsole_detachUSBDevice(req)
       
       return IUSBDevice(self.mgr,val._returnval)


   def findUSBDeviceByAddress(self, _arg_name):
       req=IConsole_findUSBDeviceByAddressRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IConsole_findUSBDeviceByAddress(req)
       
       return IUSBDevice(self.mgr,val._returnval)


   def findUSBDeviceById(self, _arg_id):
       req=IConsole_findUSBDeviceByIdRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IConsole_findUSBDeviceById(req)
       
       return IUSBDevice(self.mgr,val._returnval)


   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable, _arg_automount):
       req=IConsole_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       req._automount=_arg_automount
       val=self.mgr.getPort().IConsole_createSharedFolder(req)
       
       return 


   def removeSharedFolder(self, _arg_name):
       req=IConsole_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IConsole_removeSharedFolder(req)
       
       return 


   def teleport(self, _arg_hostname, _arg_tcpport, _arg_password, _arg_maxDowntime):
       req=IConsole_teleportRequestMsg()
       req._this=self.handle
       
       req._hostname=_arg_hostname
       req._tcpport=_arg_tcpport
       req._password=_arg_password
       req._maxDowntime=_arg_maxDowntime
       val=self.mgr.getPort().IConsole_teleport(req)
       
       return IProgress(self.mgr,val._returnval)


   def addDiskEncryptionPassword(self, _arg_id, _arg_password, _arg_clearOnSuspend):
       req=IConsole_addDiskEncryptionPasswordRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       req._password=_arg_password
       req._clearOnSuspend=_arg_clearOnSuspend
       val=self.mgr.getPort().IConsole_addDiskEncryptionPassword(req)
       
       return 


   def addDiskEncryptionPasswords(self, _arg_ids, _arg_passwords, _arg_clearOnSuspend):
       req=IConsole_addDiskEncryptionPasswordsRequestMsg()
       req._this=self.handle
       
       req._ids=_arg_ids
       req._passwords=_arg_passwords
       req._clearOnSuspend=_arg_clearOnSuspend
       val=self.mgr.getPort().IConsole_addDiskEncryptionPasswords(req)
       
       return 


   def removeDiskEncryptionPassword(self, _arg_id):
       req=IConsole_removeDiskEncryptionPasswordRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IConsole_removeDiskEncryptionPassword(req)
       
       return 


   def clearAllDiskEncryptionPasswords(self):
       req=IConsole_clearAllDiskEncryptionPasswordsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IConsole_clearAllDiskEncryptionPasswords(req)
       
       return 


   def getMachine(self):
       req=IConsole_getMachineRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getMachine(req)
       return IMachine(self.mgr,val._returnval)
   def getState(self):
       req=IConsole_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getState(req)
       return MachineState(self.mgr,val._returnval)
   def getGuest(self):
       req=IConsole_getGuestRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getGuest(req)
       return IGuest(self.mgr,val._returnval)
   def getKeyboard(self):
       req=IConsole_getKeyboardRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getKeyboard(req)
       return IKeyboard(self.mgr,val._returnval)
   def getMouse(self):
       req=IConsole_getMouseRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getMouse(req)
       return IMouse(self.mgr,val._returnval)
   def getDisplay(self):
       req=IConsole_getDisplayRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getDisplay(req)
       return IDisplay(self.mgr,val._returnval)
   def getDebugger(self):
       req=IConsole_getDebuggerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getDebugger(req)
       return IMachineDebugger(self.mgr,val._returnval)
   def getUSBDevices(self):
       req=IConsole_getUSBDevicesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getUSBDevices(req)
       return IUSBDevice(self.mgr,val._returnval, True)
   def getRemoteUSBDevices(self):
       req=IConsole_getRemoteUSBDevicesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getRemoteUSBDevices(req)
       return IHostUSBDevice(self.mgr,val._returnval, True)
   def getSharedFolders(self):
       req=IConsole_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getSharedFolders(req)
       return ISharedFolder(self.mgr,val._returnval, True)
   def getVRDEServerInfo(self):
       req=IConsole_getVRDEServerInfoRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getVRDEServerInfo(req)
       return IVRDEServerInfo(self.mgr,val._returnval)
   def getEventSource(self):
       req=IConsole_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)
   def getAttachedPCIDevices(self):
       req=IConsole_getAttachedPCIDevicesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getAttachedPCIDevices(req)
       return IPCIDeviceAttachment(self.mgr,val._returnval, True)
   def getUseHostClipboard(self):
       req=IConsole_getUseHostClipboardRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getUseHostClipboard(req)
       return Boolean(self.mgr,val._returnval)
   def setUseHostClipboard(self, value):
       req=IConsole_setUseHostClipboardRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._useHostClipboard = value
       else:
            req._useHostClipboard = value.handle
       self.mgr.getPort().IConsole_setUseHostClipboard(req)

   def getEmulatedUSB(self):
       req=IConsole_getEmulatedUSBRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IConsole_getEmulatedUSB(req)
       return IEmulatedUSB(self.mgr,val._returnval)


   _Attrs_={         'machine':[getMachine,None],
         'state':[getState,None],
         'guest':[getGuest,None],
         'keyboard':[getKeyboard,None],
         'mouse':[getMouse,None],
         'display':[getDisplay,None],
         'debugger':[getDebugger,None],
         'USBDevices':[getUSBDevices,None],
         'remoteUSBDevices':[getRemoteUSBDevices,None],
         'sharedFolders':[getSharedFolders,None],
         'VRDEServerInfo':[getVRDEServerInfo,None],
         'eventSource':[getEventSource,None],
         'attachedPCIDevices':[getAttachedPCIDevices,None],
         'useHostClipboard':[getUseHostClipboard,setUseHostClipboard,
        ],
         'emulatedUSB':[getEmulatedUSB,None]}

class IHostNetworkInterface(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IHostNetworkInterface(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostNetworkInterface._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IHostNetworkInterface._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def enableStaticIPConfig(self, _arg_IPAddress, _arg_networkMask):
       req=IHostNetworkInterface_enableStaticIPConfigRequestMsg()
       req._this=self.handle
       
       req._IPAddress=_arg_IPAddress
       req._networkMask=_arg_networkMask
       val=self.mgr.getPort().IHostNetworkInterface_enableStaticIPConfig(req)
       
       return 


   def enableStaticIPConfigV6(self, _arg_IPV6Address, _arg_IPV6NetworkMaskPrefixLength):
       req=IHostNetworkInterface_enableStaticIPConfigV6RequestMsg()
       req._this=self.handle
       
       req._IPV6Address=_arg_IPV6Address
       req._IPV6NetworkMaskPrefixLength=_arg_IPV6NetworkMaskPrefixLength
       val=self.mgr.getPort().IHostNetworkInterface_enableStaticIPConfigV6(req)
       
       return 


   def enableDynamicIPConfig(self):
       req=IHostNetworkInterface_enableDynamicIPConfigRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IHostNetworkInterface_enableDynamicIPConfig(req)
       
       return 


   def DHCPRediscover(self):
       req=IHostNetworkInterface_DHCPRediscoverRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IHostNetworkInterface_DHCPRediscover(req)
       
       return 


   def getName(self):
       req=IHostNetworkInterface_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getName(req)
       return String(self.mgr,val._returnval)
   def getShortName(self):
       req=IHostNetworkInterface_getShortNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getShortName(req)
       return String(self.mgr,val._returnval)
   def getId(self):
       req=IHostNetworkInterface_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getId(req)
       return String(self.mgr,val._returnval)
   def getNetworkName(self):
       req=IHostNetworkInterface_getNetworkNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getNetworkName(req)
       return String(self.mgr,val._returnval)
   def getDHCPEnabled(self):
       req=IHostNetworkInterface_getDHCPEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getDHCPEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def getIPAddress(self):
       req=IHostNetworkInterface_getIPAddressRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getIPAddress(req)
       return String(self.mgr,val._returnval)
   def getNetworkMask(self):
       req=IHostNetworkInterface_getNetworkMaskRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getNetworkMask(req)
       return String(self.mgr,val._returnval)
   def getIPV6Supported(self):
       req=IHostNetworkInterface_getIPV6SupportedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getIPV6Supported(req)
       return Boolean(self.mgr,val._returnval)
   def getIPV6Address(self):
       req=IHostNetworkInterface_getIPV6AddressRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getIPV6Address(req)
       return String(self.mgr,val._returnval)
   def getIPV6NetworkMaskPrefixLength(self):
       req=IHostNetworkInterface_getIPV6NetworkMaskPrefixLengthRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getIPV6NetworkMaskPrefixLength(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getHardwareAddress(self):
       req=IHostNetworkInterface_getHardwareAddressRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getHardwareAddress(req)
       return String(self.mgr,val._returnval)
   def getMediumType(self):
       req=IHostNetworkInterface_getMediumTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getMediumType(req)
       return HostNetworkInterfaceMediumType(self.mgr,val._returnval)
   def getStatus(self):
       req=IHostNetworkInterface_getStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getStatus(req)
       return HostNetworkInterfaceStatus(self.mgr,val._returnval)
   def getInterfaceType(self):
       req=IHostNetworkInterface_getInterfaceTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNetworkInterface_getInterfaceType(req)
       return HostNetworkInterfaceType(self.mgr,val._returnval)


   _Attrs_={         'name':[getName,None],
         'shortName':[getShortName,None],
         'id':[getId,None],
         'networkName':[getNetworkName,None],
         'DHCPEnabled':[getDHCPEnabled,None],
         'IPAddress':[getIPAddress,None],
         'networkMask':[getNetworkMask,None],
         'IPV6Supported':[getIPV6Supported,None],
         'IPV6Address':[getIPV6Address,None],
         'IPV6NetworkMaskPrefixLength':[getIPV6NetworkMaskPrefixLength,None],
         'hardwareAddress':[getHardwareAddress,None],
         'mediumType':[getMediumType,None],
         'status':[getStatus,None],
         'interfaceType':[getInterfaceType,None]}

class IHostVideoInputDevice(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IHostVideoInputDevice(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostVideoInputDevice._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IHostVideoInputDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IHostVideoInputDevice_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostVideoInputDevice_getName(req)
       return String(self.mgr,val._returnval)
   def getPath(self):
       req=IHostVideoInputDevice_getPathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostVideoInputDevice_getPath(req)
       return String(self.mgr,val._returnval)
   def getAlias(self):
       req=IHostVideoInputDevice_getAliasRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostVideoInputDevice_getAlias(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'name':[getName,None],
         'path':[getPath,None],
         'alias':[getAlias,None]}

class IHost(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IHost(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHost._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IHost._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getProcessorSpeed(self, _arg_cpuId):
       req=IHost_getProcessorSpeedRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       val=self.mgr.getPort().IHost_getProcessorSpeed(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getProcessorFeature(self, _arg_feature):
       req=IHost_getProcessorFeatureRequestMsg()
       req._this=self.handle
       
       req._feature=_arg_feature
       val=self.mgr.getPort().IHost_getProcessorFeature(req)
       
       return Boolean(self.mgr,val._returnval)


   def getProcessorDescription(self, _arg_cpuId):
       req=IHost_getProcessorDescriptionRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       val=self.mgr.getPort().IHost_getProcessorDescription(req)
       
       return String(self.mgr,val._returnval)


   def getProcessorCPUIDLeaf(self, _arg_cpuId, _arg_leaf, _arg_subLeaf):
       req=IHost_getProcessorCPUIDLeafRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       req._leaf=_arg_leaf
       req._subLeaf=_arg_subLeaf
       val=self.mgr.getPort().IHost_getProcessorCPUIDLeaf(req)
       
       return UnsignedInt(self.mgr,val._valEax), UnsignedInt(self.mgr,val._valEbx), UnsignedInt(self.mgr,val._valEcx), UnsignedInt(self.mgr,val._valEdx)


   def createHostOnlyNetworkInterface(self):
       req=IHost_createHostOnlyNetworkInterfaceRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IHost_createHostOnlyNetworkInterface(req)
       
       return IProgress(self.mgr,val._returnval), IHostNetworkInterface(self.mgr,val._hostInterface)


   def removeHostOnlyNetworkInterface(self, _arg_id):
       req=IHost_removeHostOnlyNetworkInterfaceRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IHost_removeHostOnlyNetworkInterface(req)
       
       return IProgress(self.mgr,val._returnval)


   def createUSBDeviceFilter(self, _arg_name):
       req=IHost_createUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IHost_createUSBDeviceFilter(req)
       
       return IHostUSBDeviceFilter(self.mgr,val._returnval)


   def insertUSBDeviceFilter(self, _arg_position, _arg_filter):
       req=IHost_insertUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._filter=_arg_filter
       val=self.mgr.getPort().IHost_insertUSBDeviceFilter(req)
       
       return 


   def removeUSBDeviceFilter(self, _arg_position):
       req=IHost_removeUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       val=self.mgr.getPort().IHost_removeUSBDeviceFilter(req)
       
       return 


   def findHostDVDDrive(self, _arg_name):
       req=IHost_findHostDVDDriveRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IHost_findHostDVDDrive(req)
       
       return IMedium(self.mgr,val._returnval)


   def findHostFloppyDrive(self, _arg_name):
       req=IHost_findHostFloppyDriveRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IHost_findHostFloppyDrive(req)
       
       return IMedium(self.mgr,val._returnval)


   def findHostNetworkInterfaceByName(self, _arg_name):
       req=IHost_findHostNetworkInterfaceByNameRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IHost_findHostNetworkInterfaceByName(req)
       
       return IHostNetworkInterface(self.mgr,val._returnval)


   def findHostNetworkInterfaceById(self, _arg_id):
       req=IHost_findHostNetworkInterfaceByIdRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IHost_findHostNetworkInterfaceById(req)
       
       return IHostNetworkInterface(self.mgr,val._returnval)


   def findHostNetworkInterfacesOfType(self, _arg_type):
       req=IHost_findHostNetworkInterfacesOfTypeRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       val=self.mgr.getPort().IHost_findHostNetworkInterfacesOfType(req)
       
       return IHostNetworkInterface(self.mgr,val._returnval, True)


   def findUSBDeviceById(self, _arg_id):
       req=IHost_findUSBDeviceByIdRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IHost_findUSBDeviceById(req)
       
       return IHostUSBDevice(self.mgr,val._returnval)


   def findUSBDeviceByAddress(self, _arg_name):
       req=IHost_findUSBDeviceByAddressRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IHost_findUSBDeviceByAddress(req)
       
       return IHostUSBDevice(self.mgr,val._returnval)


   def generateMACAddress(self):
       req=IHost_generateMACAddressRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IHost_generateMACAddress(req)
       
       return String(self.mgr,val._returnval)


   def addUSBDeviceSource(self, _arg_backend, _arg_id, _arg_address, _arg_propertyNames, _arg_propertyValues):
       req=IHost_addUSBDeviceSourceRequestMsg()
       req._this=self.handle
       
       req._backend=_arg_backend
       req._id=_arg_id
       req._address=_arg_address
       req._propertyNames=_arg_propertyNames
       req._propertyValues=_arg_propertyValues
       val=self.mgr.getPort().IHost_addUSBDeviceSource(req)
       
       return 


   def removeUSBDeviceSource(self, _arg_id):
       req=IHost_removeUSBDeviceSourceRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=self.mgr.getPort().IHost_removeUSBDeviceSource(req)
       
       return 


   def getDVDDrives(self):
       req=IHost_getDVDDrivesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getDVDDrives(req)
       return IMedium(self.mgr,val._returnval, True)
   def getFloppyDrives(self):
       req=IHost_getFloppyDrivesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getFloppyDrives(req)
       return IMedium(self.mgr,val._returnval, True)
   def getUSBDevices(self):
       req=IHost_getUSBDevicesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getUSBDevices(req)
       return IHostUSBDevice(self.mgr,val._returnval, True)
   def getUSBDeviceFilters(self):
       req=IHost_getUSBDeviceFiltersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getUSBDeviceFilters(req)
       return IHostUSBDeviceFilter(self.mgr,val._returnval, True)
   def getNetworkInterfaces(self):
       req=IHost_getNetworkInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getNetworkInterfaces(req)
       return IHostNetworkInterface(self.mgr,val._returnval, True)
   def getNameServers(self):
       req=IHost_getNameServersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getNameServers(req)
       return String(self.mgr,val._returnval, True)
   def getDomainName(self):
       req=IHost_getDomainNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getDomainName(req)
       return String(self.mgr,val._returnval)
   def getSearchStrings(self):
       req=IHost_getSearchStringsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getSearchStrings(req)
       return String(self.mgr,val._returnval, True)
   def getProcessorCount(self):
       req=IHost_getProcessorCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getProcessorCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getProcessorOnlineCount(self):
       req=IHost_getProcessorOnlineCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getProcessorOnlineCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getProcessorCoreCount(self):
       req=IHost_getProcessorCoreCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getProcessorCoreCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getProcessorOnlineCoreCount(self):
       req=IHost_getProcessorOnlineCoreCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getProcessorOnlineCoreCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMemorySize(self):
       req=IHost_getMemorySizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getMemorySize(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMemoryAvailable(self):
       req=IHost_getMemoryAvailableRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getMemoryAvailable(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getOperatingSystem(self):
       req=IHost_getOperatingSystemRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getOperatingSystem(req)
       return String(self.mgr,val._returnval)
   def getOSVersion(self):
       req=IHost_getOSVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getOSVersion(req)
       return String(self.mgr,val._returnval)
   def getUTCTime(self):
       req=IHost_getUTCTimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getUTCTime(req)
       return Long(self.mgr,val._returnval)
   def getAcceleration3DAvailable(self):
       req=IHost_getAcceleration3DAvailableRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getAcceleration3DAvailable(req)
       return Boolean(self.mgr,val._returnval)
   def getVideoInputDevices(self):
       req=IHost_getVideoInputDevicesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHost_getVideoInputDevices(req)
       return IHostVideoInputDevice(self.mgr,val._returnval, True)


   _Attrs_={         'DVDDrives':[getDVDDrives,None],
         'floppyDrives':[getFloppyDrives,None],
         'USBDevices':[getUSBDevices,None],
         'USBDeviceFilters':[getUSBDeviceFilters,None],
         'networkInterfaces':[getNetworkInterfaces,None],
         'nameServers':[getNameServers,None],
         'domainName':[getDomainName,None],
         'searchStrings':[getSearchStrings,None],
         'processorCount':[getProcessorCount,None],
         'processorOnlineCount':[getProcessorOnlineCount,None],
         'processorCoreCount':[getProcessorCoreCount,None],
         'processorOnlineCoreCount':[getProcessorOnlineCoreCount,None],
         'memorySize':[getMemorySize,None],
         'memoryAvailable':[getMemoryAvailable,None],
         'operatingSystem':[getOperatingSystem,None],
         'OSVersion':[getOSVersion,None],
         'UTCTime':[getUTCTime,None],
         'acceleration3DAvailable':[getAcceleration3DAvailable,None],
         'videoInputDevices':[getVideoInputDevices,None]}

class ISystemProperties(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISystemProperties(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISystemProperties._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISystemProperties._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMaxNetworkAdapters(self, _arg_chipset):
       req=ISystemProperties_getMaxNetworkAdaptersRequestMsg()
       req._this=self.handle
       
       req._chipset=_arg_chipset
       val=self.mgr.getPort().ISystemProperties_getMaxNetworkAdapters(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getMaxNetworkAdaptersOfType(self, _arg_chipset, _arg_type):
       req=ISystemProperties_getMaxNetworkAdaptersOfTypeRequestMsg()
       req._this=self.handle
       
       req._chipset=_arg_chipset
       req._type=_arg_type
       val=self.mgr.getPort().ISystemProperties_getMaxNetworkAdaptersOfType(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getMaxDevicesPerPortForStorageBus(self, _arg_bus):
       req=ISystemProperties_getMaxDevicesPerPortForStorageBusRequestMsg()
       req._this=self.handle
       
       req._bus=_arg_bus
       val=self.mgr.getPort().ISystemProperties_getMaxDevicesPerPortForStorageBus(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getMinPortCountForStorageBus(self, _arg_bus):
       req=ISystemProperties_getMinPortCountForStorageBusRequestMsg()
       req._this=self.handle
       
       req._bus=_arg_bus
       val=self.mgr.getPort().ISystemProperties_getMinPortCountForStorageBus(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getMaxPortCountForStorageBus(self, _arg_bus):
       req=ISystemProperties_getMaxPortCountForStorageBusRequestMsg()
       req._this=self.handle
       
       req._bus=_arg_bus
       val=self.mgr.getPort().ISystemProperties_getMaxPortCountForStorageBus(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getMaxInstancesOfStorageBus(self, _arg_chipset, _arg_bus):
       req=ISystemProperties_getMaxInstancesOfStorageBusRequestMsg()
       req._this=self.handle
       
       req._chipset=_arg_chipset
       req._bus=_arg_bus
       val=self.mgr.getPort().ISystemProperties_getMaxInstancesOfStorageBus(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getDeviceTypesForStorageBus(self, _arg_bus):
       req=ISystemProperties_getDeviceTypesForStorageBusRequestMsg()
       req._this=self.handle
       
       req._bus=_arg_bus
       val=self.mgr.getPort().ISystemProperties_getDeviceTypesForStorageBus(req)
       
       return DeviceType(self.mgr,val._returnval, True)


   def getDefaultIoCacheSettingForStorageController(self, _arg_controllerType):
       req=ISystemProperties_getDefaultIoCacheSettingForStorageControllerRequestMsg()
       req._this=self.handle
       
       req._controllerType=_arg_controllerType
       val=self.mgr.getPort().ISystemProperties_getDefaultIoCacheSettingForStorageController(req)
       
       return Boolean(self.mgr,val._returnval)


   def getStorageControllerHotplugCapable(self, _arg_controllerType):
       req=ISystemProperties_getStorageControllerHotplugCapableRequestMsg()
       req._this=self.handle
       
       req._controllerType=_arg_controllerType
       val=self.mgr.getPort().ISystemProperties_getStorageControllerHotplugCapable(req)
       
       return Boolean(self.mgr,val._returnval)


   def getMaxInstancesOfUSBControllerType(self, _arg_chipset, _arg_type):
       req=ISystemProperties_getMaxInstancesOfUSBControllerTypeRequestMsg()
       req._this=self.handle
       
       req._chipset=_arg_chipset
       req._type=_arg_type
       val=self.mgr.getPort().ISystemProperties_getMaxInstancesOfUSBControllerType(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getMinGuestRAM(self):
       req=ISystemProperties_getMinGuestRAMRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMinGuestRAM(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMaxGuestRAM(self):
       req=ISystemProperties_getMaxGuestRAMRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMaxGuestRAM(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMinGuestVRAM(self):
       req=ISystemProperties_getMinGuestVRAMRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMinGuestVRAM(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMaxGuestVRAM(self):
       req=ISystemProperties_getMaxGuestVRAMRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMaxGuestVRAM(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMinGuestCPUCount(self):
       req=ISystemProperties_getMinGuestCPUCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMinGuestCPUCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMaxGuestCPUCount(self):
       req=ISystemProperties_getMaxGuestCPUCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMaxGuestCPUCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMaxGuestMonitors(self):
       req=ISystemProperties_getMaxGuestMonitorsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMaxGuestMonitors(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getInfoVDSize(self):
       req=ISystemProperties_getInfoVDSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getInfoVDSize(req)
       return Long(self.mgr,val._returnval)
   def getSerialPortCount(self):
       req=ISystemProperties_getSerialPortCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getSerialPortCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getParallelPortCount(self):
       req=ISystemProperties_getParallelPortCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getParallelPortCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMaxBootPosition(self):
       req=ISystemProperties_getMaxBootPositionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMaxBootPosition(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getRawModeSupported(self):
       req=ISystemProperties_getRawModeSupportedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getRawModeSupported(req)
       return Boolean(self.mgr,val._returnval)
   def getExclusiveHwVirt(self):
       req=ISystemProperties_getExclusiveHwVirtRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getExclusiveHwVirt(req)
       return Boolean(self.mgr,val._returnval)
   def setExclusiveHwVirt(self, value):
       req=ISystemProperties_setExclusiveHwVirtRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._exclusiveHwVirt = value
       else:
            req._exclusiveHwVirt = value.handle
       self.mgr.getPort().ISystemProperties_setExclusiveHwVirt(req)

   def getDefaultMachineFolder(self):
       req=ISystemProperties_getDefaultMachineFolderRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getDefaultMachineFolder(req)
       return String(self.mgr,val._returnval)
   def setDefaultMachineFolder(self, value):
       req=ISystemProperties_setDefaultMachineFolderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._defaultMachineFolder = value
       else:
            req._defaultMachineFolder = value.handle
       self.mgr.getPort().ISystemProperties_setDefaultMachineFolder(req)

   def getLoggingLevel(self):
       req=ISystemProperties_getLoggingLevelRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getLoggingLevel(req)
       return String(self.mgr,val._returnval)
   def setLoggingLevel(self, value):
       req=ISystemProperties_setLoggingLevelRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._loggingLevel = value
       else:
            req._loggingLevel = value.handle
       self.mgr.getPort().ISystemProperties_setLoggingLevel(req)

   def getMediumFormats(self):
       req=ISystemProperties_getMediumFormatsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getMediumFormats(req)
       return IMediumFormat(self.mgr,val._returnval, True)
   def getDefaultHardDiskFormat(self):
       req=ISystemProperties_getDefaultHardDiskFormatRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getDefaultHardDiskFormat(req)
       return String(self.mgr,val._returnval)
   def setDefaultHardDiskFormat(self, value):
       req=ISystemProperties_setDefaultHardDiskFormatRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._defaultHardDiskFormat = value
       else:
            req._defaultHardDiskFormat = value.handle
       self.mgr.getPort().ISystemProperties_setDefaultHardDiskFormat(req)

   def getFreeDiskSpaceWarning(self):
       req=ISystemProperties_getFreeDiskSpaceWarningRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getFreeDiskSpaceWarning(req)
       return Long(self.mgr,val._returnval)
   def setFreeDiskSpaceWarning(self, value):
       req=ISystemProperties_setFreeDiskSpaceWarningRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._freeDiskSpaceWarning = value
       else:
            req._freeDiskSpaceWarning = value.handle
       self.mgr.getPort().ISystemProperties_setFreeDiskSpaceWarning(req)

   def getFreeDiskSpacePercentWarning(self):
       req=ISystemProperties_getFreeDiskSpacePercentWarningRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getFreeDiskSpacePercentWarning(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setFreeDiskSpacePercentWarning(self, value):
       req=ISystemProperties_setFreeDiskSpacePercentWarningRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._freeDiskSpacePercentWarning = value
       else:
            req._freeDiskSpacePercentWarning = value.handle
       self.mgr.getPort().ISystemProperties_setFreeDiskSpacePercentWarning(req)

   def getFreeDiskSpaceError(self):
       req=ISystemProperties_getFreeDiskSpaceErrorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getFreeDiskSpaceError(req)
       return Long(self.mgr,val._returnval)
   def setFreeDiskSpaceError(self, value):
       req=ISystemProperties_setFreeDiskSpaceErrorRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._freeDiskSpaceError = value
       else:
            req._freeDiskSpaceError = value.handle
       self.mgr.getPort().ISystemProperties_setFreeDiskSpaceError(req)

   def getFreeDiskSpacePercentError(self):
       req=ISystemProperties_getFreeDiskSpacePercentErrorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getFreeDiskSpacePercentError(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setFreeDiskSpacePercentError(self, value):
       req=ISystemProperties_setFreeDiskSpacePercentErrorRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._freeDiskSpacePercentError = value
       else:
            req._freeDiskSpacePercentError = value.handle
       self.mgr.getPort().ISystemProperties_setFreeDiskSpacePercentError(req)

   def getVRDEAuthLibrary(self):
       req=ISystemProperties_getVRDEAuthLibraryRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getVRDEAuthLibrary(req)
       return String(self.mgr,val._returnval)
   def setVRDEAuthLibrary(self, value):
       req=ISystemProperties_setVRDEAuthLibraryRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._VRDEAuthLibrary = value
       else:
            req._VRDEAuthLibrary = value.handle
       self.mgr.getPort().ISystemProperties_setVRDEAuthLibrary(req)

   def getWebServiceAuthLibrary(self):
       req=ISystemProperties_getWebServiceAuthLibraryRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getWebServiceAuthLibrary(req)
       return String(self.mgr,val._returnval)
   def setWebServiceAuthLibrary(self, value):
       req=ISystemProperties_setWebServiceAuthLibraryRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._webServiceAuthLibrary = value
       else:
            req._webServiceAuthLibrary = value.handle
       self.mgr.getPort().ISystemProperties_setWebServiceAuthLibrary(req)

   def getDefaultVRDEExtPack(self):
       req=ISystemProperties_getDefaultVRDEExtPackRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getDefaultVRDEExtPack(req)
       return String(self.mgr,val._returnval)
   def setDefaultVRDEExtPack(self, value):
       req=ISystemProperties_setDefaultVRDEExtPackRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._defaultVRDEExtPack = value
       else:
            req._defaultVRDEExtPack = value.handle
       self.mgr.getPort().ISystemProperties_setDefaultVRDEExtPack(req)

   def getLogHistoryCount(self):
       req=ISystemProperties_getLogHistoryCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getLogHistoryCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setLogHistoryCount(self, value):
       req=ISystemProperties_setLogHistoryCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._logHistoryCount = value
       else:
            req._logHistoryCount = value.handle
       self.mgr.getPort().ISystemProperties_setLogHistoryCount(req)

   def getDefaultAudioDriver(self):
       req=ISystemProperties_getDefaultAudioDriverRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getDefaultAudioDriver(req)
       return AudioDriverType(self.mgr,val._returnval)
   def getAutostartDatabasePath(self):
       req=ISystemProperties_getAutostartDatabasePathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getAutostartDatabasePath(req)
       return String(self.mgr,val._returnval)
   def setAutostartDatabasePath(self, value):
       req=ISystemProperties_setAutostartDatabasePathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._autostartDatabasePath = value
       else:
            req._autostartDatabasePath = value.handle
       self.mgr.getPort().ISystemProperties_setAutostartDatabasePath(req)

   def getDefaultAdditionsISO(self):
       req=ISystemProperties_getDefaultAdditionsISORequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getDefaultAdditionsISO(req)
       return String(self.mgr,val._returnval)
   def setDefaultAdditionsISO(self, value):
       req=ISystemProperties_setDefaultAdditionsISORequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._defaultAdditionsISO = value
       else:
            req._defaultAdditionsISO = value.handle
       self.mgr.getPort().ISystemProperties_setDefaultAdditionsISO(req)

   def getDefaultFrontend(self):
       req=ISystemProperties_getDefaultFrontendRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getDefaultFrontend(req)
       return String(self.mgr,val._returnval)
   def setDefaultFrontend(self, value):
       req=ISystemProperties_setDefaultFrontendRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._defaultFrontend = value
       else:
            req._defaultFrontend = value.handle
       self.mgr.getPort().ISystemProperties_setDefaultFrontend(req)

   def getScreenShotFormats(self):
       req=ISystemProperties_getScreenShotFormatsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISystemProperties_getScreenShotFormats(req)
       return BitmapFormat(self.mgr,val._returnval, True)


   _Attrs_={         'minGuestRAM':[getMinGuestRAM,None],
         'maxGuestRAM':[getMaxGuestRAM,None],
         'minGuestVRAM':[getMinGuestVRAM,None],
         'maxGuestVRAM':[getMaxGuestVRAM,None],
         'minGuestCPUCount':[getMinGuestCPUCount,None],
         'maxGuestCPUCount':[getMaxGuestCPUCount,None],
         'maxGuestMonitors':[getMaxGuestMonitors,None],
         'infoVDSize':[getInfoVDSize,None],
         'serialPortCount':[getSerialPortCount,None],
         'parallelPortCount':[getParallelPortCount,None],
         'maxBootPosition':[getMaxBootPosition,None],
         'rawModeSupported':[getRawModeSupported,None],
         'exclusiveHwVirt':[getExclusiveHwVirt,setExclusiveHwVirt,
        ],
         'defaultMachineFolder':[getDefaultMachineFolder,setDefaultMachineFolder,
        ],
         'loggingLevel':[getLoggingLevel,setLoggingLevel,
        ],
         'mediumFormats':[getMediumFormats,None],
         'defaultHardDiskFormat':[getDefaultHardDiskFormat,setDefaultHardDiskFormat,
        ],
         'freeDiskSpaceWarning':[getFreeDiskSpaceWarning,setFreeDiskSpaceWarning,
        ],
         'freeDiskSpacePercentWarning':[getFreeDiskSpacePercentWarning,setFreeDiskSpacePercentWarning,
        ],
         'freeDiskSpaceError':[getFreeDiskSpaceError,setFreeDiskSpaceError,
        ],
         'freeDiskSpacePercentError':[getFreeDiskSpacePercentError,setFreeDiskSpacePercentError,
        ],
         'VRDEAuthLibrary':[getVRDEAuthLibrary,setVRDEAuthLibrary,
        ],
         'webServiceAuthLibrary':[getWebServiceAuthLibrary,setWebServiceAuthLibrary,
        ],
         'defaultVRDEExtPack':[getDefaultVRDEExtPack,setDefaultVRDEExtPack,
        ],
         'logHistoryCount':[getLogHistoryCount,setLogHistoryCount,
        ],
         'defaultAudioDriver':[getDefaultAudioDriver,None],
         'autostartDatabasePath':[getAutostartDatabasePath,setAutostartDatabasePath,
        ],
         'defaultAdditionsISO':[getDefaultAdditionsISO,setDefaultAdditionsISO,
        ],
         'defaultFrontend':[getDefaultFrontend,setDefaultFrontend,
        ],
         'screenShotFormats':[getScreenShotFormats,None]}

class IDnDBase(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IDnDBase(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDnDBase._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IDnDBase._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def isFormatSupported(self, _arg_format):
       req=IDnDBase_isFormatSupportedRequestMsg()
       req._this=self.handle
       
       req._format=_arg_format
       val=self.mgr.getPort().IDnDBase_isFormatSupported(req)
       
       return Boolean(self.mgr,val._returnval)


   def addFormats(self, _arg_formats):
       req=IDnDBase_addFormatsRequestMsg()
       req._this=self.handle
       
       req._formats=_arg_formats
       val=self.mgr.getPort().IDnDBase_addFormats(req)
       
       return 


   def removeFormats(self, _arg_formats):
       req=IDnDBase_removeFormatsRequestMsg()
       req._this=self.handle
       
       req._formats=_arg_formats
       val=self.mgr.getPort().IDnDBase_removeFormats(req)
       
       return 


   def getFormats(self):
       req=IDnDBase_getFormatsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDnDBase_getFormats(req)
       return String(self.mgr,val._returnval, True)
   def getProtocolVersion(self):
       req=IDnDBase_getProtocolVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDnDBase_getProtocolVersion(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'formats':[getFormats,None],
         'protocolVersion':[getProtocolVersion,None]}

class IDnDSource(IDnDBase):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IDnDSource(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDnDSource._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IDnDBase.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IDnDSource._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def dragIsPending(self, _arg_screenId):
       req=IDnDSource_dragIsPendingRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       val=self.mgr.getPort().IDnDSource_dragIsPending(req)
       
       return DnDAction(self.mgr,val._returnval), String(self.mgr,val._formats, True), DnDAction(self.mgr,val._allowedActions, True)


   def drop(self, _arg_format, _arg_action):
       req=IDnDSource_dropRequestMsg()
       req._this=self.handle
       
       req._format=_arg_format
       req._action=_arg_action
       val=self.mgr.getPort().IDnDSource_drop(req)
       
       return IProgress(self.mgr,val._returnval)


   def receiveData(self):
       req=IDnDSource_receiveDataRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IDnDSource_receiveData(req)
       
       return self.mgr.decodebase64(val._returnval)




   _Attrs_={}

class IGuestDnDSource(IDnDSource):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestDnDSource(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestDnDSource._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IDnDSource.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestDnDSource._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IGuestDnDSource_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestDnDSource_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IDnDTarget(IDnDBase):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IDnDTarget(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDnDTarget._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IDnDBase.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IDnDTarget._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def enter(self, _arg_screenId, _arg_y, _arg_x, _arg_defaultAction, _arg_allowedActions, _arg_formats):
       req=IDnDTarget_enterRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._y=_arg_y
       req._x=_arg_x
       req._defaultAction=_arg_defaultAction
       req._allowedActions=_arg_allowedActions
       req._formats=_arg_formats
       val=self.mgr.getPort().IDnDTarget_enter(req)
       
       return DnDAction(self.mgr,val._returnval)


   def move(self, _arg_screenId, _arg_x, _arg_y, _arg_defaultAction, _arg_allowedActions, _arg_formats):
       req=IDnDTarget_moveRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._x=_arg_x
       req._y=_arg_y
       req._defaultAction=_arg_defaultAction
       req._allowedActions=_arg_allowedActions
       req._formats=_arg_formats
       val=self.mgr.getPort().IDnDTarget_move(req)
       
       return DnDAction(self.mgr,val._returnval)


   def leave(self, _arg_screenId):
       req=IDnDTarget_leaveRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       val=self.mgr.getPort().IDnDTarget_leave(req)
       
       return 


   def drop(self, _arg_screenId, _arg_x, _arg_y, _arg_defaultAction, _arg_allowedActions, _arg_formats):
       req=IDnDTarget_dropRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._x=_arg_x
       req._y=_arg_y
       req._defaultAction=_arg_defaultAction
       req._allowedActions=_arg_allowedActions
       req._formats=_arg_formats
       val=self.mgr.getPort().IDnDTarget_drop(req)
       
       return DnDAction(self.mgr,val._returnval), String(self.mgr,val._format)


   def sendData(self, _arg_screenId, _arg_format, _arg_data):
       req=IDnDTarget_sendDataRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._format=_arg_format
       req._data=self.mgr.encodebase64(_arg_data)
       val=self.mgr.getPort().IDnDTarget_sendData(req)
       
       return IProgress(self.mgr,val._returnval)


   def cancel(self):
       req=IDnDTarget_cancelRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IDnDTarget_cancel(req)
       
       return Boolean(self.mgr,val._returnval)




   _Attrs_={}

class IGuestDnDTarget(IDnDTarget):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestDnDTarget(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestDnDTarget._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IDnDTarget.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestDnDTarget._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IGuestDnDTarget_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestDnDTarget_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IGuestSession(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestSession(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestSession._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestSession._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def close(self):
       req=IGuestSession_closeRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IGuestSession_close(req)
       
       return 


   def directoryCopy(self, _arg_source, _arg_destination, _arg_flags):
       req=IGuestSession_directoryCopyRequestMsg()
       req._this=self.handle
       
       req._source=_arg_source
       req._destination=_arg_destination
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_directoryCopy(req)
       
       return IProgress(self.mgr,val._returnval)


   def directoryCopyFromGuest(self, _arg_source, _arg_destination, _arg_flags):
       req=IGuestSession_directoryCopyFromGuestRequestMsg()
       req._this=self.handle
       
       req._source=_arg_source
       req._destination=_arg_destination
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_directoryCopyFromGuest(req)
       
       return IProgress(self.mgr,val._returnval)


   def directoryCopyToGuest(self, _arg_source, _arg_destination, _arg_flags):
       req=IGuestSession_directoryCopyToGuestRequestMsg()
       req._this=self.handle
       
       req._source=_arg_source
       req._destination=_arg_destination
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_directoryCopyToGuest(req)
       
       return IProgress(self.mgr,val._returnval)


   def directoryCreate(self, _arg_path, _arg_mode, _arg_flags):
       req=IGuestSession_directoryCreateRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._mode=_arg_mode
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_directoryCreate(req)
       
       return 


   def directoryCreateTemp(self, _arg_templateName, _arg_mode, _arg_path, _arg_secure):
       req=IGuestSession_directoryCreateTempRequestMsg()
       req._this=self.handle
       
       req._templateName=_arg_templateName
       req._mode=_arg_mode
       req._path=_arg_path
       req._secure=_arg_secure
       val=self.mgr.getPort().IGuestSession_directoryCreateTemp(req)
       
       return String(self.mgr,val._returnval)


   def directoryExists(self, _arg_path, _arg_followSymlinks):
       req=IGuestSession_directoryExistsRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._followSymlinks=_arg_followSymlinks
       val=self.mgr.getPort().IGuestSession_directoryExists(req)
       
       return Boolean(self.mgr,val._returnval)


   def directoryOpen(self, _arg_path, _arg_filter, _arg_flags):
       req=IGuestSession_directoryOpenRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._filter=_arg_filter
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_directoryOpen(req)
       
       return IGuestDirectory(self.mgr,val._returnval)


   def directoryRemove(self, _arg_path):
       req=IGuestSession_directoryRemoveRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       val=self.mgr.getPort().IGuestSession_directoryRemove(req)
       
       return 


   def directoryRemoveRecursive(self, _arg_path, _arg_flags):
       req=IGuestSession_directoryRemoveRecursiveRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_directoryRemoveRecursive(req)
       
       return IProgress(self.mgr,val._returnval)


   def environmentScheduleSet(self, _arg_name, _arg_value):
       req=IGuestSession_environmentScheduleSetRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._value=_arg_value
       val=self.mgr.getPort().IGuestSession_environmentScheduleSet(req)
       
       return 


   def environmentScheduleUnset(self, _arg_name):
       req=IGuestSession_environmentScheduleUnsetRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IGuestSession_environmentScheduleUnset(req)
       
       return 


   def environmentGetBaseVariable(self, _arg_name):
       req=IGuestSession_environmentGetBaseVariableRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IGuestSession_environmentGetBaseVariable(req)
       
       return String(self.mgr,val._returnval)


   def environmentDoesBaseVariableExist(self, _arg_name):
       req=IGuestSession_environmentDoesBaseVariableExistRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IGuestSession_environmentDoesBaseVariableExist(req)
       
       return Boolean(self.mgr,val._returnval)


   def fileCopy(self, _arg_source, _arg_destination, _arg_flags):
       req=IGuestSession_fileCopyRequestMsg()
       req._this=self.handle
       
       req._source=_arg_source
       req._destination=_arg_destination
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_fileCopy(req)
       
       return IProgress(self.mgr,val._returnval)


   def fileCopyFromGuest(self, _arg_source, _arg_destination, _arg_flags):
       req=IGuestSession_fileCopyFromGuestRequestMsg()
       req._this=self.handle
       
       req._source=_arg_source
       req._destination=_arg_destination
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_fileCopyFromGuest(req)
       
       return IProgress(self.mgr,val._returnval)


   def fileCopyToGuest(self, _arg_source, _arg_destination, _arg_flags):
       req=IGuestSession_fileCopyToGuestRequestMsg()
       req._this=self.handle
       
       req._source=_arg_source
       req._destination=_arg_destination
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_fileCopyToGuest(req)
       
       return IProgress(self.mgr,val._returnval)


   def fileCreateTemp(self, _arg_templateName, _arg_mode, _arg_path, _arg_secure):
       req=IGuestSession_fileCreateTempRequestMsg()
       req._this=self.handle
       
       req._templateName=_arg_templateName
       req._mode=_arg_mode
       req._path=_arg_path
       req._secure=_arg_secure
       val=self.mgr.getPort().IGuestSession_fileCreateTemp(req)
       
       return IGuestFile(self.mgr,val._returnval)


   def fileExists(self, _arg_path, _arg_followSymlinks):
       req=IGuestSession_fileExistsRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._followSymlinks=_arg_followSymlinks
       val=self.mgr.getPort().IGuestSession_fileExists(req)
       
       return Boolean(self.mgr,val._returnval)


   def fileOpen(self, _arg_path, _arg_accessMode, _arg_openAction, _arg_creationMode):
       req=IGuestSession_fileOpenRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._accessMode=_arg_accessMode
       req._openAction=_arg_openAction
       req._creationMode=_arg_creationMode
       val=self.mgr.getPort().IGuestSession_fileOpen(req)
       
       return IGuestFile(self.mgr,val._returnval)


   def fileOpenEx(self, _arg_path, _arg_accessMode, _arg_openAction, _arg_sharingMode, _arg_creationMode, _arg_flags):
       req=IGuestSession_fileOpenExRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._accessMode=_arg_accessMode
       req._openAction=_arg_openAction
       req._sharingMode=_arg_sharingMode
       req._creationMode=_arg_creationMode
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_fileOpenEx(req)
       
       return IGuestFile(self.mgr,val._returnval)


   def fileQuerySize(self, _arg_path, _arg_followSymlinks):
       req=IGuestSession_fileQuerySizeRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._followSymlinks=_arg_followSymlinks
       val=self.mgr.getPort().IGuestSession_fileQuerySize(req)
       
       return Long(self.mgr,val._returnval)


   def fsObjExists(self, _arg_path, _arg_followSymlinks):
       req=IGuestSession_fsObjExistsRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._followSymlinks=_arg_followSymlinks
       val=self.mgr.getPort().IGuestSession_fsObjExists(req)
       
       return Boolean(self.mgr,val._returnval)


   def fsObjQueryInfo(self, _arg_path, _arg_followSymlinks):
       req=IGuestSession_fsObjQueryInfoRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._followSymlinks=_arg_followSymlinks
       val=self.mgr.getPort().IGuestSession_fsObjQueryInfo(req)
       
       return IGuestFsObjInfo(self.mgr,val._returnval)


   def fsObjRemove(self, _arg_path):
       req=IGuestSession_fsObjRemoveRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       val=self.mgr.getPort().IGuestSession_fsObjRemove(req)
       
       return 


   def fsObjRename(self, _arg_oldPath, _arg_newPath, _arg_flags):
       req=IGuestSession_fsObjRenameRequestMsg()
       req._this=self.handle
       
       req._oldPath=_arg_oldPath
       req._newPath=_arg_newPath
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_fsObjRename(req)
       
       return 


   def fsObjMove(self, _arg_source, _arg_destination, _arg_flags):
       req=IGuestSession_fsObjMoveRequestMsg()
       req._this=self.handle
       
       req._source=_arg_source
       req._destination=_arg_destination
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_fsObjMove(req)
       
       return IProgress(self.mgr,val._returnval)


   def fsObjSetACL(self, _arg_path, _arg_followSymlinks, _arg_acl, _arg_mode):
       req=IGuestSession_fsObjSetACLRequestMsg()
       req._this=self.handle
       
       req._path=_arg_path
       req._followSymlinks=_arg_followSymlinks
       req._acl=_arg_acl
       req._mode=_arg_mode
       val=self.mgr.getPort().IGuestSession_fsObjSetACL(req)
       
       return 


   def processCreate(self, _arg_executable, _arg_arguments, _arg_environmentChanges, _arg_flags, _arg_timeoutMS):
       req=IGuestSession_processCreateRequestMsg()
       req._this=self.handle
       
       req._executable=_arg_executable
       req._arguments=_arg_arguments
       req._environmentChanges=_arg_environmentChanges
       req._flags=_arg_flags
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IGuestSession_processCreate(req)
       
       return IGuestProcess(self.mgr,val._returnval)


   def processCreateEx(self, _arg_executable, _arg_arguments, _arg_environmentChanges, _arg_flags, _arg_timeoutMS, _arg_priority, _arg_affinity):
       req=IGuestSession_processCreateExRequestMsg()
       req._this=self.handle
       
       req._executable=_arg_executable
       req._arguments=_arg_arguments
       req._environmentChanges=_arg_environmentChanges
       req._flags=_arg_flags
       req._timeoutMS=_arg_timeoutMS
       req._priority=_arg_priority
       req._affinity=_arg_affinity
       val=self.mgr.getPort().IGuestSession_processCreateEx(req)
       
       return IGuestProcess(self.mgr,val._returnval)


   def processGet(self, _arg_pid):
       req=IGuestSession_processGetRequestMsg()
       req._this=self.handle
       
       req._pid=_arg_pid
       val=self.mgr.getPort().IGuestSession_processGet(req)
       
       return IGuestProcess(self.mgr,val._returnval)


   def symlinkCreate(self, _arg_symlink, _arg_target, _arg_type):
       req=IGuestSession_symlinkCreateRequestMsg()
       req._this=self.handle
       
       req._symlink=_arg_symlink
       req._target=_arg_target
       req._type=_arg_type
       val=self.mgr.getPort().IGuestSession_symlinkCreate(req)
       
       return 


   def symlinkExists(self, _arg_symlink):
       req=IGuestSession_symlinkExistsRequestMsg()
       req._this=self.handle
       
       req._symlink=_arg_symlink
       val=self.mgr.getPort().IGuestSession_symlinkExists(req)
       
       return Boolean(self.mgr,val._returnval)


   def symlinkRead(self, _arg_symlink, _arg_flags):
       req=IGuestSession_symlinkReadRequestMsg()
       req._this=self.handle
       
       req._symlink=_arg_symlink
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuestSession_symlinkRead(req)
       
       return String(self.mgr,val._returnval)


   def waitFor(self, _arg_waitFor, _arg_timeoutMS):
       req=IGuestSession_waitForRequestMsg()
       req._this=self.handle
       
       req._waitFor=_arg_waitFor
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IGuestSession_waitFor(req)
       
       return GuestSessionWaitResult(self.mgr,val._returnval)


   def waitForArray(self, _arg_waitFor, _arg_timeoutMS):
       req=IGuestSession_waitForArrayRequestMsg()
       req._this=self.handle
       
       req._waitFor=_arg_waitFor
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IGuestSession_waitForArray(req)
       
       return GuestSessionWaitResult(self.mgr,val._returnval)


   def getUser(self):
       req=IGuestSession_getUserRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getUser(req)
       return String(self.mgr,val._returnval)
   def getDomain(self):
       req=IGuestSession_getDomainRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getDomain(req)
       return String(self.mgr,val._returnval)
   def getName(self):
       req=IGuestSession_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getName(req)
       return String(self.mgr,val._returnval)
   def getId(self):
       req=IGuestSession_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getId(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getTimeout(self):
       req=IGuestSession_getTimeoutRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getTimeout(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setTimeout(self, value):
       req=IGuestSession_setTimeoutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._timeout = value
       else:
            req._timeout = value.handle
       self.mgr.getPort().IGuestSession_setTimeout(req)

   def getProtocolVersion(self):
       req=IGuestSession_getProtocolVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getProtocolVersion(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getStatus(self):
       req=IGuestSession_getStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getStatus(req)
       return GuestSessionStatus(self.mgr,val._returnval)
   def getEnvironmentChanges(self):
       req=IGuestSession_getEnvironmentChangesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getEnvironmentChanges(req)
       return String(self.mgr,val._returnval, True)
   def setEnvironmentChanges(self, value):
       req=IGuestSession_setEnvironmentChangesRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str, tuple, list]:
            req._environmentChanges = value
       else:
            req._environmentChanges = value.handle
       self.mgr.getPort().IGuestSession_setEnvironmentChanges(req)

   def getEnvironmentBase(self):
       req=IGuestSession_getEnvironmentBaseRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getEnvironmentBase(req)
       return String(self.mgr,val._returnval, True)
   def getProcesses(self):
       req=IGuestSession_getProcessesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getProcesses(req)
       return IGuestProcess(self.mgr,val._returnval, True)
   def getPathStyle(self):
       req=IGuestSession_getPathStyleRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getPathStyle(req)
       return PathStyle(self.mgr,val._returnval)
   def getCurrentDirectory(self):
       req=IGuestSession_getCurrentDirectoryRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getCurrentDirectory(req)
       return String(self.mgr,val._returnval)
   def setCurrentDirectory(self, value):
       req=IGuestSession_setCurrentDirectoryRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._currentDirectory = value
       else:
            req._currentDirectory = value.handle
       self.mgr.getPort().IGuestSession_setCurrentDirectory(req)

   def getDirectories(self):
       req=IGuestSession_getDirectoriesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getDirectories(req)
       return IGuestDirectory(self.mgr,val._returnval, True)
   def getFiles(self):
       req=IGuestSession_getFilesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getFiles(req)
       return IGuestFile(self.mgr,val._returnval, True)
   def getEventSource(self):
       req=IGuestSession_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSession_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)


   _Attrs_={         'user':[getUser,None],
         'domain':[getDomain,None],
         'name':[getName,None],
         'id':[getId,None],
         'timeout':[getTimeout,setTimeout,
        ],
         'protocolVersion':[getProtocolVersion,None],
         'status':[getStatus,None],
         'environmentChanges':[getEnvironmentChanges,setEnvironmentChanges,
        ],
         'environmentBase':[getEnvironmentBase,None],
         'processes':[getProcesses,None],
         'pathStyle':[getPathStyle,None],
         'currentDirectory':[getCurrentDirectory,setCurrentDirectory,
        ],
         'directories':[getDirectories,None],
         'files':[getFiles,None],
         'eventSource':[getEventSource,None]}

class IProcess(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IProcess(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IProcess._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IProcess._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def waitFor(self, _arg_waitFor, _arg_timeoutMS):
       req=IProcess_waitForRequestMsg()
       req._this=self.handle
       
       req._waitFor=_arg_waitFor
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IProcess_waitFor(req)
       
       return ProcessWaitResult(self.mgr,val._returnval)


   def waitForArray(self, _arg_waitFor, _arg_timeoutMS):
       req=IProcess_waitForArrayRequestMsg()
       req._this=self.handle
       
       req._waitFor=_arg_waitFor
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IProcess_waitForArray(req)
       
       return ProcessWaitResult(self.mgr,val._returnval)


   def read(self, _arg_handle, _arg_toRead, _arg_timeoutMS):
       req=IProcess_readRequestMsg()
       req._this=self.handle
       
       req._handle=_arg_handle
       req._toRead=_arg_toRead
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IProcess_read(req)
       
       return self.mgr.decodebase64(val._returnval)


   def write(self, _arg_handle, _arg_flags, _arg_data, _arg_timeoutMS):
       req=IProcess_writeRequestMsg()
       req._this=self.handle
       
       req._handle=_arg_handle
       req._flags=_arg_flags
       req._data=self.mgr.encodebase64(_arg_data)
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IProcess_write(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def writeArray(self, _arg_handle, _arg_flags, _arg_data, _arg_timeoutMS):
       req=IProcess_writeArrayRequestMsg()
       req._this=self.handle
       
       req._handle=_arg_handle
       req._flags=_arg_flags
       req._data=self.mgr.encodebase64(_arg_data)
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IProcess_writeArray(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def terminate(self):
       req=IProcess_terminateRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IProcess_terminate(req)
       
       return 


   def getArguments(self):
       req=IProcess_getArgumentsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProcess_getArguments(req)
       return String(self.mgr,val._returnval, True)
   def getEnvironment(self):
       req=IProcess_getEnvironmentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProcess_getEnvironment(req)
       return String(self.mgr,val._returnval, True)
   def getEventSource(self):
       req=IProcess_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProcess_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)
   def getExecutablePath(self):
       req=IProcess_getExecutablePathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProcess_getExecutablePath(req)
       return String(self.mgr,val._returnval)
   def getExitCode(self):
       req=IProcess_getExitCodeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProcess_getExitCode(req)
       return Int(self.mgr,val._returnval)
   def getName(self):
       req=IProcess_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProcess_getName(req)
       return String(self.mgr,val._returnval)
   def getPID(self):
       req=IProcess_getPIDRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProcess_getPID(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getStatus(self):
       req=IProcess_getStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProcess_getStatus(req)
       return ProcessStatus(self.mgr,val._returnval)


   _Attrs_={         'arguments':[getArguments,None],
         'environment':[getEnvironment,None],
         'eventSource':[getEventSource,None],
         'executablePath':[getExecutablePath,None],
         'exitCode':[getExitCode,None],
         'name':[getName,None],
         'PID':[getPID,None],
         'status':[getStatus,None]}

class IGuestProcess(IProcess):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestProcess(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestProcess._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IProcess.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestProcess._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IGuestProcess_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcess_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IDirectory(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IDirectory(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDirectory._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IDirectory._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def close(self):
       req=IDirectory_closeRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IDirectory_close(req)
       
       return 


   def read(self):
       req=IDirectory_readRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IDirectory_read(req)
       
       return IFsObjInfo(self.mgr,val._returnval)


   def getDirectoryName(self):
       req=IDirectory_getDirectoryNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDirectory_getDirectoryName(req)
       return String(self.mgr,val._returnval)
   def getFilter(self):
       req=IDirectory_getFilterRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDirectory_getFilter(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'directoryName':[getDirectoryName,None],
         'filter':[getFilter,None]}

class IGuestDirectory(IDirectory):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestDirectory(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestDirectory._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IDirectory.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestDirectory._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IGuestDirectory_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestDirectory_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IFile(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IFile(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IFile._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IFile._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def close(self):
       req=IFile_closeRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IFile_close(req)
       
       return 


   def queryInfo(self):
       req=IFile_queryInfoRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IFile_queryInfo(req)
       
       return IFsObjInfo(self.mgr,val._returnval)


   def querySize(self):
       req=IFile_querySizeRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IFile_querySize(req)
       
       return Long(self.mgr,val._returnval)


   def read(self, _arg_toRead, _arg_timeoutMS):
       req=IFile_readRequestMsg()
       req._this=self.handle
       
       req._toRead=_arg_toRead
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IFile_read(req)
       
       return self.mgr.decodebase64(val._returnval)


   def readAt(self, _arg_offset, _arg_toRead, _arg_timeoutMS):
       req=IFile_readAtRequestMsg()
       req._this=self.handle
       
       req._offset=_arg_offset
       req._toRead=_arg_toRead
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IFile_readAt(req)
       
       return self.mgr.decodebase64(val._returnval)


   def seek(self, _arg_offset, _arg_whence):
       req=IFile_seekRequestMsg()
       req._this=self.handle
       
       req._offset=_arg_offset
       req._whence=_arg_whence
       val=self.mgr.getPort().IFile_seek(req)
       
       return Long(self.mgr,val._returnval)


   def setACL(self, _arg_acl, _arg_mode):
       req=IFile_setACLRequestMsg()
       req._this=self.handle
       
       req._acl=_arg_acl
       req._mode=_arg_mode
       val=self.mgr.getPort().IFile_setACL(req)
       
       return 


   def setSize(self, _arg_size):
       req=IFile_setSizeRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=self.mgr.getPort().IFile_setSize(req)
       
       return 


   def write(self, _arg_data, _arg_timeoutMS):
       req=IFile_writeRequestMsg()
       req._this=self.handle
       
       req._data=self.mgr.encodebase64(_arg_data)
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IFile_write(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def writeAt(self, _arg_offset, _arg_data, _arg_timeoutMS):
       req=IFile_writeAtRequestMsg()
       req._this=self.handle
       
       req._offset=_arg_offset
       req._data=self.mgr.encodebase64(_arg_data)
       req._timeoutMS=_arg_timeoutMS
       val=self.mgr.getPort().IFile_writeAt(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getEventSource(self):
       req=IFile_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)
   def getId(self):
       req=IFile_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getId(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getInitialSize(self):
       req=IFile_getInitialSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getInitialSize(req)
       return Long(self.mgr,val._returnval)
   def getOffset(self):
       req=IFile_getOffsetRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getOffset(req)
       return Long(self.mgr,val._returnval)
   def getStatus(self):
       req=IFile_getStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getStatus(req)
       return FileStatus(self.mgr,val._returnval)
   def getFileName(self):
       req=IFile_getFileNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getFileName(req)
       return String(self.mgr,val._returnval)
   def getCreationMode(self):
       req=IFile_getCreationModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getCreationMode(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getOpenAction(self):
       req=IFile_getOpenActionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getOpenAction(req)
       return FileOpenAction(self.mgr,val._returnval)
   def getAccessMode(self):
       req=IFile_getAccessModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFile_getAccessMode(req)
       return FileAccessMode(self.mgr,val._returnval)


   _Attrs_={         'eventSource':[getEventSource,None],
         'id':[getId,None],
         'initialSize':[getInitialSize,None],
         'offset':[getOffset,None],
         'status':[getStatus,None],
         'fileName':[getFileName,None],
         'creationMode':[getCreationMode,None],
         'openAction':[getOpenAction,None],
         'accessMode':[getAccessMode,None]}

class IGuestFile(IFile):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFile(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFile._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IFile.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFile._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IGuestFile_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFile_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IFsObjInfo(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IFsObjInfo(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IFsObjInfo._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IFsObjInfo._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getAccessTime(self):
       req=IFsObjInfo_getAccessTimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getAccessTime(req)
       return Long(self.mgr,val._returnval)
   def getAllocatedSize(self):
       req=IFsObjInfo_getAllocatedSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getAllocatedSize(req)
       return Long(self.mgr,val._returnval)
   def getBirthTime(self):
       req=IFsObjInfo_getBirthTimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getBirthTime(req)
       return Long(self.mgr,val._returnval)
   def getChangeTime(self):
       req=IFsObjInfo_getChangeTimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getChangeTime(req)
       return Long(self.mgr,val._returnval)
   def getDeviceNumber(self):
       req=IFsObjInfo_getDeviceNumberRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getDeviceNumber(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getFileAttributes(self):
       req=IFsObjInfo_getFileAttributesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getFileAttributes(req)
       return String(self.mgr,val._returnval)
   def getGenerationId(self):
       req=IFsObjInfo_getGenerationIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getGenerationId(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getGID(self):
       req=IFsObjInfo_getGIDRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getGID(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getGroupName(self):
       req=IFsObjInfo_getGroupNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getGroupName(req)
       return String(self.mgr,val._returnval)
   def getHardLinks(self):
       req=IFsObjInfo_getHardLinksRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getHardLinks(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getModificationTime(self):
       req=IFsObjInfo_getModificationTimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getModificationTime(req)
       return Long(self.mgr,val._returnval)
   def getName(self):
       req=IFsObjInfo_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getName(req)
       return String(self.mgr,val._returnval)
   def getNodeId(self):
       req=IFsObjInfo_getNodeIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getNodeId(req)
       return Long(self.mgr,val._returnval)
   def getNodeIdDevice(self):
       req=IFsObjInfo_getNodeIdDeviceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getNodeIdDevice(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getObjectSize(self):
       req=IFsObjInfo_getObjectSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getObjectSize(req)
       return Long(self.mgr,val._returnval)
   def getType(self):
       req=IFsObjInfo_getTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getType(req)
       return FsObjType(self.mgr,val._returnval)
   def getUID(self):
       req=IFsObjInfo_getUIDRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getUID(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getUserFlags(self):
       req=IFsObjInfo_getUserFlagsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getUserFlags(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getUserName(self):
       req=IFsObjInfo_getUserNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFsObjInfo_getUserName(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'accessTime':[getAccessTime,None],
         'allocatedSize':[getAllocatedSize,None],
         'birthTime':[getBirthTime,None],
         'changeTime':[getChangeTime,None],
         'deviceNumber':[getDeviceNumber,None],
         'fileAttributes':[getFileAttributes,None],
         'generationId':[getGenerationId,None],
         'GID':[getGID,None],
         'groupName':[getGroupName,None],
         'hardLinks':[getHardLinks,None],
         'modificationTime':[getModificationTime,None],
         'name':[getName,None],
         'nodeId':[getNodeId,None],
         'nodeIdDevice':[getNodeIdDevice,None],
         'objectSize':[getObjectSize,None],
         'type':[getType,None],
         'UID':[getUID,None],
         'userFlags':[getUserFlags,None],
         'userName':[getUserName,None]}

class IGuestFsObjInfo(IFsObjInfo):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFsObjInfo(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFsObjInfo._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IFsObjInfo.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFsObjInfo._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IGuestFsObjInfo_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFsObjInfo_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IGuest(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuest(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuest._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuest._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def internalGetStatistics(self):
       req=IGuest_internalGetStatisticsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IGuest_internalGetStatistics(req)
       
       return UnsignedInt(self.mgr,val._cpuUser), UnsignedInt(self.mgr,val._cpuKernel), UnsignedInt(self.mgr,val._cpuIdle), UnsignedInt(self.mgr,val._memTotal), UnsignedInt(self.mgr,val._memFree), UnsignedInt(self.mgr,val._memBalloon), UnsignedInt(self.mgr,val._memShared), UnsignedInt(self.mgr,val._memCache), UnsignedInt(self.mgr,val._pagedTotal), UnsignedInt(self.mgr,val._memAllocTotal), UnsignedInt(self.mgr,val._memFreeTotal), UnsignedInt(self.mgr,val._memBalloonTotal), UnsignedInt(self.mgr,val._memSharedTotal)


   def getFacilityStatus(self, _arg_facility):
       req=IGuest_getFacilityStatusRequestMsg()
       req._this=self.handle
       
       req._facility=_arg_facility
       val=self.mgr.getPort().IGuest_getFacilityStatus(req)
       
       return AdditionsFacilityStatus(self.mgr,val._returnval), Long(self.mgr,val._timestamp)


   def getAdditionsStatus(self, _arg_level):
       req=IGuest_getAdditionsStatusRequestMsg()
       req._this=self.handle
       
       req._level=_arg_level
       val=self.mgr.getPort().IGuest_getAdditionsStatus(req)
       
       return Boolean(self.mgr,val._returnval)


   def setCredentials(self, _arg_userName, _arg_password, _arg_domain, _arg_allowInteractiveLogon):
       req=IGuest_setCredentialsRequestMsg()
       req._this=self.handle
       
       req._userName=_arg_userName
       req._password=_arg_password
       req._domain=_arg_domain
       req._allowInteractiveLogon=_arg_allowInteractiveLogon
       val=self.mgr.getPort().IGuest_setCredentials(req)
       
       return 


   def createSession(self, _arg_user, _arg_password, _arg_domain, _arg_sessionName):
       req=IGuest_createSessionRequestMsg()
       req._this=self.handle
       
       req._user=_arg_user
       req._password=_arg_password
       req._domain=_arg_domain
       req._sessionName=_arg_sessionName
       val=self.mgr.getPort().IGuest_createSession(req)
       
       return IGuestSession(self.mgr,val._returnval)


   def findSession(self, _arg_sessionName):
       req=IGuest_findSessionRequestMsg()
       req._this=self.handle
       
       req._sessionName=_arg_sessionName
       val=self.mgr.getPort().IGuest_findSession(req)
       
       return IGuestSession(self.mgr,val._returnval, True)


   def updateGuestAdditions(self, _arg_source, _arg_arguments, _arg_flags):
       req=IGuest_updateGuestAdditionsRequestMsg()
       req._this=self.handle
       
       req._source=_arg_source
       req._arguments=_arg_arguments
       req._flags=_arg_flags
       val=self.mgr.getPort().IGuest_updateGuestAdditions(req)
       
       return IProgress(self.mgr,val._returnval)


   def getOSTypeId(self):
       req=IGuest_getOSTypeIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getOSTypeId(req)
       return String(self.mgr,val._returnval)
   def getAdditionsRunLevel(self):
       req=IGuest_getAdditionsRunLevelRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getAdditionsRunLevel(req)
       return AdditionsRunLevelType(self.mgr,val._returnval)
   def getAdditionsVersion(self):
       req=IGuest_getAdditionsVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getAdditionsVersion(req)
       return String(self.mgr,val._returnval)
   def getAdditionsRevision(self):
       req=IGuest_getAdditionsRevisionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getAdditionsRevision(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getDnDSource(self):
       req=IGuest_getDnDSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getDnDSource(req)
       return IGuestDnDSource(self.mgr,val._returnval)
   def getDnDTarget(self):
       req=IGuest_getDnDTargetRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getDnDTarget(req)
       return IGuestDnDTarget(self.mgr,val._returnval)
   def getEventSource(self):
       req=IGuest_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)
   def getFacilities(self):
       req=IGuest_getFacilitiesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getFacilities(req)
       return IAdditionsFacility(self.mgr,val._returnval, True)
   def getSessions(self):
       req=IGuest_getSessionsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getSessions(req)
       return IGuestSession(self.mgr,val._returnval, True)
   def getMemoryBalloonSize(self):
       req=IGuest_getMemoryBalloonSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getMemoryBalloonSize(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setMemoryBalloonSize(self, value):
       req=IGuest_setMemoryBalloonSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._memoryBalloonSize = value
       else:
            req._memoryBalloonSize = value.handle
       self.mgr.getPort().IGuest_setMemoryBalloonSize(req)

   def getStatisticsUpdateInterval(self):
       req=IGuest_getStatisticsUpdateIntervalRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuest_getStatisticsUpdateInterval(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setStatisticsUpdateInterval(self, value):
       req=IGuest_setStatisticsUpdateIntervalRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._statisticsUpdateInterval = value
       else:
            req._statisticsUpdateInterval = value.handle
       self.mgr.getPort().IGuest_setStatisticsUpdateInterval(req)



   _Attrs_={         'OSTypeId':[getOSTypeId,None],
         'additionsRunLevel':[getAdditionsRunLevel,None],
         'additionsVersion':[getAdditionsVersion,None],
         'additionsRevision':[getAdditionsRevision,None],
         'dnDSource':[getDnDSource,None],
         'dnDTarget':[getDnDTarget,None],
         'eventSource':[getEventSource,None],
         'facilities':[getFacilities,None],
         'sessions':[getSessions,None],
         'memoryBalloonSize':[getMemoryBalloonSize,setMemoryBalloonSize,
        ],
         'statisticsUpdateInterval':[getStatisticsUpdateInterval,setStatisticsUpdateInterval,
        ]}

class IProgress(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IProgress(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IProgress._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IProgress._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def setCurrentOperationProgress(self, _arg_percent):
       req=IProgress_setCurrentOperationProgressRequestMsg()
       req._this=self.handle
       
       req._percent=_arg_percent
       val=self.mgr.getPort().IProgress_setCurrentOperationProgress(req)
       
       return 


   def setNextOperation(self, _arg_nextOperationDescription, _arg_nextOperationsWeight):
       req=IProgress_setNextOperationRequestMsg()
       req._this=self.handle
       
       req._nextOperationDescription=_arg_nextOperationDescription
       req._nextOperationsWeight=_arg_nextOperationsWeight
       val=self.mgr.getPort().IProgress_setNextOperation(req)
       
       return 


   def waitForCompletion(self, _arg_timeout):
       req=IProgress_waitForCompletionRequestMsg()
       req._this=self.handle
       
       req._timeout=_arg_timeout
       val=self.mgr.getPort().IProgress_waitForCompletion(req)
       
       return 


   def waitForOperationCompletion(self, _arg_operation, _arg_timeout):
       req=IProgress_waitForOperationCompletionRequestMsg()
       req._this=self.handle
       
       req._operation=_arg_operation
       req._timeout=_arg_timeout
       val=self.mgr.getPort().IProgress_waitForOperationCompletion(req)
       
       return 


   def waitForAsyncProgressCompletion(self, _arg_pProgressAsync):
       req=IProgress_waitForAsyncProgressCompletionRequestMsg()
       req._this=self.handle
       
       req._pProgressAsync=_arg_pProgressAsync
       val=self.mgr.getPort().IProgress_waitForAsyncProgressCompletion(req)
       
       return 


   def cancel(self):
       req=IProgress_cancelRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IProgress_cancel(req)
       
       return 


   def getId(self):
       req=IProgress_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getId(req)
       return String(self.mgr,val._returnval)
   def getDescription(self):
       req=IProgress_getDescriptionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getDescription(req)
       return String(self.mgr,val._returnval)
   def getInitiator(self):
       req=IProgress_getInitiatorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getInitiator(req)
       return IUnknown(self.mgr,val._returnval)
   def getCancelable(self):
       req=IProgress_getCancelableRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getCancelable(req)
       return Boolean(self.mgr,val._returnval)
   def getPercent(self):
       req=IProgress_getPercentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getPercent(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getTimeRemaining(self):
       req=IProgress_getTimeRemainingRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getTimeRemaining(req)
       return Int(self.mgr,val._returnval)
   def getCompleted(self):
       req=IProgress_getCompletedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getCompleted(req)
       return Boolean(self.mgr,val._returnval)
   def getCanceled(self):
       req=IProgress_getCanceledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getCanceled(req)
       return Boolean(self.mgr,val._returnval)
   def getResultCode(self):
       req=IProgress_getResultCodeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getResultCode(req)
       return Int(self.mgr,val._returnval)
   def getErrorInfo(self):
       req=IProgress_getErrorInfoRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getErrorInfo(req)
       return IVirtualBoxErrorInfo(self.mgr,val._returnval)
   def getOperationCount(self):
       req=IProgress_getOperationCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getOperationCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getOperation(self):
       req=IProgress_getOperationRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getOperation(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getOperationDescription(self):
       req=IProgress_getOperationDescriptionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getOperationDescription(req)
       return String(self.mgr,val._returnval)
   def getOperationPercent(self):
       req=IProgress_getOperationPercentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getOperationPercent(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getOperationWeight(self):
       req=IProgress_getOperationWeightRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getOperationWeight(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getTimeout(self):
       req=IProgress_getTimeoutRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IProgress_getTimeout(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setTimeout(self, value):
       req=IProgress_setTimeoutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._timeout = value
       else:
            req._timeout = value.handle
       self.mgr.getPort().IProgress_setTimeout(req)



   _Attrs_={         'id':[getId,None],
         'description':[getDescription,None],
         'initiator':[getInitiator,None],
         'cancelable':[getCancelable,None],
         'percent':[getPercent,None],
         'timeRemaining':[getTimeRemaining,None],
         'completed':[getCompleted,None],
         'canceled':[getCanceled,None],
         'resultCode':[getResultCode,None],
         'errorInfo':[getErrorInfo,None],
         'operationCount':[getOperationCount,None],
         'operation':[getOperation,None],
         'operationDescription':[getOperationDescription,None],
         'operationPercent':[getOperationPercent,None],
         'operationWeight':[getOperationWeight,None],
         'timeout':[getTimeout,setTimeout,
        ]}

class ISnapshot(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISnapshot(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISnapshot._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISnapshot._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getChildrenCount(self):
       req=ISnapshot_getChildrenCountRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().ISnapshot_getChildrenCount(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def getId(self):
       req=ISnapshot_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshot_getId(req)
       return String(self.mgr,val._returnval)
   def getName(self):
       req=ISnapshot_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshot_getName(req)
       return String(self.mgr,val._returnval)
   def setName(self, value):
       req=ISnapshot_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._name = value
       else:
            req._name = value.handle
       self.mgr.getPort().ISnapshot_setName(req)

   def getDescription(self):
       req=ISnapshot_getDescriptionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshot_getDescription(req)
       return String(self.mgr,val._returnval)
   def setDescription(self, value):
       req=ISnapshot_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._description = value
       else:
            req._description = value.handle
       self.mgr.getPort().ISnapshot_setDescription(req)

   def getTimeStamp(self):
       req=ISnapshot_getTimeStampRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshot_getTimeStamp(req)
       return Long(self.mgr,val._returnval)
   def getOnline(self):
       req=ISnapshot_getOnlineRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshot_getOnline(req)
       return Boolean(self.mgr,val._returnval)
   def getMachine(self):
       req=ISnapshot_getMachineRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshot_getMachine(req)
       return IMachine(self.mgr,val._returnval)
   def getParent(self):
       req=ISnapshot_getParentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshot_getParent(req)
       return ISnapshot(self.mgr,val._returnval)
   def getChildren(self):
       req=ISnapshot_getChildrenRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshot_getChildren(req)
       return ISnapshot(self.mgr,val._returnval, True)


   _Attrs_={         'id':[getId,None],
         'name':[getName,setName,
        ],
         'description':[getDescription,setDescription,
        ],
         'timeStamp':[getTimeStamp,None],
         'online':[getOnline,None],
         'machine':[getMachine,None],
         'parent':[getParent,None],
         'children':[getChildren,None]}

class IMedium(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMedium(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMedium._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMedium._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def setIds(self, _arg_setImageId, _arg_imageId, _arg_setParentId, _arg_parentId):
       req=IMedium_setIdsRequestMsg()
       req._this=self.handle
       
       req._setImageId=_arg_setImageId
       req._imageId=_arg_imageId
       req._setParentId=_arg_setParentId
       req._parentId=_arg_parentId
       val=self.mgr.getPort().IMedium_setIds(req)
       
       return 


   def refreshState(self):
       req=IMedium_refreshStateRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMedium_refreshState(req)
       
       return MediumState(self.mgr,val._returnval)


   def getSnapshotIds(self, _arg_machineId):
       req=IMedium_getSnapshotIdsRequestMsg()
       req._this=self.handle
       
       req._machineId=_arg_machineId
       val=self.mgr.getPort().IMedium_getSnapshotIds(req)
       
       return String(self.mgr,val._returnval, True)


   def lockRead(self):
       req=IMedium_lockReadRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMedium_lockRead(req)
       
       return IToken(self.mgr,val._returnval)


   def lockWrite(self):
       req=IMedium_lockWriteRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMedium_lockWrite(req)
       
       return IToken(self.mgr,val._returnval)


   def close(self):
       req=IMedium_closeRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMedium_close(req)
       
       return 


   def getProperty(self, _arg_name):
       req=IMedium_getPropertyRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMedium_getProperty(req)
       
       return String(self.mgr,val._returnval)


   def setProperty(self, _arg_name, _arg_value):
       req=IMedium_setPropertyRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._value=_arg_value
       val=self.mgr.getPort().IMedium_setProperty(req)
       
       return 


   def getProperties(self, _arg_names):
       req=IMedium_getPropertiesRequestMsg()
       req._this=self.handle
       
       req._names=_arg_names
       val=self.mgr.getPort().IMedium_getProperties(req)
       
       return String(self.mgr,val._returnval, True), String(self.mgr,val._returnNames, True)


   def setProperties(self, _arg_names, _arg_values):
       req=IMedium_setPropertiesRequestMsg()
       req._this=self.handle
       
       req._names=_arg_names
       req._values=_arg_values
       val=self.mgr.getPort().IMedium_setProperties(req)
       
       return 


   def createBaseStorage(self, _arg_logicalSize, _arg_variant):
       req=IMedium_createBaseStorageRequestMsg()
       req._this=self.handle
       
       req._logicalSize=_arg_logicalSize
       req._variant=_arg_variant
       val=self.mgr.getPort().IMedium_createBaseStorage(req)
       
       return IProgress(self.mgr,val._returnval)


   def deleteStorage(self):
       req=IMedium_deleteStorageRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMedium_deleteStorage(req)
       
       return IProgress(self.mgr,val._returnval)


   def createDiffStorage(self, _arg_target, _arg_variant):
       req=IMedium_createDiffStorageRequestMsg()
       req._this=self.handle
       
       req._target=_arg_target
       req._variant=_arg_variant
       val=self.mgr.getPort().IMedium_createDiffStorage(req)
       
       return IProgress(self.mgr,val._returnval)


   def mergeTo(self, _arg_target):
       req=IMedium_mergeToRequestMsg()
       req._this=self.handle
       
       req._target=_arg_target
       val=self.mgr.getPort().IMedium_mergeTo(req)
       
       return IProgress(self.mgr,val._returnval)


   def cloneTo(self, _arg_target, _arg_variant, _arg_parent):
       req=IMedium_cloneToRequestMsg()
       req._this=self.handle
       
       req._target=_arg_target
       req._variant=_arg_variant
       req._parent=_arg_parent
       val=self.mgr.getPort().IMedium_cloneTo(req)
       
       return IProgress(self.mgr,val._returnval)


   def cloneToBase(self, _arg_target, _arg_variant):
       req=IMedium_cloneToBaseRequestMsg()
       req._this=self.handle
       
       req._target=_arg_target
       req._variant=_arg_variant
       val=self.mgr.getPort().IMedium_cloneToBase(req)
       
       return IProgress(self.mgr,val._returnval)


   def setLocation(self, _arg_location):
       req=IMedium_setLocationRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       val=self.mgr.getPort().IMedium_setLocation(req)
       
       return IProgress(self.mgr,val._returnval)


   def compact(self):
       req=IMedium_compactRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMedium_compact(req)
       
       return IProgress(self.mgr,val._returnval)


   def resize(self, _arg_logicalSize):
       req=IMedium_resizeRequestMsg()
       req._this=self.handle
       
       req._logicalSize=_arg_logicalSize
       val=self.mgr.getPort().IMedium_resize(req)
       
       return IProgress(self.mgr,val._returnval)


   def reset(self):
       req=IMedium_resetRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMedium_reset(req)
       
       return IProgress(self.mgr,val._returnval)


   def changeEncryption(self, _arg_currentPassword, _arg_cipher, _arg_newPassword, _arg_newPasswordId):
       req=IMedium_changeEncryptionRequestMsg()
       req._this=self.handle
       
       req._currentPassword=_arg_currentPassword
       req._cipher=_arg_cipher
       req._newPassword=_arg_newPassword
       req._newPasswordId=_arg_newPasswordId
       val=self.mgr.getPort().IMedium_changeEncryption(req)
       
       return IProgress(self.mgr,val._returnval)


   def getEncryptionSettings(self):
       req=IMedium_getEncryptionSettingsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMedium_getEncryptionSettings(req)
       
       return String(self.mgr,val._returnval), String(self.mgr,val._cipher)


   def checkEncryptionPassword(self, _arg_password):
       req=IMedium_checkEncryptionPasswordRequestMsg()
       req._this=self.handle
       
       req._password=_arg_password
       val=self.mgr.getPort().IMedium_checkEncryptionPassword(req)
       
       return 


   def getId(self):
       req=IMedium_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getId(req)
       return String(self.mgr,val._returnval)
   def getDescription(self):
       req=IMedium_getDescriptionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getDescription(req)
       return String(self.mgr,val._returnval)
   def setDescription(self, value):
       req=IMedium_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._description = value
       else:
            req._description = value.handle
       self.mgr.getPort().IMedium_setDescription(req)

   def getState(self):
       req=IMedium_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getState(req)
       return MediumState(self.mgr,val._returnval)
   def getVariant(self):
       req=IMedium_getVariantRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getVariant(req)
       return MediumVariant(self.mgr,val._returnval, True)
   def getLocation(self):
       req=IMedium_getLocationRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getLocation(req)
       return String(self.mgr,val._returnval)
   def getName(self):
       req=IMedium_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getName(req)
       return String(self.mgr,val._returnval)
   def getDeviceType(self):
       req=IMedium_getDeviceTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getDeviceType(req)
       return DeviceType(self.mgr,val._returnval)
   def getHostDrive(self):
       req=IMedium_getHostDriveRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getHostDrive(req)
       return Boolean(self.mgr,val._returnval)
   def getSize(self):
       req=IMedium_getSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getSize(req)
       return Long(self.mgr,val._returnval)
   def getFormat(self):
       req=IMedium_getFormatRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getFormat(req)
       return String(self.mgr,val._returnval)
   def getMediumFormat(self):
       req=IMedium_getMediumFormatRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getMediumFormat(req)
       return IMediumFormat(self.mgr,val._returnval)
   def getType(self):
       req=IMedium_getTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getType(req)
       return MediumType(self.mgr,val._returnval)
   def setType(self, value):
       req=IMedium_setTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._type = value
       else:
            req._type = value.handle
       self.mgr.getPort().IMedium_setType(req)

   def getAllowedTypes(self):
       req=IMedium_getAllowedTypesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getAllowedTypes(req)
       return MediumType(self.mgr,val._returnval, True)
   def getParent(self):
       req=IMedium_getParentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getParent(req)
       return IMedium(self.mgr,val._returnval)
   def getChildren(self):
       req=IMedium_getChildrenRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getChildren(req)
       return IMedium(self.mgr,val._returnval, True)
   def getBase(self):
       req=IMedium_getBaseRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getBase(req)
       return IMedium(self.mgr,val._returnval)
   def getReadOnly(self):
       req=IMedium_getReadOnlyRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getReadOnly(req)
       return Boolean(self.mgr,val._returnval)
   def getLogicalSize(self):
       req=IMedium_getLogicalSizeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getLogicalSize(req)
       return Long(self.mgr,val._returnval)
   def getAutoReset(self):
       req=IMedium_getAutoResetRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getAutoReset(req)
       return Boolean(self.mgr,val._returnval)
   def setAutoReset(self, value):
       req=IMedium_setAutoResetRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._autoReset = value
       else:
            req._autoReset = value.handle
       self.mgr.getPort().IMedium_setAutoReset(req)

   def getLastAccessError(self):
       req=IMedium_getLastAccessErrorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getLastAccessError(req)
       return String(self.mgr,val._returnval)
   def getMachineIds(self):
       req=IMedium_getMachineIdsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMedium_getMachineIds(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'id':[getId,None],
         'description':[getDescription,setDescription,
        ],
         'state':[getState,None],
         'variant':[getVariant,None],
         'location':[getLocation,None],
         'name':[getName,None],
         'deviceType':[getDeviceType,None],
         'hostDrive':[getHostDrive,None],
         'size':[getSize,None],
         'format':[getFormat,None],
         'mediumFormat':[getMediumFormat,None],
         'type':[getType,setType,
        ],
         'allowedTypes':[getAllowedTypes,None],
         'parent':[getParent,None],
         'children':[getChildren,None],
         'base':[getBase,None],
         'readOnly':[getReadOnly,None],
         'logicalSize':[getLogicalSize,None],
         'autoReset':[getAutoReset,setAutoReset,
        ],
         'lastAccessError':[getLastAccessError,None],
         'machineIds':[getMachineIds,None]}

class IMediumFormat(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMediumFormat(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMediumFormat._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMediumFormat._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def describeFileExtensions(self):
       req=IMediumFormat_describeFileExtensionsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMediumFormat_describeFileExtensions(req)
       
       return String(self.mgr,val._extensions, True), DeviceType(self.mgr,val._types, True)


   def describeProperties(self):
       req=IMediumFormat_describePropertiesRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMediumFormat_describeProperties(req)
       
       return String(self.mgr,val._names, True), String(self.mgr,val._descriptions, True), DataType(self.mgr,val._types, True), UnsignedInt(self.mgr,val._flags, True), String(self.mgr,val._defaults, True)


   def getId(self):
       req=IMediumFormat_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMediumFormat_getId(req)
       return String(self.mgr,val._returnval)
   def getName(self):
       req=IMediumFormat_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMediumFormat_getName(req)
       return String(self.mgr,val._returnval)
   def getCapabilities(self):
       req=IMediumFormat_getCapabilitiesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMediumFormat_getCapabilities(req)
       return MediumFormatCapabilities(self.mgr,val._returnval, True)


   _Attrs_={         'id':[getId,None],
         'name':[getName,None],
         'capabilities':[getCapabilities,None]}

class IToken(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IToken(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IToken._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IToken._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def abandon(self):
       req=IToken_abandonRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IToken_abandon(req)
       
       return 


   def dummy(self):
       req=IToken_dummyRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IToken_dummy(req)
       
       return 




   _Attrs_={}

class IKeyboard(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IKeyboard(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IKeyboard._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IKeyboard._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def putScancode(self, _arg_scancode):
       req=IKeyboard_putScancodeRequestMsg()
       req._this=self.handle
       
       req._scancode=_arg_scancode
       val=self.mgr.getPort().IKeyboard_putScancode(req)
       
       return 


   def putScancodes(self, _arg_scancodes):
       req=IKeyboard_putScancodesRequestMsg()
       req._this=self.handle
       
       req._scancodes=_arg_scancodes
       val=self.mgr.getPort().IKeyboard_putScancodes(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def putCAD(self):
       req=IKeyboard_putCADRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IKeyboard_putCAD(req)
       
       return 


   def releaseKeys(self):
       req=IKeyboard_releaseKeysRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IKeyboard_releaseKeys(req)
       
       return 


   def getKeyboardLEDs(self):
       req=IKeyboard_getKeyboardLEDsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IKeyboard_getKeyboardLEDs(req)
       return KeyboardLED(self.mgr,val._returnval, True)
   def getEventSource(self):
       req=IKeyboard_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IKeyboard_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)


   _Attrs_={         'keyboardLEDs':[getKeyboardLEDs,None],
         'eventSource':[getEventSource,None]}

class IMousePointerShape(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMousePointerShape(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMousePointerShape._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMousePointerShape._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getVisible(self):
       req=IMousePointerShape_getVisibleRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShape_getVisible(req)
       return Boolean(self.mgr,val._returnval)
   def getAlpha(self):
       req=IMousePointerShape_getAlphaRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShape_getAlpha(req)
       return Boolean(self.mgr,val._returnval)
   def getHotX(self):
       req=IMousePointerShape_getHotXRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShape_getHotX(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getHotY(self):
       req=IMousePointerShape_getHotYRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShape_getHotY(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getWidth(self):
       req=IMousePointerShape_getWidthRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShape_getWidth(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getHeight(self):
       req=IMousePointerShape_getHeightRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShape_getHeight(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getShape(self):
       req=IMousePointerShape_getShapeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShape_getShape(req)
       return self.mgr.decodebase64(val._returnval)


   _Attrs_={         'visible':[getVisible,None],
         'alpha':[getAlpha,None],
         'hotX':[getHotX,None],
         'hotY':[getHotY,None],
         'width':[getWidth,None],
         'height':[getHeight,None],
         'shape':[getShape,None]}

class IMouse(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMouse(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMouse._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMouse._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def putMouseEvent(self, _arg_dx, _arg_dy, _arg_dz, _arg_dw, _arg_buttonState):
       req=IMouse_putMouseEventRequestMsg()
       req._this=self.handle
       
       req._dx=_arg_dx
       req._dy=_arg_dy
       req._dz=_arg_dz
       req._dw=_arg_dw
       req._buttonState=_arg_buttonState
       val=self.mgr.getPort().IMouse_putMouseEvent(req)
       
       return 


   def putMouseEventAbsolute(self, _arg_x, _arg_y, _arg_dz, _arg_dw, _arg_buttonState):
       req=IMouse_putMouseEventAbsoluteRequestMsg()
       req._this=self.handle
       
       req._x=_arg_x
       req._y=_arg_y
       req._dz=_arg_dz
       req._dw=_arg_dw
       req._buttonState=_arg_buttonState
       val=self.mgr.getPort().IMouse_putMouseEventAbsolute(req)
       
       return 


   def putEventMultiTouch(self, _arg_count, _arg_contacts, _arg_scanTime):
       req=IMouse_putEventMultiTouchRequestMsg()
       req._this=self.handle
       
       req._count=_arg_count
       req._contacts=_arg_contacts
       req._scanTime=_arg_scanTime
       val=self.mgr.getPort().IMouse_putEventMultiTouch(req)
       
       return 


   def putEventMultiTouchString(self, _arg_count, _arg_contacts, _arg_scanTime):
       req=IMouse_putEventMultiTouchStringRequestMsg()
       req._this=self.handle
       
       req._count=_arg_count
       req._contacts=_arg_contacts
       req._scanTime=_arg_scanTime
       val=self.mgr.getPort().IMouse_putEventMultiTouchString(req)
       
       return 


   def getAbsoluteSupported(self):
       req=IMouse_getAbsoluteSupportedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouse_getAbsoluteSupported(req)
       return Boolean(self.mgr,val._returnval)
   def getRelativeSupported(self):
       req=IMouse_getRelativeSupportedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouse_getRelativeSupported(req)
       return Boolean(self.mgr,val._returnval)
   def getMultiTouchSupported(self):
       req=IMouse_getMultiTouchSupportedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouse_getMultiTouchSupported(req)
       return Boolean(self.mgr,val._returnval)
   def getNeedsHostCursor(self):
       req=IMouse_getNeedsHostCursorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouse_getNeedsHostCursor(req)
       return Boolean(self.mgr,val._returnval)
   def getPointerShape(self):
       req=IMouse_getPointerShapeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouse_getPointerShape(req)
       return IMousePointerShape(self.mgr,val._returnval)
   def getEventSource(self):
       req=IMouse_getEventSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouse_getEventSource(req)
       return IEventSource(self.mgr,val._returnval)


   _Attrs_={         'absoluteSupported':[getAbsoluteSupported,None],
         'relativeSupported':[getRelativeSupported,None],
         'multiTouchSupported':[getMultiTouchSupported,None],
         'needsHostCursor':[getNeedsHostCursor,None],
         'pointerShape':[getPointerShape,None],
         'eventSource':[getEventSource,None]}

class IFramebuffer(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IFramebuffer(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IFramebuffer._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IFramebuffer._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def notifyUpdate(self, _arg_x, _arg_y, _arg_width, _arg_height):
       req=IFramebuffer_notifyUpdateRequestMsg()
       req._this=self.handle
       
       req._x=_arg_x
       req._y=_arg_y
       req._width=_arg_width
       req._height=_arg_height
       val=self.mgr.getPort().IFramebuffer_notifyUpdate(req)
       
       return 


   def notifyUpdateImage(self, _arg_x, _arg_y, _arg_width, _arg_height, _arg_image):
       req=IFramebuffer_notifyUpdateImageRequestMsg()
       req._this=self.handle
       
       req._x=_arg_x
       req._y=_arg_y
       req._width=_arg_width
       req._height=_arg_height
       req._image=self.mgr.encodebase64(_arg_image)
       val=self.mgr.getPort().IFramebuffer_notifyUpdateImage(req)
       
       return 


   def notifyChange(self, _arg_screenId, _arg_xOrigin, _arg_yOrigin, _arg_width, _arg_height):
       req=IFramebuffer_notifyChangeRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._xOrigin=_arg_xOrigin
       req._yOrigin=_arg_yOrigin
       req._width=_arg_width
       req._height=_arg_height
       val=self.mgr.getPort().IFramebuffer_notifyChange(req)
       
       return 


   def videoModeSupported(self, _arg_width, _arg_height, _arg_bpp):
       req=IFramebuffer_videoModeSupportedRequestMsg()
       req._this=self.handle
       
       req._width=_arg_width
       req._height=_arg_height
       req._bpp=_arg_bpp
       val=self.mgr.getPort().IFramebuffer_videoModeSupported(req)
       
       return Boolean(self.mgr,val._returnval)


   def getVisibleRegion(self, _arg_rectangles, _arg_count):
       req=IFramebuffer_getVisibleRegionRequestMsg()
       req._this=self.handle
       
       req._rectangles=_arg_rectangles
       req._count=_arg_count
       val=self.mgr.getPort().IFramebuffer_getVisibleRegion(req)
       
       return UnsignedInt(self.mgr,val._returnval)


   def setVisibleRegion(self, _arg_rectangles, _arg_count):
       req=IFramebuffer_setVisibleRegionRequestMsg()
       req._this=self.handle
       
       req._rectangles=_arg_rectangles
       req._count=_arg_count
       val=self.mgr.getPort().IFramebuffer_setVisibleRegion(req)
       
       return 


   def processVHWACommand(self, _arg_command):
       req=IFramebuffer_processVHWACommandRequestMsg()
       req._this=self.handle
       
       req._command=_arg_command
       val=self.mgr.getPort().IFramebuffer_processVHWACommand(req)
       
       return 


   def notify3DEvent(self, _arg_type, _arg_data):
       req=IFramebuffer_notify3DEventRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       req._data=self.mgr.encodebase64(_arg_data)
       val=self.mgr.getPort().IFramebuffer_notify3DEvent(req)
       
       return 


   def getWidth(self):
       req=IFramebuffer_getWidthRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getWidth(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getHeight(self):
       req=IFramebuffer_getHeightRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getHeight(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getBitsPerPixel(self):
       req=IFramebuffer_getBitsPerPixelRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getBitsPerPixel(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getBytesPerLine(self):
       req=IFramebuffer_getBytesPerLineRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getBytesPerLine(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getPixelFormat(self):
       req=IFramebuffer_getPixelFormatRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getPixelFormat(req)
       return BitmapFormat(self.mgr,val._returnval)
   def getHeightReduction(self):
       req=IFramebuffer_getHeightReductionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getHeightReduction(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getOverlay(self):
       req=IFramebuffer_getOverlayRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getOverlay(req)
       return IFramebufferOverlay(self.mgr,val._returnval)
   def getWinId(self):
       req=IFramebuffer_getWinIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getWinId(req)
       return Long(self.mgr,val._returnval)
   def getCapabilities(self):
       req=IFramebuffer_getCapabilitiesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebuffer_getCapabilities(req)
       return FramebufferCapabilities(self.mgr,val._returnval, True)


   _Attrs_={         'width':[getWidth,None],
         'height':[getHeight,None],
         'bitsPerPixel':[getBitsPerPixel,None],
         'bytesPerLine':[getBytesPerLine,None],
         'pixelFormat':[getPixelFormat,None],
         'heightReduction':[getHeightReduction,None],
         'overlay':[getOverlay,None],
         'winId':[getWinId,None],
         'capabilities':[getCapabilities,None]}

class IFramebufferOverlay(IFramebuffer):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IFramebufferOverlay(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IFramebufferOverlay._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IFramebuffer.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IFramebufferOverlay._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def move(self, _arg_x, _arg_y):
       req=IFramebufferOverlay_moveRequestMsg()
       req._this=self.handle
       
       req._x=_arg_x
       req._y=_arg_y
       val=self.mgr.getPort().IFramebufferOverlay_move(req)
       
       return 


   def getX(self):
       req=IFramebufferOverlay_getXRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebufferOverlay_getX(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getY(self):
       req=IFramebufferOverlay_getYRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebufferOverlay_getY(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getVisible(self):
       req=IFramebufferOverlay_getVisibleRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebufferOverlay_getVisible(req)
       return Boolean(self.mgr,val._returnval)
   def setVisible(self, value):
       req=IFramebufferOverlay_setVisibleRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._visible = value
       else:
            req._visible = value.handle
       self.mgr.getPort().IFramebufferOverlay_setVisible(req)

   def getAlpha(self):
       req=IFramebufferOverlay_getAlphaRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IFramebufferOverlay_getAlpha(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setAlpha(self, value):
       req=IFramebufferOverlay_setAlphaRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._alpha = value
       else:
            req._alpha = value.handle
       self.mgr.getPort().IFramebufferOverlay_setAlpha(req)



   _Attrs_={         'x':[getX,None],
         'y':[getY,None],
         'visible':[getVisible,setVisible,
        ],
         'alpha':[getAlpha,setAlpha,
        ]}

class IGuestScreenInfo(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestScreenInfo(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestScreenInfo._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestScreenInfo._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getScreenId(self):
       req=IGuestScreenInfo_getScreenIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getScreenId(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getGuestMonitorStatus(self):
       req=IGuestScreenInfo_getGuestMonitorStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getGuestMonitorStatus(req)
       return GuestMonitorStatus(self.mgr,val._returnval)
   def getPrimary(self):
       req=IGuestScreenInfo_getPrimaryRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getPrimary(req)
       return Boolean(self.mgr,val._returnval)
   def getOrigin(self):
       req=IGuestScreenInfo_getOriginRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getOrigin(req)
       return Boolean(self.mgr,val._returnval)
   def getOriginX(self):
       req=IGuestScreenInfo_getOriginXRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getOriginX(req)
       return Int(self.mgr,val._returnval)
   def getOriginY(self):
       req=IGuestScreenInfo_getOriginYRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getOriginY(req)
       return Int(self.mgr,val._returnval)
   def getWidth(self):
       req=IGuestScreenInfo_getWidthRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getWidth(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getHeight(self):
       req=IGuestScreenInfo_getHeightRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getHeight(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getBitsPerPixel(self):
       req=IGuestScreenInfo_getBitsPerPixelRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestScreenInfo_getBitsPerPixel(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'screenId':[getScreenId,None],
         'guestMonitorStatus':[getGuestMonitorStatus,None],
         'primary':[getPrimary,None],
         'origin':[getOrigin,None],
         'originX':[getOriginX,None],
         'originY':[getOriginY,None],
         'width':[getWidth,None],
         'height':[getHeight,None],
         'bitsPerPixel':[getBitsPerPixel,None]}

class IDisplay(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IDisplay(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDisplay._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IDisplay._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getScreenResolution(self, _arg_screenId):
       req=IDisplay_getScreenResolutionRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       val=self.mgr.getPort().IDisplay_getScreenResolution(req)
       
       return UnsignedInt(self.mgr,val._width), UnsignedInt(self.mgr,val._height), UnsignedInt(self.mgr,val._bitsPerPixel), Int(self.mgr,val._xOrigin), Int(self.mgr,val._yOrigin), GuestMonitorStatus(self.mgr,val._guestMonitorStatus)


   def attachFramebuffer(self, _arg_screenId, _arg_framebuffer):
       req=IDisplay_attachFramebufferRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._framebuffer=_arg_framebuffer
       val=self.mgr.getPort().IDisplay_attachFramebuffer(req)
       
       return String(self.mgr,val._returnval)


   def detachFramebuffer(self, _arg_screenId, _arg_id):
       req=IDisplay_detachFramebufferRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._id=_arg_id
       val=self.mgr.getPort().IDisplay_detachFramebuffer(req)
       
       return 


   def queryFramebuffer(self, _arg_screenId):
       req=IDisplay_queryFramebufferRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       val=self.mgr.getPort().IDisplay_queryFramebuffer(req)
       
       return IFramebuffer(self.mgr,val._returnval)


   def setVideoModeHint(self, _arg_display, _arg_enabled, _arg_changeOrigin, _arg_originX, _arg_originY, _arg_width, _arg_height, _arg_bitsPerPixel):
       req=IDisplay_setVideoModeHintRequestMsg()
       req._this=self.handle
       
       req._display=_arg_display
       req._enabled=_arg_enabled
       req._changeOrigin=_arg_changeOrigin
       req._originX=_arg_originX
       req._originY=_arg_originY
       req._width=_arg_width
       req._height=_arg_height
       req._bitsPerPixel=_arg_bitsPerPixel
       val=self.mgr.getPort().IDisplay_setVideoModeHint(req)
       
       return 


   def setSeamlessMode(self, _arg_enabled):
       req=IDisplay_setSeamlessModeRequestMsg()
       req._this=self.handle
       
       req._enabled=_arg_enabled
       val=self.mgr.getPort().IDisplay_setSeamlessMode(req)
       
       return 


   def takeScreenShot(self, _arg_screenId, _arg_address, _arg_width, _arg_height, _arg_bitmapFormat):
       req=IDisplay_takeScreenShotRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._address=_arg_address
       req._width=_arg_width
       req._height=_arg_height
       req._bitmapFormat=_arg_bitmapFormat
       val=self.mgr.getPort().IDisplay_takeScreenShot(req)
       
       return 


   def takeScreenShotToArray(self, _arg_screenId, _arg_width, _arg_height, _arg_bitmapFormat):
       req=IDisplay_takeScreenShotToArrayRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._width=_arg_width
       req._height=_arg_height
       req._bitmapFormat=_arg_bitmapFormat
       val=self.mgr.getPort().IDisplay_takeScreenShotToArray(req)
       
       return self.mgr.decodebase64(val._returnval)


   def drawToScreen(self, _arg_screenId, _arg_address, _arg_x, _arg_y, _arg_width, _arg_height):
       req=IDisplay_drawToScreenRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._address=_arg_address
       req._x=_arg_x
       req._y=_arg_y
       req._width=_arg_width
       req._height=_arg_height
       val=self.mgr.getPort().IDisplay_drawToScreen(req)
       
       return 


   def invalidateAndUpdate(self):
       req=IDisplay_invalidateAndUpdateRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IDisplay_invalidateAndUpdate(req)
       
       return 


   def invalidateAndUpdateScreen(self, _arg_screenId):
       req=IDisplay_invalidateAndUpdateScreenRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       val=self.mgr.getPort().IDisplay_invalidateAndUpdateScreen(req)
       
       return 


   def completeVHWACommand(self, _arg_command):
       req=IDisplay_completeVHWACommandRequestMsg()
       req._this=self.handle
       
       req._command=_arg_command
       val=self.mgr.getPort().IDisplay_completeVHWACommand(req)
       
       return 


   def viewportChanged(self, _arg_screenId, _arg_x, _arg_y, _arg_width, _arg_height):
       req=IDisplay_viewportChangedRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._x=_arg_x
       req._y=_arg_y
       req._width=_arg_width
       req._height=_arg_height
       val=self.mgr.getPort().IDisplay_viewportChanged(req)
       
       return 


   def querySourceBitmap(self, _arg_screenId):
       req=IDisplay_querySourceBitmapRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       val=self.mgr.getPort().IDisplay_querySourceBitmap(req)
       
       return IDisplaySourceBitmap(self.mgr,val._displaySourceBitmap)


   def notifyScaleFactorChange(self, _arg_screenId, _arg_u32ScaleFactorWMultiplied, _arg_u32ScaleFactorHMultiplied):
       req=IDisplay_notifyScaleFactorChangeRequestMsg()
       req._this=self.handle
       
       req._screenId=_arg_screenId
       req._u32ScaleFactorWMultiplied=_arg_u32ScaleFactorWMultiplied
       req._u32ScaleFactorHMultiplied=_arg_u32ScaleFactorHMultiplied
       val=self.mgr.getPort().IDisplay_notifyScaleFactorChange(req)
       
       return 


   def notifyHiDPIOutputPolicyChange(self, _arg_fUnscaledHiDPI):
       req=IDisplay_notifyHiDPIOutputPolicyChangeRequestMsg()
       req._this=self.handle
       
       req._fUnscaledHiDPI=_arg_fUnscaledHiDPI
       val=self.mgr.getPort().IDisplay_notifyHiDPIOutputPolicyChange(req)
       
       return 


   def setScreenLayout(self, _arg_screenLayoutMode, _arg_guestScreenInfo):
       req=IDisplay_setScreenLayoutRequestMsg()
       req._this=self.handle
       
       req._screenLayoutMode=_arg_screenLayoutMode
       req._guestScreenInfo=_arg_guestScreenInfo
       val=self.mgr.getPort().IDisplay_setScreenLayout(req)
       
       return 


   def getGuestScreenLayout(self):
       req=IDisplay_getGuestScreenLayoutRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDisplay_getGuestScreenLayout(req)
       return IGuestScreenInfo(self.mgr,val._returnval, True)


   _Attrs_={         'guestScreenLayout':[getGuestScreenLayout,None]}

class INetworkAdapter(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INetworkAdapter(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INetworkAdapter._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INetworkAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getProperty(self, _arg_key):
       req=INetworkAdapter_getPropertyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=self.mgr.getPort().INetworkAdapter_getProperty(req)
       
       return String(self.mgr,val._returnval)


   def setProperty(self, _arg_key, _arg_value):
       req=INetworkAdapter_setPropertyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=self.mgr.getPort().INetworkAdapter_setProperty(req)
       
       return 


   def getProperties(self, _arg_names):
       req=INetworkAdapter_getPropertiesRequestMsg()
       req._this=self.handle
       
       req._names=_arg_names
       val=self.mgr.getPort().INetworkAdapter_getProperties(req)
       
       return String(self.mgr,val._returnval, True), String(self.mgr,val._returnNames, True)


   def getAdapterType(self):
       req=INetworkAdapter_getAdapterTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getAdapterType(req)
       return NetworkAdapterType(self.mgr,val._returnval)
   def setAdapterType(self, value):
       req=INetworkAdapter_setAdapterTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._adapterType = value
       else:
            req._adapterType = value.handle
       self.mgr.getPort().INetworkAdapter_setAdapterType(req)

   def getSlot(self):
       req=INetworkAdapter_getSlotRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getSlot(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getEnabled(self):
       req=INetworkAdapter_getEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabled(self, value):
       req=INetworkAdapter_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabled = value
       else:
            req._enabled = value.handle
       self.mgr.getPort().INetworkAdapter_setEnabled(req)

   def getMACAddress(self):
       req=INetworkAdapter_getMACAddressRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getMACAddress(req)
       return String(self.mgr,val._returnval)
   def setMACAddress(self, value):
       req=INetworkAdapter_setMACAddressRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._MACAddress = value
       else:
            req._MACAddress = value.handle
       self.mgr.getPort().INetworkAdapter_setMACAddress(req)

   def getAttachmentType(self):
       req=INetworkAdapter_getAttachmentTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getAttachmentType(req)
       return NetworkAttachmentType(self.mgr,val._returnval)
   def setAttachmentType(self, value):
       req=INetworkAdapter_setAttachmentTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._attachmentType = value
       else:
            req._attachmentType = value.handle
       self.mgr.getPort().INetworkAdapter_setAttachmentType(req)

   def getBridgedInterface(self):
       req=INetworkAdapter_getBridgedInterfaceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getBridgedInterface(req)
       return String(self.mgr,val._returnval)
   def setBridgedInterface(self, value):
       req=INetworkAdapter_setBridgedInterfaceRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._bridgedInterface = value
       else:
            req._bridgedInterface = value.handle
       self.mgr.getPort().INetworkAdapter_setBridgedInterface(req)

   def getHostOnlyInterface(self):
       req=INetworkAdapter_getHostOnlyInterfaceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getHostOnlyInterface(req)
       return String(self.mgr,val._returnval)
   def setHostOnlyInterface(self, value):
       req=INetworkAdapter_setHostOnlyInterfaceRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._hostOnlyInterface = value
       else:
            req._hostOnlyInterface = value.handle
       self.mgr.getPort().INetworkAdapter_setHostOnlyInterface(req)

   def getInternalNetwork(self):
       req=INetworkAdapter_getInternalNetworkRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getInternalNetwork(req)
       return String(self.mgr,val._returnval)
   def setInternalNetwork(self, value):
       req=INetworkAdapter_setInternalNetworkRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._internalNetwork = value
       else:
            req._internalNetwork = value.handle
       self.mgr.getPort().INetworkAdapter_setInternalNetwork(req)

   def getNATNetwork(self):
       req=INetworkAdapter_getNATNetworkRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getNATNetwork(req)
       return String(self.mgr,val._returnval)
   def setNATNetwork(self, value):
       req=INetworkAdapter_setNATNetworkRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._NATNetwork = value
       else:
            req._NATNetwork = value.handle
       self.mgr.getPort().INetworkAdapter_setNATNetwork(req)

   def getGenericDriver(self):
       req=INetworkAdapter_getGenericDriverRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getGenericDriver(req)
       return String(self.mgr,val._returnval)
   def setGenericDriver(self, value):
       req=INetworkAdapter_setGenericDriverRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._genericDriver = value
       else:
            req._genericDriver = value.handle
       self.mgr.getPort().INetworkAdapter_setGenericDriver(req)

   def getCableConnected(self):
       req=INetworkAdapter_getCableConnectedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getCableConnected(req)
       return Boolean(self.mgr,val._returnval)
   def setCableConnected(self, value):
       req=INetworkAdapter_setCableConnectedRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._cableConnected = value
       else:
            req._cableConnected = value.handle
       self.mgr.getPort().INetworkAdapter_setCableConnected(req)

   def getLineSpeed(self):
       req=INetworkAdapter_getLineSpeedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getLineSpeed(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setLineSpeed(self, value):
       req=INetworkAdapter_setLineSpeedRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._lineSpeed = value
       else:
            req._lineSpeed = value.handle
       self.mgr.getPort().INetworkAdapter_setLineSpeed(req)

   def getPromiscModePolicy(self):
       req=INetworkAdapter_getPromiscModePolicyRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getPromiscModePolicy(req)
       return NetworkAdapterPromiscModePolicy(self.mgr,val._returnval)
   def setPromiscModePolicy(self, value):
       req=INetworkAdapter_setPromiscModePolicyRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._promiscModePolicy = value
       else:
            req._promiscModePolicy = value.handle
       self.mgr.getPort().INetworkAdapter_setPromiscModePolicy(req)

   def getTraceEnabled(self):
       req=INetworkAdapter_getTraceEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getTraceEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setTraceEnabled(self, value):
       req=INetworkAdapter_setTraceEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._traceEnabled = value
       else:
            req._traceEnabled = value.handle
       self.mgr.getPort().INetworkAdapter_setTraceEnabled(req)

   def getTraceFile(self):
       req=INetworkAdapter_getTraceFileRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getTraceFile(req)
       return String(self.mgr,val._returnval)
   def setTraceFile(self, value):
       req=INetworkAdapter_setTraceFileRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._traceFile = value
       else:
            req._traceFile = value.handle
       self.mgr.getPort().INetworkAdapter_setTraceFile(req)

   def getNATEngine(self):
       req=INetworkAdapter_getNATEngineRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getNATEngine(req)
       return INATEngine(self.mgr,val._returnval)
   def getBootPriority(self):
       req=INetworkAdapter_getBootPriorityRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getBootPriority(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setBootPriority(self, value):
       req=INetworkAdapter_setBootPriorityRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._bootPriority = value
       else:
            req._bootPriority = value.handle
       self.mgr.getPort().INetworkAdapter_setBootPriority(req)

   def getBandwidthGroup(self):
       req=INetworkAdapter_getBandwidthGroupRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapter_getBandwidthGroup(req)
       return IBandwidthGroup(self.mgr,val._returnval)
   def setBandwidthGroup(self, value):
       req=INetworkAdapter_setBandwidthGroupRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._bandwidthGroup = value
       else:
            req._bandwidthGroup = value.handle
       self.mgr.getPort().INetworkAdapter_setBandwidthGroup(req)



   _Attrs_={         'adapterType':[getAdapterType,setAdapterType,
        ],
         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'MACAddress':[getMACAddress,setMACAddress,
        ],
         'attachmentType':[getAttachmentType,setAttachmentType,
        ],
         'bridgedInterface':[getBridgedInterface,setBridgedInterface,
        ],
         'hostOnlyInterface':[getHostOnlyInterface,setHostOnlyInterface,
        ],
         'internalNetwork':[getInternalNetwork,setInternalNetwork,
        ],
         'NATNetwork':[getNATNetwork,setNATNetwork,
        ],
         'genericDriver':[getGenericDriver,setGenericDriver,
        ],
         'cableConnected':[getCableConnected,setCableConnected,
        ],
         'lineSpeed':[getLineSpeed,setLineSpeed,
        ],
         'promiscModePolicy':[getPromiscModePolicy,setPromiscModePolicy,
        ],
         'traceEnabled':[getTraceEnabled,setTraceEnabled,
        ],
         'traceFile':[getTraceFile,setTraceFile,
        ],
         'NATEngine':[getNATEngine,None],
         'bootPriority':[getBootPriority,setBootPriority,
        ],
         'bandwidthGroup':[getBandwidthGroup,setBandwidthGroup,
        ]}

class ISerialPort(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISerialPort(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISerialPort._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISerialPort._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSlot(self):
       req=ISerialPort_getSlotRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISerialPort_getSlot(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getEnabled(self):
       req=ISerialPort_getEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISerialPort_getEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabled(self, value):
       req=ISerialPort_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabled = value
       else:
            req._enabled = value.handle
       self.mgr.getPort().ISerialPort_setEnabled(req)

   def getIOBase(self):
       req=ISerialPort_getIOBaseRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISerialPort_getIOBase(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setIOBase(self, value):
       req=ISerialPort_setIOBaseRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IOBase = value
       else:
            req._IOBase = value.handle
       self.mgr.getPort().ISerialPort_setIOBase(req)

   def getIRQ(self):
       req=ISerialPort_getIRQRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISerialPort_getIRQ(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setIRQ(self, value):
       req=ISerialPort_setIRQRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IRQ = value
       else:
            req._IRQ = value.handle
       self.mgr.getPort().ISerialPort_setIRQ(req)

   def getHostMode(self):
       req=ISerialPort_getHostModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISerialPort_getHostMode(req)
       return PortMode(self.mgr,val._returnval)
   def setHostMode(self, value):
       req=ISerialPort_setHostModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._hostMode = value
       else:
            req._hostMode = value.handle
       self.mgr.getPort().ISerialPort_setHostMode(req)

   def getServer(self):
       req=ISerialPort_getServerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISerialPort_getServer(req)
       return Boolean(self.mgr,val._returnval)
   def setServer(self, value):
       req=ISerialPort_setServerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._server = value
       else:
            req._server = value.handle
       self.mgr.getPort().ISerialPort_setServer(req)

   def getPath(self):
       req=ISerialPort_getPathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISerialPort_getPath(req)
       return String(self.mgr,val._returnval)
   def setPath(self, value):
       req=ISerialPort_setPathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._path = value
       else:
            req._path = value.handle
       self.mgr.getPort().ISerialPort_setPath(req)



   _Attrs_={         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'IOBase':[getIOBase,setIOBase,
        ],
         'IRQ':[getIRQ,setIRQ,
        ],
         'hostMode':[getHostMode,setHostMode,
        ],
         'server':[getServer,setServer,
        ],
         'path':[getPath,setPath,
        ]}

class IParallelPort(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IParallelPort(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IParallelPort._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IParallelPort._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSlot(self):
       req=IParallelPort_getSlotRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IParallelPort_getSlot(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getEnabled(self):
       req=IParallelPort_getEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IParallelPort_getEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabled(self, value):
       req=IParallelPort_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabled = value
       else:
            req._enabled = value.handle
       self.mgr.getPort().IParallelPort_setEnabled(req)

   def getIOBase(self):
       req=IParallelPort_getIOBaseRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IParallelPort_getIOBase(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setIOBase(self, value):
       req=IParallelPort_setIOBaseRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IOBase = value
       else:
            req._IOBase = value.handle
       self.mgr.getPort().IParallelPort_setIOBase(req)

   def getIRQ(self):
       req=IParallelPort_getIRQRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IParallelPort_getIRQ(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setIRQ(self, value):
       req=IParallelPort_setIRQRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._IRQ = value
       else:
            req._IRQ = value.handle
       self.mgr.getPort().IParallelPort_setIRQ(req)

   def getPath(self):
       req=IParallelPort_getPathRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IParallelPort_getPath(req)
       return String(self.mgr,val._returnval)
   def setPath(self, value):
       req=IParallelPort_setPathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._path = value
       else:
            req._path = value.handle
       self.mgr.getPort().IParallelPort_setPath(req)



   _Attrs_={         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'IOBase':[getIOBase,setIOBase,
        ],
         'IRQ':[getIRQ,setIRQ,
        ],
         'path':[getPath,setPath,
        ]}

class IMachineDebugger(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMachineDebugger(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMachineDebugger._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMachineDebugger._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def dumpGuestCore(self, _arg_filename, _arg_compression):
       req=IMachineDebugger_dumpGuestCoreRequestMsg()
       req._this=self.handle
       
       req._filename=_arg_filename
       req._compression=_arg_compression
       val=self.mgr.getPort().IMachineDebugger_dumpGuestCore(req)
       
       return 


   def dumpHostProcessCore(self, _arg_filename, _arg_compression):
       req=IMachineDebugger_dumpHostProcessCoreRequestMsg()
       req._this=self.handle
       
       req._filename=_arg_filename
       req._compression=_arg_compression
       val=self.mgr.getPort().IMachineDebugger_dumpHostProcessCore(req)
       
       return 


   def info(self, _arg_name, _arg_args):
       req=IMachineDebugger_infoRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._args=_arg_args
       val=self.mgr.getPort().IMachineDebugger_info(req)
       
       return String(self.mgr,val._returnval)


   def injectNMI(self):
       req=IMachineDebugger_injectNMIRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachineDebugger_injectNMI(req)
       
       return 


   def modifyLogGroups(self, _arg_settings):
       req=IMachineDebugger_modifyLogGroupsRequestMsg()
       req._this=self.handle
       
       req._settings=_arg_settings
       val=self.mgr.getPort().IMachineDebugger_modifyLogGroups(req)
       
       return 


   def modifyLogFlags(self, _arg_settings):
       req=IMachineDebugger_modifyLogFlagsRequestMsg()
       req._this=self.handle
       
       req._settings=_arg_settings
       val=self.mgr.getPort().IMachineDebugger_modifyLogFlags(req)
       
       return 


   def modifyLogDestinations(self, _arg_settings):
       req=IMachineDebugger_modifyLogDestinationsRequestMsg()
       req._this=self.handle
       
       req._settings=_arg_settings
       val=self.mgr.getPort().IMachineDebugger_modifyLogDestinations(req)
       
       return 


   def readPhysicalMemory(self, _arg_address, _arg_size):
       req=IMachineDebugger_readPhysicalMemoryRequestMsg()
       req._this=self.handle
       
       req._address=_arg_address
       req._size=_arg_size
       val=self.mgr.getPort().IMachineDebugger_readPhysicalMemory(req)
       
       return self.mgr.decodebase64(val._returnval)


   def writePhysicalMemory(self, _arg_address, _arg_size, _arg_bytes):
       req=IMachineDebugger_writePhysicalMemoryRequestMsg()
       req._this=self.handle
       
       req._address=_arg_address
       req._size=_arg_size
       req._bytes=self.mgr.encodebase64(_arg_bytes)
       val=self.mgr.getPort().IMachineDebugger_writePhysicalMemory(req)
       
       return 


   def readVirtualMemory(self, _arg_cpuId, _arg_address, _arg_size):
       req=IMachineDebugger_readVirtualMemoryRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       req._address=_arg_address
       req._size=_arg_size
       val=self.mgr.getPort().IMachineDebugger_readVirtualMemory(req)
       
       return self.mgr.decodebase64(val._returnval)


   def writeVirtualMemory(self, _arg_cpuId, _arg_address, _arg_size, _arg_bytes):
       req=IMachineDebugger_writeVirtualMemoryRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       req._address=_arg_address
       req._size=_arg_size
       req._bytes=self.mgr.encodebase64(_arg_bytes)
       val=self.mgr.getPort().IMachineDebugger_writeVirtualMemory(req)
       
       return 


   def loadPlugIn(self, _arg_name):
       req=IMachineDebugger_loadPlugInRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachineDebugger_loadPlugIn(req)
       
       return String(self.mgr,val._returnval)


   def unloadPlugIn(self, _arg_name):
       req=IMachineDebugger_unloadPlugInRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IMachineDebugger_unloadPlugIn(req)
       
       return 


   def detectOS(self):
       req=IMachineDebugger_detectOSRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IMachineDebugger_detectOS(req)
       
       return String(self.mgr,val._returnval)


   def queryOSKernelLog(self, _arg_maxMessages):
       req=IMachineDebugger_queryOSKernelLogRequestMsg()
       req._this=self.handle
       
       req._maxMessages=_arg_maxMessages
       val=self.mgr.getPort().IMachineDebugger_queryOSKernelLog(req)
       
       return String(self.mgr,val._returnval)


   def getRegister(self, _arg_cpuId, _arg_name):
       req=IMachineDebugger_getRegisterRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       req._name=_arg_name
       val=self.mgr.getPort().IMachineDebugger_getRegister(req)
       
       return String(self.mgr,val._returnval)


   def getRegisters(self, _arg_cpuId):
       req=IMachineDebugger_getRegistersRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       val=self.mgr.getPort().IMachineDebugger_getRegisters(req)
       
       return String(self.mgr,val._names, True), String(self.mgr,val._values, True)


   def setRegister(self, _arg_cpuId, _arg_name, _arg_value):
       req=IMachineDebugger_setRegisterRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       req._name=_arg_name
       req._value=_arg_value
       val=self.mgr.getPort().IMachineDebugger_setRegister(req)
       
       return 


   def setRegisters(self, _arg_cpuId, _arg_names, _arg_values):
       req=IMachineDebugger_setRegistersRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       req._names=_arg_names
       req._values=_arg_values
       val=self.mgr.getPort().IMachineDebugger_setRegisters(req)
       
       return 


   def dumpGuestStack(self, _arg_cpuId):
       req=IMachineDebugger_dumpGuestStackRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       val=self.mgr.getPort().IMachineDebugger_dumpGuestStack(req)
       
       return String(self.mgr,val._returnval)


   def resetStats(self, _arg_pattern):
       req=IMachineDebugger_resetStatsRequestMsg()
       req._this=self.handle
       
       req._pattern=_arg_pattern
       val=self.mgr.getPort().IMachineDebugger_resetStats(req)
       
       return 


   def dumpStats(self, _arg_pattern):
       req=IMachineDebugger_dumpStatsRequestMsg()
       req._this=self.handle
       
       req._pattern=_arg_pattern
       val=self.mgr.getPort().IMachineDebugger_dumpStats(req)
       
       return 


   def getStats(self, _arg_pattern, _arg_withDescriptions):
       req=IMachineDebugger_getStatsRequestMsg()
       req._this=self.handle
       
       req._pattern=_arg_pattern
       req._withDescriptions=_arg_withDescriptions
       val=self.mgr.getPort().IMachineDebugger_getStats(req)
       
       return String(self.mgr,val._returnval)


   def getSingleStep(self):
       req=IMachineDebugger_getSingleStepRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getSingleStep(req)
       return Boolean(self.mgr,val._returnval)
   def setSingleStep(self, value):
       req=IMachineDebugger_setSingleStepRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._singleStep = value
       else:
            req._singleStep = value.handle
       self.mgr.getPort().IMachineDebugger_setSingleStep(req)

   def getRecompileUser(self):
       req=IMachineDebugger_getRecompileUserRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getRecompileUser(req)
       return Boolean(self.mgr,val._returnval)
   def setRecompileUser(self, value):
       req=IMachineDebugger_setRecompileUserRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._recompileUser = value
       else:
            req._recompileUser = value.handle
       self.mgr.getPort().IMachineDebugger_setRecompileUser(req)

   def getRecompileSupervisor(self):
       req=IMachineDebugger_getRecompileSupervisorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getRecompileSupervisor(req)
       return Boolean(self.mgr,val._returnval)
   def setRecompileSupervisor(self, value):
       req=IMachineDebugger_setRecompileSupervisorRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._recompileSupervisor = value
       else:
            req._recompileSupervisor = value.handle
       self.mgr.getPort().IMachineDebugger_setRecompileSupervisor(req)

   def getExecuteAllInIEM(self):
       req=IMachineDebugger_getExecuteAllInIEMRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getExecuteAllInIEM(req)
       return Boolean(self.mgr,val._returnval)
   def setExecuteAllInIEM(self, value):
       req=IMachineDebugger_setExecuteAllInIEMRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._executeAllInIEM = value
       else:
            req._executeAllInIEM = value.handle
       self.mgr.getPort().IMachineDebugger_setExecuteAllInIEM(req)

   def getPATMEnabled(self):
       req=IMachineDebugger_getPATMEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getPATMEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setPATMEnabled(self, value):
       req=IMachineDebugger_setPATMEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._PATMEnabled = value
       else:
            req._PATMEnabled = value.handle
       self.mgr.getPort().IMachineDebugger_setPATMEnabled(req)

   def getCSAMEnabled(self):
       req=IMachineDebugger_getCSAMEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getCSAMEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setCSAMEnabled(self, value):
       req=IMachineDebugger_setCSAMEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._CSAMEnabled = value
       else:
            req._CSAMEnabled = value.handle
       self.mgr.getPort().IMachineDebugger_setCSAMEnabled(req)

   def getLogEnabled(self):
       req=IMachineDebugger_getLogEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getLogEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setLogEnabled(self, value):
       req=IMachineDebugger_setLogEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._logEnabled = value
       else:
            req._logEnabled = value.handle
       self.mgr.getPort().IMachineDebugger_setLogEnabled(req)

   def getLogDbgFlags(self):
       req=IMachineDebugger_getLogDbgFlagsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getLogDbgFlags(req)
       return String(self.mgr,val._returnval)
   def getLogDbgGroups(self):
       req=IMachineDebugger_getLogDbgGroupsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getLogDbgGroups(req)
       return String(self.mgr,val._returnval)
   def getLogDbgDestinations(self):
       req=IMachineDebugger_getLogDbgDestinationsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getLogDbgDestinations(req)
       return String(self.mgr,val._returnval)
   def getLogRelFlags(self):
       req=IMachineDebugger_getLogRelFlagsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getLogRelFlags(req)
       return String(self.mgr,val._returnval)
   def getLogRelGroups(self):
       req=IMachineDebugger_getLogRelGroupsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getLogRelGroups(req)
       return String(self.mgr,val._returnval)
   def getLogRelDestinations(self):
       req=IMachineDebugger_getLogRelDestinationsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getLogRelDestinations(req)
       return String(self.mgr,val._returnval)
   def getHWVirtExEnabled(self):
       req=IMachineDebugger_getHWVirtExEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getHWVirtExEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def getHWVirtExNestedPagingEnabled(self):
       req=IMachineDebugger_getHWVirtExNestedPagingEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getHWVirtExNestedPagingEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def getHWVirtExVPIDEnabled(self):
       req=IMachineDebugger_getHWVirtExVPIDEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getHWVirtExVPIDEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def getHWVirtExUXEnabled(self):
       req=IMachineDebugger_getHWVirtExUXEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getHWVirtExUXEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def getOSName(self):
       req=IMachineDebugger_getOSNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getOSName(req)
       return String(self.mgr,val._returnval)
   def getOSVersion(self):
       req=IMachineDebugger_getOSVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getOSVersion(req)
       return String(self.mgr,val._returnval)
   def getPAEEnabled(self):
       req=IMachineDebugger_getPAEEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getPAEEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def getVirtualTimeRate(self):
       req=IMachineDebugger_getVirtualTimeRateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getVirtualTimeRate(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setVirtualTimeRate(self, value):
       req=IMachineDebugger_setVirtualTimeRateRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._virtualTimeRate = value
       else:
            req._virtualTimeRate = value.handle
       self.mgr.getPort().IMachineDebugger_setVirtualTimeRate(req)

   def getVM(self):
       req=IMachineDebugger_getVMRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getVM(req)
       return Long(self.mgr,val._returnval)
   def getUptime(self):
       req=IMachineDebugger_getUptimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDebugger_getUptime(req)
       return Long(self.mgr,val._returnval)


   _Attrs_={         'singleStep':[getSingleStep,setSingleStep,
        ],
         'recompileUser':[getRecompileUser,setRecompileUser,
        ],
         'recompileSupervisor':[getRecompileSupervisor,setRecompileSupervisor,
        ],
         'executeAllInIEM':[getExecuteAllInIEM,setExecuteAllInIEM,
        ],
         'PATMEnabled':[getPATMEnabled,setPATMEnabled,
        ],
         'CSAMEnabled':[getCSAMEnabled,setCSAMEnabled,
        ],
         'logEnabled':[getLogEnabled,setLogEnabled,
        ],
         'logDbgFlags':[getLogDbgFlags,None],
         'logDbgGroups':[getLogDbgGroups,None],
         'logDbgDestinations':[getLogDbgDestinations,None],
         'logRelFlags':[getLogRelFlags,None],
         'logRelGroups':[getLogRelGroups,None],
         'logRelDestinations':[getLogRelDestinations,None],
         'HWVirtExEnabled':[getHWVirtExEnabled,None],
         'HWVirtExNestedPagingEnabled':[getHWVirtExNestedPagingEnabled,None],
         'HWVirtExVPIDEnabled':[getHWVirtExVPIDEnabled,None],
         'HWVirtExUXEnabled':[getHWVirtExUXEnabled,None],
         'OSName':[getOSName,None],
         'OSVersion':[getOSVersion,None],
         'PAEEnabled':[getPAEEnabled,None],
         'virtualTimeRate':[getVirtualTimeRate,setVirtualTimeRate,
        ],
         'VM':[getVM,None],
         'uptime':[getUptime,None]}

class IUSBDeviceFilters(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IUSBDeviceFilters(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBDeviceFilters._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IUSBDeviceFilters._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def createDeviceFilter(self, _arg_name):
       req=IUSBDeviceFilters_createDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IUSBDeviceFilters_createDeviceFilter(req)
       
       return IUSBDeviceFilter(self.mgr,val._returnval)


   def insertDeviceFilter(self, _arg_position, _arg_filter):
       req=IUSBDeviceFilters_insertDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._filter=_arg_filter
       val=self.mgr.getPort().IUSBDeviceFilters_insertDeviceFilter(req)
       
       return 


   def removeDeviceFilter(self, _arg_position):
       req=IUSBDeviceFilters_removeDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       val=self.mgr.getPort().IUSBDeviceFilters_removeDeviceFilter(req)
       
       return IUSBDeviceFilter(self.mgr,val._returnval)


   def getDeviceFilters(self):
       req=IUSBDeviceFilters_getDeviceFiltersRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilters_getDeviceFilters(req)
       return IUSBDeviceFilter(self.mgr,val._returnval, True)


   _Attrs_={         'deviceFilters':[getDeviceFilters,None]}

class IUSBController(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IUSBController(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBController._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IUSBController._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IUSBController_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBController_getName(req)
       return String(self.mgr,val._returnval)
   def setName(self, value):
       req=IUSBController_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._name = value
       else:
            req._name = value.handle
       self.mgr.getPort().IUSBController_setName(req)

   def getType(self):
       req=IUSBController_getTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBController_getType(req)
       return USBControllerType(self.mgr,val._returnval)
   def setType(self, value):
       req=IUSBController_setTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._type = value
       else:
            req._type = value.handle
       self.mgr.getPort().IUSBController_setType(req)

   def getUSBStandard(self):
       req=IUSBController_getUSBStandardRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBController_getUSBStandard(req)
       return UnsignedShort(self.mgr,val._returnval)


   _Attrs_={         'name':[getName,setName,
        ],
         'type':[getType,setType,
        ],
         'USBStandard':[getUSBStandard,None]}

class IUSBDevice(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IUSBDevice(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBDevice._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getId(self):
       req=IUSBDevice_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getId(req)
       return String(self.mgr,val._returnval)
   def getVendorId(self):
       req=IUSBDevice_getVendorIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getVendorId(req)
       return UnsignedShort(self.mgr,val._returnval)
   def getProductId(self):
       req=IUSBDevice_getProductIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getProductId(req)
       return UnsignedShort(self.mgr,val._returnval)
   def getRevision(self):
       req=IUSBDevice_getRevisionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getRevision(req)
       return UnsignedShort(self.mgr,val._returnval)
   def getManufacturer(self):
       req=IUSBDevice_getManufacturerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getManufacturer(req)
       return String(self.mgr,val._returnval)
   def getProduct(self):
       req=IUSBDevice_getProductRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getProduct(req)
       return String(self.mgr,val._returnval)
   def getSerialNumber(self):
       req=IUSBDevice_getSerialNumberRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getSerialNumber(req)
       return String(self.mgr,val._returnval)
   def getAddress(self):
       req=IUSBDevice_getAddressRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getAddress(req)
       return String(self.mgr,val._returnval)
   def getPort(self):
       req=IUSBDevice_getPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getPort(req)
       return UnsignedShort(self.mgr,val._returnval)
   def getVersion(self):
       req=IUSBDevice_getVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getVersion(req)
       return UnsignedShort(self.mgr,val._returnval)
   def getPortVersion(self):
       req=IUSBDevice_getPortVersionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getPortVersion(req)
       return UnsignedShort(self.mgr,val._returnval)
   def getSpeed(self):
       req=IUSBDevice_getSpeedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getSpeed(req)
       return USBConnectionSpeed(self.mgr,val._returnval)
   def getRemote(self):
       req=IUSBDevice_getRemoteRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getRemote(req)
       return Boolean(self.mgr,val._returnval)
   def getDeviceInfo(self):
       req=IUSBDevice_getDeviceInfoRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getDeviceInfo(req)
       return String(self.mgr,val._returnval, True)
   def getBackend(self):
       req=IUSBDevice_getBackendRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDevice_getBackend(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'id':[getId,None],
         'vendorId':[getVendorId,None],
         'productId':[getProductId,None],
         'revision':[getRevision,None],
         'manufacturer':[getManufacturer,None],
         'product':[getProduct,None],
         'serialNumber':[getSerialNumber,None],
         'address':[getAddress,None],
         'port':[getPort,None],
         'version':[getVersion,None],
         'portVersion':[getPortVersion,None],
         'speed':[getSpeed,None],
         'remote':[getRemote,None],
         'deviceInfo':[getDeviceInfo,None],
         'backend':[getBackend,None]}

class IUSBDeviceFilter(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IUSBDeviceFilter(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBDeviceFilter._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IUSBDeviceFilter_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getName(req)
       return String(self.mgr,val._returnval)
   def setName(self, value):
       req=IUSBDeviceFilter_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._name = value
       else:
            req._name = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setName(req)

   def getActive(self):
       req=IUSBDeviceFilter_getActiveRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getActive(req)
       return Boolean(self.mgr,val._returnval)
   def setActive(self, value):
       req=IUSBDeviceFilter_setActiveRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._active = value
       else:
            req._active = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setActive(req)

   def getVendorId(self):
       req=IUSBDeviceFilter_getVendorIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getVendorId(req)
       return String(self.mgr,val._returnval)
   def setVendorId(self, value):
       req=IUSBDeviceFilter_setVendorIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._vendorId = value
       else:
            req._vendorId = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setVendorId(req)

   def getProductId(self):
       req=IUSBDeviceFilter_getProductIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getProductId(req)
       return String(self.mgr,val._returnval)
   def setProductId(self, value):
       req=IUSBDeviceFilter_setProductIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._productId = value
       else:
            req._productId = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setProductId(req)

   def getRevision(self):
       req=IUSBDeviceFilter_getRevisionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getRevision(req)
       return String(self.mgr,val._returnval)
   def setRevision(self, value):
       req=IUSBDeviceFilter_setRevisionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._revision = value
       else:
            req._revision = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setRevision(req)

   def getManufacturer(self):
       req=IUSBDeviceFilter_getManufacturerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getManufacturer(req)
       return String(self.mgr,val._returnval)
   def setManufacturer(self, value):
       req=IUSBDeviceFilter_setManufacturerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._manufacturer = value
       else:
            req._manufacturer = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setManufacturer(req)

   def getProduct(self):
       req=IUSBDeviceFilter_getProductRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getProduct(req)
       return String(self.mgr,val._returnval)
   def setProduct(self, value):
       req=IUSBDeviceFilter_setProductRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._product = value
       else:
            req._product = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setProduct(req)

   def getSerialNumber(self):
       req=IUSBDeviceFilter_getSerialNumberRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getSerialNumber(req)
       return String(self.mgr,val._returnval)
   def setSerialNumber(self, value):
       req=IUSBDeviceFilter_setSerialNumberRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._serialNumber = value
       else:
            req._serialNumber = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setSerialNumber(req)

   def getPort(self):
       req=IUSBDeviceFilter_getPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getPort(req)
       return String(self.mgr,val._returnval)
   def setPort(self, value):
       req=IUSBDeviceFilter_setPortRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._port = value
       else:
            req._port = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setPort(req)

   def getRemote(self):
       req=IUSBDeviceFilter_getRemoteRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getRemote(req)
       return String(self.mgr,val._returnval)
   def setRemote(self, value):
       req=IUSBDeviceFilter_setRemoteRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._remote = value
       else:
            req._remote = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setRemote(req)

   def getMaskedInterfaces(self):
       req=IUSBDeviceFilter_getMaskedInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceFilter_getMaskedInterfaces(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setMaskedInterfaces(self, value):
       req=IUSBDeviceFilter_setMaskedInterfacesRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._maskedInterfaces = value
       else:
            req._maskedInterfaces = value.handle
       self.mgr.getPort().IUSBDeviceFilter_setMaskedInterfaces(req)



   _Attrs_={         'name':[getName,setName,
        ],
         'active':[getActive,setActive,
        ],
         'vendorId':[getVendorId,setVendorId,
        ],
         'productId':[getProductId,setProductId,
        ],
         'revision':[getRevision,setRevision,
        ],
         'manufacturer':[getManufacturer,setManufacturer,
        ],
         'product':[getProduct,setProduct,
        ],
         'serialNumber':[getSerialNumber,setSerialNumber,
        ],
         'port':[getPort,setPort,
        ],
         'remote':[getRemote,setRemote,
        ],
         'maskedInterfaces':[getMaskedInterfaces,setMaskedInterfaces,
        ]}

class IHostUSBDevice(IUSBDevice):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IHostUSBDevice(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostUSBDevice._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUSBDevice.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IHostUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getState(self):
       req=IHostUSBDevice_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostUSBDevice_getState(req)
       return USBDeviceState(self.mgr,val._returnval)


   _Attrs_={         'state':[getState,None]}

class IHostUSBDeviceFilter(IUSBDeviceFilter):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IHostUSBDeviceFilter(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostUSBDeviceFilter._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUSBDeviceFilter.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IHostUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getAction(self):
       req=IHostUSBDeviceFilter_getActionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostUSBDeviceFilter_getAction(req)
       return USBDeviceFilterAction(self.mgr,val._returnval)
   def setAction(self, value):
       req=IHostUSBDeviceFilter_setActionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._action = value
       else:
            req._action = value.handle
       self.mgr.getPort().IHostUSBDeviceFilter_setAction(req)



   _Attrs_={         'action':[getAction,setAction,
        ]}

class IUSBProxyBackend(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IUSBProxyBackend(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBProxyBackend._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IUSBProxyBackend._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IUSBProxyBackend_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBProxyBackend_getName(req)
       return String(self.mgr,val._returnval)
   def getType(self):
       req=IUSBProxyBackend_getTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBProxyBackend_getType(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'name':[getName,None],
         'type':[getType,None]}

class IAudioAdapter(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IAudioAdapter(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IAudioAdapter._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IAudioAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def setProperty(self, _arg_key, _arg_value):
       req=IAudioAdapter_setPropertyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=self.mgr.getPort().IAudioAdapter_setProperty(req)
       
       return 


   def getProperty(self, _arg_key):
       req=IAudioAdapter_getPropertyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=self.mgr.getPort().IAudioAdapter_getProperty(req)
       
       return String(self.mgr,val._returnval)


   def getEnabled(self):
       req=IAudioAdapter_getEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAudioAdapter_getEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabled(self, value):
       req=IAudioAdapter_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabled = value
       else:
            req._enabled = value.handle
       self.mgr.getPort().IAudioAdapter_setEnabled(req)

   def getEnabledIn(self):
       req=IAudioAdapter_getEnabledInRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAudioAdapter_getEnabledIn(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabledIn(self, value):
       req=IAudioAdapter_setEnabledInRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabledIn = value
       else:
            req._enabledIn = value.handle
       self.mgr.getPort().IAudioAdapter_setEnabledIn(req)

   def getEnabledOut(self):
       req=IAudioAdapter_getEnabledOutRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAudioAdapter_getEnabledOut(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabledOut(self, value):
       req=IAudioAdapter_setEnabledOutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabledOut = value
       else:
            req._enabledOut = value.handle
       self.mgr.getPort().IAudioAdapter_setEnabledOut(req)

   def getAudioController(self):
       req=IAudioAdapter_getAudioControllerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAudioAdapter_getAudioController(req)
       return AudioControllerType(self.mgr,val._returnval)
   def setAudioController(self, value):
       req=IAudioAdapter_setAudioControllerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._audioController = value
       else:
            req._audioController = value.handle
       self.mgr.getPort().IAudioAdapter_setAudioController(req)

   def getAudioCodec(self):
       req=IAudioAdapter_getAudioCodecRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAudioAdapter_getAudioCodec(req)
       return AudioCodecType(self.mgr,val._returnval)
   def setAudioCodec(self, value):
       req=IAudioAdapter_setAudioCodecRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._audioCodec = value
       else:
            req._audioCodec = value.handle
       self.mgr.getPort().IAudioAdapter_setAudioCodec(req)

   def getAudioDriver(self):
       req=IAudioAdapter_getAudioDriverRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAudioAdapter_getAudioDriver(req)
       return AudioDriverType(self.mgr,val._returnval)
   def setAudioDriver(self, value):
       req=IAudioAdapter_setAudioDriverRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._audioDriver = value
       else:
            req._audioDriver = value.handle
       self.mgr.getPort().IAudioAdapter_setAudioDriver(req)

   def getPropertiesList(self):
       req=IAudioAdapter_getPropertiesListRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAudioAdapter_getPropertiesList(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'enabledIn':[getEnabledIn,setEnabledIn,
        ],
         'enabledOut':[getEnabledOut,setEnabledOut,
        ],
         'audioController':[getAudioController,setAudioController,
        ],
         'audioCodec':[getAudioCodec,setAudioCodec,
        ],
         'audioDriver':[getAudioDriver,setAudioDriver,
        ],
         'propertiesList':[getPropertiesList,None]}

class IVRDEServer(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVRDEServer(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVRDEServer._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVRDEServer._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def setVRDEProperty(self, _arg_key, _arg_value):
       req=IVRDEServer_setVRDEPropertyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=self.mgr.getPort().IVRDEServer_setVRDEProperty(req)
       
       return 


   def getVRDEProperty(self, _arg_key):
       req=IVRDEServer_getVRDEPropertyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=self.mgr.getPort().IVRDEServer_getVRDEProperty(req)
       
       return String(self.mgr,val._returnval)


   def getEnabled(self):
       req=IVRDEServer_getEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServer_getEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def setEnabled(self, value):
       req=IVRDEServer_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._enabled = value
       else:
            req._enabled = value.handle
       self.mgr.getPort().IVRDEServer_setEnabled(req)

   def getAuthType(self):
       req=IVRDEServer_getAuthTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServer_getAuthType(req)
       return AuthType(self.mgr,val._returnval)
   def setAuthType(self, value):
       req=IVRDEServer_setAuthTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._authType = value
       else:
            req._authType = value.handle
       self.mgr.getPort().IVRDEServer_setAuthType(req)

   def getAuthTimeout(self):
       req=IVRDEServer_getAuthTimeoutRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServer_getAuthTimeout(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setAuthTimeout(self, value):
       req=IVRDEServer_setAuthTimeoutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._authTimeout = value
       else:
            req._authTimeout = value.handle
       self.mgr.getPort().IVRDEServer_setAuthTimeout(req)

   def getAllowMultiConnection(self):
       req=IVRDEServer_getAllowMultiConnectionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServer_getAllowMultiConnection(req)
       return Boolean(self.mgr,val._returnval)
   def setAllowMultiConnection(self, value):
       req=IVRDEServer_setAllowMultiConnectionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._allowMultiConnection = value
       else:
            req._allowMultiConnection = value.handle
       self.mgr.getPort().IVRDEServer_setAllowMultiConnection(req)

   def getReuseSingleConnection(self):
       req=IVRDEServer_getReuseSingleConnectionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServer_getReuseSingleConnection(req)
       return Boolean(self.mgr,val._returnval)
   def setReuseSingleConnection(self, value):
       req=IVRDEServer_setReuseSingleConnectionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._reuseSingleConnection = value
       else:
            req._reuseSingleConnection = value.handle
       self.mgr.getPort().IVRDEServer_setReuseSingleConnection(req)

   def getVRDEExtPack(self):
       req=IVRDEServer_getVRDEExtPackRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServer_getVRDEExtPack(req)
       return String(self.mgr,val._returnval)
   def setVRDEExtPack(self, value):
       req=IVRDEServer_setVRDEExtPackRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._VRDEExtPack = value
       else:
            req._VRDEExtPack = value.handle
       self.mgr.getPort().IVRDEServer_setVRDEExtPack(req)

   def getAuthLibrary(self):
       req=IVRDEServer_getAuthLibraryRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServer_getAuthLibrary(req)
       return String(self.mgr,val._returnval)
   def setAuthLibrary(self, value):
       req=IVRDEServer_setAuthLibraryRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._authLibrary = value
       else:
            req._authLibrary = value.handle
       self.mgr.getPort().IVRDEServer_setAuthLibrary(req)

   def getVRDEProperties(self):
       req=IVRDEServer_getVRDEPropertiesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServer_getVRDEProperties(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'authType':[getAuthType,setAuthType,
        ],
         'authTimeout':[getAuthTimeout,setAuthTimeout,
        ],
         'allowMultiConnection':[getAllowMultiConnection,setAllowMultiConnection,
        ],
         'reuseSingleConnection':[getReuseSingleConnection,setReuseSingleConnection,
        ],
         'VRDEExtPack':[getVRDEExtPack,setVRDEExtPack,
        ],
         'authLibrary':[getAuthLibrary,setAuthLibrary,
        ],
         'VRDEProperties':[getVRDEProperties,None]}

class ISession(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISession(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISession._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISession._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def unlockMachine(self):
       req=ISession_unlockMachineRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().ISession_unlockMachine(req)
       
       return 


   def getState(self):
       req=ISession_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISession_getState(req)
       return SessionState(self.mgr,val._returnval)
   def getType(self):
       req=ISession_getTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISession_getType(req)
       return SessionType(self.mgr,val._returnval)
   def getName(self):
       req=ISession_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISession_getName(req)
       return String(self.mgr,val._returnval)
   def setName(self, value):
       req=ISession_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._name = value
       else:
            req._name = value.handle
       self.mgr.getPort().ISession_setName(req)

   def getMachine(self):
       req=ISession_getMachineRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISession_getMachine(req)
       return IMachine(self.mgr,val._returnval)
   def getConsole(self):
       req=ISession_getConsoleRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISession_getConsole(req)
       return IConsole(self.mgr,val._returnval)


   _Attrs_={         'state':[getState,None],
         'type':[getType,None],
         'name':[getName,setName,
        ],
         'machine':[getMachine,None],
         'console':[getConsole,None]}

class IStorageController(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IStorageController(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IStorageController._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IStorageController._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IStorageController_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getName(req)
       return String(self.mgr,val._returnval)
   def setName(self, value):
       req=IStorageController_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._name = value
       else:
            req._name = value.handle
       self.mgr.getPort().IStorageController_setName(req)

   def getMaxDevicesPerPortCount(self):
       req=IStorageController_getMaxDevicesPerPortCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getMaxDevicesPerPortCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMinPortCount(self):
       req=IStorageController_getMinPortCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getMinPortCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMaxPortCount(self):
       req=IStorageController_getMaxPortCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getMaxPortCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getInstance(self):
       req=IStorageController_getInstanceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getInstance(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setInstance(self, value):
       req=IStorageController_setInstanceRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._instance = value
       else:
            req._instance = value.handle
       self.mgr.getPort().IStorageController_setInstance(req)

   def getPortCount(self):
       req=IStorageController_getPortCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getPortCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setPortCount(self, value):
       req=IStorageController_setPortCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._portCount = value
       else:
            req._portCount = value.handle
       self.mgr.getPort().IStorageController_setPortCount(req)

   def getBus(self):
       req=IStorageController_getBusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getBus(req)
       return StorageBus(self.mgr,val._returnval)
   def getControllerType(self):
       req=IStorageController_getControllerTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getControllerType(req)
       return StorageControllerType(self.mgr,val._returnval)
   def setControllerType(self, value):
       req=IStorageController_setControllerTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._controllerType = value
       else:
            req._controllerType = value.handle
       self.mgr.getPort().IStorageController_setControllerType(req)

   def getUseHostIOCache(self):
       req=IStorageController_getUseHostIOCacheRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getUseHostIOCache(req)
       return Boolean(self.mgr,val._returnval)
   def setUseHostIOCache(self, value):
       req=IStorageController_setUseHostIOCacheRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._useHostIOCache = value
       else:
            req._useHostIOCache = value.handle
       self.mgr.getPort().IStorageController_setUseHostIOCache(req)

   def getBootable(self):
       req=IStorageController_getBootableRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageController_getBootable(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'name':[getName,setName,
        ],
         'maxDevicesPerPortCount':[getMaxDevicesPerPortCount,None],
         'minPortCount':[getMinPortCount,None],
         'maxPortCount':[getMaxPortCount,None],
         'instance':[getInstance,setInstance,
        ],
         'portCount':[getPortCount,setPortCount,
        ],
         'bus':[getBus,None],
         'controllerType':[getControllerType,setControllerType,
        ],
         'useHostIOCache':[getUseHostIOCache,setUseHostIOCache,
        ],
         'bootable':[getBootable,None]}

class IManagedObjectRef(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IManagedObjectRef(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IManagedObjectRef._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IManagedObjectRef._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getInterfaceName(self):
       req=IManagedObjectRef_getInterfaceNameRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IManagedObjectRef_getInterfaceName(req)
       
       return String(self.mgr,val._returnval)


   def release(self):
       req=IManagedObjectRef_releaseRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IManagedObjectRef_release(req)
       
       return 




   _Attrs_={}

class IWebsessionManager(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IWebsessionManager(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IWebsessionManager._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IWebsessionManager._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def logon(self, _arg_username, _arg_password):
       req=IWebsessionManager_logonRequestMsg()
       req._this=self.handle
       
       req._username=_arg_username
       req._password=_arg_password
       val=self.mgr.getPort().IWebsessionManager_logon(req)
       
       return IVirtualBox(self.mgr,val._returnval)


   def getSessionObject(self, _arg_refIVirtualBox):
       req=IWebsessionManager_getSessionObjectRequestMsg()
       req._this=self.handle
       
       req._refIVirtualBox=_arg_refIVirtualBox
       val=self.mgr.getPort().IWebsessionManager_getSessionObject(req)
       
       return ISession(self.mgr,val._returnval)


   def logoff(self, _arg_refIVirtualBox):
       req=IWebsessionManager_logoffRequestMsg()
       req._this=self.handle
       
       req._refIVirtualBox=_arg_refIVirtualBox
       val=self.mgr.getPort().IWebsessionManager_logoff(req)
       
       return 




   _Attrs_={}

class IPerformanceMetric(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IPerformanceMetric(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IPerformanceMetric._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IPerformanceMetric._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMetricName(self):
       req=IPerformanceMetric_getMetricNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceMetric_getMetricName(req)
       return String(self.mgr,val._returnval)
   def getObject(self):
       req=IPerformanceMetric_getObjectRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceMetric_getObject(req)
       return IUnknown(self.mgr,val._returnval)
   def getDescription(self):
       req=IPerformanceMetric_getDescriptionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceMetric_getDescription(req)
       return String(self.mgr,val._returnval)
   def getPeriod(self):
       req=IPerformanceMetric_getPeriodRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceMetric_getPeriod(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getCount(self):
       req=IPerformanceMetric_getCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceMetric_getCount(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getUnit(self):
       req=IPerformanceMetric_getUnitRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceMetric_getUnit(req)
       return String(self.mgr,val._returnval)
   def getMinimumValue(self):
       req=IPerformanceMetric_getMinimumValueRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceMetric_getMinimumValue(req)
       return Int(self.mgr,val._returnval)
   def getMaximumValue(self):
       req=IPerformanceMetric_getMaximumValueRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceMetric_getMaximumValue(req)
       return Int(self.mgr,val._returnval)


   _Attrs_={         'metricName':[getMetricName,None],
         'object':[getObject,None],
         'description':[getDescription,None],
         'period':[getPeriod,None],
         'count':[getCount,None],
         'unit':[getUnit,None],
         'minimumValue':[getMinimumValue,None],
         'maximumValue':[getMaximumValue,None]}

class IPerformanceCollector(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IPerformanceCollector(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IPerformanceCollector._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IPerformanceCollector._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_getMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=self.mgr.getPort().IPerformanceCollector_getMetrics(req)
       
       return IPerformanceMetric(self.mgr,val._returnval, True)


   def setupMetrics(self, _arg_metricNames, _arg_objects, _arg_period, _arg_count):
       req=IPerformanceCollector_setupMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       req._period=_arg_period
       req._count=_arg_count
       val=self.mgr.getPort().IPerformanceCollector_setupMetrics(req)
       
       return IPerformanceMetric(self.mgr,val._returnval, True)


   def enableMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_enableMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=self.mgr.getPort().IPerformanceCollector_enableMetrics(req)
       
       return IPerformanceMetric(self.mgr,val._returnval, True)


   def disableMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_disableMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=self.mgr.getPort().IPerformanceCollector_disableMetrics(req)
       
       return IPerformanceMetric(self.mgr,val._returnval, True)


   def queryMetricsData(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_queryMetricsDataRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=self.mgr.getPort().IPerformanceCollector_queryMetricsData(req)
       
       return Int(self.mgr,val._returnval, True), String(self.mgr,val._returnMetricNames, True), IUnknown(self.mgr,val._returnObjects, True), String(self.mgr,val._returnUnits, True), UnsignedInt(self.mgr,val._returnScales, True), UnsignedInt(self.mgr,val._returnSequenceNumbers, True), UnsignedInt(self.mgr,val._returnDataIndices, True), UnsignedInt(self.mgr,val._returnDataLengths, True)


   def getMetricNames(self):
       req=IPerformanceCollector_getMetricNamesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IPerformanceCollector_getMetricNames(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'metricNames':[getMetricNames,None]}

class INATEngine(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATEngine(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATEngine._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATEngine._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def setNetworkSettings(self, _arg_mtu, _arg_sockSnd, _arg_sockRcv, _arg_TcpWndSnd, _arg_TcpWndRcv):
       req=INATEngine_setNetworkSettingsRequestMsg()
       req._this=self.handle
       
       req._mtu=_arg_mtu
       req._sockSnd=_arg_sockSnd
       req._sockRcv=_arg_sockRcv
       req._TcpWndSnd=_arg_TcpWndSnd
       req._TcpWndRcv=_arg_TcpWndRcv
       val=self.mgr.getPort().INATEngine_setNetworkSettings(req)
       
       return 


   def getNetworkSettings(self):
       req=INATEngine_getNetworkSettingsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().INATEngine_getNetworkSettings(req)
       
       return UnsignedInt(self.mgr,val._mtu), UnsignedInt(self.mgr,val._sockSnd), UnsignedInt(self.mgr,val._sockRcv), UnsignedInt(self.mgr,val._TcpWndSnd), UnsignedInt(self.mgr,val._TcpWndRcv)


   def addRedirect(self, _arg_name, _arg_proto, _arg_hostIP, _arg_hostPort, _arg_guestIP, _arg_guestPort):
       req=INATEngine_addRedirectRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._proto=_arg_proto
       req._hostIP=_arg_hostIP
       req._hostPort=_arg_hostPort
       req._guestIP=_arg_guestIP
       req._guestPort=_arg_guestPort
       val=self.mgr.getPort().INATEngine_addRedirect(req)
       
       return 


   def removeRedirect(self, _arg_name):
       req=INATEngine_removeRedirectRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().INATEngine_removeRedirect(req)
       
       return 


   def getNetwork(self):
       req=INATEngine_getNetworkRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getNetwork(req)
       return String(self.mgr,val._returnval)
   def setNetwork(self, value):
       req=INATEngine_setNetworkRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._network = value
       else:
            req._network = value.handle
       self.mgr.getPort().INATEngine_setNetwork(req)

   def getHostIP(self):
       req=INATEngine_getHostIPRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getHostIP(req)
       return String(self.mgr,val._returnval)
   def setHostIP(self, value):
       req=INATEngine_setHostIPRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._hostIP = value
       else:
            req._hostIP = value.handle
       self.mgr.getPort().INATEngine_setHostIP(req)

   def getTFTPPrefix(self):
       req=INATEngine_getTFTPPrefixRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getTFTPPrefix(req)
       return String(self.mgr,val._returnval)
   def setTFTPPrefix(self, value):
       req=INATEngine_setTFTPPrefixRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._TFTPPrefix = value
       else:
            req._TFTPPrefix = value.handle
       self.mgr.getPort().INATEngine_setTFTPPrefix(req)

   def getTFTPBootFile(self):
       req=INATEngine_getTFTPBootFileRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getTFTPBootFile(req)
       return String(self.mgr,val._returnval)
   def setTFTPBootFile(self, value):
       req=INATEngine_setTFTPBootFileRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._TFTPBootFile = value
       else:
            req._TFTPBootFile = value.handle
       self.mgr.getPort().INATEngine_setTFTPBootFile(req)

   def getTFTPNextServer(self):
       req=INATEngine_getTFTPNextServerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getTFTPNextServer(req)
       return String(self.mgr,val._returnval)
   def setTFTPNextServer(self, value):
       req=INATEngine_setTFTPNextServerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._TFTPNextServer = value
       else:
            req._TFTPNextServer = value.handle
       self.mgr.getPort().INATEngine_setTFTPNextServer(req)

   def getAliasMode(self):
       req=INATEngine_getAliasModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getAliasMode(req)
       return UnsignedInt(self.mgr,val._returnval)
   def setAliasMode(self, value):
       req=INATEngine_setAliasModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._aliasMode = value
       else:
            req._aliasMode = value.handle
       self.mgr.getPort().INATEngine_setAliasMode(req)

   def getDNSPassDomain(self):
       req=INATEngine_getDNSPassDomainRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getDNSPassDomain(req)
       return Boolean(self.mgr,val._returnval)
   def setDNSPassDomain(self, value):
       req=INATEngine_setDNSPassDomainRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._DNSPassDomain = value
       else:
            req._DNSPassDomain = value.handle
       self.mgr.getPort().INATEngine_setDNSPassDomain(req)

   def getDNSProxy(self):
       req=INATEngine_getDNSProxyRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getDNSProxy(req)
       return Boolean(self.mgr,val._returnval)
   def setDNSProxy(self, value):
       req=INATEngine_setDNSProxyRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._DNSProxy = value
       else:
            req._DNSProxy = value.handle
       self.mgr.getPort().INATEngine_setDNSProxy(req)

   def getDNSUseHostResolver(self):
       req=INATEngine_getDNSUseHostResolverRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getDNSUseHostResolver(req)
       return Boolean(self.mgr,val._returnval)
   def setDNSUseHostResolver(self, value):
       req=INATEngine_setDNSUseHostResolverRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._DNSUseHostResolver = value
       else:
            req._DNSUseHostResolver = value.handle
       self.mgr.getPort().INATEngine_setDNSUseHostResolver(req)

   def getRedirects(self):
       req=INATEngine_getRedirectsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATEngine_getRedirects(req)
       return String(self.mgr,val._returnval, True)


   _Attrs_={         'network':[getNetwork,setNetwork,
        ],
         'hostIP':[getHostIP,setHostIP,
        ],
         'TFTPPrefix':[getTFTPPrefix,setTFTPPrefix,
        ],
         'TFTPBootFile':[getTFTPBootFile,setTFTPBootFile,
        ],
         'TFTPNextServer':[getTFTPNextServer,setTFTPNextServer,
        ],
         'aliasMode':[getAliasMode,setAliasMode,
        ],
         'DNSPassDomain':[getDNSPassDomain,setDNSPassDomain,
        ],
         'DNSProxy':[getDNSProxy,setDNSProxy,
        ],
         'DNSUseHostResolver':[getDNSUseHostResolver,setDNSUseHostResolver,
        ],
         'redirects':[getRedirects,None]}

class IBandwidthGroup(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IBandwidthGroup(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IBandwidthGroup._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IBandwidthGroup._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IBandwidthGroup_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBandwidthGroup_getName(req)
       return String(self.mgr,val._returnval)
   def getType(self):
       req=IBandwidthGroup_getTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBandwidthGroup_getType(req)
       return BandwidthGroupType(self.mgr,val._returnval)
   def getReference(self):
       req=IBandwidthGroup_getReferenceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBandwidthGroup_getReference(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getMaxBytesPerSec(self):
       req=IBandwidthGroup_getMaxBytesPerSecRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBandwidthGroup_getMaxBytesPerSec(req)
       return Long(self.mgr,val._returnval)
   def setMaxBytesPerSec(self, value):
       req=IBandwidthGroup_setMaxBytesPerSecRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._maxBytesPerSec = value
       else:
            req._maxBytesPerSec = value.handle
       self.mgr.getPort().IBandwidthGroup_setMaxBytesPerSec(req)



   _Attrs_={         'name':[getName,None],
         'type':[getType,None],
         'reference':[getReference,None],
         'maxBytesPerSec':[getMaxBytesPerSec,setMaxBytesPerSec,
        ]}

class IBandwidthControl(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IBandwidthControl(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IBandwidthControl._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IBandwidthControl._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def createBandwidthGroup(self, _arg_name, _arg_type, _arg_maxBytesPerSec):
       req=IBandwidthControl_createBandwidthGroupRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._type=_arg_type
       req._maxBytesPerSec=_arg_maxBytesPerSec
       val=self.mgr.getPort().IBandwidthControl_createBandwidthGroup(req)
       
       return 


   def deleteBandwidthGroup(self, _arg_name):
       req=IBandwidthControl_deleteBandwidthGroupRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IBandwidthControl_deleteBandwidthGroup(req)
       
       return 


   def getBandwidthGroup(self, _arg_name):
       req=IBandwidthControl_getBandwidthGroupRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=self.mgr.getPort().IBandwidthControl_getBandwidthGroup(req)
       
       return IBandwidthGroup(self.mgr,val._returnval)


   def getAllBandwidthGroups(self):
       req=IBandwidthControl_getAllBandwidthGroupsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IBandwidthControl_getAllBandwidthGroups(req)
       
       return IBandwidthGroup(self.mgr,val._returnval, True)


   def getNumGroups(self):
       req=IBandwidthControl_getNumGroupsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBandwidthControl_getNumGroups(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'numGroups':[getNumGroups,None]}

class IEventSource(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IEventSource(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IEventSource._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IEventSource._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def createListener(self):
       req=IEventSource_createListenerRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IEventSource_createListener(req)
       
       return IEventListener(self.mgr,val._returnval)


   def createAggregator(self, _arg_subordinates):
       req=IEventSource_createAggregatorRequestMsg()
       req._this=self.handle
       
       req._subordinates=_arg_subordinates
       val=self.mgr.getPort().IEventSource_createAggregator(req)
       
       return IEventSource(self.mgr,val._returnval)


   def registerListener(self, _arg_listener, _arg_interesting, _arg_active):
       req=IEventSource_registerListenerRequestMsg()
       req._this=self.handle
       
       req._listener=_arg_listener
       req._interesting=_arg_interesting
       req._active=_arg_active
       val=self.mgr.getPort().IEventSource_registerListener(req)
       
       return 


   def unregisterListener(self, _arg_listener):
       req=IEventSource_unregisterListenerRequestMsg()
       req._this=self.handle
       
       req._listener=_arg_listener
       val=self.mgr.getPort().IEventSource_unregisterListener(req)
       
       return 


   def fireEvent(self, _arg_event, _arg_timeout):
       req=IEventSource_fireEventRequestMsg()
       req._this=self.handle
       
       req._event=_arg_event
       req._timeout=_arg_timeout
       val=self.mgr.getPort().IEventSource_fireEvent(req)
       
       return Boolean(self.mgr,val._returnval)


   def getEvent(self, _arg_listener, _arg_timeout):
       req=IEventSource_getEventRequestMsg()
       req._this=self.handle
       
       req._listener=_arg_listener
       req._timeout=_arg_timeout
       val=self.mgr.getPort().IEventSource_getEvent(req)
       
       return IEvent(self.mgr,val._returnval)


   def eventProcessed(self, _arg_listener, _arg_event):
       req=IEventSource_eventProcessedRequestMsg()
       req._this=self.handle
       
       req._listener=_arg_listener
       req._event=_arg_event
       val=self.mgr.getPort().IEventSource_eventProcessed(req)
       
       return 




   _Attrs_={}

class IEventListener(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IEventListener(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IEventListener._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IEventListener._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def handleEvent(self, _arg_event):
       req=IEventListener_handleEventRequestMsg()
       req._this=self.handle
       
       req._event=_arg_event
       val=self.mgr.getPort().IEventListener_handleEvent(req)
       
       return 




   _Attrs_={}

class IEvent(IUnknown):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IUnknown.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def setProcessed(self):
       req=IEvent_setProcessedRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IEvent_setProcessed(req)
       
       return 


   def waitProcessed(self, _arg_timeout):
       req=IEvent_waitProcessedRequestMsg()
       req._this=self.handle
       
       req._timeout=_arg_timeout
       val=self.mgr.getPort().IEvent_waitProcessed(req)
       
       return Boolean(self.mgr,val._returnval)


   def getType(self):
       req=IEvent_getTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IEvent_getType(req)
       return VBoxEventType(self.mgr,val._returnval)
   def getSource(self):
       req=IEvent_getSourceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IEvent_getSource(req)
       return IEventSource(self.mgr,val._returnval)
   def getWaitable(self):
       req=IEvent_getWaitableRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IEvent_getWaitable(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'type':[getType,None],
         'source':[getSource,None],
         'waitable':[getWaitable,None]}

class IReusableEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IReusableEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IReusableEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IReusableEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def reuse(self):
       req=IReusableEvent_reuseRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IReusableEvent_reuse(req)
       
       return 


   def getGeneration(self):
       req=IReusableEvent_getGenerationRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IReusableEvent_getGeneration(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'generation':[getGeneration,None]}

class IMachineEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMachineEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMachineEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMachineEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMachineId(self):
       req=IMachineEvent_getMachineIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineEvent_getMachineId(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'machineId':[getMachineId,None]}

class IMachineStateChangedEvent(IMachineEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMachineStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMachineStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IMachineEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMachineStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getState(self):
       req=IMachineStateChangedEvent_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineStateChangedEvent_getState(req)
       return MachineState(self.mgr,val._returnval)


   _Attrs_={         'state':[getState,None]}

class IMachineDataChangedEvent(IMachineEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMachineDataChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMachineDataChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IMachineEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMachineDataChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getTemporary(self):
       req=IMachineDataChangedEvent_getTemporaryRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineDataChangedEvent_getTemporary(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'temporary':[getTemporary,None]}

class IMediumRegisteredEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMediumRegisteredEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMediumRegisteredEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMediumRegisteredEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMediumId(self):
       req=IMediumRegisteredEvent_getMediumIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMediumRegisteredEvent_getMediumId(req)
       return String(self.mgr,val._returnval)
   def getMediumType(self):
       req=IMediumRegisteredEvent_getMediumTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMediumRegisteredEvent_getMediumType(req)
       return DeviceType(self.mgr,val._returnval)
   def getRegistered(self):
       req=IMediumRegisteredEvent_getRegisteredRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMediumRegisteredEvent_getRegistered(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'mediumId':[getMediumId,None],
         'mediumType':[getMediumType,None],
         'registered':[getRegistered,None]}

class IMediumConfigChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMediumConfigChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMediumConfigChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMediumConfigChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMedium(self):
       req=IMediumConfigChangedEvent_getMediumRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMediumConfigChangedEvent_getMedium(req)
       return IMedium(self.mgr,val._returnval)


   _Attrs_={         'medium':[getMedium,None]}

class IMachineRegisteredEvent(IMachineEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMachineRegisteredEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMachineRegisteredEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IMachineEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMachineRegisteredEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getRegistered(self):
       req=IMachineRegisteredEvent_getRegisteredRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMachineRegisteredEvent_getRegistered(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'registered':[getRegistered,None]}

class ISessionStateChangedEvent(IMachineEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISessionStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISessionStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IMachineEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISessionStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getState(self):
       req=ISessionStateChangedEvent_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISessionStateChangedEvent_getState(req)
       return SessionState(self.mgr,val._returnval)


   _Attrs_={         'state':[getState,None]}

class IGuestPropertyChangedEvent(IMachineEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestPropertyChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestPropertyChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IMachineEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestPropertyChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IGuestPropertyChangedEvent_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestPropertyChangedEvent_getName(req)
       return String(self.mgr,val._returnval)
   def getValue(self):
       req=IGuestPropertyChangedEvent_getValueRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestPropertyChangedEvent_getValue(req)
       return String(self.mgr,val._returnval)
   def getFlags(self):
       req=IGuestPropertyChangedEvent_getFlagsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestPropertyChangedEvent_getFlags(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'name':[getName,None],
         'value':[getValue,None],
         'flags':[getFlags,None]}

class ISnapshotEvent(IMachineEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISnapshotEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISnapshotEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IMachineEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISnapshotEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSnapshotId(self):
       req=ISnapshotEvent_getSnapshotIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshotEvent_getSnapshotId(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'snapshotId':[getSnapshotId,None]}

class ISnapshotTakenEvent(ISnapshotEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISnapshotTakenEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISnapshotTakenEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return ISnapshotEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISnapshotTakenEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=ISnapshotTakenEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshotTakenEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class ISnapshotDeletedEvent(ISnapshotEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISnapshotDeletedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISnapshotDeletedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return ISnapshotEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISnapshotDeletedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=ISnapshotDeletedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshotDeletedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class ISnapshotRestoredEvent(ISnapshotEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISnapshotRestoredEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISnapshotRestoredEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return ISnapshotEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISnapshotRestoredEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=ISnapshotRestoredEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshotRestoredEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class ISnapshotChangedEvent(ISnapshotEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISnapshotChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISnapshotChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return ISnapshotEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISnapshotChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=ISnapshotChangedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISnapshotChangedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IMousePointerShapeChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMousePointerShapeChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMousePointerShapeChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMousePointerShapeChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getVisible(self):
       req=IMousePointerShapeChangedEvent_getVisibleRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShapeChangedEvent_getVisible(req)
       return Boolean(self.mgr,val._returnval)
   def getAlpha(self):
       req=IMousePointerShapeChangedEvent_getAlphaRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShapeChangedEvent_getAlpha(req)
       return Boolean(self.mgr,val._returnval)
   def getXhot(self):
       req=IMousePointerShapeChangedEvent_getXhotRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShapeChangedEvent_getXhot(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getYhot(self):
       req=IMousePointerShapeChangedEvent_getYhotRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShapeChangedEvent_getYhot(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getWidth(self):
       req=IMousePointerShapeChangedEvent_getWidthRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShapeChangedEvent_getWidth(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getHeight(self):
       req=IMousePointerShapeChangedEvent_getHeightRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShapeChangedEvent_getHeight(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getShape(self):
       req=IMousePointerShapeChangedEvent_getShapeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMousePointerShapeChangedEvent_getShape(req)
       return self.mgr.decodebase64(val._returnval)


   _Attrs_={         'visible':[getVisible,None],
         'alpha':[getAlpha,None],
         'xhot':[getXhot,None],
         'yhot':[getYhot,None],
         'width':[getWidth,None],
         'height':[getHeight,None],
         'shape':[getShape,None]}

class IMouseCapabilityChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMouseCapabilityChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMouseCapabilityChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMouseCapabilityChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSupportsAbsolute(self):
       req=IMouseCapabilityChangedEvent_getSupportsAbsoluteRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouseCapabilityChangedEvent_getSupportsAbsolute(req)
       return Boolean(self.mgr,val._returnval)
   def getSupportsRelative(self):
       req=IMouseCapabilityChangedEvent_getSupportsRelativeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouseCapabilityChangedEvent_getSupportsRelative(req)
       return Boolean(self.mgr,val._returnval)
   def getSupportsMultiTouch(self):
       req=IMouseCapabilityChangedEvent_getSupportsMultiTouchRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouseCapabilityChangedEvent_getSupportsMultiTouch(req)
       return Boolean(self.mgr,val._returnval)
   def getNeedsHostCursor(self):
       req=IMouseCapabilityChangedEvent_getNeedsHostCursorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMouseCapabilityChangedEvent_getNeedsHostCursor(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'supportsAbsolute':[getSupportsAbsolute,None],
         'supportsRelative':[getSupportsRelative,None],
         'supportsMultiTouch':[getSupportsMultiTouch,None],
         'needsHostCursor':[getNeedsHostCursor,None]}

class IKeyboardLedsChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IKeyboardLedsChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IKeyboardLedsChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IKeyboardLedsChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getNumLock(self):
       req=IKeyboardLedsChangedEvent_getNumLockRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IKeyboardLedsChangedEvent_getNumLock(req)
       return Boolean(self.mgr,val._returnval)
   def getCapsLock(self):
       req=IKeyboardLedsChangedEvent_getCapsLockRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IKeyboardLedsChangedEvent_getCapsLock(req)
       return Boolean(self.mgr,val._returnval)
   def getScrollLock(self):
       req=IKeyboardLedsChangedEvent_getScrollLockRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IKeyboardLedsChangedEvent_getScrollLock(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'numLock':[getNumLock,None],
         'capsLock':[getCapsLock,None],
         'scrollLock':[getScrollLock,None]}

class IStateChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getState(self):
       req=IStateChangedEvent_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStateChangedEvent_getState(req)
       return MachineState(self.mgr,val._returnval)


   _Attrs_={         'state':[getState,None]}

class IAdditionsStateChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IAdditionsStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IAdditionsStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IAdditionsStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IAdditionsStateChangedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IAdditionsStateChangedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class INetworkAdapterChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INetworkAdapterChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INetworkAdapterChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INetworkAdapterChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getNetworkAdapter(self):
       req=INetworkAdapterChangedEvent_getNetworkAdapterRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INetworkAdapterChangedEvent_getNetworkAdapter(req)
       return INetworkAdapter(self.mgr,val._returnval)


   _Attrs_={         'networkAdapter':[getNetworkAdapter,None]}

class ISerialPortChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISerialPortChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISerialPortChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISerialPortChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSerialPort(self):
       req=ISerialPortChangedEvent_getSerialPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISerialPortChangedEvent_getSerialPort(req)
       return ISerialPort(self.mgr,val._returnval)


   _Attrs_={         'serialPort':[getSerialPort,None]}

class IParallelPortChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IParallelPortChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IParallelPortChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IParallelPortChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getParallelPort(self):
       req=IParallelPortChangedEvent_getParallelPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IParallelPortChangedEvent_getParallelPort(req)
       return IParallelPort(self.mgr,val._returnval)


   _Attrs_={         'parallelPort':[getParallelPort,None]}

class IStorageControllerChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IStorageControllerChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IStorageControllerChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IStorageControllerChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IStorageControllerChangedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageControllerChangedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IMediumChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IMediumChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMediumChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IMediumChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMediumAttachment(self):
       req=IMediumChangedEvent_getMediumAttachmentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IMediumChangedEvent_getMediumAttachment(req)
       return IMediumAttachment(self.mgr,val._returnval)


   _Attrs_={         'mediumAttachment':[getMediumAttachment,None]}

class IClipboardModeChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IClipboardModeChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IClipboardModeChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IClipboardModeChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getClipboardMode(self):
       req=IClipboardModeChangedEvent_getClipboardModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IClipboardModeChangedEvent_getClipboardMode(req)
       return ClipboardMode(self.mgr,val._returnval)


   _Attrs_={         'clipboardMode':[getClipboardMode,None]}

class IDnDModeChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IDnDModeChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDnDModeChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IDnDModeChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getDndMode(self):
       req=IDnDModeChangedEvent_getDndModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IDnDModeChangedEvent_getDndMode(req)
       return DnDMode(self.mgr,val._returnval)


   _Attrs_={         'dndMode':[getDndMode,None]}

class ICPUChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ICPUChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ICPUChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ICPUChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getCPU(self):
       req=ICPUChangedEvent_getCPURequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICPUChangedEvent_getCPU(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getAdd(self):
       req=ICPUChangedEvent_getAddRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICPUChangedEvent_getAdd(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'CPU':[getCPU,None],
         'add':[getAdd,None]}

class ICPUExecutionCapChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ICPUExecutionCapChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ICPUExecutionCapChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ICPUExecutionCapChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getExecutionCap(self):
       req=ICPUExecutionCapChangedEvent_getExecutionCapRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICPUExecutionCapChangedEvent_getExecutionCap(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'executionCap':[getExecutionCap,None]}

class IGuestKeyboardEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestKeyboardEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestKeyboardEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestKeyboardEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getScancodes(self):
       req=IGuestKeyboardEvent_getScancodesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestKeyboardEvent_getScancodes(req)
       return Int(self.mgr,val._returnval, True)


   _Attrs_={         'scancodes':[getScancodes,None]}

class IGuestMouseEvent(IReusableEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestMouseEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestMouseEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IReusableEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestMouseEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMode(self):
       req=IGuestMouseEvent_getModeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMouseEvent_getMode(req)
       return GuestMouseEventMode(self.mgr,val._returnval)
   def getX(self):
       req=IGuestMouseEvent_getXRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMouseEvent_getX(req)
       return Int(self.mgr,val._returnval)
   def getY(self):
       req=IGuestMouseEvent_getYRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMouseEvent_getY(req)
       return Int(self.mgr,val._returnval)
   def getZ(self):
       req=IGuestMouseEvent_getZRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMouseEvent_getZ(req)
       return Int(self.mgr,val._returnval)
   def getW(self):
       req=IGuestMouseEvent_getWRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMouseEvent_getW(req)
       return Int(self.mgr,val._returnval)
   def getButtons(self):
       req=IGuestMouseEvent_getButtonsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMouseEvent_getButtons(req)
       return Int(self.mgr,val._returnval)


   _Attrs_={         'mode':[getMode,None],
         'x':[getX,None],
         'y':[getY,None],
         'z':[getZ,None],
         'w':[getW,None],
         'buttons':[getButtons,None]}

class IGuestMultiTouchEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestMultiTouchEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestMultiTouchEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestMultiTouchEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getContactCount(self):
       req=IGuestMultiTouchEvent_getContactCountRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMultiTouchEvent_getContactCount(req)
       return Int(self.mgr,val._returnval)
   def getXPositions(self):
       req=IGuestMultiTouchEvent_getXPositionsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMultiTouchEvent_getXPositions(req)
       return Short(self.mgr,val._returnval, True)
   def getYPositions(self):
       req=IGuestMultiTouchEvent_getYPositionsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMultiTouchEvent_getYPositions(req)
       return Short(self.mgr,val._returnval, True)
   def getContactIds(self):
       req=IGuestMultiTouchEvent_getContactIdsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMultiTouchEvent_getContactIds(req)
       return UnsignedShort(self.mgr,val._returnval, True)
   def getContactFlags(self):
       req=IGuestMultiTouchEvent_getContactFlagsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMultiTouchEvent_getContactFlags(req)
       return UnsignedShort(self.mgr,val._returnval, True)
   def getScanTime(self):
       req=IGuestMultiTouchEvent_getScanTimeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMultiTouchEvent_getScanTime(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'contactCount':[getContactCount,None],
         'xPositions':[getXPositions,None],
         'yPositions':[getYPositions,None],
         'contactIds':[getContactIds,None],
         'contactFlags':[getContactFlags,None],
         'scanTime':[getScanTime,None]}

class IGuestSessionEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestSessionEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestSessionEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestSessionEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSession(self):
       req=IGuestSessionEvent_getSessionRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSessionEvent_getSession(req)
       return IGuestSession(self.mgr,val._returnval)


   _Attrs_={         'session':[getSession,None]}

class IGuestSessionStateChangedEvent(IGuestSessionEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestSessionStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestSessionStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestSessionEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestSessionStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getId(self):
       req=IGuestSessionStateChangedEvent_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSessionStateChangedEvent_getId(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getStatus(self):
       req=IGuestSessionStateChangedEvent_getStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSessionStateChangedEvent_getStatus(req)
       return GuestSessionStatus(self.mgr,val._returnval)
   def getError(self):
       req=IGuestSessionStateChangedEvent_getErrorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSessionStateChangedEvent_getError(req)
       return IVirtualBoxErrorInfo(self.mgr,val._returnval)


   _Attrs_={         'id':[getId,None],
         'status':[getStatus,None],
         'error':[getError,None]}

class IGuestSessionRegisteredEvent(IGuestSessionEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestSessionRegisteredEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestSessionRegisteredEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestSessionEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestSessionRegisteredEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getRegistered(self):
       req=IGuestSessionRegisteredEvent_getRegisteredRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestSessionRegisteredEvent_getRegistered(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'registered':[getRegistered,None]}

class IGuestProcessEvent(IGuestSessionEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestProcessEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestProcessEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestSessionEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestProcessEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getProcess(self):
       req=IGuestProcessEvent_getProcessRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessEvent_getProcess(req)
       return IGuestProcess(self.mgr,val._returnval)
   def getPid(self):
       req=IGuestProcessEvent_getPidRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessEvent_getPid(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'process':[getProcess,None],
         'pid':[getPid,None]}

class IGuestProcessRegisteredEvent(IGuestProcessEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestProcessRegisteredEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestProcessRegisteredEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestProcessEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestProcessRegisteredEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getRegistered(self):
       req=IGuestProcessRegisteredEvent_getRegisteredRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessRegisteredEvent_getRegistered(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'registered':[getRegistered,None]}

class IGuestProcessStateChangedEvent(IGuestProcessEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestProcessStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestProcessStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestProcessEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestProcessStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getStatus(self):
       req=IGuestProcessStateChangedEvent_getStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessStateChangedEvent_getStatus(req)
       return ProcessStatus(self.mgr,val._returnval)
   def getError(self):
       req=IGuestProcessStateChangedEvent_getErrorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessStateChangedEvent_getError(req)
       return IVirtualBoxErrorInfo(self.mgr,val._returnval)


   _Attrs_={         'status':[getStatus,None],
         'error':[getError,None]}

class IGuestProcessIOEvent(IGuestProcessEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestProcessIOEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestProcessIOEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestProcessEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestProcessIOEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getHandle(self):
       req=IGuestProcessIOEvent_getHandleRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessIOEvent_getHandle(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getProcessed(self):
       req=IGuestProcessIOEvent_getProcessedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessIOEvent_getProcessed(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'handle':[getHandle,None],
         'processed':[getProcessed,None]}

class IGuestProcessInputNotifyEvent(IGuestProcessIOEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestProcessInputNotifyEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestProcessInputNotifyEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestProcessIOEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestProcessInputNotifyEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getStatus(self):
       req=IGuestProcessInputNotifyEvent_getStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessInputNotifyEvent_getStatus(req)
       return ProcessInputStatus(self.mgr,val._returnval)


   _Attrs_={         'status':[getStatus,None]}

class IGuestProcessOutputEvent(IGuestProcessIOEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestProcessOutputEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestProcessOutputEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestProcessIOEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestProcessOutputEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getData(self):
       req=IGuestProcessOutputEvent_getDataRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestProcessOutputEvent_getData(req)
       return self.mgr.decodebase64(val._returnval)


   _Attrs_={         'data':[getData,None]}

class IGuestFileEvent(IGuestSessionEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFileEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFileEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestSessionEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFileEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getFile(self):
       req=IGuestFileEvent_getFileRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileEvent_getFile(req)
       return IGuestFile(self.mgr,val._returnval)


   _Attrs_={         'file':[getFile,None]}

class IGuestFileRegisteredEvent(IGuestFileEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFileRegisteredEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFileRegisteredEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestFileEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFileRegisteredEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getRegistered(self):
       req=IGuestFileRegisteredEvent_getRegisteredRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileRegisteredEvent_getRegistered(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'registered':[getRegistered,None]}

class IGuestFileStateChangedEvent(IGuestFileEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFileStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFileStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestFileEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFileStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getStatus(self):
       req=IGuestFileStateChangedEvent_getStatusRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileStateChangedEvent_getStatus(req)
       return FileStatus(self.mgr,val._returnval)
   def getError(self):
       req=IGuestFileStateChangedEvent_getErrorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileStateChangedEvent_getError(req)
       return IVirtualBoxErrorInfo(self.mgr,val._returnval)


   _Attrs_={         'status':[getStatus,None],
         'error':[getError,None]}

class IGuestFileIOEvent(IGuestFileEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFileIOEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFileIOEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestFileEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFileIOEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getOffset(self):
       req=IGuestFileIOEvent_getOffsetRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileIOEvent_getOffset(req)
       return Long(self.mgr,val._returnval)
   def getProcessed(self):
       req=IGuestFileIOEvent_getProcessedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileIOEvent_getProcessed(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'offset':[getOffset,None],
         'processed':[getProcessed,None]}

class IGuestFileOffsetChangedEvent(IGuestFileIOEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFileOffsetChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFileOffsetChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestFileIOEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFileOffsetChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IGuestFileOffsetChangedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileOffsetChangedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IGuestFileReadEvent(IGuestFileIOEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFileReadEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFileReadEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestFileIOEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFileReadEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getData(self):
       req=IGuestFileReadEvent_getDataRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileReadEvent_getData(req)
       return self.mgr.decodebase64(val._returnval)


   _Attrs_={         'data':[getData,None]}

class IGuestFileWriteEvent(IGuestFileIOEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestFileWriteEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestFileWriteEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IGuestFileIOEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestFileWriteEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IGuestFileWriteEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestFileWriteEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IVRDEServerChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVRDEServerChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVRDEServerChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVRDEServerChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IVRDEServerChangedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServerChangedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IVRDEServerInfoChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVRDEServerInfoChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVRDEServerInfoChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVRDEServerInfoChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IVRDEServerInfoChangedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVRDEServerInfoChangedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IVideoCaptureChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVideoCaptureChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVideoCaptureChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVideoCaptureChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IVideoCaptureChangedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVideoCaptureChangedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IUSBControllerChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IUSBControllerChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBControllerChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IUSBControllerChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IUSBControllerChangedEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBControllerChangedEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IUSBDeviceStateChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IUSBDeviceStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBDeviceStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IUSBDeviceStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getDevice(self):
       req=IUSBDeviceStateChangedEvent_getDeviceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceStateChangedEvent_getDevice(req)
       return IUSBDevice(self.mgr,val._returnval)
   def getAttached(self):
       req=IUSBDeviceStateChangedEvent_getAttachedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceStateChangedEvent_getAttached(req)
       return Boolean(self.mgr,val._returnval)
   def getError(self):
       req=IUSBDeviceStateChangedEvent_getErrorRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IUSBDeviceStateChangedEvent_getError(req)
       return IVirtualBoxErrorInfo(self.mgr,val._returnval)


   _Attrs_={         'device':[getDevice,None],
         'attached':[getAttached,None],
         'error':[getError,None]}

class ISharedFolderChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ISharedFolderChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISharedFolderChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ISharedFolderChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getScope(self):
       req=ISharedFolderChangedEvent_getScopeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ISharedFolderChangedEvent_getScope(req)
       return Scope(self.mgr,val._returnval)


   _Attrs_={         'scope':[getScope,None]}

class IRuntimeErrorEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IRuntimeErrorEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IRuntimeErrorEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IRuntimeErrorEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getFatal(self):
       req=IRuntimeErrorEvent_getFatalRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IRuntimeErrorEvent_getFatal(req)
       return Boolean(self.mgr,val._returnval)
   def getId(self):
       req=IRuntimeErrorEvent_getIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IRuntimeErrorEvent_getId(req)
       return String(self.mgr,val._returnval)
   def getMessage(self):
       req=IRuntimeErrorEvent_getMessageRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IRuntimeErrorEvent_getMessage(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'fatal':[getFatal,None],
         'id':[getId,None],
         'message':[getMessage,None]}

class IEventSourceChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IEventSourceChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IEventSourceChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IEventSourceChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getListener(self):
       req=IEventSourceChangedEvent_getListenerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IEventSourceChangedEvent_getListener(req)
       return IEventListener(self.mgr,val._returnval)
   def getAdd(self):
       req=IEventSourceChangedEvent_getAddRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IEventSourceChangedEvent_getAdd(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'listener':[getListener,None],
         'add':[getAdd,None]}

class IExtraDataChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IExtraDataChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IExtraDataChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IExtraDataChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMachineId(self):
       req=IExtraDataChangedEvent_getMachineIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IExtraDataChangedEvent_getMachineId(req)
       return String(self.mgr,val._returnval)
   def getKey(self):
       req=IExtraDataChangedEvent_getKeyRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IExtraDataChangedEvent_getKey(req)
       return String(self.mgr,val._returnval)
   def getValue(self):
       req=IExtraDataChangedEvent_getValueRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IExtraDataChangedEvent_getValue(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'machineId':[getMachineId,None],
         'key':[getKey,None],
         'value':[getValue,None]}

class IVetoEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVetoEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVetoEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVetoEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def addVeto(self, _arg_reason):
       req=IVetoEvent_addVetoRequestMsg()
       req._this=self.handle
       
       req._reason=_arg_reason
       val=self.mgr.getPort().IVetoEvent_addVeto(req)
       
       return 


   def isVetoed(self):
       req=IVetoEvent_isVetoedRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVetoEvent_isVetoed(req)
       
       return Boolean(self.mgr,val._returnval)


   def getVetos(self):
       req=IVetoEvent_getVetosRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVetoEvent_getVetos(req)
       
       return String(self.mgr,val._returnval, True)


   def addApproval(self, _arg_reason):
       req=IVetoEvent_addApprovalRequestMsg()
       req._this=self.handle
       
       req._reason=_arg_reason
       val=self.mgr.getPort().IVetoEvent_addApproval(req)
       
       return 


   def isApproved(self):
       req=IVetoEvent_isApprovedRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVetoEvent_isApproved(req)
       
       return Boolean(self.mgr,val._returnval)


   def getApprovals(self):
       req=IVetoEvent_getApprovalsRequestMsg()
       req._this=self.handle
       
       val=self.mgr.getPort().IVetoEvent_getApprovals(req)
       
       return String(self.mgr,val._returnval, True)




   _Attrs_={}

class IExtraDataCanChangeEvent(IVetoEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IExtraDataCanChangeEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IExtraDataCanChangeEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IVetoEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IExtraDataCanChangeEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMachineId(self):
       req=IExtraDataCanChangeEvent_getMachineIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IExtraDataCanChangeEvent_getMachineId(req)
       return String(self.mgr,val._returnval)
   def getKey(self):
       req=IExtraDataCanChangeEvent_getKeyRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IExtraDataCanChangeEvent_getKey(req)
       return String(self.mgr,val._returnval)
   def getValue(self):
       req=IExtraDataCanChangeEvent_getValueRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IExtraDataCanChangeEvent_getValue(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'machineId':[getMachineId,None],
         'key':[getKey,None],
         'value':[getValue,None]}

class ICanShowWindowEvent(IVetoEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return ICanShowWindowEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ICanShowWindowEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IVetoEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = ICanShowWindowEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=ICanShowWindowEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().ICanShowWindowEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class IShowWindowEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IShowWindowEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IShowWindowEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IShowWindowEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getWinId(self):
       req=IShowWindowEvent_getWinIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IShowWindowEvent_getWinId(req)
       return Long(self.mgr,val._returnval)
   def setWinId(self, value):
       req=IShowWindowEvent_setWinIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring, str]:
            req._winId = value
       else:
            req._winId = value.handle
       self.mgr.getPort().IShowWindowEvent_setWinId(req)



   _Attrs_={         'winId':[getWinId,setWinId,
        ]}

class INATRedirectEvent(IMachineEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATRedirectEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATRedirectEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IMachineEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATRedirectEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSlot(self):
       req=INATRedirectEvent_getSlotRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATRedirectEvent_getSlot(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getRemove(self):
       req=INATRedirectEvent_getRemoveRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATRedirectEvent_getRemove(req)
       return Boolean(self.mgr,val._returnval)
   def getName(self):
       req=INATRedirectEvent_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATRedirectEvent_getName(req)
       return String(self.mgr,val._returnval)
   def getProto(self):
       req=INATRedirectEvent_getProtoRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATRedirectEvent_getProto(req)
       return NATProtocol(self.mgr,val._returnval)
   def getHostIP(self):
       req=INATRedirectEvent_getHostIPRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATRedirectEvent_getHostIP(req)
       return String(self.mgr,val._returnval)
   def getHostPort(self):
       req=INATRedirectEvent_getHostPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATRedirectEvent_getHostPort(req)
       return Int(self.mgr,val._returnval)
   def getGuestIP(self):
       req=INATRedirectEvent_getGuestIPRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATRedirectEvent_getGuestIP(req)
       return String(self.mgr,val._returnval)
   def getGuestPort(self):
       req=INATRedirectEvent_getGuestPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATRedirectEvent_getGuestPort(req)
       return Int(self.mgr,val._returnval)


   _Attrs_={         'slot':[getSlot,None],
         'remove':[getRemove,None],
         'name':[getName,None],
         'proto':[getProto,None],
         'hostIP':[getHostIP,None],
         'hostPort':[getHostPort,None],
         'guestIP':[getGuestIP,None],
         'guestPort':[getGuestPort,None]}

class IHostPCIDevicePlugEvent(IMachineEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IHostPCIDevicePlugEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostPCIDevicePlugEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IMachineEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IHostPCIDevicePlugEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getPlugged(self):
       req=IHostPCIDevicePlugEvent_getPluggedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostPCIDevicePlugEvent_getPlugged(req)
       return Boolean(self.mgr,val._returnval)
   def getSuccess(self):
       req=IHostPCIDevicePlugEvent_getSuccessRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostPCIDevicePlugEvent_getSuccess(req)
       return Boolean(self.mgr,val._returnval)
   def getAttachment(self):
       req=IHostPCIDevicePlugEvent_getAttachmentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostPCIDevicePlugEvent_getAttachment(req)
       return IPCIDeviceAttachment(self.mgr,val._returnval)
   def getMessage(self):
       req=IHostPCIDevicePlugEvent_getMessageRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostPCIDevicePlugEvent_getMessage(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'plugged':[getPlugged,None],
         'success':[getSuccess,None],
         'attachment':[getAttachment,None],
         'message':[getMessage,None]}

class IVBoxSVCAvailabilityChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IVBoxSVCAvailabilityChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVBoxSVCAvailabilityChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IVBoxSVCAvailabilityChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getAvailable(self):
       req=IVBoxSVCAvailabilityChangedEvent_getAvailableRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IVBoxSVCAvailabilityChangedEvent_getAvailable(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'available':[getAvailable,None]}

class IBandwidthGroupChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IBandwidthGroupChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IBandwidthGroupChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IBandwidthGroupChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getBandwidthGroup(self):
       req=IBandwidthGroupChangedEvent_getBandwidthGroupRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IBandwidthGroupChangedEvent_getBandwidthGroup(req)
       return IBandwidthGroup(self.mgr,val._returnval)


   _Attrs_={         'bandwidthGroup':[getBandwidthGroup,None]}

class IGuestMonitorChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestMonitorChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestMonitorChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestMonitorChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getChangeType(self):
       req=IGuestMonitorChangedEvent_getChangeTypeRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMonitorChangedEvent_getChangeType(req)
       return GuestMonitorChangedEventType(self.mgr,val._returnval)
   def getScreenId(self):
       req=IGuestMonitorChangedEvent_getScreenIdRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMonitorChangedEvent_getScreenId(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getOriginX(self):
       req=IGuestMonitorChangedEvent_getOriginXRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMonitorChangedEvent_getOriginX(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getOriginY(self):
       req=IGuestMonitorChangedEvent_getOriginYRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMonitorChangedEvent_getOriginY(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getWidth(self):
       req=IGuestMonitorChangedEvent_getWidthRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMonitorChangedEvent_getWidth(req)
       return UnsignedInt(self.mgr,val._returnval)
   def getHeight(self):
       req=IGuestMonitorChangedEvent_getHeightRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestMonitorChangedEvent_getHeight(req)
       return UnsignedInt(self.mgr,val._returnval)


   _Attrs_={         'changeType':[getChangeType,None],
         'screenId':[getScreenId,None],
         'originX':[getOriginX,None],
         'originY':[getOriginY,None],
         'width':[getWidth,None],
         'height':[getHeight,None]}

class IGuestUserStateChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IGuestUserStateChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IGuestUserStateChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IGuestUserStateChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IGuestUserStateChangedEvent_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestUserStateChangedEvent_getName(req)
       return String(self.mgr,val._returnval)
   def getDomain(self):
       req=IGuestUserStateChangedEvent_getDomainRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestUserStateChangedEvent_getDomain(req)
       return String(self.mgr,val._returnval)
   def getState(self):
       req=IGuestUserStateChangedEvent_getStateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestUserStateChangedEvent_getState(req)
       return GuestUserState(self.mgr,val._returnval)
   def getStateDetails(self):
       req=IGuestUserStateChangedEvent_getStateDetailsRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IGuestUserStateChangedEvent_getStateDetails(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'name':[getName,None],
         'domain':[getDomain,None],
         'state':[getState,None],
         'stateDetails':[getStateDetails,None]}

class IStorageDeviceChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IStorageDeviceChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IStorageDeviceChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IStorageDeviceChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getStorageDevice(self):
       req=IStorageDeviceChangedEvent_getStorageDeviceRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageDeviceChangedEvent_getStorageDevice(req)
       return IMediumAttachment(self.mgr,val._returnval)
   def getRemoved(self):
       req=IStorageDeviceChangedEvent_getRemovedRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageDeviceChangedEvent_getRemoved(req)
       return Boolean(self.mgr,val._returnval)
   def getSilent(self):
       req=IStorageDeviceChangedEvent_getSilentRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IStorageDeviceChangedEvent_getSilent(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'storageDevice':[getStorageDevice,None],
         'removed':[getRemoved,None],
         'silent':[getSilent,None]}

class INATNetworkChangedEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATNetworkChangedEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATNetworkChangedEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATNetworkChangedEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getNetworkName(self):
       req=INATNetworkChangedEvent_getNetworkNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkChangedEvent_getNetworkName(req)
       return String(self.mgr,val._returnval)


   _Attrs_={         'networkName':[getNetworkName,None]}

class INATNetworkStartStopEvent(INATNetworkChangedEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATNetworkStartStopEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATNetworkStartStopEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return INATNetworkChangedEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATNetworkStartStopEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getStartEvent(self):
       req=INATNetworkStartStopEvent_getStartEventRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkStartStopEvent_getStartEvent(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'startEvent':[getStartEvent,None]}

class INATNetworkAlterEvent(INATNetworkChangedEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATNetworkAlterEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATNetworkAlterEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return INATNetworkChangedEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATNetworkAlterEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=INATNetworkAlterEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkAlterEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}

class INATNetworkCreationDeletionEvent(INATNetworkAlterEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATNetworkCreationDeletionEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATNetworkCreationDeletionEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return INATNetworkAlterEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATNetworkCreationDeletionEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getCreationEvent(self):
       req=INATNetworkCreationDeletionEvent_getCreationEventRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkCreationDeletionEvent_getCreationEvent(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'creationEvent':[getCreationEvent,None]}

class INATNetworkSettingEvent(INATNetworkAlterEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATNetworkSettingEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATNetworkSettingEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return INATNetworkAlterEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATNetworkSettingEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getEnabled(self):
       req=INATNetworkSettingEvent_getEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkSettingEvent_getEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def getNetwork(self):
       req=INATNetworkSettingEvent_getNetworkRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkSettingEvent_getNetwork(req)
       return String(self.mgr,val._returnval)
   def getGateway(self):
       req=INATNetworkSettingEvent_getGatewayRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkSettingEvent_getGateway(req)
       return String(self.mgr,val._returnval)
   def getAdvertiseDefaultIPv6RouteEnabled(self):
       req=INATNetworkSettingEvent_getAdvertiseDefaultIPv6RouteEnabledRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkSettingEvent_getAdvertiseDefaultIPv6RouteEnabled(req)
       return Boolean(self.mgr,val._returnval)
   def getNeedDhcpServer(self):
       req=INATNetworkSettingEvent_getNeedDhcpServerRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkSettingEvent_getNeedDhcpServer(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'enabled':[getEnabled,None],
         'network':[getNetwork,None],
         'gateway':[getGateway,None],
         'advertiseDefaultIPv6RouteEnabled':[getAdvertiseDefaultIPv6RouteEnabled,None],
         'needDhcpServer':[getNeedDhcpServer,None]}

class INATNetworkPortForwardEvent(INATNetworkAlterEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return INATNetworkPortForwardEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INATNetworkPortForwardEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return INATNetworkAlterEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = INATNetworkPortForwardEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getCreate(self):
       req=INATNetworkPortForwardEvent_getCreateRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkPortForwardEvent_getCreate(req)
       return Boolean(self.mgr,val._returnval)
   def getIpv6(self):
       req=INATNetworkPortForwardEvent_getIpv6RequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkPortForwardEvent_getIpv6(req)
       return Boolean(self.mgr,val._returnval)
   def getName(self):
       req=INATNetworkPortForwardEvent_getNameRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkPortForwardEvent_getName(req)
       return String(self.mgr,val._returnval)
   def getProto(self):
       req=INATNetworkPortForwardEvent_getProtoRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkPortForwardEvent_getProto(req)
       return NATProtocol(self.mgr,val._returnval)
   def getHostIp(self):
       req=INATNetworkPortForwardEvent_getHostIpRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkPortForwardEvent_getHostIp(req)
       return String(self.mgr,val._returnval)
   def getHostPort(self):
       req=INATNetworkPortForwardEvent_getHostPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkPortForwardEvent_getHostPort(req)
       return Int(self.mgr,val._returnval)
   def getGuestIp(self):
       req=INATNetworkPortForwardEvent_getGuestIpRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkPortForwardEvent_getGuestIp(req)
       return String(self.mgr,val._returnval)
   def getGuestPort(self):
       req=INATNetworkPortForwardEvent_getGuestPortRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().INATNetworkPortForwardEvent_getGuestPort(req)
       return Int(self.mgr,val._returnval)


   _Attrs_={         'create':[getCreate,None],
         'ipv6':[getIpv6,None],
         'name':[getName,None],
         'proto':[getProto,None],
         'hostIp':[getHostIp,None],
         'hostPort':[getHostPort,None],
         'guestIp':[getGuestIp,None],
         'guestPort':[getGuestPort,None]}

class IHostNameResolutionConfigurationChangeEvent(IEvent):
   def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       if handle is None:
           raise Exception("bad handle: "+str(handle))
       self.handle = handle
       self.isarray = isarray
       if self.isarray:
           for strHnd in handle:
               mgr.register(strHnd)
       else:
           mgr.register(self.handle)

   def __del__(self):
       self.releaseRemote()

   def releaseRemote(self):
        try:
            if self.handle is not None:
               if self.isarray:
                   for strHnd in self.handle:
                       self.mgr.unregister(strHnd)
               else:
                   self.mgr.unregister(self.handle)
               self.handle = None;
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

   def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

   def __getitem__(self, index):
      if self.isarray:
          return IHostNameResolutionConfigurationChangeEvent(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")

   def __str__(self):
        if self.isarray:
            return str(self.handle)
        else:
            return self.handle

   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostNameResolutionConfigurationChangeEvent._Attrs_.get(name, None)
      if hndl != None:
         if hndl[0] != None:
           return hndl[0](self)
         else:
          raise AttributeError
      else:
         return IEvent.__getattr__(self, name)

   def __setattr__(self, name, val):
      hndl = IHostNameResolutionConfigurationChangeEvent._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMidlDoesNotLikeEmptyInterfaces(self):
       req=IHostNameResolutionConfigurationChangeEvent_getMidlDoesNotLikeEmptyInterfacesRequestMsg()
       req._this=self.handle
       val=self.mgr.getPort().IHostNameResolutionConfigurationChangeEvent_getMidlDoesNotLikeEmptyInterfaces(req)
       return Boolean(self.mgr,val._returnval)


   _Attrs_={         'midlDoesNotLikeEmptyInterfaces':[getMidlDoesNotLikeEmptyInterfaces,None]}
class IPCIDeviceAttachment:
    def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       self.isarray = isarray
       if isarray:
          self.handle = handle
       else:

          self.name = String(self.mgr, handle._name)
       
          self.isPhysicalDevice = Boolean(self.mgr, handle._isPhysicalDevice)
       
          self.hostAddress = Int(self.mgr, handle._hostAddress)
       
          self.guestAddress = Int(self.mgr, handle._guestAddress)
       
          pass

   
    def getName(self):
       return self.name

    def setName(self):
       raise Error('setters not supported')
    
    def getIsPhysicalDevice(self):
       return self.isPhysicalDevice

    def setIsPhysicalDevice(self):
       raise Error('setters not supported')
    
    def getHostAddress(self):
       return self.hostAddress

    def setHostAddress(self):
       raise Error('setters not supported')
    
    def getGuestAddress(self):
       return self.guestAddress

    def setGuestAddress(self):
       raise Error('setters not supported')
    

    def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

    def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

    def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

    def __getitem__(self, index):
      if self.isarray:
          return IPCIDeviceAttachment(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")


class IVRDEServerInfo:
    def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       self.isarray = isarray
       if isarray:
          self.handle = handle
       else:

          self.active = Boolean(self.mgr, handle._active)
       
          self.port = Int(self.mgr, handle._port)
       
          self.numberOfClients = UnsignedInt(self.mgr, handle._numberOfClients)
       
          self.beginTime = Long(self.mgr, handle._beginTime)
       
          self.endTime = Long(self.mgr, handle._endTime)
       
          self.bytesSent = Long(self.mgr, handle._bytesSent)
       
          self.bytesSentTotal = Long(self.mgr, handle._bytesSentTotal)
       
          self.bytesReceived = Long(self.mgr, handle._bytesReceived)
       
          self.bytesReceivedTotal = Long(self.mgr, handle._bytesReceivedTotal)
       
          self.user = String(self.mgr, handle._user)
       
          self.domain = String(self.mgr, handle._domain)
       
          self.clientName = String(self.mgr, handle._clientName)
       
          self.clientIP = String(self.mgr, handle._clientIP)
       
          self.clientVersion = UnsignedInt(self.mgr, handle._clientVersion)
       
          self.encryptionStyle = UnsignedInt(self.mgr, handle._encryptionStyle)
       
          pass

   
    def getActive(self):
       return self.active

    def setActive(self):
       raise Error('setters not supported')
    
    def getPort(self):
       return self.port

    def setPort(self):
       raise Error('setters not supported')
    
    def getNumberOfClients(self):
       return self.numberOfClients

    def setNumberOfClients(self):
       raise Error('setters not supported')
    
    def getBeginTime(self):
       return self.beginTime

    def setBeginTime(self):
       raise Error('setters not supported')
    
    def getEndTime(self):
       return self.endTime

    def setEndTime(self):
       raise Error('setters not supported')
    
    def getBytesSent(self):
       return self.bytesSent

    def setBytesSent(self):
       raise Error('setters not supported')
    
    def getBytesSentTotal(self):
       return self.bytesSentTotal

    def setBytesSentTotal(self):
       raise Error('setters not supported')
    
    def getBytesReceived(self):
       return self.bytesReceived

    def setBytesReceived(self):
       raise Error('setters not supported')
    
    def getBytesReceivedTotal(self):
       return self.bytesReceivedTotal

    def setBytesReceivedTotal(self):
       raise Error('setters not supported')
    
    def getUser(self):
       return self.user

    def setUser(self):
       raise Error('setters not supported')
    
    def getDomain(self):
       return self.domain

    def setDomain(self):
       raise Error('setters not supported')
    
    def getClientName(self):
       return self.clientName

    def setClientName(self):
       raise Error('setters not supported')
    
    def getClientIP(self):
       return self.clientIP

    def setClientIP(self):
       raise Error('setters not supported')
    
    def getClientVersion(self):
       return self.clientVersion

    def setClientVersion(self):
       raise Error('setters not supported')
    
    def getEncryptionStyle(self):
       return self.encryptionStyle

    def setEncryptionStyle(self):
       raise Error('setters not supported')
    

    def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

    def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

    def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

    def __getitem__(self, index):
      if self.isarray:
          return IVRDEServerInfo(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")


class IGuestOSType:
    def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       self.isarray = isarray
       if isarray:
          self.handle = handle
       else:

          self.familyId = String(self.mgr, handle._familyId)
       
          self.familyDescription = String(self.mgr, handle._familyDescription)
       
          self.id = String(self.mgr, handle._id)
       
          self.description = String(self.mgr, handle._description)
       
          self.is64Bit = Boolean(self.mgr, handle._is64Bit)
       
          self.recommendedIOAPIC = Boolean(self.mgr, handle._recommendedIOAPIC)
       
          self.recommendedVirtEx = Boolean(self.mgr, handle._recommendedVirtEx)
       
          self.recommendedRAM = UnsignedInt(self.mgr, handle._recommendedRAM)
       
          self.recommendedVRAM = UnsignedInt(self.mgr, handle._recommendedVRAM)
       
          self.recommended2DVideoAcceleration = Boolean(self.mgr, handle._recommended2DVideoAcceleration)
       
          self.recommended3DAcceleration = Boolean(self.mgr, handle._recommended3DAcceleration)
       
          self.recommendedHDD = Long(self.mgr, handle._recommendedHDD)
       
          self.adapterType = NetworkAdapterType(self.mgr, handle._adapterType)
       
          self.recommendedPAE = Boolean(self.mgr, handle._recommendedPAE)
       
          self.recommendedDVDStorageController = StorageControllerType(self.mgr, handle._recommendedDVDStorageController)
       
          self.recommendedDVDStorageBus = StorageBus(self.mgr, handle._recommendedDVDStorageBus)
       
          self.recommendedHDStorageController = StorageControllerType(self.mgr, handle._recommendedHDStorageController)
       
          self.recommendedHDStorageBus = StorageBus(self.mgr, handle._recommendedHDStorageBus)
       
          self.recommendedFirmware = FirmwareType(self.mgr, handle._recommendedFirmware)
       
          self.recommendedUSBHID = Boolean(self.mgr, handle._recommendedUSBHID)
       
          self.recommendedHPET = Boolean(self.mgr, handle._recommendedHPET)
       
          self.recommendedUSBTablet = Boolean(self.mgr, handle._recommendedUSBTablet)
       
          self.recommendedRTCUseUTC = Boolean(self.mgr, handle._recommendedRTCUseUTC)
       
          self.recommendedChipset = ChipsetType(self.mgr, handle._recommendedChipset)
       
          self.recommendedAudioController = AudioControllerType(self.mgr, handle._recommendedAudioController)
       
          self.recommendedAudioCodec = AudioCodecType(self.mgr, handle._recommendedAudioCodec)
       
          self.recommendedFloppy = Boolean(self.mgr, handle._recommendedFloppy)
       
          self.recommendedUSB = Boolean(self.mgr, handle._recommendedUSB)
       
          self.recommendedUSB3 = Boolean(self.mgr, handle._recommendedUSB3)
       
          self.recommendedTFReset = Boolean(self.mgr, handle._recommendedTFReset)
       
          self.recommendedX2APIC = Boolean(self.mgr, handle._recommendedX2APIC)
       
          pass

   
    def getFamilyId(self):
       return self.familyId

    def setFamilyId(self):
       raise Error('setters not supported')
    
    def getFamilyDescription(self):
       return self.familyDescription

    def setFamilyDescription(self):
       raise Error('setters not supported')
    
    def getId(self):
       return self.id

    def setId(self):
       raise Error('setters not supported')
    
    def getDescription(self):
       return self.description

    def setDescription(self):
       raise Error('setters not supported')
    
    def getIs64Bit(self):
       return self.is64Bit

    def setIs64Bit(self):
       raise Error('setters not supported')
    
    def getRecommendedIOAPIC(self):
       return self.recommendedIOAPIC

    def setRecommendedIOAPIC(self):
       raise Error('setters not supported')
    
    def getRecommendedVirtEx(self):
       return self.recommendedVirtEx

    def setRecommendedVirtEx(self):
       raise Error('setters not supported')
    
    def getRecommendedRAM(self):
       return self.recommendedRAM

    def setRecommendedRAM(self):
       raise Error('setters not supported')
    
    def getRecommendedVRAM(self):
       return self.recommendedVRAM

    def setRecommendedVRAM(self):
       raise Error('setters not supported')
    
    def getRecommended2DVideoAcceleration(self):
       return self.recommended2DVideoAcceleration

    def setRecommended2DVideoAcceleration(self):
       raise Error('setters not supported')
    
    def getRecommended3DAcceleration(self):
       return self.recommended3DAcceleration

    def setRecommended3DAcceleration(self):
       raise Error('setters not supported')
    
    def getRecommendedHDD(self):
       return self.recommendedHDD

    def setRecommendedHDD(self):
       raise Error('setters not supported')
    
    def getAdapterType(self):
       return self.adapterType

    def setAdapterType(self):
       raise Error('setters not supported')
    
    def getRecommendedPAE(self):
       return self.recommendedPAE

    def setRecommendedPAE(self):
       raise Error('setters not supported')
    
    def getRecommendedDVDStorageController(self):
       return self.recommendedDVDStorageController

    def setRecommendedDVDStorageController(self):
       raise Error('setters not supported')
    
    def getRecommendedDVDStorageBus(self):
       return self.recommendedDVDStorageBus

    def setRecommendedDVDStorageBus(self):
       raise Error('setters not supported')
    
    def getRecommendedHDStorageController(self):
       return self.recommendedHDStorageController

    def setRecommendedHDStorageController(self):
       raise Error('setters not supported')
    
    def getRecommendedHDStorageBus(self):
       return self.recommendedHDStorageBus

    def setRecommendedHDStorageBus(self):
       raise Error('setters not supported')
    
    def getRecommendedFirmware(self):
       return self.recommendedFirmware

    def setRecommendedFirmware(self):
       raise Error('setters not supported')
    
    def getRecommendedUSBHID(self):
       return self.recommendedUSBHID

    def setRecommendedUSBHID(self):
       raise Error('setters not supported')
    
    def getRecommendedHPET(self):
       return self.recommendedHPET

    def setRecommendedHPET(self):
       raise Error('setters not supported')
    
    def getRecommendedUSBTablet(self):
       return self.recommendedUSBTablet

    def setRecommendedUSBTablet(self):
       raise Error('setters not supported')
    
    def getRecommendedRTCUseUTC(self):
       return self.recommendedRTCUseUTC

    def setRecommendedRTCUseUTC(self):
       raise Error('setters not supported')
    
    def getRecommendedChipset(self):
       return self.recommendedChipset

    def setRecommendedChipset(self):
       raise Error('setters not supported')
    
    def getRecommendedAudioController(self):
       return self.recommendedAudioController

    def setRecommendedAudioController(self):
       raise Error('setters not supported')
    
    def getRecommendedAudioCodec(self):
       return self.recommendedAudioCodec

    def setRecommendedAudioCodec(self):
       raise Error('setters not supported')
    
    def getRecommendedFloppy(self):
       return self.recommendedFloppy

    def setRecommendedFloppy(self):
       raise Error('setters not supported')
    
    def getRecommendedUSB(self):
       return self.recommendedUSB

    def setRecommendedUSB(self):
       raise Error('setters not supported')
    
    def getRecommendedUSB3(self):
       return self.recommendedUSB3

    def setRecommendedUSB3(self):
       raise Error('setters not supported')
    
    def getRecommendedTFReset(self):
       return self.recommendedTFReset

    def setRecommendedTFReset(self):
       raise Error('setters not supported')
    
    def getRecommendedX2APIC(self):
       return self.recommendedX2APIC

    def setRecommendedX2APIC(self):
       raise Error('setters not supported')
    

    def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

    def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

    def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

    def __getitem__(self, index):
      if self.isarray:
          return IGuestOSType(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")


class IAdditionsFacility:
    def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       self.isarray = isarray
       if isarray:
          self.handle = handle
       else:

          self.classType = AdditionsFacilityClass(self.mgr, handle._classType)
       
          self.lastUpdated = Long(self.mgr, handle._lastUpdated)
       
          self.name = String(self.mgr, handle._name)
       
          self.status = AdditionsFacilityStatus(self.mgr, handle._status)
       
          self.type = AdditionsFacilityType(self.mgr, handle._type)
       
          pass

   
    def getClassType(self):
       return self.classType

    def setClassType(self):
       raise Error('setters not supported')
    
    def getLastUpdated(self):
       return self.lastUpdated

    def setLastUpdated(self):
       raise Error('setters not supported')
    
    def getName(self):
       return self.name

    def setName(self):
       raise Error('setters not supported')
    
    def getStatus(self):
       return self.status

    def setStatus(self):
       raise Error('setters not supported')
    
    def getType(self):
       return self.type

    def setType(self):
       raise Error('setters not supported')
    

    def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

    def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

    def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

    def __getitem__(self, index):
      if self.isarray:
          return IAdditionsFacility(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")


class IMediumAttachment:
    def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       self.isarray = isarray
       if isarray:
          self.handle = handle
       else:

          self.medium = IMedium(self.mgr, handle._medium)
       
          self.controller = String(self.mgr, handle._controller)
       
          self.port = Int(self.mgr, handle._port)
       
          self.device = Int(self.mgr, handle._device)
       
          self.type = DeviceType(self.mgr, handle._type)
       
          self.passthrough = Boolean(self.mgr, handle._passthrough)
       
          self.temporaryEject = Boolean(self.mgr, handle._temporaryEject)
       
          self.isEjected = Boolean(self.mgr, handle._isEjected)
       
          self.nonRotational = Boolean(self.mgr, handle._nonRotational)
       
          self.discard = Boolean(self.mgr, handle._discard)
       
          self.hotPluggable = Boolean(self.mgr, handle._hotPluggable)
       
          self.bandwidthGroup = IBandwidthGroup(self.mgr, handle._bandwidthGroup)
       
          pass

   
    def getMedium(self):
       return self.medium

    def setMedium(self):
       raise Error('setters not supported')
    
    def getController(self):
       return self.controller

    def setController(self):
       raise Error('setters not supported')
    
    def getPort(self):
       return self.port

    def setPort(self):
       raise Error('setters not supported')
    
    def getDevice(self):
       return self.device

    def setDevice(self):
       raise Error('setters not supported')
    
    def getType(self):
       return self.type

    def setType(self):
       raise Error('setters not supported')
    
    def getPassthrough(self):
       return self.passthrough

    def setPassthrough(self):
       raise Error('setters not supported')
    
    def getTemporaryEject(self):
       return self.temporaryEject

    def setTemporaryEject(self):
       raise Error('setters not supported')
    
    def getIsEjected(self):
       return self.isEjected

    def setIsEjected(self):
       raise Error('setters not supported')
    
    def getNonRotational(self):
       return self.nonRotational

    def setNonRotational(self):
       raise Error('setters not supported')
    
    def getDiscard(self):
       return self.discard

    def setDiscard(self):
       raise Error('setters not supported')
    
    def getHotPluggable(self):
       return self.hotPluggable

    def setHotPluggable(self):
       raise Error('setters not supported')
    
    def getBandwidthGroup(self):
       return self.bandwidthGroup

    def setBandwidthGroup(self):
       raise Error('setters not supported')
    

    def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

    def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

    def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

    def __getitem__(self, index):
      if self.isarray:
          return IMediumAttachment(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")


class ISharedFolder:
    def __init__(self, mgr, handle, isarray = False):
       self.mgr = mgr
       self.isarray = isarray
       if isarray:
          self.handle = handle
       else:

          self.name = String(self.mgr, handle._name)
       
          self.hostPath = String(self.mgr, handle._hostPath)
       
          self.accessible = Boolean(self.mgr, handle._accessible)
       
          self.writable = Boolean(self.mgr, handle._writable)
       
          self.autoMount = Boolean(self.mgr, handle._autoMount)
       
          self.lastAccessError = String(self.mgr, handle._lastAccessError)
       
          pass

   
    def getName(self):
       return self.name

    def setName(self):
       raise Error('setters not supported')
    
    def getHostPath(self):
       return self.hostPath

    def setHostPath(self):
       raise Error('setters not supported')
    
    def getAccessible(self):
       return self.accessible

    def setAccessible(self):
       raise Error('setters not supported')
    
    def getWritable(self):
       return self.writable

    def setWritable(self):
       raise Error('setters not supported')
    
    def getAutoMount(self):
       return self.autoMount

    def setAutoMount(self):
       raise Error('setters not supported')
    
    def getLastAccessError(self):
       return self.lastAccessError

    def setLastAccessError(self):
       raise Error('setters not supported')
    

    def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError("iteration over non-sequence")

    def __size(self):
      if self.isarray:
          return self.handle.__size()
      raise TypeError("iteration over non-sequence")

    def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError("iteration over non-sequence")

    def __getitem__(self, index):
      if self.isarray:
          return ISharedFolder(self.mgr, self.handle[index])
      raise TypeError("iteration over non-sequence")


class SettingsVersion:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=SettingsVersion._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SettingsVersion):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,SettingsVersion):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return SettingsVersion._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'v1_0',2:'v1_1',3:'v1_2',4:'v1_3pre',5:'v1_3',6:'v1_4',7:'v1_5',8:'v1_6',9:'v1_7',10:'v1_8',11:'v1_9',12:'v1_10',13:'v1_11',14:'v1_12',15:'v1_13',16:'v1_14',17:'v1_15',18:'v1_16',99999:'Future'}
   _ValueMap={
              'Null':0,
              'v1_0':1,
              'v1_1':2,
              'v1_2':3,
              'v1_3pre':4,
              'v1_3':5,
              'v1_4':6,
              'v1_5':7,
              'v1_6':8,
              'v1_7':9,
              'v1_8':10,
              'v1_9':11,
              'v1_10':12,
              'v1_11':13,
              'v1_12':14,
              'v1_13':15,
              'v1_14':16,
              'v1_15':17,
              'v1_16':18,
              'Future':99999}

   Null=0
   v1_0=1
   v1_1=2
   v1_2=3
   v1_3pre=4
   v1_3=5
   v1_4=6
   v1_5=7
   v1_6=8
   v1_7=9
   v1_8=10
   v1_9=11
   v1_10=12
   v1_11=13
   v1_12=14
   v1_13=15
   v1_14=16
   v1_15=17
   v1_16=18
   Future=99999

class AccessMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AccessMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AccessMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AccessMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AccessMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'ReadOnly',2:'ReadWrite'}
   _ValueMap={
              'ReadOnly':1,
              'ReadWrite':2}

   ReadOnly=1
   ReadWrite=2

class MachineState:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=MachineState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MachineState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,MachineState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return MachineState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'PoweredOff',2:'Saved',3:'Teleported',4:'Aborted',5:'Running',6:'Paused',7:'Stuck',8:'Teleporting',9:'LiveSnapshotting',10:'Starting',11:'Stopping',12:'Saving',13:'Restoring',14:'TeleportingPausedVM',15:'TeleportingIn',16:'FaultTolerantSyncing',17:'DeletingSnapshotOnline',18:'DeletingSnapshotPaused',19:'OnlineSnapshotting',20:'RestoringSnapshot',21:'DeletingSnapshot',22:'SettingUp',23:'Snapshotting',5:'FirstOnline',19:'LastOnline',8:'FirstTransient',23:'LastTransient'}
   _ValueMap={
              'Null':0,
              'PoweredOff':1,
              'Saved':2,
              'Teleported':3,
              'Aborted':4,
              'Running':5,
              'Paused':6,
              'Stuck':7,
              'Teleporting':8,
              'LiveSnapshotting':9,
              'Starting':10,
              'Stopping':11,
              'Saving':12,
              'Restoring':13,
              'TeleportingPausedVM':14,
              'TeleportingIn':15,
              'FaultTolerantSyncing':16,
              'DeletingSnapshotOnline':17,
              'DeletingSnapshotPaused':18,
              'OnlineSnapshotting':19,
              'RestoringSnapshot':20,
              'DeletingSnapshot':21,
              'SettingUp':22,
              'Snapshotting':23,
              'FirstOnline':5,
              'LastOnline':19,
              'FirstTransient':8,
              'LastTransient':23}

   Null=0
   PoweredOff=1
   Saved=2
   Teleported=3
   Aborted=4
   Running=5
   Paused=6
   Stuck=7
   Teleporting=8
   LiveSnapshotting=9
   Starting=10
   Stopping=11
   Saving=12
   Restoring=13
   TeleportingPausedVM=14
   TeleportingIn=15
   FaultTolerantSyncing=16
   DeletingSnapshotOnline=17
   DeletingSnapshotPaused=18
   OnlineSnapshotting=19
   RestoringSnapshot=20
   DeletingSnapshot=21
   SettingUp=22
   Snapshotting=23
   FirstOnline=5
   LastOnline=19
   FirstTransient=8
   LastTransient=23

class SessionState:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=SessionState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SessionState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,SessionState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return SessionState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Unlocked',2:'Locked',3:'Spawning',4:'Unlocking'}
   _ValueMap={
              'Null':0,
              'Unlocked':1,
              'Locked':2,
              'Spawning':3,
              'Unlocking':4}

   Null=0
   Unlocked=1
   Locked=2
   Spawning=3
   Unlocking=4

class CPUPropertyType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=CPUPropertyType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,CPUPropertyType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,CPUPropertyType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return CPUPropertyType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'PAE',2:'LongMode',3:'TripleFaultReset',4:'APIC',5:'X2APIC'}
   _ValueMap={
              'Null':0,
              'PAE':1,
              'LongMode':2,
              'TripleFaultReset':3,
              'APIC':4,
              'X2APIC':5}

   Null=0
   PAE=1
   LongMode=2
   TripleFaultReset=3
   APIC=4
   X2APIC=5

class HWVirtExPropertyType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=HWVirtExPropertyType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HWVirtExPropertyType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,HWVirtExPropertyType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return HWVirtExPropertyType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Enabled',2:'VPID',3:'NestedPaging',4:'UnrestrictedExecution',5:'LargePages',6:'Force'}
   _ValueMap={
              'Null':0,
              'Enabled':1,
              'VPID':2,
              'NestedPaging':3,
              'UnrestrictedExecution':4,
              'LargePages':5,
              'Force':6}

   Null=0
   Enabled=1
   VPID=2
   NestedPaging=3
   UnrestrictedExecution=4
   LargePages=5
   Force=6

class ParavirtProvider:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ParavirtProvider._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ParavirtProvider):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ParavirtProvider):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ParavirtProvider._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'Default',2:'Legacy',3:'Minimal',4:'HyperV',5:'KVM'}
   _ValueMap={
              'None':0,
              'Default':1,
              'Legacy':2,
              'Minimal':3,
              'HyperV':4,
              'KVM':5}

   _None=0
   Default=1
   Legacy=2
   Minimal=3
   HyperV=4
   KVM=5

class FaultToleranceState:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FaultToleranceState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FaultToleranceState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FaultToleranceState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FaultToleranceState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Inactive',2:'Master',3:'Standby'}
   _ValueMap={
              'Inactive':1,
              'Master':2,
              'Standby':3}

   Inactive=1
   Master=2
   Standby=3

class LockType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=LockType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,LockType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,LockType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return LockType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Shared',2:'Write',3:'VM'}
   _ValueMap={
              'Null':0,
              'Shared':1,
              'Write':2,
              'VM':3}

   Null=0
   Shared=1
   Write=2
   VM=3

class SessionType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=SessionType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SessionType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,SessionType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return SessionType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'WriteLock',2:'Remote',3:'Shared'}
   _ValueMap={
              'Null':0,
              'WriteLock':1,
              'Remote':2,
              'Shared':3}

   Null=0
   WriteLock=1
   Remote=2
   Shared=3

class DeviceType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DeviceType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DeviceType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DeviceType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DeviceType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Floppy',2:'DVD',3:'HardDisk',4:'Network',5:'USB',6:'SharedFolder',7:'Graphics3D'}
   _ValueMap={
              'Null':0,
              'Floppy':1,
              'DVD':2,
              'HardDisk':3,
              'Network':4,
              'USB':5,
              'SharedFolder':6,
              'Graphics3D':7}

   Null=0
   Floppy=1
   DVD=2
   HardDisk=3
   Network=4
   USB=5
   SharedFolder=6
   Graphics3D=7

class DeviceActivity:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DeviceActivity._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DeviceActivity):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DeviceActivity):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DeviceActivity._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Idle',2:'Reading',3:'Writing'}
   _ValueMap={
              'Null':0,
              'Idle':1,
              'Reading':2,
              'Writing':3}

   Null=0
   Idle=1
   Reading=2
   Writing=3

class ClipboardMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ClipboardMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ClipboardMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ClipboardMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ClipboardMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'HostToGuest',2:'GuestToHost',3:'Bidirectional'}
   _ValueMap={
              'Disabled':0,
              'HostToGuest':1,
              'GuestToHost':2,
              'Bidirectional':3}

   Disabled=0
   HostToGuest=1
   GuestToHost=2
   Bidirectional=3

class DnDMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DnDMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DnDMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DnDMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DnDMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'HostToGuest',2:'GuestToHost',3:'Bidirectional'}
   _ValueMap={
              'Disabled':0,
              'HostToGuest':1,
              'GuestToHost':2,
              'Bidirectional':3}

   Disabled=0
   HostToGuest=1
   GuestToHost=2
   Bidirectional=3

class Scope:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=Scope._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,Scope):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,Scope):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return Scope._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Global',1:'Machine',2:'Session'}
   _ValueMap={
              'Global':0,
              'Machine':1,
              'Session':2}

   Global=0
   Machine=1
   Session=2

class BIOSBootMenuMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=BIOSBootMenuMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,BIOSBootMenuMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,BIOSBootMenuMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return BIOSBootMenuMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'MenuOnly',2:'MessageAndMenu'}
   _ValueMap={
              'Disabled':0,
              'MenuOnly':1,
              'MessageAndMenu':2}

   Disabled=0
   MenuOnly=1
   MessageAndMenu=2

class APICMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=APICMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,APICMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,APICMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return APICMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'APIC',2:'X2APIC'}
   _ValueMap={
              'Disabled':0,
              'APIC':1,
              'X2APIC':2}

   Disabled=0
   APIC=1
   X2APIC=2

class ProcessorFeature:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessorFeature._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessorFeature):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessorFeature):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessorFeature._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'HWVirtEx',1:'PAE',2:'LongMode',3:'NestedPaging'}
   _ValueMap={
              'HWVirtEx':0,
              'PAE':1,
              'LongMode':2,
              'NestedPaging':3}

   HWVirtEx=0
   PAE=1
   LongMode=2
   NestedPaging=3

class FirmwareType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FirmwareType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FirmwareType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FirmwareType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FirmwareType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'BIOS',2:'EFI',3:'EFI32',4:'EFI64',5:'EFIDUAL'}
   _ValueMap={
              'BIOS':1,
              'EFI':2,
              'EFI32':3,
              'EFI64':4,
              'EFIDUAL':5}

   BIOS=1
   EFI=2
   EFI32=3
   EFI64=4
   EFIDUAL=5

class PointingHIDType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=PointingHIDType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,PointingHIDType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,PointingHIDType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return PointingHIDType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'None',2:'PS2Mouse',3:'USBMouse',4:'USBTablet',5:'ComboMouse',6:'USBMultiTouch'}
   _ValueMap={
              'None':1,
              'PS2Mouse':2,
              'USBMouse':3,
              'USBTablet':4,
              'ComboMouse':5,
              'USBMultiTouch':6}

   _None=1
   PS2Mouse=2
   USBMouse=3
   USBTablet=4
   ComboMouse=5
   USBMultiTouch=6

class KeyboardHIDType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=KeyboardHIDType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,KeyboardHIDType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,KeyboardHIDType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return KeyboardHIDType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'None',2:'PS2Keyboard',3:'USBKeyboard',4:'ComboKeyboard'}
   _ValueMap={
              'None':1,
              'PS2Keyboard':2,
              'USBKeyboard':3,
              'ComboKeyboard':4}

   _None=1
   PS2Keyboard=2
   USBKeyboard=3
   ComboKeyboard=4

class BitmapFormat:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=BitmapFormat._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,BitmapFormat):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,BitmapFormat):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return BitmapFormat._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Opaque',0x20524742:'BGR',0x30524742:'BGR0',0x41524742:'BGRA',0x41424752:'RGBA',0x20474E50:'PNG',0x4745504A:'JPEG'}
   _ValueMap={
              'Opaque':0,
              'BGR':0x20524742,
              'BGR0':0x30524742,
              'BGRA':0x41524742,
              'RGBA':0x41424752,
              'PNG':0x20474E50,
              'JPEG':0x4745504A}

   Opaque=0
   BGR=0x20524742
   BGR0=0x30524742
   BGRA=0x41524742
   RGBA=0x41424752
   PNG=0x20474E50
   JPEG=0x4745504A

class DhcpOpt:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DhcpOpt._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DhcpOpt):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DhcpOpt):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DhcpOpt._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'SubnetMask',2:'TimeOffset',3:'Router',4:'TimeServer',5:'NameServer',6:'DomainNameServer',7:'LogServer',8:'Cookie',9:'LPRServer',10:'ImpressServer',11:'ResourseLocationServer',12:'HostName',13:'BootFileSize',14:'MeritDumpFile',15:'DomainName',16:'SwapServer',17:'RootPath',18:'ExtensionPath',19:'IPForwardingEnableDisable',20:'NonLocalSourceRoutingEnableDisable',21:'PolicyFilter',22:'MaximumDatagramReassemblySize',23:'DefaultIPTime2Live',24:'PathMTUAgingTimeout',25:'IPLayerParametersPerInterface',26:'InterfaceMTU',27:'AllSubnetsAreLocal',28:'BroadcastAddress',29:'PerformMaskDiscovery',30:'MaskSupplier',31:'PerformRouteDiscovery',32:'RouterSolicitationAddress',33:'StaticRoute',34:'TrailerEncapsulation',35:'ARPCacheTimeout',36:'EthernetEncapsulation',37:'TCPDefaultTTL',38:'TCPKeepAliveInterval',39:'TCPKeepAliveGarbage',40:'NetworkInformationServiceDomain',41:'NetworkInformationServiceServers',42:'NetworkTimeProtocolServers',43:'VendorSpecificInformation',44:'Option_44',45:'Option_45',46:'Option_46',47:'Option_47',48:'Option_48',49:'Option_49',51:'IPAddressLeaseTime',64:'Option_64',65:'Option_65',66:'TFTPServerName',67:'BootfileName',68:'Option_68',69:'Option_69',70:'Option_70',71:'Option_71',72:'Option_72',73:'Option_73',74:'Option_74',75:'Option_75',119:'Option_119'}
   _ValueMap={
              'SubnetMask':1,
              'TimeOffset':2,
              'Router':3,
              'TimeServer':4,
              'NameServer':5,
              'DomainNameServer':6,
              'LogServer':7,
              'Cookie':8,
              'LPRServer':9,
              'ImpressServer':10,
              'ResourseLocationServer':11,
              'HostName':12,
              'BootFileSize':13,
              'MeritDumpFile':14,
              'DomainName':15,
              'SwapServer':16,
              'RootPath':17,
              'ExtensionPath':18,
              'IPForwardingEnableDisable':19,
              'NonLocalSourceRoutingEnableDisable':20,
              'PolicyFilter':21,
              'MaximumDatagramReassemblySize':22,
              'DefaultIPTime2Live':23,
              'PathMTUAgingTimeout':24,
              'IPLayerParametersPerInterface':25,
              'InterfaceMTU':26,
              'AllSubnetsAreLocal':27,
              'BroadcastAddress':28,
              'PerformMaskDiscovery':29,
              'MaskSupplier':30,
              'PerformRouteDiscovery':31,
              'RouterSolicitationAddress':32,
              'StaticRoute':33,
              'TrailerEncapsulation':34,
              'ARPCacheTimeout':35,
              'EthernetEncapsulation':36,
              'TCPDefaultTTL':37,
              'TCPKeepAliveInterval':38,
              'TCPKeepAliveGarbage':39,
              'NetworkInformationServiceDomain':40,
              'NetworkInformationServiceServers':41,
              'NetworkTimeProtocolServers':42,
              'VendorSpecificInformation':43,
              'Option_44':44,
              'Option_45':45,
              'Option_46':46,
              'Option_47':47,
              'Option_48':48,
              'Option_49':49,
              'IPAddressLeaseTime':51,
              'Option_64':64,
              'Option_65':65,
              'TFTPServerName':66,
              'BootfileName':67,
              'Option_68':68,
              'Option_69':69,
              'Option_70':70,
              'Option_71':71,
              'Option_72':72,
              'Option_73':73,
              'Option_74':74,
              'Option_75':75,
              'Option_119':119}

   SubnetMask=1
   TimeOffset=2
   Router=3
   TimeServer=4
   NameServer=5
   DomainNameServer=6
   LogServer=7
   Cookie=8
   LPRServer=9
   ImpressServer=10
   ResourseLocationServer=11
   HostName=12
   BootFileSize=13
   MeritDumpFile=14
   DomainName=15
   SwapServer=16
   RootPath=17
   ExtensionPath=18
   IPForwardingEnableDisable=19
   NonLocalSourceRoutingEnableDisable=20
   PolicyFilter=21
   MaximumDatagramReassemblySize=22
   DefaultIPTime2Live=23
   PathMTUAgingTimeout=24
   IPLayerParametersPerInterface=25
   InterfaceMTU=26
   AllSubnetsAreLocal=27
   BroadcastAddress=28
   PerformMaskDiscovery=29
   MaskSupplier=30
   PerformRouteDiscovery=31
   RouterSolicitationAddress=32
   StaticRoute=33
   TrailerEncapsulation=34
   ARPCacheTimeout=35
   EthernetEncapsulation=36
   TCPDefaultTTL=37
   TCPKeepAliveInterval=38
   TCPKeepAliveGarbage=39
   NetworkInformationServiceDomain=40
   NetworkInformationServiceServers=41
   NetworkTimeProtocolServers=42
   VendorSpecificInformation=43
   Option_44=44
   Option_45=45
   Option_46=46
   Option_47=47
   Option_48=48
   Option_49=49
   IPAddressLeaseTime=51
   Option_64=64
   Option_65=65
   TFTPServerName=66
   BootfileName=67
   Option_68=68
   Option_69=69
   Option_70=70
   Option_71=71
   Option_72=72
   Option_73=73
   Option_74=74
   Option_75=75
   Option_119=119

class DhcpOptEncoding:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DhcpOptEncoding._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DhcpOptEncoding):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DhcpOptEncoding):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DhcpOptEncoding._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Legacy',1:'Hex'}
   _ValueMap={
              'Legacy':0,
              'Hex':1}

   Legacy=0
   Hex=1

class VFSType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=VFSType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,VFSType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,VFSType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return VFSType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'File',2:'Cloud',3:'S3',4:'WebDav'}
   _ValueMap={
              'File':1,
              'Cloud':2,
              'S3':3,
              'WebDav':4}

   File=1
   Cloud=2
   S3=3
   WebDav=4

class ImportOptions:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ImportOptions._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ImportOptions):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ImportOptions):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ImportOptions._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'KeepAllMACs',2:'KeepNATMACs',3:'ImportToVDI'}
   _ValueMap={
              'KeepAllMACs':1,
              'KeepNATMACs':2,
              'ImportToVDI':3}

   KeepAllMACs=1
   KeepNATMACs=2
   ImportToVDI=3

class ExportOptions:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ExportOptions._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ExportOptions):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ExportOptions):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ExportOptions._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'CreateManifest',2:'ExportDVDImages',3:'StripAllMACs',4:'StripAllNonNATMACs'}
   _ValueMap={
              'CreateManifest':1,
              'ExportDVDImages':2,
              'StripAllMACs':3,
              'StripAllNonNATMACs':4}

   CreateManifest=1
   ExportDVDImages=2
   StripAllMACs=3
   StripAllNonNATMACs=4

class CertificateVersion:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=CertificateVersion._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,CertificateVersion):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,CertificateVersion):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return CertificateVersion._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'V1',2:'V2',3:'V3',99:'Unknown'}
   _ValueMap={
              'V1':1,
              'V2':2,
              'V3':3,
              'Unknown':99}

   V1=1
   V2=2
   V3=3
   Unknown=99

class VirtualSystemDescriptionType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=VirtualSystemDescriptionType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,VirtualSystemDescriptionType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,VirtualSystemDescriptionType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return VirtualSystemDescriptionType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Ignore',2:'OS',3:'Name',4:'Product',5:'Vendor',6:'Version',7:'ProductUrl',8:'VendorUrl',9:'Description',10:'License',11:'Miscellaneous',12:'CPU',13:'Memory',14:'HardDiskControllerIDE',15:'HardDiskControllerSATA',16:'HardDiskControllerSCSI',17:'HardDiskControllerSAS',18:'HardDiskImage',19:'Floppy',20:'CDROM',21:'NetworkAdapter',22:'USBController',23:'SoundCard',24:'SettingsFile'}
   _ValueMap={
              'Ignore':1,
              'OS':2,
              'Name':3,
              'Product':4,
              'Vendor':5,
              'Version':6,
              'ProductUrl':7,
              'VendorUrl':8,
              'Description':9,
              'License':10,
              'Miscellaneous':11,
              'CPU':12,
              'Memory':13,
              'HardDiskControllerIDE':14,
              'HardDiskControllerSATA':15,
              'HardDiskControllerSCSI':16,
              'HardDiskControllerSAS':17,
              'HardDiskImage':18,
              'Floppy':19,
              'CDROM':20,
              'NetworkAdapter':21,
              'USBController':22,
              'SoundCard':23,
              'SettingsFile':24}

   Ignore=1
   OS=2
   Name=3
   Product=4
   Vendor=5
   Version=6
   ProductUrl=7
   VendorUrl=8
   Description=9
   License=10
   Miscellaneous=11
   CPU=12
   Memory=13
   HardDiskControllerIDE=14
   HardDiskControllerSATA=15
   HardDiskControllerSCSI=16
   HardDiskControllerSAS=17
   HardDiskImage=18
   Floppy=19
   CDROM=20
   NetworkAdapter=21
   USBController=22
   SoundCard=23
   SettingsFile=24

class VirtualSystemDescriptionValueType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=VirtualSystemDescriptionValueType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,VirtualSystemDescriptionValueType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,VirtualSystemDescriptionValueType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return VirtualSystemDescriptionValueType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Reference',2:'Original',3:'Auto',4:'ExtraConfig'}
   _ValueMap={
              'Reference':1,
              'Original':2,
              'Auto':3,
              'ExtraConfig':4}

   Reference=1
   Original=2
   Auto=3
   ExtraConfig=4

class GraphicsControllerType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=GraphicsControllerType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GraphicsControllerType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,GraphicsControllerType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return GraphicsControllerType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'VBoxVGA',2:'VMSVGA'}
   _ValueMap={
              'Null':0,
              'VBoxVGA':1,
              'VMSVGA':2}

   Null=0
   VBoxVGA=1
   VMSVGA=2

class CleanupMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=CleanupMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,CleanupMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,CleanupMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return CleanupMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'UnregisterOnly',2:'DetachAllReturnNone',3:'DetachAllReturnHardDisksOnly',4:'Full'}
   _ValueMap={
              'UnregisterOnly':1,
              'DetachAllReturnNone':2,
              'DetachAllReturnHardDisksOnly':3,
              'Full':4}

   UnregisterOnly=1
   DetachAllReturnNone=2
   DetachAllReturnHardDisksOnly=3
   Full=4

class CloneMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=CloneMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,CloneMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,CloneMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return CloneMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'MachineState',2:'MachineAndChildStates',3:'AllStates'}
   _ValueMap={
              'MachineState':1,
              'MachineAndChildStates':2,
              'AllStates':3}

   MachineState=1
   MachineAndChildStates=2
   AllStates=3

class CloneOptions:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=CloneOptions._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,CloneOptions):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,CloneOptions):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return CloneOptions._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Link',2:'KeepAllMACs',3:'KeepNATMACs',4:'KeepDiskNames'}
   _ValueMap={
              'Link':1,
              'KeepAllMACs':2,
              'KeepNATMACs':3,
              'KeepDiskNames':4}

   Link=1
   KeepAllMACs=2
   KeepNATMACs=3
   KeepDiskNames=4

class AutostopType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AutostopType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AutostopType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AutostopType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AutostopType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Disabled',2:'SaveState',3:'PowerOff',4:'AcpiShutdown'}
   _ValueMap={
              'Disabled':1,
              'SaveState':2,
              'PowerOff':3,
              'AcpiShutdown':4}

   Disabled=1
   SaveState=2
   PowerOff=3
   AcpiShutdown=4

class HostNetworkInterfaceMediumType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=HostNetworkInterfaceMediumType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HostNetworkInterfaceMediumType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,HostNetworkInterfaceMediumType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return HostNetworkInterfaceMediumType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Unknown',1:'Ethernet',2:'PPP',3:'SLIP'}
   _ValueMap={
              'Unknown':0,
              'Ethernet':1,
              'PPP':2,
              'SLIP':3}

   Unknown=0
   Ethernet=1
   PPP=2
   SLIP=3

class HostNetworkInterfaceStatus:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=HostNetworkInterfaceStatus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HostNetworkInterfaceStatus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,HostNetworkInterfaceStatus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return HostNetworkInterfaceStatus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Unknown',1:'Up',2:'Down'}
   _ValueMap={
              'Unknown':0,
              'Up':1,
              'Down':2}

   Unknown=0
   Up=1
   Down=2

class HostNetworkInterfaceType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=HostNetworkInterfaceType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HostNetworkInterfaceType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,HostNetworkInterfaceType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return HostNetworkInterfaceType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Bridged',2:'HostOnly'}
   _ValueMap={
              'Bridged':1,
              'HostOnly':2}

   Bridged=1
   HostOnly=2

class AdditionsFacilityType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AdditionsFacilityType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AdditionsFacilityType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AdditionsFacilityType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AdditionsFacilityType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',20:'VBoxGuestDriver',90:'AutoLogon',100:'VBoxService',101:'VBoxTrayClient',1000:'Seamless',1100:'Graphics',2147483646:'All'}
   _ValueMap={
              'None':0,
              'VBoxGuestDriver':20,
              'AutoLogon':90,
              'VBoxService':100,
              'VBoxTrayClient':101,
              'Seamless':1000,
              'Graphics':1100,
              'All':2147483646}

   _None=0
   VBoxGuestDriver=20
   AutoLogon=90
   VBoxService=100
   VBoxTrayClient=101
   Seamless=1000
   Graphics=1100
   All=2147483646

class AdditionsFacilityClass:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AdditionsFacilityClass._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AdditionsFacilityClass):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AdditionsFacilityClass):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AdditionsFacilityClass._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',10:'Driver',30:'Service',50:'Program',100:'Feature',999:'ThirdParty',2147483646:'All'}
   _ValueMap={
              'None':0,
              'Driver':10,
              'Service':30,
              'Program':50,
              'Feature':100,
              'ThirdParty':999,
              'All':2147483646}

   _None=0
   Driver=10
   Service=30
   Program=50
   Feature=100
   ThirdParty=999
   All=2147483646

class AdditionsFacilityStatus:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AdditionsFacilityStatus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AdditionsFacilityStatus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AdditionsFacilityStatus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AdditionsFacilityStatus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Inactive',1:'Paused',20:'PreInit',30:'Init',50:'Active',100:'Terminating',101:'Terminated',800:'Failed',999:'Unknown'}
   _ValueMap={
              'Inactive':0,
              'Paused':1,
              'PreInit':20,
              'Init':30,
              'Active':50,
              'Terminating':100,
              'Terminated':101,
              'Failed':800,
              'Unknown':999}

   Inactive=0
   Paused=1
   PreInit=20
   Init=30
   Active=50
   Terminating=100
   Terminated=101
   Failed=800
   Unknown=999

class AdditionsRunLevelType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AdditionsRunLevelType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AdditionsRunLevelType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AdditionsRunLevelType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AdditionsRunLevelType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'System',2:'Userland',3:'Desktop'}
   _ValueMap={
              'None':0,
              'System':1,
              'Userland':2,
              'Desktop':3}

   _None=0
   System=1
   Userland=2
   Desktop=3

class AdditionsUpdateFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AdditionsUpdateFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AdditionsUpdateFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AdditionsUpdateFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AdditionsUpdateFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'WaitForUpdateStartOnly'}
   _ValueMap={
              'None':0,
              'WaitForUpdateStartOnly':1}

   _None=0
   WaitForUpdateStartOnly=1

class GuestSessionStatus:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=GuestSessionStatus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestSessionStatus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestSessionStatus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return GuestSessionStatus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Undefined',10:'Starting',100:'Started',480:'Terminating',500:'Terminated',512:'TimedOutKilled',513:'TimedOutAbnormally',600:'Down',800:'Error'}
   _ValueMap={
              'Undefined':0,
              'Starting':10,
              'Started':100,
              'Terminating':480,
              'Terminated':500,
              'TimedOutKilled':512,
              'TimedOutAbnormally':513,
              'Down':600,
              'Error':800}

   Undefined=0
   Starting=10
   Started=100
   Terminating=480
   Terminated=500
   TimedOutKilled=512
   TimedOutAbnormally=513
   Down=600
   Error=800

class GuestSessionWaitForFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=GuestSessionWaitForFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestSessionWaitForFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestSessionWaitForFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return GuestSessionWaitForFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'Start',2:'Terminate',4:'Status'}
   _ValueMap={
              'None':0,
              'Start':1,
              'Terminate':2,
              'Status':4}

   _None=0
   Start=1
   Terminate=2
   Status=4

class GuestSessionWaitResult:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=GuestSessionWaitResult._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestSessionWaitResult):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestSessionWaitResult):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return GuestSessionWaitResult._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'Start',2:'Terminate',3:'Status',4:'Error',5:'Timeout',6:'WaitFlagNotSupported'}
   _ValueMap={
              'None':0,
              'Start':1,
              'Terminate':2,
              'Status':3,
              'Error':4,
              'Timeout':5,
              'WaitFlagNotSupported':6}

   _None=0
   Start=1
   Terminate=2
   Status=3
   Error=4
   Timeout=5
   WaitFlagNotSupported=6

class GuestUserState:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=GuestUserState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestUserState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestUserState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return GuestUserState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Unknown',1:'LoggedIn',2:'LoggedOut',3:'Locked',4:'Unlocked',5:'Disabled',6:'Idle',7:'InUse',8:'Created',9:'Deleted',10:'SessionChanged',11:'CredentialsChanged',12:'RoleChanged',13:'GroupAdded',14:'GroupRemoved',15:'Elevated'}
   _ValueMap={
              'Unknown':0,
              'LoggedIn':1,
              'LoggedOut':2,
              'Locked':3,
              'Unlocked':4,
              'Disabled':5,
              'Idle':6,
              'InUse':7,
              'Created':8,
              'Deleted':9,
              'SessionChanged':10,
              'CredentialsChanged':11,
              'RoleChanged':12,
              'GroupAdded':13,
              'GroupRemoved':14,
              'Elevated':15}

   Unknown=0
   LoggedIn=1
   LoggedOut=2
   Locked=3
   Unlocked=4
   Disabled=5
   Idle=6
   InUse=7
   Created=8
   Deleted=9
   SessionChanged=10
   CredentialsChanged=11
   RoleChanged=12
   GroupAdded=13
   GroupRemoved=14
   Elevated=15

class FileSeekOrigin:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FileSeekOrigin._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FileSeekOrigin):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FileSeekOrigin):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FileSeekOrigin._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Begin',1:'Current',2:'End'}
   _ValueMap={
              'Begin':0,
              'Current':1,
              'End':2}

   Begin=0
   Current=1
   End=2

class ProcessInputFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessInputFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessInputFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessInputFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessInputFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'EndOfFile'}
   _ValueMap={
              'None':0,
              'EndOfFile':1}

   _None=0
   EndOfFile=1

class ProcessOutputFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessOutputFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessOutputFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessOutputFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessOutputFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'StdErr'}
   _ValueMap={
              'None':0,
              'StdErr':1}

   _None=0
   StdErr=1

class ProcessWaitForFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessWaitForFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessWaitForFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessWaitForFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessWaitForFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'Start',2:'Terminate',4:'StdIn',8:'StdOut',16:'StdErr'}
   _ValueMap={
              'None':0,
              'Start':1,
              'Terminate':2,
              'StdIn':4,
              'StdOut':8,
              'StdErr':16}

   _None=0
   Start=1
   Terminate=2
   StdIn=4
   StdOut=8
   StdErr=16

class ProcessWaitResult:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessWaitResult._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessWaitResult):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessWaitResult):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessWaitResult._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'Start',2:'Terminate',3:'Status',4:'Error',5:'Timeout',6:'StdIn',7:'StdOut',8:'StdErr',9:'WaitFlagNotSupported'}
   _ValueMap={
              'None':0,
              'Start':1,
              'Terminate':2,
              'Status':3,
              'Error':4,
              'Timeout':5,
              'StdIn':6,
              'StdOut':7,
              'StdErr':8,
              'WaitFlagNotSupported':9}

   _None=0
   Start=1
   Terminate=2
   Status=3
   Error=4
   Timeout=5
   StdIn=6
   StdOut=7
   StdErr=8
   WaitFlagNotSupported=9

class FileCopyFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FileCopyFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FileCopyFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FileCopyFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FileCopyFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'NoReplace',2:'FollowLinks',4:'Update'}
   _ValueMap={
              'None':0,
              'NoReplace':1,
              'FollowLinks':2,
              'Update':4}

   _None=0
   NoReplace=1
   FollowLinks=2
   Update=4

class FsObjMoveFlags:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FsObjMoveFlags._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FsObjMoveFlags):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FsObjMoveFlags):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FsObjMoveFlags._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'Replace',2:'FollowLinks',4:'AllowDirectoryMoves'}
   _ValueMap={
              'None':0,
              'Replace':1,
              'FollowLinks':2,
              'AllowDirectoryMoves':4}

   _None=0
   Replace=1
   FollowLinks=2
   AllowDirectoryMoves=4

class DirectoryCreateFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DirectoryCreateFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DirectoryCreateFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DirectoryCreateFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DirectoryCreateFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'Parents'}
   _ValueMap={
              'None':0,
              'Parents':1}

   _None=0
   Parents=1

class DirectoryCopyFlags:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DirectoryCopyFlags._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DirectoryCopyFlags):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DirectoryCopyFlags):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DirectoryCopyFlags._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'CopyIntoExisting'}
   _ValueMap={
              'None':0,
              'CopyIntoExisting':1}

   _None=0
   CopyIntoExisting=1

class DirectoryRemoveRecFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DirectoryRemoveRecFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DirectoryRemoveRecFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DirectoryRemoveRecFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DirectoryRemoveRecFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'ContentAndDir',2:'ContentOnly'}
   _ValueMap={
              'None':0,
              'ContentAndDir':1,
              'ContentOnly':2}

   _None=0
   ContentAndDir=1
   ContentOnly=2

class FsObjRenameFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FsObjRenameFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FsObjRenameFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FsObjRenameFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FsObjRenameFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'NoReplace',1:'Replace'}
   _ValueMap={
              'NoReplace':0,
              'Replace':1}

   NoReplace=0
   Replace=1

class ProcessCreateFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessCreateFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessCreateFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessCreateFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessCreateFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'WaitForProcessStartOnly',2:'IgnoreOrphanedProcesses',4:'Hidden',8:'Profile',16:'WaitForStdOut',32:'WaitForStdErr',64:'ExpandArguments',128:'UnquotedArguments'}
   _ValueMap={
              'None':0,
              'WaitForProcessStartOnly':1,
              'IgnoreOrphanedProcesses':2,
              'Hidden':4,
              'Profile':8,
              'WaitForStdOut':16,
              'WaitForStdErr':32,
              'ExpandArguments':64,
              'UnquotedArguments':128}

   _None=0
   WaitForProcessStartOnly=1
   IgnoreOrphanedProcesses=2
   Hidden=4
   Profile=8
   WaitForStdOut=16
   WaitForStdErr=32
   ExpandArguments=64
   UnquotedArguments=128

class ProcessPriority:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessPriority._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessPriority):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessPriority):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessPriority._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Invalid',1:'Default'}
   _ValueMap={
              'Invalid':0,
              'Default':1}

   Invalid=0
   Default=1

class SymlinkType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=SymlinkType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SymlinkType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,SymlinkType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return SymlinkType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Unknown',1:'Directory',2:'File'}
   _ValueMap={
              'Unknown':0,
              'Directory':1,
              'File':2}

   Unknown=0
   Directory=1
   File=2

class SymlinkReadFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=SymlinkReadFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SymlinkReadFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,SymlinkReadFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return SymlinkReadFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'NoSymlinks'}
   _ValueMap={
              'None':0,
              'NoSymlinks':1}

   _None=0
   NoSymlinks=1

class ProcessStatus:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessStatus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessStatus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessStatus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessStatus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Undefined',10:'Starting',100:'Started',110:'Paused',480:'Terminating',500:'TerminatedNormally',510:'TerminatedSignal',511:'TerminatedAbnormally',512:'TimedOutKilled',513:'TimedOutAbnormally',600:'Down',800:'Error'}
   _ValueMap={
              'Undefined':0,
              'Starting':10,
              'Started':100,
              'Paused':110,
              'Terminating':480,
              'TerminatedNormally':500,
              'TerminatedSignal':510,
              'TerminatedAbnormally':511,
              'TimedOutKilled':512,
              'TimedOutAbnormally':513,
              'Down':600,
              'Error':800}

   Undefined=0
   Starting=10
   Started=100
   Paused=110
   Terminating=480
   TerminatedNormally=500
   TerminatedSignal=510
   TerminatedAbnormally=511
   TimedOutKilled=512
   TimedOutAbnormally=513
   Down=600
   Error=800

class ProcessInputStatus:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ProcessInputStatus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessInputStatus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessInputStatus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ProcessInputStatus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Undefined',1:'Broken',10:'Available',50:'Written',100:'Overflow'}
   _ValueMap={
              'Undefined':0,
              'Broken':1,
              'Available':10,
              'Written':50,
              'Overflow':100}

   Undefined=0
   Broken=1
   Available=10
   Written=50
   Overflow=100

class PathStyle:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=PathStyle._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,PathStyle):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,PathStyle):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return PathStyle._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'DOS',2:'UNIX',8:'Unknown'}
   _ValueMap={
              'DOS':1,
              'UNIX':2,
              'Unknown':8}

   DOS=1
   UNIX=2
   Unknown=8

class FileAccessMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FileAccessMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FileAccessMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FileAccessMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FileAccessMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'ReadOnly',2:'WriteOnly',3:'ReadWrite',4:'AppendOnly',5:'AppendRead'}
   _ValueMap={
              'ReadOnly':1,
              'WriteOnly':2,
              'ReadWrite':3,
              'AppendOnly':4,
              'AppendRead':5}

   ReadOnly=1
   WriteOnly=2
   ReadWrite=3
   AppendOnly=4
   AppendRead=5

class FileOpenAction:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FileOpenAction._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FileOpenAction):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FileOpenAction):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FileOpenAction._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'OpenExisting',2:'OpenOrCreate',3:'CreateNew',4:'CreateOrReplace',5:'OpenExistingTruncated',99:'AppendOrCreate'}
   _ValueMap={
              'OpenExisting':1,
              'OpenOrCreate':2,
              'CreateNew':3,
              'CreateOrReplace':4,
              'OpenExistingTruncated':5,
              'AppendOrCreate':99}

   OpenExisting=1
   OpenOrCreate=2
   CreateNew=3
   CreateOrReplace=4
   OpenExistingTruncated=5
   AppendOrCreate=99

class FileSharingMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FileSharingMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FileSharingMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FileSharingMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FileSharingMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Read',2:'Write',3:'ReadWrite',4:'Delete',5:'ReadDelete',6:'WriteDelete',7:'All'}
   _ValueMap={
              'Read':1,
              'Write':2,
              'ReadWrite':3,
              'Delete':4,
              'ReadDelete':5,
              'WriteDelete':6,
              'All':7}

   Read=1
   Write=2
   ReadWrite=3
   Delete=4
   ReadDelete=5
   WriteDelete=6
   All=7

class FileOpenExFlags:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FileOpenExFlags._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FileOpenExFlags):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FileOpenExFlags):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FileOpenExFlags._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None'}
   _ValueMap={
              'None':0}

   _None=0

class FileStatus:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FileStatus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FileStatus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FileStatus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FileStatus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Undefined',10:'Opening',100:'Open',150:'Closing',200:'Closed',600:'Down',800:'Error'}
   _ValueMap={
              'Undefined':0,
              'Opening':10,
              'Open':100,
              'Closing':150,
              'Closed':200,
              'Down':600,
              'Error':800}

   Undefined=0
   Opening=10
   Open=100
   Closing=150
   Closed=200
   Down=600
   Error=800

class FsObjType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FsObjType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FsObjType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FsObjType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FsObjType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Unknown',2:'Fifo',3:'DevChar',4:'Directory',5:'DevBlock',6:'File',7:'Symlink',8:'Socket',9:'WhiteOut'}
   _ValueMap={
              'Unknown':1,
              'Fifo':2,
              'DevChar':3,
              'Directory':4,
              'DevBlock':5,
              'File':6,
              'Symlink':7,
              'Socket':8,
              'WhiteOut':9}

   Unknown=1
   Fifo=2
   DevChar=3
   Directory=4
   DevBlock=5
   File=6
   Symlink=7
   Socket=8
   WhiteOut=9

class DnDAction:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DnDAction._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DnDAction):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DnDAction):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DnDAction._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Ignore',1:'Copy',2:'Move',3:'Link'}
   _ValueMap={
              'Ignore':0,
              'Copy':1,
              'Move':2,
              'Link':3}

   Ignore=0
   Copy=1
   Move=2
   Link=3

class DirectoryOpenFlag:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DirectoryOpenFlag._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DirectoryOpenFlag):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DirectoryOpenFlag):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DirectoryOpenFlag._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'None',1:'NoSymlinks'}
   _ValueMap={
              'None':0,
              'NoSymlinks':1}

   _None=0
   NoSymlinks=1

class MediumState:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=MediumState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MediumState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,MediumState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return MediumState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'NotCreated',1:'Created',2:'LockedRead',3:'LockedWrite',4:'Inaccessible',5:'Creating',6:'Deleting'}
   _ValueMap={
              'NotCreated':0,
              'Created':1,
              'LockedRead':2,
              'LockedWrite':3,
              'Inaccessible':4,
              'Creating':5,
              'Deleting':6}

   NotCreated=0
   Created=1
   LockedRead=2
   LockedWrite=3
   Inaccessible=4
   Creating=5
   Deleting=6

class MediumType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=MediumType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MediumType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,MediumType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return MediumType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Normal',1:'Immutable',2:'Writethrough',3:'Shareable',4:'Readonly',5:'MultiAttach'}
   _ValueMap={
              'Normal':0,
              'Immutable':1,
              'Writethrough':2,
              'Shareable':3,
              'Readonly':4,
              'MultiAttach':5}

   Normal=0
   Immutable=1
   Writethrough=2
   Shareable=3
   Readonly=4
   MultiAttach=5

class MediumVariant:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=MediumVariant._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MediumVariant):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,MediumVariant):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return MediumVariant._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Standard',0x01:'VmdkSplit2G',0x02:'VmdkRawDisk',0x04:'VmdkStreamOptimized',0x08:'VmdkESX',0x100:'VdiZeroExpand',0x10000:'Fixed',0x20000:'Diff',0x40000000:'NoCreateDir'}
   _ValueMap={
              'Standard':0,
              'VmdkSplit2G':0x01,
              'VmdkRawDisk':0x02,
              'VmdkStreamOptimized':0x04,
              'VmdkESX':0x08,
              'VdiZeroExpand':0x100,
              'Fixed':0x10000,
              'Diff':0x20000,
              'NoCreateDir':0x40000000}

   Standard=0
   VmdkSplit2G=0x01
   VmdkRawDisk=0x02
   VmdkStreamOptimized=0x04
   VmdkESX=0x08
   VdiZeroExpand=0x100
   Fixed=0x10000
   Diff=0x20000
   NoCreateDir=0x40000000

class DataType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DataType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DataType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DataType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DataType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Int32',1:'Int8',2:'String'}
   _ValueMap={
              'Int32':0,
              'Int8':1,
              'String':2}

   Int32=0
   Int8=1
   String=2

class DataFlags:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=DataFlags._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DataFlags):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,DataFlags):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return DataFlags._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x00:'None',0x01:'Mandatory',0x02:'Expert',0x04:'Array',0x07:'FlagMask'}
   _ValueMap={
              'None':0x00,
              'Mandatory':0x01,
              'Expert':0x02,
              'Array':0x04,
              'FlagMask':0x07}

   _None=0x00
   Mandatory=0x01
   Expert=0x02
   Array=0x04
   FlagMask=0x07

class MediumFormatCapabilities:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=MediumFormatCapabilities._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MediumFormatCapabilities):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,MediumFormatCapabilities):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return MediumFormatCapabilities._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x01:'Uuid',0x02:'CreateFixed',0x04:'CreateDynamic',0x08:'CreateSplit2G',0x10:'Differencing',0x20:'Asynchronous',0x40:'File',0x80:'Properties',0x100:'TcpNetworking',0x200:'VFS',0x400:'Discard',0x800:'Preferred',0xFFF:'CapabilityMask'}
   _ValueMap={
              'Uuid':0x01,
              'CreateFixed':0x02,
              'CreateDynamic':0x04,
              'CreateSplit2G':0x08,
              'Differencing':0x10,
              'Asynchronous':0x20,
              'File':0x40,
              'Properties':0x80,
              'TcpNetworking':0x100,
              'VFS':0x200,
              'Discard':0x400,
              'Preferred':0x800,
              'CapabilityMask':0xFFF}

   Uuid=0x01
   CreateFixed=0x02
   CreateDynamic=0x04
   CreateSplit2G=0x08
   Differencing=0x10
   Asynchronous=0x20
   File=0x40
   Properties=0x80
   TcpNetworking=0x100
   VFS=0x200
   Discard=0x400
   Preferred=0x800
   CapabilityMask=0xFFF

class KeyboardLED:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=KeyboardLED._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,KeyboardLED):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,KeyboardLED):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return KeyboardLED._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x01:'NumLock',0x02:'CapsLock',0x04:'ScrollLock'}
   _ValueMap={
              'NumLock':0x01,
              'CapsLock':0x02,
              'ScrollLock':0x04}

   NumLock=0x01
   CapsLock=0x02
   ScrollLock=0x04

class MouseButtonState:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=MouseButtonState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MouseButtonState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,MouseButtonState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return MouseButtonState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x01:'LeftButton',0x02:'RightButton',0x04:'MiddleButton',0x08:'WheelUp',0x10:'WheelDown',0x20:'XButton1',0x40:'XButton2',0x7F:'MouseStateMask'}
   _ValueMap={
              'LeftButton':0x01,
              'RightButton':0x02,
              'MiddleButton':0x04,
              'WheelUp':0x08,
              'WheelDown':0x10,
              'XButton1':0x20,
              'XButton2':0x40,
              'MouseStateMask':0x7F}

   LeftButton=0x01
   RightButton=0x02
   MiddleButton=0x04
   WheelUp=0x08
   WheelDown=0x10
   XButton1=0x20
   XButton2=0x40
   MouseStateMask=0x7F

class TouchContactState:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=TouchContactState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,TouchContactState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,TouchContactState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return TouchContactState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x00:'None',0x01:'InContact',0x02:'InRange',0x03:'ContactStateMask'}
   _ValueMap={
              'None':0x00,
              'InContact':0x01,
              'InRange':0x02,
              'ContactStateMask':0x03}

   _None=0x00
   InContact=0x01
   InRange=0x02
   ContactStateMask=0x03

class FramebufferCapabilities:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=FramebufferCapabilities._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FramebufferCapabilities):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,FramebufferCapabilities):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return FramebufferCapabilities._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x01:'UpdateImage',0x02:'VHWA',0x04:'VisibleRegion'}
   _ValueMap={
              'UpdateImage':0x01,
              'VHWA':0x02,
              'VisibleRegion':0x04}

   UpdateImage=0x01
   VHWA=0x02
   VisibleRegion=0x04

class GuestMonitorStatus:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=GuestMonitorStatus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestMonitorStatus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestMonitorStatus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return GuestMonitorStatus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'Enabled',2:'Blank'}
   _ValueMap={
              'Disabled':0,
              'Enabled':1,
              'Blank':2}

   Disabled=0
   Enabled=1
   Blank=2

class ScreenLayoutMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ScreenLayoutMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ScreenLayoutMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ScreenLayoutMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ScreenLayoutMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Apply',1:'Reset'}
   _ValueMap={
              'Apply':0,
              'Reset':1}

   Apply=0
   Reset=1

class NetworkAttachmentType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=NetworkAttachmentType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NetworkAttachmentType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,NetworkAttachmentType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return NetworkAttachmentType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'NAT',2:'Bridged',3:'Internal',4:'HostOnly',5:'Generic',6:'NATNetwork'}
   _ValueMap={
              'Null':0,
              'NAT':1,
              'Bridged':2,
              'Internal':3,
              'HostOnly':4,
              'Generic':5,
              'NATNetwork':6}

   Null=0
   NAT=1
   Bridged=2
   Internal=3
   HostOnly=4
   Generic=5
   NATNetwork=6

class NetworkAdapterType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=NetworkAdapterType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NetworkAdapterType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,NetworkAdapterType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return NetworkAdapterType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Am79C970A',2:'Am79C973',3:'I82540EM',4:'I82543GC',5:'I82545EM',6:'Virtio'}
   _ValueMap={
              'Null':0,
              'Am79C970A':1,
              'Am79C973':2,
              'I82540EM':3,
              'I82543GC':4,
              'I82545EM':5,
              'Virtio':6}

   Null=0
   Am79C970A=1
   Am79C973=2
   I82540EM=3
   I82543GC=4
   I82545EM=5
   Virtio=6

class NetworkAdapterPromiscModePolicy:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=NetworkAdapterPromiscModePolicy._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NetworkAdapterPromiscModePolicy):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,NetworkAdapterPromiscModePolicy):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return NetworkAdapterPromiscModePolicy._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Deny',2:'AllowNetwork',3:'AllowAll'}
   _ValueMap={
              'Deny':1,
              'AllowNetwork':2,
              'AllowAll':3}

   Deny=1
   AllowNetwork=2
   AllowAll=3

class PortMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=PortMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,PortMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,PortMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return PortMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disconnected',1:'HostPipe',2:'HostDevice',3:'RawFile',4:'TCP'}
   _ValueMap={
              'Disconnected':0,
              'HostPipe':1,
              'HostDevice':2,
              'RawFile':3,
              'TCP':4}

   Disconnected=0
   HostPipe=1
   HostDevice=2
   RawFile=3
   TCP=4

class USBControllerType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=USBControllerType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,USBControllerType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,USBControllerType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return USBControllerType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'OHCI',2:'EHCI',3:'XHCI',4:'Last'}
   _ValueMap={
              'Null':0,
              'OHCI':1,
              'EHCI':2,
              'XHCI':3,
              'Last':4}

   Null=0
   OHCI=1
   EHCI=2
   XHCI=3
   Last=4

class USBConnectionSpeed:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=USBConnectionSpeed._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,USBConnectionSpeed):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,USBConnectionSpeed):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return USBConnectionSpeed._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Low',2:'Full',3:'High',4:'Super',5:'SuperPlus'}
   _ValueMap={
              'Null':0,
              'Low':1,
              'Full':2,
              'High':3,
              'Super':4,
              'SuperPlus':5}

   Null=0
   Low=1
   Full=2
   High=3
   Super=4
   SuperPlus=5

class USBDeviceState:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=USBDeviceState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,USBDeviceState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,USBDeviceState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return USBDeviceState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'NotSupported',1:'Unavailable',2:'Busy',3:'Available',4:'Held',5:'Captured'}
   _ValueMap={
              'NotSupported':0,
              'Unavailable':1,
              'Busy':2,
              'Available':3,
              'Held':4,
              'Captured':5}

   NotSupported=0
   Unavailable=1
   Busy=2
   Available=3
   Held=4
   Captured=5

class USBDeviceFilterAction:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=USBDeviceFilterAction._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,USBDeviceFilterAction):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,USBDeviceFilterAction):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return USBDeviceFilterAction._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Ignore',2:'Hold'}
   _ValueMap={
              'Null':0,
              'Ignore':1,
              'Hold':2}

   Null=0
   Ignore=1
   Hold=2

class AudioDriverType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AudioDriverType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AudioDriverType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AudioDriverType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AudioDriverType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'WinMM',2:'OSS',3:'ALSA',4:'DirectSound',5:'CoreAudio',6:'MMPM',7:'Pulse',8:'SolAudio'}
   _ValueMap={
              'Null':0,
              'WinMM':1,
              'OSS':2,
              'ALSA':3,
              'DirectSound':4,
              'CoreAudio':5,
              'MMPM':6,
              'Pulse':7,
              'SolAudio':8}

   Null=0
   WinMM=1
   OSS=2
   ALSA=3
   DirectSound=4
   CoreAudio=5
   MMPM=6
   Pulse=7
   SolAudio=8

class AudioControllerType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AudioControllerType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AudioControllerType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AudioControllerType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AudioControllerType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'AC97',1:'SB16',2:'HDA'}
   _ValueMap={
              'AC97':0,
              'SB16':1,
              'HDA':2}

   AC97=0
   SB16=1
   HDA=2

class AudioCodecType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AudioCodecType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AudioCodecType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AudioCodecType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AudioCodecType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'SB16',2:'STAC9700',3:'AD1980',4:'STAC9221'}
   _ValueMap={
              'Null':0,
              'SB16':1,
              'STAC9700':2,
              'AD1980':3,
              'STAC9221':4}

   Null=0
   SB16=1
   STAC9700=2
   AD1980=3
   STAC9221=4

class AuthType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=AuthType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AuthType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,AuthType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return AuthType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'External',2:'Guest'}
   _ValueMap={
              'Null':0,
              'External':1,
              'Guest':2}

   Null=0
   External=1
   Guest=2

class Reason:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=Reason._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,Reason):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,Reason):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return Reason._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Unspecified',1:'HostSuspend',2:'HostResume',3:'HostBatteryLow',4:'Snapshot'}
   _ValueMap={
              'Unspecified':0,
              'HostSuspend':1,
              'HostResume':2,
              'HostBatteryLow':3,
              'Snapshot':4}

   Unspecified=0
   HostSuspend=1
   HostResume=2
   HostBatteryLow=3
   Snapshot=4

class StorageBus:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=StorageBus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,StorageBus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,StorageBus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return StorageBus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'IDE',2:'SATA',3:'SCSI',4:'Floppy',5:'SAS',6:'USB',7:'PCIe'}
   _ValueMap={
              'Null':0,
              'IDE':1,
              'SATA':2,
              'SCSI':3,
              'Floppy':4,
              'SAS':5,
              'USB':6,
              'PCIe':7}

   Null=0
   IDE=1
   SATA=2
   SCSI=3
   Floppy=4
   SAS=5
   USB=6
   PCIe=7

class StorageControllerType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=StorageControllerType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,StorageControllerType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,StorageControllerType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return StorageControllerType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'LsiLogic',2:'BusLogic',3:'IntelAhci',4:'PIIX3',5:'PIIX4',6:'ICH6',7:'I82078',8:'LsiLogicSas',9:'USB',10:'NVMe'}
   _ValueMap={
              'Null':0,
              'LsiLogic':1,
              'BusLogic':2,
              'IntelAhci':3,
              'PIIX3':4,
              'PIIX4':5,
              'ICH6':6,
              'I82078':7,
              'LsiLogicSas':8,
              'USB':9,
              'NVMe':10}

   Null=0
   LsiLogic=1
   BusLogic=2
   IntelAhci=3
   PIIX3=4
   PIIX4=5
   ICH6=6
   I82078=7
   LsiLogicSas=8
   USB=9
   NVMe=10

class ChipsetType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=ChipsetType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ChipsetType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,ChipsetType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return ChipsetType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'PIIX3',2:'ICH9'}
   _ValueMap={
              'Null':0,
              'PIIX3':1,
              'ICH9':2}

   Null=0
   PIIX3=1
   ICH9=2

class NATAliasMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=NATAliasMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NATAliasMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,NATAliasMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return NATAliasMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x1:'AliasLog',0x02:'AliasProxyOnly',0x04:'AliasUseSamePorts'}
   _ValueMap={
              'AliasLog':0x1,
              'AliasProxyOnly':0x02,
              'AliasUseSamePorts':0x04}

   AliasLog=0x1
   AliasProxyOnly=0x02
   AliasUseSamePorts=0x04

class NATProtocol:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=NATProtocol._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NATProtocol):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,NATProtocol):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return NATProtocol._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'UDP',1:'TCP'}
   _ValueMap={
              'UDP':0,
              'TCP':1}

   UDP=0
   TCP=1

class BandwidthGroupType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=BandwidthGroupType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,BandwidthGroupType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,BandwidthGroupType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return BandwidthGroupType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Disk',2:'Network'}
   _ValueMap={
              'Null':0,
              'Disk':1,
              'Network':2}

   Null=0
   Disk=1
   Network=2

class VBoxEventType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=VBoxEventType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,VBoxEventType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,VBoxEventType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return VBoxEventType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Invalid',1:'Any',2:'Vetoable',3:'MachineEvent',4:'SnapshotEvent',5:'InputEvent',31:'LastWildcard',32:'OnMachineStateChanged',33:'OnMachineDataChanged',34:'OnExtraDataChanged',35:'OnExtraDataCanChange',36:'OnMediumRegistered',37:'OnMachineRegistered',38:'OnSessionStateChanged',39:'OnSnapshotTaken',40:'OnSnapshotDeleted',41:'OnSnapshotChanged',42:'OnGuestPropertyChanged',43:'OnMousePointerShapeChanged',44:'OnMouseCapabilityChanged',45:'OnKeyboardLedsChanged',46:'OnStateChanged',47:'OnAdditionsStateChanged',48:'OnNetworkAdapterChanged',49:'OnSerialPortChanged',50:'OnParallelPortChanged',51:'OnStorageControllerChanged',52:'OnMediumChanged',53:'OnVRDEServerChanged',54:'OnUSBControllerChanged',55:'OnUSBDeviceStateChanged',56:'OnSharedFolderChanged',57:'OnRuntimeError',58:'OnCanShowWindow',59:'OnShowWindow',60:'OnCPUChanged',61:'OnVRDEServerInfoChanged',62:'OnEventSourceChanged',63:'OnCPUExecutionCapChanged',64:'OnGuestKeyboard',65:'OnGuestMouse',66:'OnNATRedirect',67:'OnHostPCIDevicePlug',68:'OnVBoxSVCAvailabilityChanged',69:'OnBandwidthGroupChanged',70:'OnGuestMonitorChanged',71:'OnStorageDeviceChanged',72:'OnClipboardModeChanged',73:'OnDnDModeChanged',74:'OnNATNetworkChanged',75:'OnNATNetworkStartStop',76:'OnNATNetworkAlter',77:'OnNATNetworkCreationDeletion',78:'OnNATNetworkSetting',79:'OnNATNetworkPortForward',80:'OnGuestSessionStateChanged',81:'OnGuestSessionRegistered',82:'OnGuestProcessRegistered',83:'OnGuestProcessStateChanged',84:'OnGuestProcessInputNotify',85:'OnGuestProcessOutput',86:'OnGuestFileRegistered',87:'OnGuestFileStateChanged',88:'OnGuestFileOffsetChanged',89:'OnGuestFileRead',90:'OnGuestFileWrite',91:'OnVideoCaptureChanged',92:'OnGuestUserStateChanged',93:'OnGuestMultiTouch',94:'OnHostNameResolutionConfigurationChange',95:'OnSnapshotRestored',96:'OnMediumConfigChanged',97:'Last'}
   _ValueMap={
              'Invalid':0,
              'Any':1,
              'Vetoable':2,
              'MachineEvent':3,
              'SnapshotEvent':4,
              'InputEvent':5,
              'LastWildcard':31,
              'OnMachineStateChanged':32,
              'OnMachineDataChanged':33,
              'OnExtraDataChanged':34,
              'OnExtraDataCanChange':35,
              'OnMediumRegistered':36,
              'OnMachineRegistered':37,
              'OnSessionStateChanged':38,
              'OnSnapshotTaken':39,
              'OnSnapshotDeleted':40,
              'OnSnapshotChanged':41,
              'OnGuestPropertyChanged':42,
              'OnMousePointerShapeChanged':43,
              'OnMouseCapabilityChanged':44,
              'OnKeyboardLedsChanged':45,
              'OnStateChanged':46,
              'OnAdditionsStateChanged':47,
              'OnNetworkAdapterChanged':48,
              'OnSerialPortChanged':49,
              'OnParallelPortChanged':50,
              'OnStorageControllerChanged':51,
              'OnMediumChanged':52,
              'OnVRDEServerChanged':53,
              'OnUSBControllerChanged':54,
              'OnUSBDeviceStateChanged':55,
              'OnSharedFolderChanged':56,
              'OnRuntimeError':57,
              'OnCanShowWindow':58,
              'OnShowWindow':59,
              'OnCPUChanged':60,
              'OnVRDEServerInfoChanged':61,
              'OnEventSourceChanged':62,
              'OnCPUExecutionCapChanged':63,
              'OnGuestKeyboard':64,
              'OnGuestMouse':65,
              'OnNATRedirect':66,
              'OnHostPCIDevicePlug':67,
              'OnVBoxSVCAvailabilityChanged':68,
              'OnBandwidthGroupChanged':69,
              'OnGuestMonitorChanged':70,
              'OnStorageDeviceChanged':71,
              'OnClipboardModeChanged':72,
              'OnDnDModeChanged':73,
              'OnNATNetworkChanged':74,
              'OnNATNetworkStartStop':75,
              'OnNATNetworkAlter':76,
              'OnNATNetworkCreationDeletion':77,
              'OnNATNetworkSetting':78,
              'OnNATNetworkPortForward':79,
              'OnGuestSessionStateChanged':80,
              'OnGuestSessionRegistered':81,
              'OnGuestProcessRegistered':82,
              'OnGuestProcessStateChanged':83,
              'OnGuestProcessInputNotify':84,
              'OnGuestProcessOutput':85,
              'OnGuestFileRegistered':86,
              'OnGuestFileStateChanged':87,
              'OnGuestFileOffsetChanged':88,
              'OnGuestFileRead':89,
              'OnGuestFileWrite':90,
              'OnVideoCaptureChanged':91,
              'OnGuestUserStateChanged':92,
              'OnGuestMultiTouch':93,
              'OnHostNameResolutionConfigurationChange':94,
              'OnSnapshotRestored':95,
              'OnMediumConfigChanged':96,
              'Last':97}

   Invalid=0
   Any=1
   Vetoable=2
   MachineEvent=3
   SnapshotEvent=4
   InputEvent=5
   LastWildcard=31
   OnMachineStateChanged=32
   OnMachineDataChanged=33
   OnExtraDataChanged=34
   OnExtraDataCanChange=35
   OnMediumRegistered=36
   OnMachineRegistered=37
   OnSessionStateChanged=38
   OnSnapshotTaken=39
   OnSnapshotDeleted=40
   OnSnapshotChanged=41
   OnGuestPropertyChanged=42
   OnMousePointerShapeChanged=43
   OnMouseCapabilityChanged=44
   OnKeyboardLedsChanged=45
   OnStateChanged=46
   OnAdditionsStateChanged=47
   OnNetworkAdapterChanged=48
   OnSerialPortChanged=49
   OnParallelPortChanged=50
   OnStorageControllerChanged=51
   OnMediumChanged=52
   OnVRDEServerChanged=53
   OnUSBControllerChanged=54
   OnUSBDeviceStateChanged=55
   OnSharedFolderChanged=56
   OnRuntimeError=57
   OnCanShowWindow=58
   OnShowWindow=59
   OnCPUChanged=60
   OnVRDEServerInfoChanged=61
   OnEventSourceChanged=62
   OnCPUExecutionCapChanged=63
   OnGuestKeyboard=64
   OnGuestMouse=65
   OnNATRedirect=66
   OnHostPCIDevicePlug=67
   OnVBoxSVCAvailabilityChanged=68
   OnBandwidthGroupChanged=69
   OnGuestMonitorChanged=70
   OnStorageDeviceChanged=71
   OnClipboardModeChanged=72
   OnDnDModeChanged=73
   OnNATNetworkChanged=74
   OnNATNetworkStartStop=75
   OnNATNetworkAlter=76
   OnNATNetworkCreationDeletion=77
   OnNATNetworkSetting=78
   OnNATNetworkPortForward=79
   OnGuestSessionStateChanged=80
   OnGuestSessionRegistered=81
   OnGuestProcessRegistered=82
   OnGuestProcessStateChanged=83
   OnGuestProcessInputNotify=84
   OnGuestProcessOutput=85
   OnGuestFileRegistered=86
   OnGuestFileStateChanged=87
   OnGuestFileOffsetChanged=88
   OnGuestFileRead=89
   OnGuestFileWrite=90
   OnVideoCaptureChanged=91
   OnGuestUserStateChanged=92
   OnGuestMultiTouch=93
   OnHostNameResolutionConfigurationChange=94
   OnSnapshotRestored=95
   OnMediumConfigChanged=96
   Last=97

class GuestMouseEventMode:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=GuestMouseEventMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestMouseEventMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestMouseEventMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return GuestMouseEventMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Relative',1:'Absolute'}
   _ValueMap={
              'Relative':0,
              'Absolute':1}

   Relative=0
   Absolute=1

class GuestMonitorChangedEventType:
   def __init__(self,mgr,handle):
       self.mgr=mgr
       if isinstance(handle,basestring):
           self.handle=GuestMonitorChangedEventType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestMonitorChangedEventType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      if isinstance(other,basestring):
         return str(self) == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestMonitorChangedEventType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      if isinstance(other,basestring):
         return str(self) != other
      return True

   def __str__(self):
        return GuestMonitorChangedEventType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Enabled',1:'Disabled',2:'NewOrigin'}
   _ValueMap={
              'Enabled':0,
              'Disabled':1,
              'NewOrigin':2}

   Enabled=0
   Disabled=1
   NewOrigin=2


import base64

class IWebsessionManager2(IWebsessionManager, ObjectRefManager):
  def __init__(self, url):
       self.url = url
       self.port = None
       self.handle = None
       self.mgr = self
       ObjectRefManager.__init__(self, self.mgr)

  def getPort(self):
      if self.port is None:
          try:
             self.port = vboxServiceLocator().getvboxPortType(self.url)
          except:
             self.port = vboxServiceLocator().getvboxServicePort(self.url)
      return self.port

  def decodebase64(self, str):
      return base64.decodestring(str)

  def encodebase64(self, str):
      return base64.encodestring(str)
