
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * Reason.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_1;

import org.virtualbox_5_1.jaxws.*;
import javax.xml.ws.*;

/**
Internal event reason type.
Interface ID: <tt>{E7E8E097-299D-4E98-8BBC-C31C2D47D0CC}</tt>
*/
public enum Reason
{

/**
Null value, means "no known reason".
*/
    Unspecified(0),

/**
Host is being suspended (power management event).
*/
    HostSuspend(1),

/**
Host is being resumed (power management event).
*/
    HostResume(2),

/**
Host is running low on battery (power management event).
*/
    HostBatteryLow(3),

/**
A snapshot of the VM is being taken.
*/
    Snapshot(4);

    private final int value;

    Reason(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static Reason fromValue(long v)
    {
        for (Reason c: Reason.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static Reason fromValue(String v)
    {
        return valueOf(Reason.class, v);
    }
}

