
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IDisplay.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_1;

import org.virtualbox_5_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The IDisplay interface represents the virtual machine's display.

The object implementing this interface is contained in each{@link org.virtualbox_5_1.IConsole#getDisplay()}attribute and represents the visual
output of the virtual machine.

The virtual display supports pluggable output targets represented by the
IFramebuffer interface. Examples of the output target are a window on
the host computer or an RDP session's display on a remote computer.

Interface ID: <tt>{02326F63-BCB3-4481-96E0-30D1C2EE97F6}</tt>
*/
public class IDisplay extends IUnknown
{

    public IDisplay(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Layout of the guest screens.
@return List&lt;org.virtualbox_5_1.IGuestScreenInfo&gt;
*/
    public List<org.virtualbox_5_1.IGuestScreenInfo> getGuestScreenLayout()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            List<String> retVal = port.iDisplayGetGuestScreenLayout(obj);
            return Helper.wrap(org.virtualbox_5_1.IGuestScreenInfo.class, getObjMgr(), port, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public static IDisplay queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IDisplay(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Queries certain attributes such as display width, height, color depth
and the X and Y origin for a given guest screen.

The parameters  xOrigin and  yOrigin return the X and Y
coordinates of the framebuffer's origin.

All return parameters are optional.
*/
    public void getScreenResolution(Long screenId, Holder<Long> width, Holder<Long> height, Holder<Long> bitsPerPixel, Holder<Integer> xOrigin, Holder<Integer> yOrigin, Holder<org.virtualbox_5_1.GuestMonitorStatus> guestMonitorStatus)
    {
        try
        {
        javax.xml.ws.Holder<Long> tmp_width = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_height = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_bitsPerPixel = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Integer> tmp_xOrigin = new javax.xml.ws.Holder<Integer>();
        javax.xml.ws.Holder<Integer> tmp_yOrigin = new javax.xml.ws.Holder<Integer>();
        javax.xml.ws.Holder<org.virtualbox_5_1.jaxws.GuestMonitorStatus> tmp_guestMonitorStatus = new javax.xml.ws.Holder<org.virtualbox_5_1.jaxws.GuestMonitorStatus>();
        port.iDisplayGetScreenResolution(obj, screenId, tmp_width, tmp_height, tmp_bitsPerPixel, tmp_xOrigin, tmp_yOrigin, tmp_guestMonitorStatus);
        width.value = tmp_width.value;
        height.value = tmp_height.value;
        bitsPerPixel.value = tmp_bitsPerPixel.value;
        xOrigin.value = tmp_xOrigin.value;
        yOrigin.value = tmp_yOrigin.value;
        guestMonitorStatus.value = org.virtualbox_5_1.GuestMonitorStatus.fromValue(tmp_guestMonitorStatus.value.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Sets the graphics update target for a screen.
*/
    public String attachFramebuffer(Long screenId, org.virtualbox_5_1.IFramebuffer framebuffer)
    {
        try
        {
            String retVal;
        retVal = port.iDisplayAttachFramebuffer(obj, screenId, ((framebuffer == null) ? null :framebuffer.getWrapped()));
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Removes the graphics updates target for a screen.
*/
    public void detachFramebuffer(Long screenId, String id)
    {
        try
        {
        port.iDisplayDetachFramebuffer(obj, screenId, id);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Queries the graphics updates targets for a screen.
*/
    public org.virtualbox_5_1.IFramebuffer queryFramebuffer(Long screenId)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.iDisplayQueryFramebuffer(obj, screenId);
           return (retVal.length() > 0) ? new org.virtualbox_5_1.IFramebuffer(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Asks VirtualBox to request the given video mode from
the guest. This is just a hint and it cannot be guaranteed
that the requested resolution will be used. Guest Additions
are required for the request to be seen by guests. The caller
should issue the request and wait for a resolution change and
after a timeout retry.

Specifying  0 for either  width,  height or  bitsPerPixel
parameters means that the corresponding values should be taken from the
current video mode (i.e. left unchanged).

If the guest OS supports multi-monitor configuration then the  display
parameter specifies the number of the guest display to send the hint to:
0 is the primary display,  1 is the first secondary and
so on. If the multi-monitor configuration is not supported,  display
must be  0.
@param display The number of the guest display to send the hint to.

@param enabled True, if this guest screen is enabled,
False otherwise.

@param changeOrigin True, if the origin of the guest screen should be changed,
False otherwise.

@param originX The X origin of the guest screen.

@param originY The Y origin of the guest screen.

Expected result codes:
<table summary="">
<tr><td>E_INVALIDARG</td><td>The  display is not associated with any monitor.</td></tr>
</table>

*/
    public void setVideoModeHint(Long display, Boolean enabled, Boolean changeOrigin, Integer originX, Integer originY, Long width, Long height, Long bitsPerPixel)
    {
        try
        {
        port.iDisplaySetVideoModeHint(obj, display, enabled, changeOrigin, originX, originY, width, height, bitsPerPixel);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Enables or disables seamless guest display rendering (seamless desktop
integration) mode.
NOTE: Calling this method has no effect if{@link org.virtualbox_5_1.IGuest#getFacilityStatus(org.virtualbox_5_1.AdditionsFacilityType,Holder)}with facility  Seamless
does not return  Active.

*/
    public void setSeamlessMode(Boolean enabled)
    {
        try
        {
        port.iDisplaySetSeamlessMode(obj, enabled);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    // Skipping method takeScreenShot for it has parameters with suppressed types

/**
Takes a guest screen shot of the requested size and format
and returns it as an array of bytes.
@param screenId The guest monitor to take screenshot from.

@param width Desired image width.

@param height Desired image height.

@param bitmapFormat The requested format.

@return Array with resulting screen data.

*/
    public byte[] takeScreenShotToArray(Long screenId, Long width, Long height, org.virtualbox_5_1.BitmapFormat bitmapFormat)
    {
        try
        {
            /*base64*/String retVal;
        retVal = port.iDisplayTakeScreenShotToArray(obj, screenId, width, height, org.virtualbox_5_1.jaxws.BitmapFormat.fromValue(bitmapFormat.name()));
           return Helper.decodeBase64(retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    // Skipping method drawToScreen for it has parameters with suppressed types

/**
Does a full invalidation of the VM display and instructs the VM
to update it.
Expected result codes:
<table summary="">
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>Could not invalidate and update screen.</td></tr>
</table>

*/
    public void invalidateAndUpdate()
    {
        try
        {
        port.iDisplayInvalidateAndUpdate(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Redraw the specified VM screen.
@param screenId The guest screen to redraw.

*/
    public void invalidateAndUpdateScreen(Long screenId)
    {
        try
        {
        port.iDisplayInvalidateAndUpdateScreen(obj, screenId);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    // Skipping method completeVHWACommand for it has parameters with suppressed types

/**
Signals that framebuffer window viewport has changed.
@param screenId Monitor to take the screenshot from.

@param x Framebuffer x offset.

@param y Framebuffer y offset.

@param width Viewport width.

@param height Viewport height.

Expected result codes:
<table summary="">
<tr><td>E_INVALIDARG</td><td>The specified viewport data is invalid.</td></tr>
</table>

*/
    public void viewportChanged(Long screenId, Long x, Long y, Long width, Long height)
    {
        try
        {
        port.iDisplayViewportChanged(obj, screenId, x, y, width, height);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    // Skipping method querySourceBitmap for it has parameters with suppressed types

/**
Notify OpenGL HGCM host service about graphics content scaling factor change.
*/
    public void notifyScaleFactorChange(Long screenId, Long u32ScaleFactorWMultiplied, Long u32ScaleFactorHMultiplied)
    {
        try
        {
        port.iDisplayNotifyScaleFactorChange(obj, screenId, u32ScaleFactorWMultiplied, u32ScaleFactorHMultiplied);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Notify OpenGL HGCM host service about HiDPI monitor scaling policy change.
*/
    public void notifyHiDPIOutputPolicyChange(Boolean fUnscaledHiDPI)
    {
        try
        {
        port.iDisplayNotifyHiDPIOutputPolicyChange(obj, fUnscaledHiDPI);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Set video modes for the guest screens.
*/
    public void setScreenLayout(org.virtualbox_5_1.ScreenLayoutMode screenLayoutMode, List<org.virtualbox_5_1.IGuestScreenInfo> guestScreenInfo)
    {
        try
        {
        port.iDisplaySetScreenLayout(obj, org.virtualbox_5_1.jaxws.ScreenLayoutMode.fromValue(screenLayoutMode.name()), Helper.unwrap(guestScreenInfo));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
