
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IEventListener.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Event listener. An event listener can work in either active or passive mode, depending on the way
it was registered.
See{@link org.virtualbox_5_0.IEvent}for an introduction to VirtualBox event handling.

Interface ID: <tt>{67099191-32E7-4F6C-85EE-422304C71B90}</tt>
*/
public class IEventListener extends IUnknown
{

    public IEventListener(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }
    public static IEventListener queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IEventListener(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Handle event callback for active listeners. It is not called for
passive listeners. After calling{@link #handleEvent(org.virtualbox_5_0.IEvent)}on all active listeners
and having received acknowledgement from all passive listeners via{@link org.virtualbox_5_0.IEventSource#eventProcessed(org.virtualbox_5_0.IEventListener,org.virtualbox_5_0.IEvent)}, the event is marked as
processed and{@link org.virtualbox_5_0.IEvent#waitProcessed(Integer)}will return
immediately.
@param event Event available.

*/
    public void handleEvent(org.virtualbox_5_0.IEvent event)
    {
        try
        {
        port.iEventListenerHandleEvent(obj, ((event == null) ? null :event.getWrapped()));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
