
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * FsObjRenameFlag.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
Flags for use when renaming file system objects (files, directories,
symlink, etc), see{@link org.virtualbox_5_0.IGuestSession#fsObjRename(String,String,List)}.
Interface ID: <tt>{59BBF3A1-4E23-D7CF-05D5-CCAE32080ED2}</tt>
*/
public enum FsObjRenameFlag
{

/**
Do not replace any destination object.
*/
    NoReplace(0),

/**
This will attempt to replace any destination object other except
directories. (The default is to fail if the destination exists.)
*/
    Replace(1);

    private final int value;

    FsObjRenameFlag(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static FsObjRenameFlag fromValue(long v)
    {
        for (FsObjRenameFlag c: FsObjRenameFlag.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static FsObjRenameFlag fromValue(String v)
    {
        return valueOf(FsObjRenameFlag.class, v);
    }
}

