
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * FsObjMoveFlags.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
File moving flags.
Interface ID: <tt>{98FDD11F-4063-AC60-5737-E49092AAB95F}</tt>
*/
public enum FsObjMoveFlags
{

/**
No flag set.
*/
    None(0),

/**
Replace the destination file, symlink, etc if it exists, however this
does not allow replacing any directories.
*/
    Replace(1),

/**
Follow symbolic links in the final components or not (only applied to
the given source and target paths, not to anything else).
*/
    FollowLinks(2),

/**
Allow moving directories accross file system boundraries. Because it
is could be a big undertaking, we require extra assurance that we
should do it when requested.
*/
    AllowDirectoryMoves(4);

    private final int value;

    FsObjMoveFlags(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static FsObjMoveFlags fromValue(long v)
    {
        for (FsObjMoveFlags c: FsObjMoveFlags.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static FsObjMoveFlags fromValue(String v)
    {
        return valueOf(FsObjMoveFlags.class, v);
    }
}

