
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IMediumConfigChangedEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The configuration of the given medium was changed (location, properties,
child/parent or anything else).
NOTE: This event is not yet implemented.


Interface ID: <tt>{DD3E2654-A161-41F1-B583-4892F4A9D5D5}</tt>
*/
public class IMediumConfigChangedEvent extends IEvent
{

    public IMediumConfigChangedEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
ID of the medium this event relates to.
@return org.virtualbox_5_0.IMedium
*/
    public org.virtualbox_5_0.IMedium getMedium()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iMediumConfigChangedEventGetMedium(obj);
            return (retVal.length() > 0) ? new org.virtualbox_5_0.IMedium(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public static IMediumConfigChangedEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IMediumConfigChangedEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
