
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IBandwidthGroup.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Represents one bandwidth group.

Interface ID: <tt>{31587F93-2D12-4D7C-BA6D-CE51D0D5B265}</tt>
*/
public class IBandwidthGroup extends IUnknown
{

    public IBandwidthGroup(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Name of the group.
@return String
*/
    public String getName()
    {
        try
        {
            String retVal = port.iBandwidthGroupGetName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Type of the group.
@return org.virtualbox_5_0.BandwidthGroupType
*/
    public org.virtualbox_5_0.BandwidthGroupType getType()
    {
        try
        {
            org.virtualbox_5_0.jaxws.BandwidthGroupType retVal = port.iBandwidthGroupGetType(obj);
            return org.virtualbox_5_0.BandwidthGroupType.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
How many devices/medium attachments use this group.
@return Long
*/
    public Long getReference()
    {
        try
        {
            Long retVal = port.iBandwidthGroupGetReference(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The maximum number of bytes which can be transfered by all
entities attached to this group during one second.
@return Long
*/
    public Long getMaxBytesPerSec()
    {
        try
        {
            Long retVal = port.iBandwidthGroupGetMaxBytesPerSec(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The maximum number of bytes which can be transfered by all
entities attached to this group during one second.
@param value Long

*/
    public void setMaxBytesPerSec(Long value)
    {
        try
        {
        port.iBandwidthGroupSetMaxBytesPerSec(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IBandwidthGroup queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IBandwidthGroup(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
