
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * CPUPropertyType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
Virtual CPU property type. This enumeration represents possible values of the
IMachine get- and setCPUProperty methods.
Interface ID: <tt>{ED4094C1-D00E-483A-93E9-7163549EBD6E}</tt>
*/
public enum CPUPropertyType
{

/**
Null value (never used by the API).
*/
    Null(0),

/**
This setting determines whether VirtualBox will expose the Physical Address
Extension (PAE) feature of the host CPU to the guest. Note that in case PAE
is not available, it will not be reported.
*/
    PAE(1),

/**
This setting determines whether VirtualBox will advertise long mode
(i.e. 64-bit guest support) and let the guest enter it.
*/
    LongMode(2),

/**
This setting determines whether a triple fault within a guest will trigger an internal
error condition and stop the VM (default) or reset the virtual CPU and continue execution.
*/
    TripleFaultReset(3);

    private final int value;

    CPUPropertyType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static CPUPropertyType fromValue(long v)
    {
        for (CPUPropertyType c: CPUPropertyType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static CPUPropertyType fromValue(String v)
    {
        return valueOf(CPUPropertyType.class, v);
    }
}

