
/*
 * Copyright (C) 2010-2015 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * DirectoryCopyFlags.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
Directory copying flags.
NOTE: Not flags are implemented yet.

Interface ID: <tt>{CC500F0C-4A54-88C9-56B3-7E9310416DA7}</tt>
*/
public enum DirectoryCopyFlags
{

/**
No flag set.
*/
    None(0),

/**
Allow copying into an existing destination directory.
*/
    CopyIntoExisting(1);

    private final int value;

    DirectoryCopyFlags(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static DirectoryCopyFlags fromValue(long v)
    {
        for (DirectoryCopyFlags c: DirectoryCopyFlags.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static DirectoryCopyFlags fromValue(String v)
    {
        return valueOf(DirectoryCopyFlags.class, v);
    }
}

