
/*
 * Copyright (C) 2010-2015 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * StorageBus.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
The bus type of the storage controller (IDE, SATA, SCSI, SAS or Floppy);
see{@link org.virtualbox_5_0.IStorageController#getBus()}.
Interface ID: <tt>{2DAB9DF1-9683-48FD-8C11-CAADA236FCB0}</tt>
*/
public enum StorageBus
{

/**
null value. Never used by the API.
*/
    Null(0),
    IDE(1),
    SATA(2),
    SCSI(3),
    Floppy(4),
    SAS(5),
    USB(6);

    private final int value;

    StorageBus(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static StorageBus fromValue(long v)
    {
        for (StorageBus c: StorageBus.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static StorageBus fromValue(String v)
    {
        return valueOf(StorageBus.class, v);
    }
}

