
/*
 * Copyright (C) 2010-2015 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * FileCopyFlag.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
File copying flags.
NOTE: Not flags are implemented yet.

Interface ID: <tt>{791909D7-4C64-2FA4-4303-ADB10658D347}</tt>
*/
public enum FileCopyFlag
{

/**
No flag set.
*/
    None(0),

/**
Do not replace the destination file if it exists.
NOTE: This flag is not implemented yet.

*/
    NoReplace(1),

/**
Follow symbolic links.
NOTE: This flag is not implemented yet.

*/
    FollowLinks(2),

/**
Only copy when the source file is newer than the destination file
or when the destination file is missing.
NOTE: This flag is not implemented yet.

*/
    Update(4);

    private final int value;

    FileCopyFlag(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static FileCopyFlag fromValue(long v)
    {
        for (FileCopyFlag c: FileCopyFlag.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static FileCopyFlag fromValue(String v)
    {
        return valueOf(FileCopyFlag.class, v);
    }
}

