
/*
 * Copyright (C) 2010-2015 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IDnDBase.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Base abstract interface for drag'n drop.

Interface ID: <tt>{4132147B-42F8-CD96-7570-6A8800E3342C}</tt>
*/
public class IDnDBase extends IUnknown
{

    public IDnDBase(String wrapped, VboxPortType port)
    {
        super(wrapped, port);
    }

/**
Returns all supported drag'n drop formats.
@return List&lt;String&gt;
*/
    public List<String> getFormats()
    {
        try
        {
            List<String> retVal = port.iDnDBaseGetFormats(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Returns the protocol version which is used to communicate
with the guest.
@return Long
*/
    public Long getProtocolVersion()
    {
        try
        {
            Long retVal = port.iDnDBaseGetProtocolVersion(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public static IDnDBase queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IDnDBase(obj.getWrapped(), obj.getRemoteWSPort());
    }

/**
Checks if a specific drag'n drop MIME / Content-type format is supported.
@param format Format to check for.

@return Returns  true if the specified format is supported,  false if not.

*/
    public Boolean isFormatSupported(String format)
    {
        try
        {
            Boolean retVal;
        retVal = port.iDnDBaseIsFormatSupported(obj, format);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Adds MIME / Content-type formats to the supported formats.
@param formats Collection of formats to add.

*/
    public void addFormats(List<String> formats)
    {
        try
        {
        port.iDnDBaseAddFormats(obj, formats);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Removes MIME / Content-type formats from the supported formats.
@param formats Collection of formats to remove.

*/
    public void removeFormats(List<String> formats)
    {
        try
        {
        port.iDnDBaseRemoveFormats(obj, formats);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
}
