/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_5_0;

import java.util.List;
import org.virtualbox_5_0.Helper;
import org.virtualbox_5_0.Holder;
import org.virtualbox_5_0.IHostNetworkInterface;
import org.virtualbox_5_0.IHostUSBDevice;
import org.virtualbox_5_0.IHostUSBDeviceFilter;
import org.virtualbox_5_0.IHostVideoInputDevice;
import org.virtualbox_5_0.IMedium;
import org.virtualbox_5_0.IProgress;
import org.virtualbox_5_0.IUnknown;
import org.virtualbox_5_0.ProcessorFeature;
import org.virtualbox_5_0.VBoxException;
import org.virtualbox_5_0.jaxws.HostNetworkInterfaceType;
import org.virtualbox_5_0.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_5_0.jaxws.RuntimeFaultMsg;
import org.virtualbox_5_0.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IHost
extends IUnknown {
    public IHost(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public List<IMedium> getDVDDrives() {
        try {
            List<String> list = this.port.iHostGetDVDDrives(this.obj);
            return Helper.wrap(IMedium.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public List<IMedium> getFloppyDrives() {
        try {
            List<String> list = this.port.iHostGetFloppyDrives(this.obj);
            return Helper.wrap(IMedium.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public List<IHostUSBDevice> getUSBDevices() {
        try {
            List<String> list = this.port.iHostGetUSBDevices(this.obj);
            return Helper.wrap(IHostUSBDevice.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public List<IHostUSBDeviceFilter> getUSBDeviceFilters() {
        try {
            List<String> list = this.port.iHostGetUSBDeviceFilters(this.obj);
            return Helper.wrap(IHostUSBDeviceFilter.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public List<IHostNetworkInterface> getNetworkInterfaces() {
        try {
            List<String> list = this.port.iHostGetNetworkInterfaces(this.obj);
            return Helper.wrap(IHostNetworkInterface.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public List<String> getNameServers() {
        try {
            List<String> list = this.port.iHostGetNameServers(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public String getDomainName() {
        try {
            String string = this.port.iHostGetDomainName(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public List<String> getSearchStrings() {
        try {
            List<String> list = this.port.iHostGetSearchStrings(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Long getProcessorCount() {
        try {
            Long l = this.port.iHostGetProcessorCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Long getProcessorOnlineCount() {
        try {
            Long l = this.port.iHostGetProcessorOnlineCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Long getProcessorCoreCount() {
        try {
            Long l = this.port.iHostGetProcessorCoreCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Long getProcessorOnlineCoreCount() {
        try {
            Long l = this.port.iHostGetProcessorOnlineCoreCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Long getMemorySize() {
        try {
            Long l = this.port.iHostGetMemorySize(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Long getMemoryAvailable() {
        try {
            Long l = this.port.iHostGetMemoryAvailable(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public String getOperatingSystem() {
        try {
            String string = this.port.iHostGetOperatingSystem(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public String getOSVersion() {
        try {
            String string = this.port.iHostGetOSVersion(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Long getUTCTime() {
        try {
            Long l = this.port.iHostGetUTCTime(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Boolean getAcceleration3DAvailable() {
        try {
            Boolean bl = this.port.iHostGetAcceleration3DAvailable(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public List<IHostVideoInputDevice> getVideoInputDevices() {
        try {
            List<String> list = this.port.iHostGetVideoInputDevices(this.obj);
            return Helper.wrap(IHostVideoInputDevice.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public static IHost queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IHost(iUnknown.getWrapped(), iUnknown.getRemoteWSPort());
    }

    public Long getProcessorSpeed(Long l) {
        try {
            Long l2 = this.port.iHostGetProcessorSpeed(this.obj, l);
            return l2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public Boolean getProcessorFeature(ProcessorFeature processorFeature) {
        try {
            Boolean bl = this.port.iHostGetProcessorFeature(this.obj, org.virtualbox_5_0.jaxws.ProcessorFeature.fromValue(processorFeature.name()));
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public String getProcessorDescription(Long l) {
        try {
            String string = this.port.iHostGetProcessorDescription(this.obj, l);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public void getProcessorCPUIDLeaf(Long l, Long l2, Long l3, Holder<Long> holder, Holder<Long> holder2, Holder<Long> holder3, Holder<Long> holder4) {
        try {
            javax.xml.ws.Holder holder5 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder6 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder7 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder8 = new javax.xml.ws.Holder();
            this.port.iHostGetProcessorCPUIDLeaf(this.obj, l, l2, l3, (javax.xml.ws.Holder<Long>)holder5, (javax.xml.ws.Holder<Long>)holder6, (javax.xml.ws.Holder<Long>)holder7, (javax.xml.ws.Holder<Long>)holder8);
            holder.value = holder5.value;
            holder2.value = holder6.value;
            holder3.value = holder7.value;
            holder4.value = holder8.value;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IProgress createHostOnlyNetworkInterface(Holder<IHostNetworkInterface> holder) {
        try {
            javax.xml.ws.Holder holder2 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder3 = new javax.xml.ws.Holder();
            this.port.iHostCreateHostOnlyNetworkInterface(this.obj, (javax.xml.ws.Holder<String>)holder2, (javax.xml.ws.Holder<String>)holder3);
            holder.value = ((String)holder2.value).length() > 0 ? new IHostNetworkInterface((String)holder2.value, this.port) : null;
            return ((String)holder3.value).length() > 0 ? new IProgress((String)holder3.value, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IProgress removeHostOnlyNetworkInterface(String string) {
        try {
            String string2 = this.port.iHostRemoveHostOnlyNetworkInterface(this.obj, string);
            return string2.length() > 0 ? new IProgress(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IHostUSBDeviceFilter createUSBDeviceFilter(String string) {
        try {
            String string2 = this.port.iHostCreateUSBDeviceFilter(this.obj, string);
            return string2.length() > 0 ? new IHostUSBDeviceFilter(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public void insertUSBDeviceFilter(Long l, IHostUSBDeviceFilter iHostUSBDeviceFilter) {
        try {
            this.port.iHostInsertUSBDeviceFilter(this.obj, l, iHostUSBDeviceFilter == null ? null : iHostUSBDeviceFilter.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public void removeUSBDeviceFilter(Long l) {
        try {
            this.port.iHostRemoveUSBDeviceFilter(this.obj, l);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IMedium findHostDVDDrive(String string) {
        try {
            String string2 = this.port.iHostFindHostDVDDrive(this.obj, string);
            return string2.length() > 0 ? new IMedium(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IMedium findHostFloppyDrive(String string) {
        try {
            String string2 = this.port.iHostFindHostFloppyDrive(this.obj, string);
            return string2.length() > 0 ? new IMedium(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IHostNetworkInterface findHostNetworkInterfaceByName(String string) {
        try {
            String string2 = this.port.iHostFindHostNetworkInterfaceByName(this.obj, string);
            return string2.length() > 0 ? new IHostNetworkInterface(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IHostNetworkInterface findHostNetworkInterfaceById(String string) {
        try {
            String string2 = this.port.iHostFindHostNetworkInterfaceById(this.obj, string);
            return string2.length() > 0 ? new IHostNetworkInterface(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public List<IHostNetworkInterface> findHostNetworkInterfacesOfType(org.virtualbox_5_0.HostNetworkInterfaceType hostNetworkInterfaceType) {
        try {
            List<String> list = this.port.iHostFindHostNetworkInterfacesOfType(this.obj, HostNetworkInterfaceType.fromValue(hostNetworkInterfaceType.name()));
            return Helper.wrap(IHostNetworkInterface.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IHostUSBDevice findUSBDeviceById(String string) {
        try {
            String string2 = this.port.iHostFindUSBDeviceById(this.obj, string);
            return string2.length() > 0 ? new IHostUSBDevice(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public IHostUSBDevice findUSBDeviceByAddress(String string) {
        try {
            String string2 = this.port.iHostFindUSBDeviceByAddress(this.obj, string);
            return string2.length() > 0 ? new IHostUSBDevice(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }

    public String generateMACAddress() {
        try {
            String string = this.port.iHostGenerateMACAddress(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), invalidObjectFaultMsg, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), runtimeFaultMsg, this.port);
        }
    }
}

