
/*
 * Copyright (C) 2010-2015 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * VBoxEventType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
Type of an event.
See{@link org.virtualbox_5_0.IEvent}for an introduction to VirtualBox event handling.
Interface ID: <tt>{B2DDB312-2F9E-4E69-98DF-7235E43B2149}</tt>
*/
public enum VBoxEventType
{

/**
Invalid event, must be first.
*/
    Invalid(0),

/**
Wildcard for all events.
Events of this type are never delivered, and only used in{@link org.virtualbox_5_0.IEventSource#registerListener(org.virtualbox_5_0.IEventListener,List,Boolean)}call to simplify registration.
*/
    Any(1),

/**
Wildcard for all vetoable events. Events of this type are never delivered, and only
used in{@link org.virtualbox_5_0.IEventSource#registerListener(org.virtualbox_5_0.IEventListener,List,Boolean)}call to simplify registration.
*/
    Vetoable(2),

/**
Wildcard for all machine events. Events of this type are never delivered, and only used in{@link org.virtualbox_5_0.IEventSource#registerListener(org.virtualbox_5_0.IEventListener,List,Boolean)}call to simplify registration.
*/
    MachineEvent(3),

/**
Wildcard for all snapshot events. Events of this type are never delivered, and only used in{@link org.virtualbox_5_0.IEventSource#registerListener(org.virtualbox_5_0.IEventListener,List,Boolean)}call to simplify registration.
*/
    SnapshotEvent(4),

/**
Wildcard for all input device (keyboard, mouse) events.
Events of this type are never delivered, and only used in{@link org.virtualbox_5_0.IEventSource#registerListener(org.virtualbox_5_0.IEventListener,List,Boolean)}call to simplify registration.
*/
    InputEvent(5),

/**
Last wildcard.
*/
    LastWildcard(31),

/**
See{@link org.virtualbox_5_0.IMachineStateChangedEvent}.
*/
    OnMachineStateChanged(32),

/**
See{@link org.virtualbox_5_0.IMachineDataChangedEvent}.
*/
    OnMachineDataChanged(33),

/**
See{@link org.virtualbox_5_0.IExtraDataChangedEvent}.
*/
    OnExtraDataChanged(34),

/**
See{@link org.virtualbox_5_0.IExtraDataCanChangeEvent}.
*/
    OnExtraDataCanChange(35),

/**
See{@link org.virtualbox_5_0.IMediumRegisteredEvent}.
*/
    OnMediumRegistered(36),

/**
See{@link org.virtualbox_5_0.IMachineRegisteredEvent}.
*/
    OnMachineRegistered(37),

/**
See{@link org.virtualbox_5_0.ISessionStateChangedEvent}.
*/
    OnSessionStateChanged(38),

/**
See{@link org.virtualbox_5_0.ISnapshotTakenEvent}.
*/
    OnSnapshotTaken(39),

/**
See{@link org.virtualbox_5_0.ISnapshotDeletedEvent}.
*/
    OnSnapshotDeleted(40),

/**
See{@link org.virtualbox_5_0.ISnapshotChangedEvent}.
*/
    OnSnapshotChanged(41),

/**
See{@link org.virtualbox_5_0.IGuestPropertyChangedEvent}.
*/
    OnGuestPropertyChanged(42),

/**
See{@link org.virtualbox_5_0.IMousePointerShapeChangedEvent}.
*/
    OnMousePointerShapeChanged(43),

/**
See{@link org.virtualbox_5_0.IMouseCapabilityChangedEvent}.
*/
    OnMouseCapabilityChanged(44),

/**
See{@link org.virtualbox_5_0.IKeyboardLedsChangedEvent}.
*/
    OnKeyboardLedsChanged(45),

/**
See{@link org.virtualbox_5_0.IStateChangedEvent}.
*/
    OnStateChanged(46),

/**
See{@link org.virtualbox_5_0.IAdditionsStateChangedEvent}.
*/
    OnAdditionsStateChanged(47),

/**
See{@link org.virtualbox_5_0.INetworkAdapterChangedEvent}.
*/
    OnNetworkAdapterChanged(48),

/**
See{@link org.virtualbox_5_0.ISerialPortChangedEvent}.
*/
    OnSerialPortChanged(49),

/**
See{@link org.virtualbox_5_0.IParallelPortChangedEvent}.
*/
    OnParallelPortChanged(50),

/**
See{@link org.virtualbox_5_0.IStorageControllerChangedEvent}.
*/
    OnStorageControllerChanged(51),

/**
See{@link org.virtualbox_5_0.IMediumChangedEvent}.
*/
    OnMediumChanged(52),

/**
See{@link org.virtualbox_5_0.IVRDEServerChangedEvent}.
*/
    OnVRDEServerChanged(53),

/**
See{@link org.virtualbox_5_0.IUSBControllerChangedEvent}.
*/
    OnUSBControllerChanged(54),

/**
See{@link org.virtualbox_5_0.IUSBDeviceStateChangedEvent}.
*/
    OnUSBDeviceStateChanged(55),

/**
See{@link org.virtualbox_5_0.ISharedFolderChangedEvent}.
*/
    OnSharedFolderChanged(56),

/**
See{@link org.virtualbox_5_0.IRuntimeErrorEvent}.
*/
    OnRuntimeError(57),

/**
See{@link org.virtualbox_5_0.ICanShowWindowEvent}.
*/
    OnCanShowWindow(58),

/**
See{@link org.virtualbox_5_0.IShowWindowEvent}.
*/
    OnShowWindow(59),

/**
See{@link org.virtualbox_5_0.ICPUChangedEvent}.
*/
    OnCPUChanged(60),

/**
See{@link org.virtualbox_5_0.IVRDEServerInfoChangedEvent}.
*/
    OnVRDEServerInfoChanged(61),

/**
See{@link org.virtualbox_5_0.IEventSourceChangedEvent}.
*/
    OnEventSourceChanged(62),

/**
See{@link org.virtualbox_5_0.ICPUExecutionCapChangedEvent}.
*/
    OnCPUExecutionCapChanged(63),

/**
See{@link org.virtualbox_5_0.IGuestKeyboardEvent}.
*/
    OnGuestKeyboard(64),

/**
See{@link org.virtualbox_5_0.IGuestMouseEvent}.
*/
    OnGuestMouse(65),

/**
See{@link org.virtualbox_5_0.INATRedirectEvent}.
*/
    OnNATRedirect(66),

/**
See{@link org.virtualbox_5_0.IHostPCIDevicePlugEvent}.
*/
    OnHostPCIDevicePlug(67),

/**
See{@link org.virtualbox_5_0.IVBoxSVCAvailabilityChangedEvent}.
*/
    OnVBoxSVCAvailabilityChanged(68),

/**
See{@link org.virtualbox_5_0.IBandwidthGroupChangedEvent}.
*/
    OnBandwidthGroupChanged(69),

/**
See{@link org.virtualbox_5_0.IGuestMonitorChangedEvent}.
*/
    OnGuestMonitorChanged(70),

/**
See{@link org.virtualbox_5_0.IStorageDeviceChangedEvent}.
*/
    OnStorageDeviceChanged(71),

/**
See{@link org.virtualbox_5_0.IClipboardModeChangedEvent}.
*/
    OnClipboardModeChanged(72),

/**
See{@link org.virtualbox_5_0.IDnDModeChangedEvent}.
*/
    OnDnDModeChanged(73),

/**
See{@link org.virtualbox_5_0.INATNetworkChangedEvent}.
*/
    OnNATNetworkChanged(74),

/**
See{@link org.virtualbox_5_0.INATNetworkStartStopEvent}.
*/
    OnNATNetworkStartStop(75),

/**
See{@link org.virtualbox_5_0.INATNetworkAlterEvent}.
*/
    OnNATNetworkAlter(76),

/**
See{@link org.virtualbox_5_0.INATNetworkCreationDeletionEvent}.
*/
    OnNATNetworkCreationDeletion(77),

/**
See{@link org.virtualbox_5_0.INATNetworkSettingEvent}.
*/
    OnNATNetworkSetting(78),

/**
See{@link org.virtualbox_5_0.INATNetworkPortForwardEvent}.
*/
    OnNATNetworkPortForward(79),

/**
See{@link org.virtualbox_5_0.IGuestSessionStateChangedEvent}.
*/
    OnGuestSessionStateChanged(80),

/**
See{@link org.virtualbox_5_0.IGuestSessionRegisteredEvent}.
*/
    OnGuestSessionRegistered(81),

/**
See{@link org.virtualbox_5_0.IGuestProcessRegisteredEvent}.
*/
    OnGuestProcessRegistered(82),

/**
See{@link org.virtualbox_5_0.IGuestProcessStateChangedEvent}.
*/
    OnGuestProcessStateChanged(83),

/**
See{@link org.virtualbox_5_0.IGuestProcessInputNotifyEvent}.
*/
    OnGuestProcessInputNotify(84),

/**
See{@link org.virtualbox_5_0.IGuestProcessOutputEvent}.
*/
    OnGuestProcessOutput(85),

/**
See{@link org.virtualbox_5_0.IGuestFileRegisteredEvent}.
*/
    OnGuestFileRegistered(86),

/**
See{@link org.virtualbox_5_0.IGuestFileStateChangedEvent}.
*/
    OnGuestFileStateChanged(87),

/**
See{@link org.virtualbox_5_0.IGuestFileOffsetChangedEvent}.
*/
    OnGuestFileOffsetChanged(88),

/**
See{@link org.virtualbox_5_0.IGuestFileReadEvent}.
*/
    OnGuestFileRead(89),

/**
See{@link org.virtualbox_5_0.IGuestFileWriteEvent}.
*/
    OnGuestFileWrite(90),

/**
See{@link org.virtualbox_5_0.IVideoCaptureChangedEvent}.
*/
    OnVideoCaptureChanged(91),

/**
See{@link org.virtualbox_5_0.IGuestUserStateChangedEvent}.
*/
    OnGuestUserStateChanged(92),

/**
See{@link org.virtualbox_5_0.IGuestMouseEvent}.
*/
    OnGuestMultiTouch(93),

/**
See{@link org.virtualbox_5_0.IHostNameResolutionConfigurationChangeEvent}.
*/
    OnHostNameResolutionConfigurationChange(94),

/**
See{@link org.virtualbox_5_0.ISnapshotRestoredEvent}.
*/
    OnSnapshotRestored(95),

/**
See{@link org.virtualbox_5_0.IMediumConfigChangedEvent}.
*/
    OnMediumConfigChanged(96),

/**
Must be last event, used for iterations and structures relying on numerical event values.
*/
    Last(97);

    private final int value;

    VBoxEventType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static VBoxEventType fromValue(long v)
    {
        for (VBoxEventType c: VBoxEventType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static VBoxEventType fromValue(String v)
    {
        return valueOf(VBoxEventType.class, v);
    }
}

