
/*
 * Copyright (C) 2010-2015 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IMouse.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The IMouse interface represents the virtual machine's mouse. Used in{@link org.virtualbox_5_0.IConsole#getMouse()}.

Through this interface, the virtual machine's virtual mouse can be
controlled.

Interface ID: <tt>{EE35ADB0-4748-3E12-E7FD-5AAD957BBA0F}</tt>
*/
public class IMouse extends IUnknown
{

    public IMouse(String wrapped, VboxPortType port)
    {
        super(wrapped, port);
    }

/**
Whether the guest OS supports absolute mouse pointer positioning
or not.
NOTE: You can use the{@link org.virtualbox_5_0.IMouseCapabilityChangedEvent}event to be instantly informed about changes of this attribute
during virtual machine execution.

@return Boolean

@see #putMouseEventAbsolute(Integer,Integer,Integer,Integer,Integer)
*/
    public Boolean getAbsoluteSupported()
    {
        try
        {
            Boolean retVal = port.iMouseGetAbsoluteSupported(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Whether the guest OS supports relative mouse pointer positioning
or not.
NOTE: You can use the{@link org.virtualbox_5_0.IMouseCapabilityChangedEvent}event to be instantly informed about changes of this attribute
during virtual machine execution.

@return Boolean

@see #putMouseEvent(Integer,Integer,Integer,Integer,Integer)
*/
    public Boolean getRelativeSupported()
    {
        try
        {
            Boolean retVal = port.iMouseGetRelativeSupported(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Whether the guest OS has enabled the multi-touch reporting device.
NOTE: You can use the{@link org.virtualbox_5_0.IMouseCapabilityChangedEvent}event to be instantly informed about changes of this attribute
during virtual machine execution.

@return Boolean

@see #putMouseEvent(Integer,Integer,Integer,Integer,Integer)
*/
    public Boolean getMultiTouchSupported()
    {
        try
        {
            Boolean retVal = port.iMouseGetMultiTouchSupported(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Whether the guest OS can currently switch to drawing it's own mouse
cursor on demand.
NOTE: You can use the{@link org.virtualbox_5_0.IMouseCapabilityChangedEvent}event to be instantly informed about changes of this attribute
during virtual machine execution.

@return Boolean

@see #putMouseEvent(Integer,Integer,Integer,Integer,Integer)
*/
    public Boolean getNeedsHostCursor()
    {
        try
        {
            Boolean retVal = port.iMouseGetNeedsHostCursor(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
The current mouse pointer used by the guest.
@return org.virtualbox_5_0.IMousePointerShape
*/
    public org.virtualbox_5_0.IMousePointerShape getPointerShape()
    {
        try
        {
            String retVal = port.iMouseGetPointerShape(obj);
            return (retVal.length() > 0) ? new org.virtualbox_5_0.IMousePointerShape(retVal, port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Event source for mouse events.
@return org.virtualbox_5_0.IEventSource
*/
    public org.virtualbox_5_0.IEventSource getEventSource()
    {
        try
        {
            String retVal = port.iMouseGetEventSource(obj);
            return (retVal.length() > 0) ? new org.virtualbox_5_0.IEventSource(retVal, port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public static IMouse queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IMouse(obj.getWrapped(), obj.getRemoteWSPort());
    }

/**
Initiates a mouse event using relative pointer movements
along x and y axis.
@param dx Amount of pixels the mouse should move to the right.
Negative values move the mouse to the left.

@param dy Amount of pixels the mouse should move downwards.
Negative values move the mouse upwards.

@param dz Amount of mouse wheel moves.
Positive values describe clockwise wheel rotations,
negative values describe counterclockwise rotations.

@param dw Amount of horizontal mouse wheel moves.
Positive values describe a movement to the left,
negative values describe a movement to the right.

@param buttonState The current state of mouse buttons. Every bit represents
a mouse button as follows:<table summary=""><tr><td>Bit 0 (<tt>0x01</tt>)</td><td>left mouse button</td></tr><tr><td>Bit 1 (<tt>0x02</tt>)</td><td>right mouse button</td></tr><tr><td>Bit 2 (<tt>0x04</tt>)</td><td>middle mouse button</td></tr></table>A value of<tt>1</tt>means the corresponding button is pressed.
otherwise it is released.

Expected result codes:
<table summary="">
<tr><td>E_ACCESSDENIED</td><td>Console not powered up.</td></tr>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>Could not send mouse event to virtual mouse.</td></tr>
</table>

*/
    public void putMouseEvent(Integer dx, Integer dy, Integer dz, Integer dw, Integer buttonState)
    {
        try
        {
        port.iMousePutMouseEvent(obj, dx, dy, dz, dw, buttonState);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Positions the mouse pointer using absolute x and y coordinates.
These coordinates are expressed in pixels and
start from<tt>[1,1]</tt>which corresponds to the top left
corner of the virtual display.
@param x X coordinate of the pointer in pixels, starting from  1.

@param y Y coordinate of the pointer in pixels, starting from  1.

@param dz Amount of mouse wheel moves.
Positive values describe clockwise wheel rotations,
negative values describe counterclockwise rotations.

@param dw Amount of horizontal mouse wheel moves.
Positive values describe a movement to the left,
negative values describe a movement to the right.

@param buttonState The current state of mouse buttons. Every bit represents
a mouse button as follows:<table summary=""><tr><td>Bit 0 (<tt>0x01</tt>)</td><td>left mouse button</td></tr><tr><td>Bit 1 (<tt>0x02</tt>)</td><td>right mouse button</td></tr><tr><td>Bit 2 (<tt>0x04</tt>)</td><td>middle mouse button</td></tr></table>A value of  1 means the corresponding button is pressed.
otherwise it is released.

Expected result codes:
<table summary="">
<tr><td>E_ACCESSDENIED</td><td>Console not powered up.</td></tr>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>Could not send mouse event to virtual mouse.</td></tr>
</table>

NOTE: This method will have effect only if absolute mouse
positioning is supported by the guest OS.

@see #getAbsoluteSupported()

*/
    public void putMouseEventAbsolute(Integer x, Integer y, Integer dz, Integer dw, Integer buttonState)
    {
        try
        {
        port.iMousePutMouseEventAbsolute(obj, x, y, dz, dw, buttonState);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Sends a multi-touch pointer event. The coordinates are expressed in
pixels and start from<tt>[1,1]</tt>which corresponds to the top left
corner of the virtual display.
@param count Number of contacts in the event.

@param contacts Each array element contains packed information about one contact.
Bits 0..15: X coordinate in pixels.
Bits 16..31: Y coordinate in pixels.
Bits 32..39: contact identifier.
Bit 40: "in contact" flag, which indicates that there is a contact with the touch surface.
Bit 41: "in range" flag, the contact is close enough to the touch surface.
All other bits are reserved for future use and must be set to 0.

@param scanTime Timestamp of the event in milliseconds. Only relative time between events is important.

Expected result codes:
<table summary="">
<tr><td>E_ACCESSDENIED</td><td>Console not powered up.</td></tr>
<tr><td>@link ::VBOX_E_IPRT_ERROR VBOX_E_IPRT_ERROR</td><td>Could not send event to virtual device.</td></tr>
</table>

NOTE: The guest may not understand or may choose to ignore this event.

@see #getMultiTouchSupported()

*/
    public void putEventMultiTouch(Integer count, List<Long> contacts, Long scanTime)
    {
        try
        {
        port.iMousePutEventMultiTouch(obj, count, contacts, scanTime);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**

@param contacts Contains information about all contacts:
"id1,x1,y1,inContact1,inRange1;...;idN,xN,yN,inContactN,inRangeN".
For example for two contacts: "0,10,20,1,1;1,30,40,1,1"

@see #putEventMultiTouch(Integer,List,Long)

*/
    public void putEventMultiTouchString(Integer count, String contacts, Long scanTime)
    {
        try
        {
        port.iMousePutEventMultiTouchString(obj, count, contacts, scanTime);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
}
