
/*
 * Copyright (C) 2010-2014 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * AutostopType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
Autostop types, used with{@link org.virtualbox_5_0.IMachine#getAutostopType()}.
Interface ID: <tt>{6BB96740-CF34-470D-AAB2-2CD48EA2E10E}</tt>
*/
public enum AutostopType
{

/**
Stopping the VM during system shutdown is disabled.
*/
    Disabled(1),

/**
The state of the VM will be saved when the system shuts down.
*/
    SaveState(2),

/**
The VM is powered off when the system shuts down.
*/
    PowerOff(3),

/**
An ACPI shutdown event is generated.
*/
    AcpiShutdown(4);

    private final int value;

    AutostopType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static AutostopType fromValue(long v)
    {
        for (AutostopType c: AutostopType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static AutostopType fromValue(String v)
    {
        return valueOf(AutostopType.class, v);
    }
}

