
/*
 * Copyright (C) 2010-2014 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IHostVideoInputDevice.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Represents one of host's video capture devices, for example a webcam.

Interface ID: <tt>{A1CEAE44-D65E-4156-9359-D390F93EE9A0}</tt>
*/
public class IHostVideoInputDevice extends IUnknown
{

    public IHostVideoInputDevice(String wrapped, VboxPortType port)
    {
        super(wrapped, port);
    }

/**
User friendly name.
@return String
*/
    public String getName()
    {
        try
        {
            String retVal = port.iHostVideoInputDeviceGetName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
The host path of the device.
@return String
*/
    public String getPath()
    {
        try
        {
            String retVal = port.iHostVideoInputDeviceGetPath(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
An alias which can be used for IConsole::webcamAttach
@return String
*/
    public String getAlias()
    {
        try
        {
            String retVal = port.iHostVideoInputDeviceGetAlias(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public static IHostVideoInputDevice queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IHostVideoInputDevice(obj.getWrapped(), obj.getRemoteWSPort());
    }
}
