
/*
 * Copyright (C) 2010-2014 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IDHCPServer.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The IDHCPServer interface represents the VirtualBox DHCP server configuration.

To enumerate all the DHCP servers on the host, use the{@link org.virtualbox_5_0.IVirtualBox#getDHCPServers()}attribute.

Interface ID: <tt>{FF0774C5-1F62-4BC3-919C-7FC942BF1D25}</tt>
*/
public class IDHCPServer extends IUnknown
{

    public IDHCPServer(String wrapped, VboxPortType port)
    {
        super(wrapped, port);
    }
    public org.virtualbox_5_0.IEventSource getEventSource()
    {
        try
        {
            String retVal = port.idhcpServerGetEventSource(obj);
            return (retVal.length() > 0) ? new org.virtualbox_5_0.IEventSource(retVal, port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
specifies if the DHCP server is enabled
@return Boolean
*/
    public Boolean getEnabled()
    {
        try
        {
            Boolean retVal = port.idhcpServerGetEnabled(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
specifies if the DHCP server is enabled
@param value Boolean

*/
    public void setEnabled(Boolean value)
    {
        try
        {
        port.idhcpServerSetEnabled(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
specifies server IP
@return String
*/
    public String getIPAddress()
    {
        try
        {
            String retVal = port.idhcpServerGetIPAddress(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
specifies server network mask
@return String
*/
    public String getNetworkMask()
    {
        try
        {
            String retVal = port.idhcpServerGetNetworkMask(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
specifies internal network name the server is used for
@return String
*/
    public String getNetworkName()
    {
        try
        {
            String retVal = port.idhcpServerGetNetworkName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
specifies from IP address in server address range
@return String
*/
    public String getLowerIP()
    {
        try
        {
            String retVal = port.idhcpServerGetLowerIP(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
specifies to IP address in server address range
@return String
*/
    public String getUpperIP()
    {
        try
        {
            String retVal = port.idhcpServerGetUpperIP(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public List<String> getGlobalOptions()
    {
        try
        {
            List<String> retVal = port.idhcpServerGetGlobalOptions(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public List<String> getVmConfigs()
    {
        try
        {
            List<String> retVal = port.idhcpServerGetVmConfigs(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public static IDHCPServer queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IDHCPServer(obj.getWrapped(), obj.getRemoteWSPort());
    }
    public void addGlobalOption(org.virtualbox_5_0.DhcpOpt option, String value)
    {
        try
        {
        port.idhcpServerAddGlobalOption(obj, org.virtualbox_5_0.jaxws.DhcpOpt.fromValue(option.name()), value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public void addVmSlotOption(String vmname, Integer slot, org.virtualbox_5_0.DhcpOpt option, String value)
    {
        try
        {
        port.idhcpServerAddVmSlotOption(obj, vmname, slot, org.virtualbox_5_0.jaxws.DhcpOpt.fromValue(option.name()), value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public void removeVmSlotOptions(String vmname, Integer slot)
    {
        try
        {
        port.idhcpServerRemoveVmSlotOptions(obj, vmname, slot);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public List<String> getVmSlotOptions(String vmname, Integer slot)
    {
        try
        {
            List<String> retVal;
        retVal = port.idhcpServerGetVmSlotOptions(obj, vmname, slot);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public List<String> getMacOptions(String mac)
    {
        try
        {
            List<String> retVal;
        retVal = port.idhcpServerGetMacOptions(obj, mac);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
configures the server
@param IPAddress server IP address

@param networkMask server network mask

@param FromIPAddress server From IP address for address range

@param ToIPAddress server To IP address for address range

Expected result codes:
<table summary="">
<tr><td>E_INVALIDARG</td><td>invalid configuration supplied</td></tr>
</table>

*/
    public void setConfiguration(String IPAddress, String networkMask, String FromIPAddress, String ToIPAddress)
    {
        try
        {
        port.idhcpServerSetConfiguration(obj, IPAddress, networkMask, FromIPAddress, ToIPAddress);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Starts DHCP server process.
@param networkName Name of internal network DHCP server should attach to.

@param trunkName Name of internal network trunk.

@param trunkType Type of internal network trunk.

Expected result codes:
<table summary="">
<tr><td>E_FAIL</td><td>Failed to start the process.</td></tr>
</table>

*/
    public void start(String networkName, String trunkName, String trunkType)
    {
        try
        {
        port.idhcpServerStart(obj, networkName, trunkName, trunkType);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Stops DHCP server process.
Expected result codes:
<table summary="">
<tr><td>E_FAIL</td><td>Failed to stop the process.</td></tr>
</table>

*/
    public void stop()
    {
        try
        {
        port.idhcpServerStop(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
}
