
/*
 * Copyright (C) 2010-2014 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * VBoxException.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

public class VBoxException extends RuntimeException
{
    private int resultCode;
    private IVirtualBoxErrorInfo errorInfo;

    public VBoxException(String message)
    {
        super(message);
        resultCode = -1;
        errorInfo = null;
    }

    public VBoxException(String message, Throwable cause)
    {
        super(message, cause);
        resultCode = -1;
        errorInfo = null;
    }

    public VBoxException(String message, Throwable cause, VboxPortType port)
    {
        super(message, cause);
        if (cause instanceof RuntimeFaultMsg)
        {
            RuntimeFaultMsg m = (RuntimeFaultMsg)cause;
            RuntimeFault f = m.getFaultInfo();
            resultCode = f.getResultCode();
            String retVal = f.getReturnval();
            errorInfo = (retVal.length() > 0) ? new IVirtualBoxErrorInfo(retVal, port) : null;
        }
        else
            resultCode = -1;
    }

    public int getResultCode()
    {
        return resultCode;
    }

    public IVirtualBoxErrorInfo getVirtualBoxErrorInfo()
    {
        return errorInfo;
    }
}
