
/*
 * Copyright (C) 2010-2014 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * LockType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;

/**
Used with{@link org.virtualbox_5_0.IMachine#lockMachine(org.virtualbox_5_0.ISession,org.virtualbox_5_0.LockType)}.
Interface ID: <tt>{168A6A8E-12FD-4878-A1F9-38A750A56089}</tt>
*/
public enum LockType
{

/**
Lock the machine for writing. This requests an exclusive lock, i.e.
there cannot be any other API client holding any type of lock for this
VM concurrently. Remember that a VM process counts as an API client
which implicitly holds the equivalent of a shared lock during the
entire VM runtime.
*/
    Write(2),

/**
Request only a shared lock for remote-controlling the machine.
Such a lock allows changing certain VM settings which can be safely
modified for a running VM.
*/
    Shared(1),

/**
Lock the machine for writing, and create objects necessary for
running a VM in this process.
*/
    VM(3);

    private final int value;

    LockType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static LockType fromValue(long v)
    {
        for (LockType c: LockType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static LockType fromValue(String v)
    {
        return valueOf(LockType.class, v);
    }
}

